HTTP Client
===========

The class [stormname:http.Client] implements a basic HTTP client. It is intended to encapsulate
state that is persistent across connections, such as cookies and persistent connections. None of
this functionality is, however, implemented currently.

The [stormname:http.Client] class contains the following members:

```stormdoc
@http.Client
- .timeout(*)
- .request(*)
```

The library also provides a protocol, [stormname:http.HttpProtocol] that allows representing HTTP
and HTTPS URLs. The library also provides convenience methods for creating the protocol:

```stormdoc
@http
- .httpUrl(*)
- .httpsUrl(*)
```

To store query parameters, the library also extends the [stormname:core.io.Url] class with
[stormname:http.QueryUrl]. It behaves as the [stormname:core.io.Url] class but also stores query
parameters in its `parameters` member. It also allows adding parameters using the `&` operator as
shown below.

For example, this allows fetching data through HTTP as follows:

```bsstmt
Url url = httpsUrl("storm-lang.org") / "index.html" & QueryParam("id", "12");
print(url.toS); // Prints: https://storm-lang.org/index.html?id=12
Str data = url.readAllText();
print(data);    // Prints the raw HTML.
```

Note that all path components are escaped properly internally. Printing `Url`s with `toS` does not
print them properly escaped. Using the `format` member will however give the escaped representation
if you need it for something.
