#pragma once
#include "Utils/Bitmask.h"

namespace storm {
	STORM_PKG(core.lang);

	/**
	 * Misc. flags for lookup options.
	 */
	enum NamedFlags {
		// No flags, default behaviour.
		namedDefault = 0x00,

		// Ignore inheritance when matching types for this Named.
		namedMatchNoInheritance = 0x01,

		// Be strict with matching references vs no references.
		namedStrictRef = 0x02,

		// This entity was implicitly generated at some point. Allow replacing it whenever a new
		// exact match is inserted.
		namedAllowReplace = 0x04,

	};

	BITMASK_OPERATORS(NamedFlags);

}
