% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.R
\name{vec_c}
\alias{vec_c}
\title{Combine many vectors into one vector}
\usage{
vec_c(
  ...,
  .ptype = NULL,
  .name_spec = NULL,
  .name_repair = c("minimal", "unique", "check_unique", "universal", "unique_quiet",
    "universal_quiet"),
  .error_arg = "",
  .error_call = current_env()
)
}
\arguments{
\item{...}{Vectors to coerce.}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}

\item{.name_spec}{A name specification for combining
inner and outer names. This is relevant for inputs passed with a
name, when these inputs are themselves named, like \code{outer = c(inner = 1)}, or when they have length greater than 1: \code{outer = 1:2}. By default, these cases trigger an error. You can resolve
the error by providing a specification that describes how to
combine the names or the indices of the inner vector with the
name of the input. This specification can be:
\itemize{
\item A function of two arguments. The outer name is passed as a
string to the first argument, and the inner names or positions
are passed as second argument.
\item An anonymous function as a purrr-style formula.
\item A glue specification of the form \code{"{outer}_{inner}"}.
\item \code{"inner"}, in which case outer names are ignored, and inner
names are used if they exist. Note that outer names may still
be used to provide informative error messages.
\item An \code{\link[rlang:zap]{rlang::zap()}} object, in which case both outer and inner
names are ignored and the result is unnamed.
}

See the \link[=name_spec]{name specification topic}.}

\item{.name_repair}{How to repair names, see \code{repair} options in
\code{\link[=vec_as_names]{vec_as_names()}}.}

\item{.error_arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{.error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A vector with class given by \code{.ptype}, and length equal to the
sum of the \code{vec_size()} of the contents of \code{...}.

The vector will have names if the individual components have names
(inner names) or if the arguments are named (outer names). If both
inner and outer names are present, an error is thrown unless a
\code{.name_spec} is provided.
}
\description{
Combine all arguments into a new vector of common type.
}
\section{Invariants}{

\itemize{
\item \code{vec_size(vec_c(x, y)) == vec_size(x) + vec_size(y)}
\item \code{vec_ptype(vec_c(x, y)) == vec_ptype_common(x, y)}.
}
}

\section{Dependencies}{

\subsection{vctrs dependencies}{
\itemize{
\item \code{\link[=vec_cast_common]{vec_cast_common()}} with fallback
\item \code{\link[=vec_proxy]{vec_proxy()}}
\item \code{\link[=vec_restore]{vec_restore()}}
}
}

\subsection{base dependencies}{
\itemize{
\item \code{\link[base:c]{base::c()}}
}

If inputs inherit from a common class hierarchy, \code{vec_c()} falls
back to \code{base::c()} if there exists a \code{c()} method implemented for
this class hierarchy.
}
}

\examples{
vec_c(FALSE, 1L, 1.5)

# Date/times --------------------------
c(Sys.Date(), Sys.time())
c(Sys.time(), Sys.Date())

vec_c(Sys.Date(), Sys.time())
vec_c(Sys.time(), Sys.Date())

# Factors -----------------------------
c(factor("a"), factor("b"))
vec_c(factor("a"), factor("b"))


# By default, named inputs must be length 1:
vec_c(name = 1)
try(vec_c(name = 1:3))

# Pass a name specification to work around this:
vec_c(name = 1:3, .name_spec = "{outer}_{inner}")

# See `?name_spec` for more examples of name specifications.
}
\seealso{
\code{\link[=vec_cbind]{vec_cbind()}}/\code{\link[=vec_rbind]{vec_rbind()}} for combining data frames by rows
or columns.
}
