% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WA-estimands.R
\name{WA_recurrent}
\alias{WA_recurrent}
\title{While-Alive estimands for recurrent events}
\usage{
WA_recurrent(
  formula,
  data,
  time = NULL,
  cens.code = 0,
  cause = 1,
  death.code = 2,
  trans = NULL,
  cens.formula = NULL,
  augmentR = NULL,
  augmentC = NULL,
  type = NULL,
  marks = NULL,
  ...
)
}
\arguments{
\item{formula}{Event formula first covariate on rhs must be a factor giving the treatment}

\item{data}{data frame}

\item{time}{for estimation}

\item{cens.code}{of censorings}

\item{cause}{of events}

\item{death.code}{of terminal events}

\item{trans}{possible power for mean of events per time-unit}

\item{cens.formula}{censoring model, default is to use strata(treatment)}

\item{augmentR}{covariates for model of mean ratio}

\item{augmentC}{covariates for censoring augmentation}

\item{type}{augmentation for call of binreg, when augmentC is given default is "I" and otherwise "II"}

\item{marks}{possible marks for composite outcome situation for model for counts with marks}

\item{...}{arguments for binregATE}
}
\description{
Considers the ratio of means \deqn{E(N(min(D,t)))/E(min(D,t))} and the
the mean of the events per time unit \deqn{E(N(min(D,t))/min(D,t))} both based on
IPCW etimation. RMST estimator equivalent to Kaplan-Meier based estimator.
}
\examples{
library(mets)
data(hfactioncpx12)

dtable(hfactioncpx12,~status)
dd <- WA_recurrent(Event(entry,time,status)~treatment+cluster(id),hfactioncpx12,time=2,death.code=2)
summary(dd)
}
\references{
Nonparametric estimation of the Patient Weighted While-Alive Estimand arXiv preprint by A. Ragni, T. Martinussen, T. Scheike
Mao, L. (2023). Nonparametric inference of general while-alive estimands for recurrent events. Biometrics, 79(3):1749–1760.
Schmidli, H., Roger, J. H., and Akacha, M. (2023). Estimands for recurrent event endpoints in the presence of a terminal event. Statistics in Biopharmaceutical Research, 15(2):238–248.
}
\author{
Thomas Scheike
}
