% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kprod.R
\name{kprod}
\alias{kprod}
\title{Iterated Kronecker product}
\usage{
kprod(..., FUN = `*`)
}
\arguments{
\item{...}{A listing of matrices}

\item{FUN}{A function to pass to \code{\link[base:kronecker]{base::kronecker()}}}
}
\value{
A matrix that is the kronecker product of the specified matrices
(from left to right).
}
\description{
Compute the Kronecker product of several matrices.
}
\details{
If kronecker is  the function that computes A x B, kprod computes A x B x C
and so on; it's a wrapper of Reduce and kronecker.
}
\examples{

kprod(diag(2), t(ones(2)))
kprod(t(ones(2)), diag(2))


kprod(diag(2), t(ones(2)), t(ones(2)))
kprod(t(ones(2)), diag(2), t(ones(2)))
kprod(t(ones(2)), t(ones(2)), diag(2))


# cf. aoki, hara, and takemura p.13
rbind(
  kprod(diag(2), t(ones(2))),
  kprod(t(ones(2)), diag(2))
) 


}
