% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latte-files.R
\name{latte-files}
\alias{latte-files}
\alias{format_latte}
\alias{write_latte}
\alias{write.latte}
\alias{read_latte}
\alias{read.latte}
\title{Format/read/write a matrix in latte's style}
\usage{
format_latte(mat, file)

write_latte(mat, file)

write.latte(mat, file)

read_latte(file, format = c("mat", "Ab"))

read.latte(file, format = c("mat", "Ab"))
}
\arguments{
\item{mat}{A matrix}

\item{file}{A filename}

\item{format}{"mat" or "Ab"}
}
\value{
\itemize{

\item \code{\link[=format_latte]{format_latte()}} -- A character string of the matrix in
latte format.

\item \code{\link[=write_latte]{write_latte()}} -- An invisible character
string of the formatted output.

\item \code{\link[=read_latte]{read_latte()}} -- An integer matrix.

}
}
\description{
\code{\link[=format_latte]{format_latte()}} formats a matrix in latte's style.
\code{\link[=write_latte]{write_latte()}} writes a latte-formatted file to file.
\code{\link[=read_latte]{read_latte()}} reads a latte-formatted file from disk.
}
\examples{


(mat <- matrix(sample(9), 3, 3))

format_latte(mat)
cat(format_latte(mat))

(file <- file.path(tempdir(), "foo.hrep"))
write_latte(mat, file)
file.show(file)
read_latte(file)
read_latte(file, "Ab")

attr(mat, "linearity") <- c(1, 3)
attr(mat, "nonnegative") <- 2
mat
format_latte(mat)
cat(format_latte(mat))
write_latte(mat, file)
file.show(file)
read_latte(file)

file.remove(file)



}
