
test_that("ggstripchart is reproducible", {
  p <- ggstripchart(PlantGrowth, x = "group", y = "weight")
  jitter_data <- layer_data(p, 1) %>%
    dplyr::select(x, y) %>%
    dplyr::mutate(x = as.numeric(round(x, 7)), y = as.numeric(round(y, 7)))
  expected_data <- data.frame(
              x = c(0.915031,1.1153221,0.9635908,
                    1.153207,1.1761869,0.8182226,1.0112422,1.1569676,1.020574,
                    0.9826459,2.1827333,1.9813337,2.0710283,2.0290534,
                    1.8411699,2.15993,1.8984351,1.8168238,1.9311683,2.1818015,
                    3.1558157,3.0771214,3.0562027,3.1977079,3.0622823,
                    3.0834122,3.0176264,3.0376568,2.9156639,2.8588455),
              y = c(4.1737042,5.5832184,5.1815256,
                    6.1123637,4.4961969,4.6098224,5.1720677,4.5277313,5.3285454,
                    5.137853,4.8071424,4.1693164,4.4093098,3.5889508,
                    5.8672196,3.8271104,6.0278643,4.8897277,4.3181278,4.6928626,
                    6.3063666,5.1195376,5.5423914,5.4969752,5.3704876,
                    5.2876523,4.9170203,6.1520265,5.8031604,5.2589957)
   )
  expect_equal(jitter_data, expected_data)
})






