% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{prune}
\alias{prune}
\alias{prune.default}
\alias{prune.dendrogram}
\alias{prune.hclust}
\alias{prune.phylo}
\alias{prune.rpart}
\title{Prunes a tree (using leaves' labels)}
\usage{
prune(dend, ...)

\method{prune}{default}(dend, ...)

\method{prune}{dendrogram}(dend, leaves, reindex_dend = TRUE, ...)

\method{prune}{hclust}(dend, leaves, ...)

\method{prune}{phylo}(dend, ...)

\method{prune}{rpart}(dend, ...)
}
\arguments{
\item{dend}{tree object (dendrogram/hclust/phylo)}

\item{...}{passed on}

\item{leaves}{a character vector of the label(S) of the tip(s) (leaves) we wish to prune off the tree.}

\item{reindex_dend}{logical (default is TRUE). If TRUE, the leaves of the new dendrograms
include the rank of the old order.dendrogram.
This insures that their values are just like the number of leaves.
When FALSE, the values in the leaves is that of the original dendrogram. Thie is useful
if prunning a dendrogram but then wanting to use \link{order.dendrogram} with the original values.
When using prune.hclust, then reindex_dend is used by default since otherwise the \link{as.hclust} function
would return an error.}
}
\value{
A pruned tree
}
\description{
Trimms a tree (dendrogram, hclust) from a set of leaves based on their labels.
}
\details{
I was not sure if to call this function drop.tip (from ape), snip/prune (from rpart) or just remove.leaves.  I ended up deciding on prune.
}
\examples{
hc <- hclust(dist(USArrests[1:5, ]), "ave")
dend <- as.dendrogram(hc)

par(mfrow = c(1, 2))
plot(dend, main = "original tree")
plot(prune(dend, c("Alaska", "California")), main = "tree without Alaska and California")


# this works because prune uses reindex_dend = TRUE by default
as.hclust(prune(dend, c("Alaska", "California")))
prune(hc, c("Alaska", "California"))
}
\seealso{
\link{prune_leaf}, \link[ape]{drop.tip}
}
