% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridgesampling.R
\name{bridge_sampler.brmsfit}
\alias{bridge_sampler.brmsfit}
\alias{bridge_sampler}
\title{Log Marginal Likelihood via Bridge Sampling}
\usage{
\method{bridge_sampler}{brmsfit}(samples, recompile = FALSE, ...)
}
\arguments{
\item{samples}{A \code{brmsfit} object.}

\item{recompile}{Logical, indicating whether the Stan model should be
recompiled. This may be necessary if you are running bridge sampling on
another machine than the one used to fit the model. No recompilation
is done by default.}

\item{...}{Additional arguments passed to
\code{\link[bridgesampling:bridge_sampler]{bridge_sampler.stanfit}}.}
}
\description{
Computes log marginal likelihood via bridge sampling,
which can be used in the computation of bayes factors
and posterior model probabilities.
The \code{brmsfit} method is just a thin wrapper around
the corresponding method for \code{stanfit} objects.
}
\details{
Computing the marginal likelihood requires samples of all variables
  defined in Stan's \code{parameters} block to be saved. Otherwise
  \code{bridge_sampler} cannot be computed. Thus, please set \code{save_pars
  = save_pars(all = TRUE)} in the call to \code{brm}, if you are planning to
  apply \code{bridge_sampler} to your models.

  The computation of marginal likelihoods based on bridge sampling requires
  a lot more posterior draws than usual. A good conservative
  rule of thump is perhaps 10-fold more draws (read: the default of 4000
  draws may not be enough in many cases). If not enough posterior
  draws are provided, the bridge sampling algorithm tends to be
  unstable leading to considerably different results each time it is run.
  We thus recommend running \code{bridge_sampler}
  multiple times to check the stability of the results.

  More details are provided under
  \code{\link[bridgesampling:bridge_sampler]{bridgesampling::bridge_sampler}}.
}
\examples{
\dontrun{
# model with the treatment effect
fit1 <- brm(
  count ~ zAge + zBase + Trt,
  data = epilepsy, family = negbinomial(),
  prior = prior(normal(0, 1), class = b),
  save_pars = save_pars(all = TRUE)
)
summary(fit1)
bridge_sampler(fit1)

# model without the treatment effect
fit2 <- brm(
  count ~ zAge + zBase,
  data = epilepsy, family = negbinomial(),
  prior = prior(normal(0, 1), class = b),
  save_pars = save_pars(all = TRUE)
)
summary(fit2)
bridge_sampler(fit2)
}

}
\seealso{
\code{
  \link[brms:bayes_factor.brmsfit]{bayes_factor},
  \link[brms:post_prob.brmsfit]{post_prob}
}
}
