# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AutomatedCheckResult(_serialization.Model):
    """Only for AutomatedStep type.

    :ivar version: Version for automated check result.
    :vartype version: str
    :ivar status: Status for automated check result.
    :vartype status: str
    :ivar result: Insight Article Content.
    :vartype result: str
    :ivar type: Type of Result. Known values are: "Success", "Warning", "Error", and "Information".
    :vartype type: str or ~azure.mgmt.selfhelp.models.AutomatedCheckResultType
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "result": {"key": "result", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        status: Optional[str] = None,
        result: Optional[str] = None,
        type: Optional[Union[str, "_models.AutomatedCheckResultType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Version for automated check result.
        :paramtype version: str
        :keyword status: Status for automated check result.
        :paramtype status: str
        :keyword result: Insight Article Content.
        :paramtype result: str
        :keyword type: Type of Result. Known values are: "Success", "Warning", "Error", and
         "Information".
        :paramtype type: str or ~azure.mgmt.selfhelp.models.AutomatedCheckResultType
        """
        super().__init__(**kwargs)
        self.version = version
        self.status = status
        self.result = result
        self.type = type


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """Response for whether the requested resource name is available or not.

    :ivar name_available: Returns true or false depending on the availability of the name.
    :vartype name_available: bool
    :ivar reason: Reason for why value is not available. This field is returned if nameAvailable is
     false.
    :vartype reason: str
    :ivar message: Gets an error message explaining the 'reason' value with more details. This
     field is returned iif nameAvailable is false.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Returns true or false depending on the availability of the name.
        :paramtype name_available: bool
        :keyword reason: Reason for why value is not available. This field is returned if nameAvailable
         is false.
        :paramtype reason: str
        :keyword message: Gets an error message explaining the 'reason' value with more details. This
         field is returned iif nameAvailable is false.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ClassificationService(_serialization.Model):
    """Service Classification result object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_id: Azure resource Id of the service.
    :vartype service_id: str
    :ivar display_name: Localized name of the azure service.
    :vartype display_name: str
    :ivar resource_types: List of applicable ARM resource types for this service.
    :vartype resource_types: list[str]
    """

    _validation = {
        "service_id": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "service_id": {"key": "serviceId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "resource_types": {"key": "resourceTypes", "type": "[str]"},
    }

    def __init__(self, *, resource_types: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword resource_types: List of applicable ARM resource types for this service.
        :paramtype resource_types: list[str]
        """
        super().__init__(**kwargs)
        self.service_id = None
        self.display_name = None
        self.resource_types = resource_types


class ContinueRequestBody(_serialization.Model):
    """Troubleshooter ContinueRequest body.

    :ivar step_id: Unique id of the result.
    :vartype step_id: str
    :ivar responses:
    :vartype responses: list[~azure.mgmt.selfhelp.models.TroubleshooterResponse]
    """

    _attribute_map = {
        "step_id": {"key": "stepId", "type": "str"},
        "responses": {"key": "responses", "type": "[TroubleshooterResponse]"},
    }

    def __init__(
        self,
        *,
        step_id: Optional[str] = None,
        responses: Optional[List["_models.TroubleshooterResponse"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword step_id: Unique id of the result.
        :paramtype step_id: str
        :keyword responses:
        :paramtype responses: list[~azure.mgmt.selfhelp.models.TroubleshooterResponse]
        """
        super().__init__(**kwargs)
        self.step_id = step_id
        self.responses = responses


class Diagnostic(_serialization.Model):
    """Properties returned with in an insight.

    :ivar solution_id: Solution Id.
    :vartype solution_id: str
    :ivar status: Denotes the status of the diagnostic resource. Known values are: "Failed",
     "MissingInputs", "Running", "Succeeded", and "Timeout".
    :vartype status: str or ~azure.mgmt.selfhelp.models.Status
    :ivar insights: The problems (if any) detected by this insight.
    :vartype insights: list[~azure.mgmt.selfhelp.models.Insight]
    :ivar error: Error definition.
    :vartype error: ~azure.mgmt.selfhelp.models.Error
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "insights": {"key": "insights", "type": "[Insight]"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        insights: Optional[List["_models.Insight"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id.
        :paramtype solution_id: str
        :keyword status: Denotes the status of the diagnostic resource. Known values are: "Failed",
         "MissingInputs", "Running", "Succeeded", and "Timeout".
        :paramtype status: str or ~azure.mgmt.selfhelp.models.Status
        :keyword insights: The problems (if any) detected by this insight.
        :paramtype insights: list[~azure.mgmt.selfhelp.models.Insight]
        :keyword error: Error definition.
        :paramtype error: ~azure.mgmt.selfhelp.models.Error
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.status = status
        self.insights = insights
        self.error = error


class DiagnosticInvocation(_serialization.Model):
    """Solution Invocation with additional params needed for invocation.

    :ivar solution_id: Solution Id to invoke.
    :vartype solution_id: str
    :ivar additional_parameters: Additional parameters required to invoke the solutionId.
    :vartype additional_parameters: dict[str, str]
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "additional_parameters": {"key": "additionalParameters", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        additional_parameters: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id to invoke.
        :paramtype solution_id: str
        :keyword additional_parameters: Additional parameters required to invoke the solutionId.
        :paramtype additional_parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.additional_parameters = additional_parameters


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    """


class DiagnosticResource(ProxyResource):
    """Diagnostic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar global_parameters: Global parameters is an optional map which can be used to add key and
     value to request body to improve the diagnostics results.
    :vartype global_parameters: dict[str, str]
    :ivar insights: SolutionIds that are needed to be invoked.
    :vartype insights: list[~azure.mgmt.selfhelp.models.DiagnosticInvocation]
    :ivar accepted_at: Diagnostic Request Accepted time.
    :vartype accepted_at: str
    :ivar provisioning_state: Status of diagnostic provisioning. Known values are: "Succeeded",
     "PartialComplete", "Failed", "Running", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.selfhelp.models.DiagnosticProvisioningState
    :ivar diagnostics: Array of Diagnostics.
    :vartype diagnostics: list[~azure.mgmt.selfhelp.models.Diagnostic]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "accepted_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "diagnostics": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "global_parameters": {"key": "properties.globalParameters", "type": "{str}"},
        "insights": {"key": "properties.insights", "type": "[DiagnosticInvocation]"},
        "accepted_at": {"key": "properties.acceptedAt", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "diagnostics": {"key": "properties.diagnostics", "type": "[Diagnostic]"},
    }

    def __init__(
        self,
        *,
        global_parameters: Optional[Dict[str, str]] = None,
        insights: Optional[List["_models.DiagnosticInvocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword global_parameters: Global parameters is an optional map which can be used to add key
         and  value to request body to improve the diagnostics results.
        :paramtype global_parameters: dict[str, str]
        :keyword insights: SolutionIds that are needed to be invoked.
        :paramtype insights: list[~azure.mgmt.selfhelp.models.DiagnosticInvocation]
        """
        super().__init__(**kwargs)
        self.global_parameters = global_parameters
        self.insights = insights
        self.accepted_at = None
        self.provisioning_state = None
        self.diagnostics = None


class DiscoveryNlpRequest(_serialization.Model):
    """Discover NLP request.

    All required parameters must be populated in order to send to server.

    :ivar issue_summary: Natural language description of the issue. Required.
    :vartype issue_summary: str
    :ivar resource_id: ARM resource Id of the resource that is having the issue. Only applicable
     for Discovery Solution NLP Subscription Scope.
    :vartype resource_id: str
    :ivar service_id: ARM service Id of the service that is having the issue. For more information
     on service Id see https://learn.microsoft.com/rest/api/support/services/list?tabs=HTTP.
    :vartype service_id: str
    :ivar additional_context: Additional information in the form of a string.
    :vartype additional_context: str
    """

    _validation = {
        "issue_summary": {"required": True},
    }

    _attribute_map = {
        "issue_summary": {"key": "issueSummary", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "service_id": {"key": "serviceId", "type": "str"},
        "additional_context": {"key": "additionalContext", "type": "str"},
    }

    def __init__(
        self,
        *,
        issue_summary: str,
        resource_id: Optional[str] = None,
        service_id: Optional[str] = None,
        additional_context: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issue_summary: Natural language description of the issue. Required.
        :paramtype issue_summary: str
        :keyword resource_id: ARM resource Id of the resource that is having the issue. Only applicable
         for Discovery Solution NLP Subscription Scope.
        :paramtype resource_id: str
        :keyword service_id: ARM service Id of the service that is having the issue. For more
         information on service Id see
         https://learn.microsoft.com/rest/api/support/services/list?tabs=HTTP.
        :paramtype service_id: str
        :keyword additional_context: Additional information in the form of a string.
        :paramtype additional_context: str
        """
        super().__init__(**kwargs)
        self.issue_summary = issue_summary
        self.resource_id = resource_id
        self.service_id = service_id
        self.additional_context = additional_context


class DiscoveryNlpResponse(_serialization.Model):
    """Successfully fetched list of solution metadata.

    :ivar value: The list of solution metadata.
    :vartype value: list[~azure.mgmt.selfhelp.models.SolutionNlpMetadataResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SolutionNlpMetadataResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.SolutionNlpMetadataResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of solution metadata.
        :paramtype value: list[~azure.mgmt.selfhelp.models.SolutionNlpMetadataResource]
        """
        super().__init__(**kwargs)
        self.value = value


class DiscoveryResponse(_serialization.Model):
    """Discovery response.

    :ivar value: The list of metadata.
    :vartype value: list[~azure.mgmt.selfhelp.models.SolutionMetadataResource]
    :ivar next_link: The link used to get the next page of solution metadata.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SolutionMetadataResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SolutionMetadataResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of metadata.
        :paramtype value: list[~azure.mgmt.selfhelp.models.SolutionMetadataResource]
        :keyword next_link: The link used to get the next page of solution metadata.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Error(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar type: Service specific error type which serves as additional context for the error
     herein.
    :vartype type: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: An array of additional nested error response info objects, as described by this
     contract.
    :vartype details: list[~azure.mgmt.selfhelp.models.Error]
    """

    _validation = {
        "code": {"readonly": True},
        "type": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
    }

    def __init__(self, *, details: Optional[List["_models.Error"]] = None, **kwargs: Any) -> None:
        """
        :keyword details: An array of additional nested error response info objects, as described by
         this contract.
        :paramtype details: list[~azure.mgmt.selfhelp.models.Error]
        """
        super().__init__(**kwargs)
        self.code = None
        self.type = None
        self.message = None
        self.details = details


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.selfhelp.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.selfhelp.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.selfhelp.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.selfhelp.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Filter(_serialization.Model):
    """Filter criterion.

    :ivar name: Filter name.
    :vartype name: str
    :ivar values: Filter values.
    :vartype values: str
    :ivar operator: Filter operator.
    :vartype operator: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "values": {"key": "values", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, values: Optional[str] = None, operator: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Filter name.
        :paramtype name: str
        :keyword values: Filter values.
        :paramtype values: str
        :keyword operator: Filter operator.
        :paramtype operator: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.values = values
        self.operator = operator


class FilterGroup(_serialization.Model):
    """Filter group.

    :ivar filter: List of filters.
    :vartype filter: list[~azure.mgmt.selfhelp.models.Filter]
    """

    _attribute_map = {
        "filter": {"key": "filter", "type": "[Filter]"},
    }

    def __init__(
        self, *, filter: Optional[List["_models.Filter"]] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword filter: List of filters.
        :paramtype filter: list[~azure.mgmt.selfhelp.models.Filter]
        """
        super().__init__(**kwargs)
        self.filter = filter


class Insight(_serialization.Model):
    """Detailed insights(s) obtained via the invocation of an insight diagnostic.

    :ivar id: Article id.
    :vartype id: str
    :ivar title: This insight's title.
    :vartype title: str
    :ivar results: Detailed result content.
    :vartype results: str
    :ivar importance_level: Importance level of the insight. Known values are: "Critical",
     "Warning", and "Information".
    :vartype importance_level: str or ~azure.mgmt.selfhelp.models.ImportanceLevel
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "results": {"key": "results", "type": "str"},
        "importance_level": {"key": "importanceLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        title: Optional[str] = None,
        results: Optional[str] = None,
        importance_level: Optional[Union[str, "_models.ImportanceLevel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Article id.
        :paramtype id: str
        :keyword title: This insight's title.
        :paramtype title: str
        :keyword results: Detailed result content.
        :paramtype results: str
        :keyword importance_level: Importance level of the insight. Known values are: "Critical",
         "Warning", and "Information".
        :paramtype importance_level: str or ~azure.mgmt.selfhelp.models.ImportanceLevel
        """
        super().__init__(**kwargs)
        self.id = id
        self.title = title
        self.results = results
        self.importance_level = importance_level


class MetricsBasedChart(_serialization.Model):
    """Solutions metrics based chart.

    :ivar name: Chart name.
    :vartype name: str
    :ivar aggregation_type: Allowed values are Sum, Avg, Count, Min, Max. Default is Sum. Known
     values are: "Sum", "Avg", "Count", "Min", and "Max".
    :vartype aggregation_type: str or ~azure.mgmt.selfhelp.models.AggregationType
    :ivar time_span_duration: Time span duration.
    :vartype time_span_duration: str
    :ivar title: Chart title.
    :vartype title: str
    :ivar filter_group: Filter group.
    :vartype filter_group: ~azure.mgmt.selfhelp.models.FilterGroup
    :ivar replacement_key: Place holder used in HTML Content replace control with the content.
    :vartype replacement_key: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "time_span_duration": {"key": "timeSpanDuration", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "filter_group": {"key": "filterGroup", "type": "FilterGroup"},
        "replacement_key": {"key": "replacementKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        aggregation_type: Optional[Union[str, "_models.AggregationType"]] = None,
        time_span_duration: Optional[str] = None,
        title: Optional[str] = None,
        filter_group: Optional["_models.FilterGroup"] = None,
        replacement_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Chart name.
        :paramtype name: str
        :keyword aggregation_type: Allowed values are Sum, Avg, Count, Min, Max. Default is Sum. Known
         values are: "Sum", "Avg", "Count", "Min", and "Max".
        :paramtype aggregation_type: str or ~azure.mgmt.selfhelp.models.AggregationType
        :keyword time_span_duration: Time span duration.
        :paramtype time_span_duration: str
        :keyword title: Chart title.
        :paramtype title: str
        :keyword filter_group: Filter group.
        :paramtype filter_group: ~azure.mgmt.selfhelp.models.FilterGroup
        :keyword replacement_key: Place holder used in HTML Content replace control with the content.
        :paramtype replacement_key: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.aggregation_type = aggregation_type
        self.time_span_duration = time_span_duration
        self.title = title
        self.filter_group = filter_group
        self.replacement_key = replacement_key


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.selfhelp.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.selfhelp.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.selfhelp.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.selfhelp.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.selfhelp.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReplacementMaps(_serialization.Model):
    """Solution replacement maps.

    :ivar web_results: Solution AzureKB results.
    :vartype web_results: list[~azure.mgmt.selfhelp.models.WebResult]
    :ivar diagnostics: Solution diagnostics results.
    :vartype diagnostics: list[~azure.mgmt.selfhelp.models.SolutionsDiagnostic]
    :ivar troubleshooters: Solutions Troubleshooters.
    :vartype troubleshooters: list[~azure.mgmt.selfhelp.models.SolutionsTroubleshooters]
    :ivar metrics_based_charts: Solution metrics based charts.
    :vartype metrics_based_charts: list[~azure.mgmt.selfhelp.models.MetricsBasedChart]
    :ivar videos: Video solutions, which have the power to engage the customer by stimulating their
     senses.
    :vartype videos: list[~azure.mgmt.selfhelp.models.Video]
    :ivar video_groups: Group of Videos.
    :vartype video_groups: list[~azure.mgmt.selfhelp.models.VideoGroup]
    """

    _attribute_map = {
        "web_results": {"key": "webResults", "type": "[WebResult]"},
        "diagnostics": {"key": "diagnostics", "type": "[SolutionsDiagnostic]"},
        "troubleshooters": {"key": "troubleshooters", "type": "[SolutionsTroubleshooters]"},
        "metrics_based_charts": {"key": "metricsBasedCharts", "type": "[MetricsBasedChart]"},
        "videos": {"key": "videos", "type": "[Video]"},
        "video_groups": {"key": "videoGroups", "type": "[VideoGroup]"},
    }

    def __init__(
        self,
        *,
        web_results: Optional[List["_models.WebResult"]] = None,
        diagnostics: Optional[List["_models.SolutionsDiagnostic"]] = None,
        troubleshooters: Optional[List["_models.SolutionsTroubleshooters"]] = None,
        metrics_based_charts: Optional[List["_models.MetricsBasedChart"]] = None,
        videos: Optional[List["_models.Video"]] = None,
        video_groups: Optional[List["_models.VideoGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword web_results: Solution AzureKB results.
        :paramtype web_results: list[~azure.mgmt.selfhelp.models.WebResult]
        :keyword diagnostics: Solution diagnostics results.
        :paramtype diagnostics: list[~azure.mgmt.selfhelp.models.SolutionsDiagnostic]
        :keyword troubleshooters: Solutions Troubleshooters.
        :paramtype troubleshooters: list[~azure.mgmt.selfhelp.models.SolutionsTroubleshooters]
        :keyword metrics_based_charts: Solution metrics based charts.
        :paramtype metrics_based_charts: list[~azure.mgmt.selfhelp.models.MetricsBasedChart]
        :keyword videos: Video solutions, which have the power to engage the customer by stimulating
         their senses.
        :paramtype videos: list[~azure.mgmt.selfhelp.models.Video]
        :keyword video_groups: Group of Videos.
        :paramtype video_groups: list[~azure.mgmt.selfhelp.models.VideoGroup]
        """
        super().__init__(**kwargs)
        self.web_results = web_results
        self.diagnostics = diagnostics
        self.troubleshooters = troubleshooters
        self.metrics_based_charts = metrics_based_charts
        self.videos = videos
        self.video_groups = video_groups


class ReplacementMapsSelfHelp(_serialization.Model):
    """Solution replacement maps.

    :ivar web_results: Solution AzureKB results.
    :vartype web_results: list[~azure.mgmt.selfhelp.models.WebResult]
    :ivar videos: Video solutions, which have the power to engage the customer by stimulating their
     senses.
    :vartype videos: list[~azure.mgmt.selfhelp.models.Video]
    :ivar video_groups: Group of Videos.
    :vartype video_groups: list[~azure.mgmt.selfhelp.models.VideoGroup]
    """

    _attribute_map = {
        "web_results": {"key": "webResults", "type": "[WebResult]"},
        "videos": {"key": "videos", "type": "[Video]"},
        "video_groups": {"key": "videoGroups", "type": "[VideoGroup]"},
    }

    def __init__(
        self,
        *,
        web_results: Optional[List["_models.WebResult"]] = None,
        videos: Optional[List["_models.Video"]] = None,
        video_groups: Optional[List["_models.VideoGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword web_results: Solution AzureKB results.
        :paramtype web_results: list[~azure.mgmt.selfhelp.models.WebResult]
        :keyword videos: Video solutions, which have the power to engage the customer by stimulating
         their senses.
        :paramtype videos: list[~azure.mgmt.selfhelp.models.Video]
        :keyword video_groups: Group of Videos.
        :paramtype video_groups: list[~azure.mgmt.selfhelp.models.VideoGroup]
        """
        super().__init__(**kwargs)
        self.web_results = web_results
        self.videos = videos
        self.video_groups = video_groups


class ResponseOption(_serialization.Model):
    """The status of the resource.

    :ivar key: Unique string.
    :vartype key: str
    :ivar value: Option description.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Unique string.
        :paramtype key: str
        :keyword value: Option description.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ResponseValidationProperties(_serialization.Model):
    """Troubleshooter step input response validation properties.

    :ivar regex: Regex used for the input validation.
    :vartype regex: str
    :ivar validation_scope: Validation scope. Known values are: "None", "URLFormat", "GuidFormat",
     "IpAddressFormat", and "NumberOnlyFormat".
    :vartype validation_scope: str or ~azure.mgmt.selfhelp.models.ValidationScope
    :ivar is_required: Default True.
    :vartype is_required: bool
    :ivar validation_error_message: Validation Error Message.
    :vartype validation_error_message: str
    :ivar max_length: Max text input (open Ended Text).
    :vartype max_length: int
    """

    _attribute_map = {
        "regex": {"key": "regex", "type": "str"},
        "validation_scope": {"key": "validationScope", "type": "str"},
        "is_required": {"key": "isRequired", "type": "bool"},
        "validation_error_message": {"key": "validationErrorMessage", "type": "str"},
        "max_length": {"key": "maxLength", "type": "int"},
    }

    def __init__(
        self,
        *,
        regex: Optional[str] = None,
        validation_scope: Optional[Union[str, "_models.ValidationScope"]] = None,
        is_required: Optional[bool] = None,
        validation_error_message: Optional[str] = None,
        max_length: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword regex: Regex used for the input validation.
        :paramtype regex: str
        :keyword validation_scope: Validation scope. Known values are: "None", "URLFormat",
         "GuidFormat", "IpAddressFormat", and "NumberOnlyFormat".
        :paramtype validation_scope: str or ~azure.mgmt.selfhelp.models.ValidationScope
        :keyword is_required: Default True.
        :paramtype is_required: bool
        :keyword validation_error_message: Validation Error Message.
        :paramtype validation_error_message: str
        :keyword max_length: Max text input (open Ended Text).
        :paramtype max_length: int
        """
        super().__init__(**kwargs)
        self.regex = regex
        self.validation_scope = validation_scope
        self.is_required = is_required
        self.validation_error_message = validation_error_message
        self.max_length = max_length


class RestartTroubleshooterResponse(_serialization.Model):
    """Troubleshooter restart response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar troubleshooter_resource_name: Updated TroubleshooterResource Name .
    :vartype troubleshooter_resource_name: str
    """

    _validation = {
        "troubleshooter_resource_name": {"readonly": True},
    }

    _attribute_map = {
        "troubleshooter_resource_name": {"key": "troubleshooterResourceName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.troubleshooter_resource_name = None


class SearchResult(_serialization.Model):
    """Details of an AzureKB search result.

    :ivar solution_id: Unique id of the result.
    :vartype solution_id: str
    :ivar content: Content of the search result.
    :vartype content: str
    :ivar title: Title of the search result.
    :vartype title: str
    :ivar confidence: Confidence of the search result. Known values are: "Low", "Medium", and
     "High".
    :vartype confidence: str or ~azure.mgmt.selfhelp.models.Confidence
    :ivar source: Source of the search result.
    :vartype source: str
    :ivar result_type: Result type of the search result. Known values are: "Community" and
     "Documentation".
    :vartype result_type: str or ~azure.mgmt.selfhelp.models.ResultType
    :ivar rank: rank of the search result.
    :vartype rank: int
    :ivar link: Link to the document.
    :vartype link: str
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "confidence": {"key": "confidence", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "rank": {"key": "rank", "type": "int"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        content: Optional[str] = None,
        title: Optional[str] = None,
        confidence: Optional[Union[str, "_models.Confidence"]] = None,
        source: Optional[str] = None,
        result_type: Optional[Union[str, "_models.ResultType"]] = None,
        rank: Optional[int] = None,
        link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Unique id of the result.
        :paramtype solution_id: str
        :keyword content: Content of the search result.
        :paramtype content: str
        :keyword title: Title of the search result.
        :paramtype title: str
        :keyword confidence: Confidence of the search result. Known values are: "Low", "Medium", and
         "High".
        :paramtype confidence: str or ~azure.mgmt.selfhelp.models.Confidence
        :keyword source: Source of the search result.
        :paramtype source: str
        :keyword result_type: Result type of the search result. Known values are: "Community" and
         "Documentation".
        :paramtype result_type: str or ~azure.mgmt.selfhelp.models.ResultType
        :keyword rank: rank of the search result.
        :paramtype rank: int
        :keyword link: Link to the document.
        :paramtype link: str
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.content = content
        self.title = title
        self.confidence = confidence
        self.source = source
        self.result_type = result_type
        self.rank = rank
        self.link = link


class Section(_serialization.Model):
    """Part of the solution and are dividers in the solution rendering.

    :ivar title: Solution sections title.
    :vartype title: str
    :ivar content: Solution sections content.
    :vartype content: str
    :ivar replacement_maps: Solution replacement maps.
    :vartype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMaps
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "replacement_maps": {"key": "replacementMaps", "type": "ReplacementMaps"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content: Optional[str] = None,
        replacement_maps: Optional["_models.ReplacementMaps"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: Solution sections title.
        :paramtype title: str
        :keyword content: Solution sections content.
        :paramtype content: str
        :keyword replacement_maps: Solution replacement maps.
        :paramtype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMaps
        """
        super().__init__(**kwargs)
        self.title = title
        self.content = content
        self.replacement_maps = replacement_maps


class SectionSelfHelp(_serialization.Model):
    """Part of the solution and are dividers in the solution rendering.

    :ivar title: Solution sections title.
    :vartype title: str
    :ivar content: Solution sections content.
    :vartype content: str
    :ivar replacement_maps: Solution replacement maps.
    :vartype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMapsSelfHelp
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "replacement_maps": {"key": "replacementMaps", "type": "ReplacementMapsSelfHelp"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        content: Optional[str] = None,
        replacement_maps: Optional["_models.ReplacementMapsSelfHelp"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: Solution sections title.
        :paramtype title: str
        :keyword content: Solution sections content.
        :paramtype content: str
        :keyword replacement_maps: Solution replacement maps.
        :paramtype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMapsSelfHelp
        """
        super().__init__(**kwargs)
        self.title = title
        self.content = content
        self.replacement_maps = replacement_maps


class SimplifiedSolutionsResource(ProxyResource):
    """Simplified Solutions response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar solution_id: Solution Id to identify single Simplified Solution.
    :vartype solution_id: str
    :ivar parameters: Client input parameters to run Simplified Solutions.
    :vartype parameters: dict[str, str]
    :ivar title: The title.
    :vartype title: str
    :ivar appendix: Additional parameter response for Simplified Solutions.
    :vartype appendix: dict[str, str]
    :ivar content: The HTML content that needs to be rendered and shown to customer.
    :vartype content: str
    :ivar provisioning_state: Status of Simplified Solution provisioning. Known values are:
     "Succeeded", "PartialComplete", "Failed", "Running", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.selfhelp.models.SolutionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "title": {"readonly": True},
        "appendix": {"readonly": True},
        "content": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "solution_id": {"key": "properties.solutionId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "{str}"},
        "title": {"key": "properties.title", "type": "str"},
        "appendix": {"key": "properties.appendix", "type": "{str}"},
        "content": {"key": "properties.content", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, solution_id: Optional[str] = None, parameters: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id to identify single Simplified Solution.
        :paramtype solution_id: str
        :keyword parameters: Client input parameters to run Simplified Solutions.
        :paramtype parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.parameters = parameters
        self.title = None
        self.appendix = None
        self.content = None
        self.provisioning_state = None


class SolutionMetadataProperties(_serialization.Model):
    """Metadata Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar solution_id: Solution Id.
    :vartype solution_id: str
    :ivar solution_type: Solution Type. Known values are: "Diagnostics", "Solutions",
     "Troubleshooters", and "SelfHelp".
    :vartype solution_type: str or ~azure.mgmt.selfhelp.models.SolutionType
    :ivar description: A detailed description of solution.
    :vartype description: str
    :ivar required_inputs: Required parameters for invoking this particular solution.
    :vartype required_inputs: list[str]
    """

    _validation = {
        "solution_type": {"readonly": True},
        "description": {"readonly": True},
        "required_inputs": {"readonly": True},
    }

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "solution_type": {"key": "solutionType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "required_inputs": {"key": "requiredInputs", "type": "[str]"},
    }

    def __init__(self, *, solution_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword solution_id: Solution Id.
        :paramtype solution_id: str
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.solution_type = None
        self.description = None
        self.required_inputs = None


class SolutionMetadataResource(ProxyResource):
    """Metadata resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar solutions: List of metadata.
    :vartype solutions: list[~azure.mgmt.selfhelp.models.SolutionMetadataProperties]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "solutions": {"key": "properties.solutions", "type": "[SolutionMetadataProperties]"},
    }

    def __init__(
        self, *, solutions: Optional[List["_models.SolutionMetadataProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword solutions: List of metadata.
        :paramtype solutions: list[~azure.mgmt.selfhelp.models.SolutionMetadataProperties]
        """
        super().__init__(**kwargs)
        self.solutions = solutions


class SolutionNlpMetadataResource(ProxyResource):
    """Nlp Metadata resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar problem_title: Title of the problem classification.
    :vartype problem_title: str
    :ivar problem_description: Description of the problem classification.
    :vartype problem_description: str
    :ivar service_id: Id of the service
     (https://learn.microsoft.com/en-us/rest/api/support/services?view=rest-support-2020-04-01) that
     may be used to create a support ticket.
    :vartype service_id: str
    :ivar problem_classification_id: Id of the ProblemClassification
     (https://learn.microsoft.com/en-us/rest/api/support/problem-classifications?view=rest-support-2020-04-01)
     that may be used to create a support ticket.
    :vartype problem_classification_id: str
    :ivar solutions: The list of solution metadata.
    :vartype solutions: list[~azure.mgmt.selfhelp.models.SolutionMetadataProperties]
    :ivar related_services: The set of services that are most likely related to the request. If
     relatedServices is included in the response then solutions may not be discovered until the
     client calls a second time specifying one of the service Ids in the relatedServices object.
    :vartype related_services: list[~azure.mgmt.selfhelp.models.ClassificationService]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "problem_title": {"key": "properties.problemTitle", "type": "str"},
        "problem_description": {"key": "properties.problemDescription", "type": "str"},
        "service_id": {"key": "properties.serviceId", "type": "str"},
        "problem_classification_id": {"key": "properties.problemClassificationId", "type": "str"},
        "solutions": {"key": "properties.solutions", "type": "[SolutionMetadataProperties]"},
        "related_services": {"key": "properties.relatedServices", "type": "[ClassificationService]"},
    }

    def __init__(
        self,
        *,
        problem_title: Optional[str] = None,
        problem_description: Optional[str] = None,
        service_id: Optional[str] = None,
        problem_classification_id: Optional[str] = None,
        solutions: Optional[List["_models.SolutionMetadataProperties"]] = None,
        related_services: Optional[List["_models.ClassificationService"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword problem_title: Title of the problem classification.
        :paramtype problem_title: str
        :keyword problem_description: Description of the problem classification.
        :paramtype problem_description: str
        :keyword service_id: Id of the service
         (https://learn.microsoft.com/en-us/rest/api/support/services?view=rest-support-2020-04-01) that
         may be used to create a support ticket.
        :paramtype service_id: str
        :keyword problem_classification_id: Id of the ProblemClassification
         (https://learn.microsoft.com/en-us/rest/api/support/problem-classifications?view=rest-support-2020-04-01)
         that may be used to create a support ticket.
        :paramtype problem_classification_id: str
        :keyword solutions: The list of solution metadata.
        :paramtype solutions: list[~azure.mgmt.selfhelp.models.SolutionMetadataProperties]
        :keyword related_services: The set of services that are most likely related to the request. If
         relatedServices is included in the response then solutions may not be discovered until the
         client calls a second time specifying one of the service Ids in the relatedServices object.
        :paramtype related_services: list[~azure.mgmt.selfhelp.models.ClassificationService]
        """
        super().__init__(**kwargs)
        self.problem_title = problem_title
        self.problem_description = problem_description
        self.service_id = service_id
        self.problem_classification_id = problem_classification_id
        self.solutions = solutions
        self.related_services = related_services


class SolutionPatchRequestBody(_serialization.Model):
    """Solution PatchRequest body.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar trigger_criteria: Solution request trigger criteria.
    :vartype trigger_criteria: list[~azure.mgmt.selfhelp.models.TriggerCriterion]
    :ivar parameters: Client input parameters to run Solution.
    :vartype parameters: dict[str, str]
    :ivar solution_id: Solution Id to identify single solution.
    :vartype solution_id: str
    :ivar provisioning_state: Status of solution provisioning. Known values are: "Succeeded",
     "PartialComplete", "Failed", "Running", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.selfhelp.models.SolutionProvisioningState
    :ivar title: The title.
    :vartype title: str
    :ivar content: The HTML content that needs to be rendered and shown to customer.
    :vartype content: str
    :ivar replacement_maps: Solution replacement maps.
    :vartype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMaps
    :ivar sections: List of section object.
    :vartype sections: list[~azure.mgmt.selfhelp.models.Section]
    """

    _validation = {
        "solution_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "title": {"readonly": True},
        "content": {"readonly": True},
        "replacement_maps": {"readonly": True},
        "sections": {"readonly": True},
    }

    _attribute_map = {
        "trigger_criteria": {"key": "properties.triggerCriteria", "type": "[TriggerCriterion]"},
        "parameters": {"key": "properties.parameters", "type": "{str}"},
        "solution_id": {"key": "properties.solutionId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "content": {"key": "properties.content", "type": "str"},
        "replacement_maps": {"key": "properties.replacementMaps", "type": "ReplacementMaps"},
        "sections": {"key": "properties.sections", "type": "[Section]"},
    }

    def __init__(
        self,
        *,
        trigger_criteria: Optional[List["_models.TriggerCriterion"]] = None,
        parameters: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword trigger_criteria: Solution request trigger criteria.
        :paramtype trigger_criteria: list[~azure.mgmt.selfhelp.models.TriggerCriterion]
        :keyword parameters: Client input parameters to run Solution.
        :paramtype parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.trigger_criteria = trigger_criteria
        self.parameters = parameters
        self.solution_id = None
        self.provisioning_state = None
        self.title = None
        self.content = None
        self.replacement_maps = None
        self.sections = None


class SolutionResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Solution response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar trigger_criteria: Solution request trigger criteria.
    :vartype trigger_criteria: list[~azure.mgmt.selfhelp.models.TriggerCriterion]
    :ivar parameters: Client input parameters to run Solution.
    :vartype parameters: dict[str, str]
    :ivar solution_id: Solution Id to identify single solution.
    :vartype solution_id: str
    :ivar provisioning_state: Status of solution provisioning. Known values are: "Succeeded",
     "PartialComplete", "Failed", "Running", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.selfhelp.models.SolutionProvisioningState
    :ivar title: The title.
    :vartype title: str
    :ivar content: The HTML content that needs to be rendered and shown to customer.
    :vartype content: str
    :ivar replacement_maps: Solution replacement maps.
    :vartype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMaps
    :ivar sections: List of section object.
    :vartype sections: list[~azure.mgmt.selfhelp.models.Section]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "solution_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "title": {"readonly": True},
        "content": {"readonly": True},
        "replacement_maps": {"readonly": True},
        "sections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "trigger_criteria": {"key": "properties.triggerCriteria", "type": "[TriggerCriterion]"},
        "parameters": {"key": "properties.parameters", "type": "{str}"},
        "solution_id": {"key": "properties.solutionId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "content": {"key": "properties.content", "type": "str"},
        "replacement_maps": {"key": "properties.replacementMaps", "type": "ReplacementMaps"},
        "sections": {"key": "properties.sections", "type": "[Section]"},
    }

    def __init__(
        self,
        *,
        trigger_criteria: Optional[List["_models.TriggerCriterion"]] = None,
        parameters: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword trigger_criteria: Solution request trigger criteria.
        :paramtype trigger_criteria: list[~azure.mgmt.selfhelp.models.TriggerCriterion]
        :keyword parameters: Client input parameters to run Solution.
        :paramtype parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.trigger_criteria = trigger_criteria
        self.parameters = parameters
        self.solution_id = None
        self.provisioning_state = None
        self.title = None
        self.content = None
        self.replacement_maps = None
        self.sections = None


class SolutionResourceSelfHelp(ProxyResource):
    """Self Help Solution response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar solution_id: SolutionId is a unique id to identify a solution. You can retrieve the
     solution id using the Discovery api -
     https://learn.microsoft.com/en-us/rest/api/help/discovery-solution/list?view=rest-help-2023-09-01-preview&tabs=HTTP.  # pylint: disable=line-too-long
    :vartype solution_id: str
    :ivar title: The title.
    :vartype title: str
    :ivar content: The HTML content that needs to be rendered and shown to customer.
    :vartype content: str
    :ivar replacement_maps: Solution replacement maps.
    :vartype replacement_maps: ~azure.mgmt.selfhelp.models.ReplacementMapsSelfHelp
    :ivar sections: List of section object.
    :vartype sections: list[~azure.mgmt.selfhelp.models.SectionSelfHelp]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "solution_id": {"readonly": True},
        "title": {"readonly": True},
        "content": {"readonly": True},
        "replacement_maps": {"readonly": True},
        "sections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "solution_id": {"key": "properties.solutionId", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "content": {"key": "properties.content", "type": "str"},
        "replacement_maps": {"key": "properties.replacementMaps", "type": "ReplacementMapsSelfHelp"},
        "sections": {"key": "properties.sections", "type": "[SectionSelfHelp]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.solution_id = None
        self.title = None
        self.content = None
        self.replacement_maps = None
        self.sections = None


class SolutionsDiagnostic(_serialization.Model):
    """Solutions Diagnostic.

    :ivar solution_id: Solution Id to identify single Solutions Diagnostic.
    :vartype solution_id: str
    :ivar status: Denotes the status of the diagnostic resource. Known values are: "Failed",
     "MissingInputs", "Running", "Succeeded", and "Timeout".
    :vartype status: str or ~azure.mgmt.selfhelp.models.Status
    :ivar status_details: Details of the status.
    :vartype status_details: str
    :ivar replacement_key: Place holder used in HTML Content replace control with the content.
    :vartype replacement_key: str
    :ivar estimated_completion_time: Diagnostics estimated completion time in minutes.
    :vartype estimated_completion_time: str
    :ivar required_parameters: Required parameters of this item.
    :vartype required_parameters: list[str]
    :ivar insights: Diagnostic insights.
    :vartype insights: list[~azure.mgmt.selfhelp.models.Insight]
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_details": {"key": "statusDetails", "type": "str"},
        "replacement_key": {"key": "replacementKey", "type": "str"},
        "estimated_completion_time": {"key": "estimatedCompletionTime", "type": "str"},
        "required_parameters": {"key": "requiredParameters", "type": "[str]"},
        "insights": {"key": "insights", "type": "[Insight]"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        status_details: Optional[str] = None,
        replacement_key: Optional[str] = None,
        estimated_completion_time: Optional[str] = None,
        required_parameters: Optional[List[str]] = None,
        insights: Optional[List["_models.Insight"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id to identify single Solutions Diagnostic.
        :paramtype solution_id: str
        :keyword status: Denotes the status of the diagnostic resource. Known values are: "Failed",
         "MissingInputs", "Running", "Succeeded", and "Timeout".
        :paramtype status: str or ~azure.mgmt.selfhelp.models.Status
        :keyword status_details: Details of the status.
        :paramtype status_details: str
        :keyword replacement_key: Place holder used in HTML Content replace control with the content.
        :paramtype replacement_key: str
        :keyword estimated_completion_time: Diagnostics estimated completion time in minutes.
        :paramtype estimated_completion_time: str
        :keyword required_parameters: Required parameters of this item.
        :paramtype required_parameters: list[str]
        :keyword insights: Diagnostic insights.
        :paramtype insights: list[~azure.mgmt.selfhelp.models.Insight]
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.status = status
        self.status_details = status_details
        self.replacement_key = replacement_key
        self.estimated_completion_time = estimated_completion_time
        self.required_parameters = required_parameters
        self.insights = insights


class SolutionsTroubleshooters(_serialization.Model):
    """Troubleshooters in Solutions.

    :ivar solution_id: Solution Id to identify single Solutions Troubleshooter.
    :vartype solution_id: str
    :ivar title: Troubleshooter title.
    :vartype title: str
    :ivar summary: Troubleshooter summary.
    :vartype summary: str
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        title: Optional[str] = None,
        summary: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id to identify single Solutions Troubleshooter.
        :paramtype solution_id: str
        :keyword title: Troubleshooter title.
        :paramtype title: str
        :keyword summary: Troubleshooter summary.
        :paramtype summary: str
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.title = title
        self.summary = summary


class SolutionWarmUpRequestBody(_serialization.Model):
    """Solution WarmUpRequest body.

    :ivar parameters: Dictionary of :code:`<string>`.
    :vartype parameters: dict[str, str]
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "{str}"},
    }

    def __init__(self, *, parameters: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword parameters: Dictionary of :code:`<string>`.
        :paramtype parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.parameters = parameters


class Step(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Troubleshooter step.

    :ivar id: Unique step id.
    :vartype id: str
    :ivar title: Step title.
    :vartype title: str
    :ivar description: Step description.
    :vartype description: str
    :ivar guidance: Get or sets the Step guidance.
    :vartype guidance: str
    :ivar execution_status: Status of Troubleshooter Step execution. Known values are: "Success",
     "Running", "Failed", and "Warning".
    :vartype execution_status: str or ~azure.mgmt.selfhelp.models.ExecutionStatus
    :ivar execution_status_description: This field has more detailed status description of the
     execution status.
    :vartype execution_status_description: str
    :ivar type: Type of Troubleshooting step. Known values are: "Decision", "Solution", "Insight",
     "AutomatedCheck", and "Input".
    :vartype type: str or ~azure.mgmt.selfhelp.models.Type
    :ivar is_last_step: is this last step of the workflow.
    :vartype is_last_step: bool
    :ivar inputs:
    :vartype inputs: list[~azure.mgmt.selfhelp.models.StepInput]
    :ivar automated_check_results: Only for AutomatedStep type.
    :vartype automated_check_results: ~azure.mgmt.selfhelp.models.AutomatedCheckResult
    :ivar insights:
    :vartype insights: list[~azure.mgmt.selfhelp.models.Insight]
    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.selfhelp.models.ErrorDetail
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "guidance": {"key": "guidance", "type": "str"},
        "execution_status": {"key": "executionStatus", "type": "str"},
        "execution_status_description": {"key": "executionStatusDescription", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_last_step": {"key": "isLastStep", "type": "bool"},
        "inputs": {"key": "inputs", "type": "[StepInput]"},
        "automated_check_results": {"key": "automatedCheckResults", "type": "AutomatedCheckResult"},
        "insights": {"key": "insights", "type": "[Insight]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        title: Optional[str] = None,
        description: Optional[str] = None,
        guidance: Optional[str] = None,
        execution_status: Optional[Union[str, "_models.ExecutionStatus"]] = None,
        execution_status_description: Optional[str] = None,
        type: Optional[Union[str, "_models.Type"]] = None,
        is_last_step: Optional[bool] = None,
        inputs: Optional[List["_models.StepInput"]] = None,
        automated_check_results: Optional["_models.AutomatedCheckResult"] = None,
        insights: Optional[List["_models.Insight"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique step id.
        :paramtype id: str
        :keyword title: Step title.
        :paramtype title: str
        :keyword description: Step description.
        :paramtype description: str
        :keyword guidance: Get or sets the Step guidance.
        :paramtype guidance: str
        :keyword execution_status: Status of Troubleshooter Step execution. Known values are:
         "Success", "Running", "Failed", and "Warning".
        :paramtype execution_status: str or ~azure.mgmt.selfhelp.models.ExecutionStatus
        :keyword execution_status_description: This field has more detailed status description of the
         execution status.
        :paramtype execution_status_description: str
        :keyword type: Type of Troubleshooting step. Known values are: "Decision", "Solution",
         "Insight", "AutomatedCheck", and "Input".
        :paramtype type: str or ~azure.mgmt.selfhelp.models.Type
        :keyword is_last_step: is this last step of the workflow.
        :paramtype is_last_step: bool
        :keyword inputs:
        :paramtype inputs: list[~azure.mgmt.selfhelp.models.StepInput]
        :keyword automated_check_results: Only for AutomatedStep type.
        :paramtype automated_check_results: ~azure.mgmt.selfhelp.models.AutomatedCheckResult
        :keyword insights:
        :paramtype insights: list[~azure.mgmt.selfhelp.models.Insight]
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.selfhelp.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.title = title
        self.description = description
        self.guidance = guidance
        self.execution_status = execution_status
        self.execution_status_description = execution_status_description
        self.type = type
        self.is_last_step = is_last_step
        self.inputs = inputs
        self.automated_check_results = automated_check_results
        self.insights = insights
        self.error = error


class StepInput(_serialization.Model):
    """Details of step input.

    :ivar question_id: Use Index as QuestionId.
    :vartype question_id: str
    :ivar question_type: Type of Question. Known values are: "RadioButton", "Dropdown",
     "TextInput", "MultiLineInfoBox", "DateTimePicker", and "MultiSelect".
    :vartype question_type: str or ~azure.mgmt.selfhelp.models.QuestionType
    :ivar question_title: Question title.
    :vartype question_title: str
    :ivar question_content: User question content.
    :vartype question_content: str
    :ivar question_content_type: Default is Text. Known values are: "Text", "Html", and "Markdown".
    :vartype question_content_type: str or ~azure.mgmt.selfhelp.models.QuestionContentType
    :ivar response_hint: Place holder text for response hints.
    :vartype response_hint: str
    :ivar recommended_option: Result of Automate step.
    :vartype recommended_option: str
    :ivar selected_option_value: Text of response that was selected.
    :vartype selected_option_value: str
    :ivar response_validation_properties: Troubleshooter step input response validation properties.
    :vartype response_validation_properties:
     ~azure.mgmt.selfhelp.models.ResponseValidationProperties
    :ivar response_options:
    :vartype response_options: list[~azure.mgmt.selfhelp.models.ResponseOption]
    """

    _attribute_map = {
        "question_id": {"key": "questionId", "type": "str"},
        "question_type": {"key": "questionType", "type": "str"},
        "question_title": {"key": "questionTitle", "type": "str"},
        "question_content": {"key": "questionContent", "type": "str"},
        "question_content_type": {"key": "questionContentType", "type": "str"},
        "response_hint": {"key": "responseHint", "type": "str"},
        "recommended_option": {"key": "recommendedOption", "type": "str"},
        "selected_option_value": {"key": "selectedOptionValue", "type": "str"},
        "response_validation_properties": {
            "key": "responseValidationProperties",
            "type": "ResponseValidationProperties",
        },
        "response_options": {"key": "responseOptions", "type": "[ResponseOption]"},
    }

    def __init__(
        self,
        *,
        question_id: Optional[str] = None,
        question_type: Optional[Union[str, "_models.QuestionType"]] = None,
        question_title: Optional[str] = None,
        question_content: Optional[str] = None,
        question_content_type: Optional[Union[str, "_models.QuestionContentType"]] = None,
        response_hint: Optional[str] = None,
        recommended_option: Optional[str] = None,
        selected_option_value: Optional[str] = None,
        response_validation_properties: Optional["_models.ResponseValidationProperties"] = None,
        response_options: Optional[List["_models.ResponseOption"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword question_id: Use Index as QuestionId.
        :paramtype question_id: str
        :keyword question_type: Type of Question. Known values are: "RadioButton", "Dropdown",
         "TextInput", "MultiLineInfoBox", "DateTimePicker", and "MultiSelect".
        :paramtype question_type: str or ~azure.mgmt.selfhelp.models.QuestionType
        :keyword question_title: Question title.
        :paramtype question_title: str
        :keyword question_content: User question content.
        :paramtype question_content: str
        :keyword question_content_type: Default is Text. Known values are: "Text", "Html", and
         "Markdown".
        :paramtype question_content_type: str or ~azure.mgmt.selfhelp.models.QuestionContentType
        :keyword response_hint: Place holder text for response hints.
        :paramtype response_hint: str
        :keyword recommended_option: Result of Automate step.
        :paramtype recommended_option: str
        :keyword selected_option_value: Text of response that was selected.
        :paramtype selected_option_value: str
        :keyword response_validation_properties: Troubleshooter step input response validation
         properties.
        :paramtype response_validation_properties:
         ~azure.mgmt.selfhelp.models.ResponseValidationProperties
        :keyword response_options:
        :paramtype response_options: list[~azure.mgmt.selfhelp.models.ResponseOption]
        """
        super().__init__(**kwargs)
        self.question_id = question_id
        self.question_type = question_type
        self.question_title = question_title
        self.question_content = question_content
        self.question_content_type = question_content_type
        self.response_hint = response_hint
        self.recommended_option = recommended_option
        self.selected_option_value = selected_option_value
        self.response_validation_properties = response_validation_properties
        self.response_options = response_options


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TriggerCriterion(_serialization.Model):
    """Solution request trigger criterion. SolutionId/ProblemClassificationId is the only supported
    trigger type for Solution PUT request. ReplacementKey is the only supported trigger type for
    Solution PATCH request.

    :ivar name: Trigger criterion name. Known values are: "SolutionId", "ProblemClassificationId",
     and "ReplacementKey".
    :vartype name: str or ~azure.mgmt.selfhelp.models.Name
    :ivar value: Trigger criterion value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.Name"]] = None, value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Trigger criterion name. Known values are: "SolutionId",
         "ProblemClassificationId", and "ReplacementKey".
        :paramtype name: str or ~azure.mgmt.selfhelp.models.Name
        :keyword value: Trigger criterion value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class TroubleshooterResource(ProxyResource):
    """Troubleshooter response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar solution_id: Solution Id to identify single troubleshooter.
    :vartype solution_id: str
    :ivar parameters: Client input parameters to run Troubleshooter Resource.
    :vartype parameters: dict[str, str]
    :ivar provisioning_state: Status of troubleshooter provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Running", and "AutoContinue".
    :vartype provisioning_state: str or ~azure.mgmt.selfhelp.models.TroubleshooterProvisioningState
    :ivar steps: List of step object.
    :vartype steps: list[~azure.mgmt.selfhelp.models.Step]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "steps": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "solution_id": {"key": "properties.solutionId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "steps": {"key": "properties.steps", "type": "[Step]"},
    }

    def __init__(
        self, *, solution_id: Optional[str] = None, parameters: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id to identify single troubleshooter.
        :paramtype solution_id: str
        :keyword parameters: Client input parameters to run Troubleshooter Resource.
        :paramtype parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.parameters = parameters
        self.provisioning_state = None
        self.steps = None


class TroubleshooterResponse(_serialization.Model):
    """User Response for Troubleshooter continue request.

    :ivar question_id: id of the question.
    :vartype question_id: str
    :ivar question_type: Type of Question. Known values are: "RadioButton", "Dropdown",
     "TextInput", "MultiLineInfoBox", "DateTimePicker", and "MultiSelect".
    :vartype question_type: str or ~azure.mgmt.selfhelp.models.QuestionType
    :ivar response: Response key for SingleInput. For Multi-line test/open ended question it is
     free form text.
    :vartype response: str
    """

    _attribute_map = {
        "question_id": {"key": "questionId", "type": "str"},
        "question_type": {"key": "questionType", "type": "str"},
        "response": {"key": "response", "type": "str"},
    }

    def __init__(
        self,
        *,
        question_id: Optional[str] = None,
        question_type: Optional[Union[str, "_models.QuestionType"]] = None,
        response: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword question_id: id of the question.
        :paramtype question_id: str
        :keyword question_type: Type of Question. Known values are: "RadioButton", "Dropdown",
         "TextInput", "MultiLineInfoBox", "DateTimePicker", and "MultiSelect".
        :paramtype question_type: str or ~azure.mgmt.selfhelp.models.QuestionType
        :keyword response: Response key for SingleInput. For Multi-line test/open ended question it is
         free form text.
        :paramtype response: str
        """
        super().__init__(**kwargs)
        self.question_id = question_id
        self.question_type = question_type
        self.response = response


class VideoGroupVideo(_serialization.Model):
    """VideoGroup video detail.

    :ivar src: Link to the video.
    :vartype src: str
    :ivar title: Title of the video.
    :vartype title: str
    """

    _attribute_map = {
        "src": {"key": "src", "type": "str"},
        "title": {"key": "title", "type": "str"},
    }

    def __init__(self, *, src: Optional[str] = None, title: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword src: Link to the video.
        :paramtype src: str
        :keyword title: Title of the video.
        :paramtype title: str
        """
        super().__init__(**kwargs)
        self.src = src
        self.title = title


class Video(VideoGroupVideo):
    """Video detail.

    :ivar src: Link to the video.
    :vartype src: str
    :ivar title: Title of the video.
    :vartype title: str
    :ivar replacement_key: Place holder used in HTML Content replace control with the insight
     content.
    :vartype replacement_key: str
    """

    _attribute_map = {
        "src": {"key": "src", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "replacement_key": {"key": "replacementKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        src: Optional[str] = None,
        title: Optional[str] = None,
        replacement_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword src: Link to the video.
        :paramtype src: str
        :keyword title: Title of the video.
        :paramtype title: str
        :keyword replacement_key: Place holder used in HTML Content replace control with the insight
         content.
        :paramtype replacement_key: str
        """
        super().__init__(src=src, title=title, **kwargs)
        self.replacement_key = replacement_key


class VideoGroup(_serialization.Model):
    """Video group detail.

    :ivar videos: List of videos will be shown to customers.
    :vartype videos: list[~azure.mgmt.selfhelp.models.VideoGroupVideo]
    :ivar replacement_key: Place holder used in HTML Content replace control with the insight
     content.
    :vartype replacement_key: str
    """

    _attribute_map = {
        "videos": {"key": "videos", "type": "[VideoGroupVideo]"},
        "replacement_key": {"key": "replacementKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        videos: Optional[List["_models.VideoGroupVideo"]] = None,
        replacement_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword videos: List of videos will be shown to customers.
        :paramtype videos: list[~azure.mgmt.selfhelp.models.VideoGroupVideo]
        :keyword replacement_key: Place holder used in HTML Content replace control with the insight
         content.
        :paramtype replacement_key: str
        """
        super().__init__(**kwargs)
        self.videos = videos
        self.replacement_key = replacement_key


class WebResult(_serialization.Model):
    """AzureKB web result.

    :ivar replacement_key: Place holder used in HTML Content replace control with the content.
    :vartype replacement_key: str
    :ivar search_results: AzureKB search results.
    :vartype search_results: list[~azure.mgmt.selfhelp.models.SearchResult]
    """

    _attribute_map = {
        "replacement_key": {"key": "replacementKey", "type": "str"},
        "search_results": {"key": "searchResults", "type": "[SearchResult]"},
    }

    def __init__(
        self,
        *,
        replacement_key: Optional[str] = None,
        search_results: Optional[List["_models.SearchResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword replacement_key: Place holder used in HTML Content replace control with the content.
        :paramtype replacement_key: str
        :keyword search_results: AzureKB search results.
        :paramtype search_results: list[~azure.mgmt.selfhelp.models.SearchResult]
        """
        super().__init__(**kwargs)
        self.replacement_key = replacement_key
        self.search_results = search_results
