# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterCustomEntityStoreAssignmentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_custom_entity_store_assignments_get(self, resource_group):
        response = await self.client.custom_entity_store_assignments.get(
            resource_group_name=resource_group.name,
            custom_entity_store_assignment_name="str",
            api_version="2021-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_custom_entity_store_assignments_create(self, resource_group):
        response = await self.client.custom_entity_store_assignments.create(
            resource_group_name=resource_group.name,
            custom_entity_store_assignment_name="str",
            custom_entity_store_assignment_request_body={"principal": "str"},
            api_version="2021-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_custom_entity_store_assignments_delete(self, resource_group):
        response = await self.client.custom_entity_store_assignments.delete(
            resource_group_name=resource_group.name,
            custom_entity_store_assignment_name="str",
            api_version="2021-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_custom_entity_store_assignments_list_by_resource_group(self, resource_group):
        response = self.client.custom_entity_store_assignments.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2021-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_custom_entity_store_assignments_list_by_subscription(self, resource_group):
        response = self.client.custom_entity_store_assignments.list_by_subscription(
            api_version="2021-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
