# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterAlertsSuppressionRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alerts_suppression_rules_list(self, resource_group):
        response = self.client.alerts_suppression_rules.list(
            api_version="2019-01-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alerts_suppression_rules_get(self, resource_group):
        response = self.client.alerts_suppression_rules.get(
            alerts_suppression_rule_name="str",
            api_version="2019-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alerts_suppression_rules_update(self, resource_group):
        response = self.client.alerts_suppression_rules.update(
            alerts_suppression_rule_name="str",
            alerts_suppression_rule={
                "alertType": "str",
                "comment": "str",
                "expirationDateUtc": "2020-02-20 00:00:00",
                "id": "str",
                "lastModifiedUtc": "2020-02-20 00:00:00",
                "name": "str",
                "reason": "str",
                "state": "str",
                "suppressionAlertsScope": {"allOf": [{"field": "str"}]},
                "type": "str",
            },
            api_version="2019-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_alerts_suppression_rules_delete(self, resource_group):
        response = self.client.alerts_suppression_rules.delete(
            alerts_suppression_rule_name="str",
            api_version="2019-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
