# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.redis.aio import RedisManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRedisManagementPatchSchedulesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RedisManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_patch_schedules_list_by_redis_resource(self, resource_group):
        response = self.client.patch_schedules.list_by_redis_resource(
            resource_group_name=resource_group.name,
            cache_name="str",
            api_version="2024-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_patch_schedules_create_or_update(self, resource_group):
        response = await self.client.patch_schedules.create_or_update(
            resource_group_name=resource_group.name,
            name="str",
            default="str",
            parameters={
                "scheduleEntries": [{"dayOfWeek": "str", "startHourUtc": 0, "maintenanceWindow": "1 day, 0:00:00"}],
                "id": "str",
                "location": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_patch_schedules_delete(self, resource_group):
        response = await self.client.patch_schedules.delete(
            resource_group_name=resource_group.name,
            name="str",
            default="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_patch_schedules_get(self, resource_group):
        response = await self.client.patch_schedules.get(
            resource_group_name=resource_group.name,
            name="str",
            default="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...
