# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from json import loads as _loads
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
# fmt: off

def build_metadata_roles_list_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2021-07-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/metadataRoles')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_metadata_policy_list_all_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    collection_name = kwargs.pop('collection_name', None)  # type: Optional[str]

    api_version = "2021-07-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/metadataPolicies')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if collection_name is not None:
        query_parameters['collectionName'] = _SERIALIZER.query("collection_name", collection_name, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_metadata_policy_update_request(
    policy_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-07-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/metadataPolicies/{policyId}')
    path_format_arguments = {
        "policyId": _SERIALIZER.url("policy_id", policy_id, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_metadata_policy_get_request(
    policy_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2021-07-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/metadataPolicies/{policyId}')
    path_format_arguments = {
        "policyId": _SERIALIZER.url("policy_id", policy_id, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class MetadataRolesOperations(object):
    """MetadataRolesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """Lists roles for Purview Account.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "values": [
                        {
                            "id": "str",  # Optional. The Id of role.
                            "name": "str",  # Optional. The name of role.
                            "properties": {
                                "cnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "description": "str",  # Optional. The description of role.
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "friendlyName": "str",  # Optional. The friendly name of role.
                                "provisioningState": "str",  # Optional. The provisioningState of role.
                                "roleType": "str",  # Optional. The type of role.
                                "version": 0.0  # Optional. The version of role.
                            },
                            "type": "str"  # Optional. The type of role.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_metadata_roles_list_request(
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_metadata_roles_list_request(
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["values"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': '/metadataRoles'}  # type: ignore
class MetadataPolicyOperations(object):
    """MetadataPolicyOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list_all(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """List or Get metadata policies.

        :keyword collection_name: The name of an existing collection for which one policy needs to be
         fetched.
        :paramtype collection_name: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "values": [
                        {
                            "id": "str",  # Optional. The id of policy.
                            "name": "str",  # Optional. The name of policy.
                            "properties": {
                                "attributeRules": [
                                    {
                                        "dnfCondition": [
                                            [
                                                {
                                                    "attributeName": "str",  # Optional. AttributeName.
                                                    "attributeValueExcludedIn": [
                                                        "str"  # Optional. List of values excluded for attribute.
                                                    ],
                                                    "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                                    "attributeValueIncludedIn": [
                                                        "str"  # Optional. List of values for attribute.
                                                    ],
                                                    "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                                }
                                            ]
                                        ],
                                        "id": "str",  # Optional. The id for rule.
                                        "kind": "str",  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                                        "name": "str"  # Optional. The name for rule.
                                    }
                                ],
                                "collection": {
                                    "referenceName": "str",  # Optional. The name of reference.
                                    "type": "CollectionReference"  # Optional. Default value is "CollectionReference". The type of reference.
                                },
                                "decisionRules": [
                                    {
                                        "dnfCondition": [
                                            [
                                                {
                                                    "attributeName": "str",  # Optional. AttributeName.
                                                    "attributeValueExcludedIn": [
                                                        "str"  # Optional. List of values excluded for attribute.
                                                    ],
                                                    "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                                    "attributeValueIncludedIn": [
                                                        "str"  # Optional. List of values for attribute.
                                                    ],
                                                    "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                                }
                                            ]
                                        ],
                                        "effect": "str",  # Optional. The effect for rule. Possible values include: "Deny", "Permit".
                                        "kind": "str"  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                                    }
                                ],
                                "description": "str",  # Optional. The description of policy.
                                "parentCollectionName": "str"  # Optional. The parent collection of the policy.
                            },
                            "version": 0  # Optional. The version of policy.
                        }
                    ]
                }
        """
        collection_name = kwargs.pop('collection_name', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_metadata_policy_list_all_request(
                    collection_name=collection_name,
                    template_url=self.list_all.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_metadata_policy_list_all_request(
                    collection_name=collection_name,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["values"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_all.metadata = {'url': '/metadataPolicies'}  # type: ignore

    @distributed_trace
    def update(
        self,
        policy_id,  # type: str
        body=None,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Updates a metadata policy.

        :param policy_id: Unique policy id.
        :type policy_id: str
        :param body: Policy to be updated.
        :type body: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "id": "str",  # Optional. The id of policy.
                    "name": "str",  # Optional. The name of policy.
                    "properties": {
                        "attributeRules": [
                            {
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "id": "str",  # Optional. The id for rule.
                                "kind": "str",  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                                "name": "str"  # Optional. The name for rule.
                            }
                        ],
                        "collection": {
                            "referenceName": "str",  # Optional. The name of reference.
                            "type": "CollectionReference"  # Optional. Default value is "CollectionReference". The type of reference.
                        },
                        "decisionRules": [
                            {
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "effect": "str",  # Optional. The effect for rule. Possible values include: "Deny", "Permit".
                                "kind": "str"  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                            }
                        ],
                        "description": "str",  # Optional. The description of policy.
                        "parentCollectionName": "str"  # Optional. The parent collection of the policy.
                    },
                    "version": 0  # Optional. The version of policy.
                }

                # response body for status code(s): 200
                response.json() == {
                    "id": "str",  # Optional. The id of policy.
                    "name": "str",  # Optional. The name of policy.
                    "properties": {
                        "attributeRules": [
                            {
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "id": "str",  # Optional. The id for rule.
                                "kind": "str",  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                                "name": "str"  # Optional. The name for rule.
                            }
                        ],
                        "collection": {
                            "referenceName": "str",  # Optional. The name of reference.
                            "type": "CollectionReference"  # Optional. Default value is "CollectionReference". The type of reference.
                        },
                        "decisionRules": [
                            {
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "effect": "str",  # Optional. The effect for rule. Possible values include: "Deny", "Permit".
                                "kind": "str"  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                            }
                        ],
                        "description": "str",  # Optional. The description of policy.
                        "parentCollectionName": "str"  # Optional. The parent collection of the policy.
                    },
                    "version": 0  # Optional. The version of policy.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if body is not None:
            json = body
        else:
            json = None

        request = build_metadata_policy_update_request(
            policy_id=policy_id,
            content_type=content_type,
            json=json,
            template_url=self.update.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {'url': '/metadataPolicies/{policyId}'}  # type: ignore


    @distributed_trace
    def get(
        self,
        policy_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Gets a metadata policy.

        :param policy_id: Id of an existing policy that needs to be fetched.
        :type policy_id: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "id": "str",  # Optional. The id of policy.
                    "name": "str",  # Optional. The name of policy.
                    "properties": {
                        "attributeRules": [
                            {
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "id": "str",  # Optional. The id for rule.
                                "kind": "str",  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                                "name": "str"  # Optional. The name for rule.
                            }
                        ],
                        "collection": {
                            "referenceName": "str",  # Optional. The name of reference.
                            "type": "CollectionReference"  # Optional. Default value is "CollectionReference". The type of reference.
                        },
                        "decisionRules": [
                            {
                                "dnfCondition": [
                                    [
                                        {
                                            "attributeName": "str",  # Optional. AttributeName.
                                            "attributeValueExcludedIn": [
                                                "str"  # Optional. List of values excluded for attribute.
                                            ],
                                            "attributeValueExcludes": "str",  # Optional. Value excluded for attribute.
                                            "attributeValueIncludedIn": [
                                                "str"  # Optional. List of values for attribute.
                                            ],
                                            "attributeValueIncludes": "str"  # Optional. Value for attribute.
                                        }
                                    ]
                                ],
                                "effect": "str",  # Optional. The effect for rule. Possible values include: "Deny", "Permit".
                                "kind": "str"  # Optional. The kind of rule. Possible values include: "decisionrule", "attributerule".
                            }
                        ],
                        "description": "str",  # Optional. The description of policy.
                        "parentCollectionName": "str"  # Optional. The parent collection of the policy.
                    },
                    "version": 0  # Optional. The version of policy.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_metadata_policy_get_request(
            policy_id=policy_id,
            template_url=self.get.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/metadataPolicies/{policyId}'}  # type: ignore

