# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iotoperations import IoTOperationsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIoTOperationsMgmtBrokerAuthorizationOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IoTOperationsMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_broker_authorization_get(self, resource_group):
        response = self.client.broker_authorization.get(
            resource_group_name=resource_group.name,
            instance_name="str",
            broker_name="str",
            authorization_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_broker_authorization_begin_create_or_update(self, resource_group):
        response = self.client.broker_authorization.begin_create_or_update(
            resource_group_name=resource_group.name,
            instance_name="str",
            broker_name="str",
            authorization_name="str",
            resource={
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "authorizationPolicies": {
                        "cache": "str",
                        "rules": [
                            {
                                "brokerResources": [{"method": "str", "clientIds": ["str"], "topics": ["str"]}],
                                "principals": {
                                    "attributes": [{"str": "str"}],
                                    "clientIds": ["str"],
                                    "usernames": ["str"],
                                },
                                "stateStoreResources": [{"keyType": "str", "keys": ["str"], "method": "str"}],
                            }
                        ],
                    },
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_broker_authorization_begin_delete(self, resource_group):
        response = self.client.broker_authorization.begin_delete(
            resource_group_name=resource_group.name,
            instance_name="str",
            broker_name="str",
            authorization_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_broker_authorization_list_by_resource_group(self, resource_group):
        response = self.client.broker_authorization.list_by_resource_group(
            resource_group_name=resource_group.name,
            instance_name="str",
            broker_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
