# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AsyncOperationResult(_Model):
    """Result of a long running operation.

    :ivar status: current status of a long running operation.
    :vartype status: str
    :ivar error: Error message containing code, description and details.
    :vartype error: ~azure.mgmt.iothubprovisioningservices.models.ErrorMessage
    """

    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """current status of a long running operation."""
    error: Optional["_models.ErrorMessage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message containing code, description and details."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[str] = None,
        error: Optional["_models.ErrorMessage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertificateProperties(_Model):
    """The description of an X509 CA Certificate.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: bytes
    :ivar created: The certificate's creation date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    """

    subject: Optional[str] = rest_field(visibility=["read"])
    """The certificate's subject name."""
    expiry: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc7231")
    """The certificate's expiration date and time."""
    thumbprint: Optional[str] = rest_field(visibility=["read"])
    """The certificate's thumbprint."""
    is_verified: Optional[bool] = rest_field(
        name="isVerified", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines whether certificate has been verified."""
    certificate: Optional[bytes] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="base64"
    )
    """base-64 representation of X509 certificate .cer file or just .pem file content."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc7231")
    """The certificate's creation date and time."""
    updated: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc7231")
    """The certificate's last update date and time."""

    @overload
    def __init__(
        self,
        *,
        is_verified: Optional[bool] = None,
        certificate: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    """


class CertificateResponse(ProxyResource):
    """The X509 Certificate.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    :ivar properties: properties of a certificate.
    :vartype properties: ~azure.mgmt.iothubprovisioningservices.models.CertificateProperties
    :ivar etag: The entity tag.
    :vartype etag: str
    """

    properties: Optional["_models.CertificateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """properties of a certificate."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """The entity tag."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CertificateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeviceRegistryNamespaceDescription(_Model):
    """Description of the Device Registry namespace that is linked to the provisioning service.

    :ivar resource_id: The ARM resource ID of the Device Registry namespace. Required.
    :vartype resource_id: str
    :ivar authentication_type: Device Registry Namespace MI authentication type: UserAssigned,
     SystemAssigned. Required. Known values are: "UserAssigned" and "SystemAssigned".
    :vartype authentication_type: str or
     ~azure.mgmt.iothubprovisioningservices.models.DeviceRegistryNamespaceAuthenticationType
    :ivar selected_user_assigned_identity_resource_id: The selected user-assigned identity resource
     Id associated with Device Registry namespace. This is required when authenticationType is
     UserAssigned.
    :vartype selected_user_assigned_identity_resource_id: str
    """

    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource ID of the Device Registry namespace. Required."""
    authentication_type: Union[str, "_models.DeviceRegistryNamespaceAuthenticationType"] = rest_field(
        name="authenticationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Device Registry Namespace MI authentication type: UserAssigned, SystemAssigned. Required. Known
     values are: \"UserAssigned\" and \"SystemAssigned\"."""
    selected_user_assigned_identity_resource_id: Optional[str] = rest_field(
        name="selectedUserAssignedIdentityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The selected user-assigned identity resource Id associated with Device Registry namespace. This
     is required when authenticationType is UserAssigned."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
        authentication_type: Union[str, "_models.DeviceRegistryNamespaceAuthenticationType"],
        selected_user_assigned_identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.iothubprovisioningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.iothubprovisioningservices.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorDetails(_Model):
    """Error details.

    :ivar code: The error code.
    :vartype code: int
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    code: Optional[int] = rest_field(visibility=["read"])
    """The error code."""
    http_status_code: Optional[str] = rest_field(name="httpStatusCode", visibility=["read"])
    """The HTTP status code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    details: Optional[str] = rest_field(visibility=["read"])
    """The error details."""


class ErrorMessage(_Model):
    """Error response containing message and code.

    :ivar code: standard error code.
    :vartype code: str
    :ivar message: standard error description.
    :vartype message: str
    :ivar details: detailed summary of error.
    :vartype details: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """standard error code."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """standard error description."""
    details: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """detailed summary of error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.iothubprovisioningservices.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupIdInformation(ProxyResource):
    """The group information for creating a private endpoint on a provisioning service.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    :ivar properties: The properties for a group information object. Required.
    :vartype properties: ~azure.mgmt.iothubprovisioningservices.models.GroupIdInformationProperties
    """

    properties: "_models.GroupIdInformationProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for a group information object. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.GroupIdInformationProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GroupIdInformationProperties(_Model):
    """The properties for a group information object.

    :ivar group_id: The group id.
    :vartype group_id: str
    :ivar required_members: The required members for a specific group id.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required DNS zones for a specific group id.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read", "create", "update", "delete", "query"])
    """The group id."""
    required_members: Optional[list[str]] = rest_field(
        name="requiredMembers", visibility=["read", "create", "update", "delete", "query"]
    )
    """The required members for a specific group id."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The required DNS zones for a specific group id."""

    @overload
    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[list[str]] = None,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IotDpsPropertiesDescription(_Model):
    """the service specific properties of a provisioning service, including keys, linked iot hubs,
    current state, and system generated properties such as hostname and idScope.

    :ivar state: Current state of the provisioning service. Known values are: "Activating",
     "Active", "Deleting", "Deleted", "ActivationFailed", "DeletionFailed", "Transitioning",
     "Suspending", "Suspended", "Resuming", "FailingOver", and "FailoverFailed".
    :vartype state: str or ~azure.mgmt.iothubprovisioningservices.models.State
    :ivar public_network_access: Whether requests from Public Network are allowed. Known values
     are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.iothubprovisioningservices.models.PublicNetworkAccess
    :ivar ip_filter_rules: The IP filter rules.
    :vartype ip_filter_rules: list[~azure.mgmt.iothubprovisioningservices.models.IpFilterRule]
    :ivar private_endpoint_connections: Private endpoint connections created on this IotHub.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
    :ivar provisioning_state: The ARM provisioning state of the provisioning service.
    :vartype provisioning_state: str
    :ivar iot_hubs: List of IoT hubs associated with this provisioning service.
    :vartype iot_hubs:
     list[~azure.mgmt.iothubprovisioningservices.models.IotHubDefinitionDescription]
    :ivar device_registry_namespace: The Device Registry namespace that is linked to the
     provisioning service.
    :vartype device_registry_namespace:
     ~azure.mgmt.iothubprovisioningservices.models.DeviceRegistryNamespaceDescription
    :ivar allocation_policy: Allocation policy to be used by this provisioning service. Known
     values are: "Hashed", "GeoLatency", and "Static".
    :vartype allocation_policy: str or
     ~azure.mgmt.iothubprovisioningservices.models.AllocationPolicy
    :ivar service_operations_host_name: Service endpoint for provisioning service.
    :vartype service_operations_host_name: str
    :ivar device_provisioning_host_name: Device endpoint for this provisioning service.
    :vartype device_provisioning_host_name: str
    :ivar id_scope: Unique identifier of this provisioning service.
    :vartype id_scope: str
    :ivar authorization_policies: List of authorization keys for a provisioning service.
    :vartype authorization_policies:
     list[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
    :ivar enable_data_residency: Optional.
     Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster
     recovery.
    :vartype enable_data_residency: bool
    :ivar portal_operations_host_name: Portal endpoint to enable CORS for this provisioning
     service.
    :vartype portal_operations_host_name: str
    """

    state: Optional[Union[str, "_models.State"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Current state of the provisioning service. Known values are: \"Activating\", \"Active\",
     \"Deleting\", \"Deleted\", \"ActivationFailed\", \"DeletionFailed\", \"Transitioning\",
     \"Suspending\", \"Suspended\", \"Resuming\", \"FailingOver\", and \"FailoverFailed\"."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether requests from Public Network are allowed. Known values are: \"Enabled\" and
     \"Disabled\"."""
    ip_filter_rules: Optional[list["_models.IpFilterRule"]] = rest_field(
        name="ipFilterRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP filter rules."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private endpoint connections created on this IotHub."""
    provisioning_state: Optional[str] = rest_field(
        name="provisioningState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM provisioning state of the provisioning service."""
    iot_hubs: Optional[list["_models.IotHubDefinitionDescription"]] = rest_field(
        name="iotHubs", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of IoT hubs associated with this provisioning service."""
    device_registry_namespace: Optional["_models.DeviceRegistryNamespaceDescription"] = rest_field(
        name="deviceRegistryNamespace", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Device Registry namespace that is linked to the provisioning service."""
    allocation_policy: Optional[Union[str, "_models.AllocationPolicy"]] = rest_field(
        name="allocationPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allocation policy to be used by this provisioning service. Known values are: \"Hashed\",
     \"GeoLatency\", and \"Static\"."""
    service_operations_host_name: Optional[str] = rest_field(name="serviceOperationsHostName", visibility=["read"])
    """Service endpoint for provisioning service."""
    device_provisioning_host_name: Optional[str] = rest_field(name="deviceProvisioningHostName", visibility=["read"])
    """Device endpoint for this provisioning service."""
    id_scope: Optional[str] = rest_field(name="idScope", visibility=["read"])
    """Unique identifier of this provisioning service."""
    authorization_policies: Optional[list["_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription"]] = (
        rest_field(name="authorizationPolicies", visibility=["read", "create", "update", "delete", "query"])
    )
    """List of authorization keys for a provisioning service."""
    enable_data_residency: Optional[bool] = rest_field(
        name="enableDataResidency", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional.
     Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster
     recovery."""
    portal_operations_host_name: Optional[str] = rest_field(
        name="portalOperationsHostName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Portal endpoint to enable CORS for this provisioning service."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.State"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        ip_filter_rules: Optional[list["_models.IpFilterRule"]] = None,
        private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = None,
        provisioning_state: Optional[str] = None,
        iot_hubs: Optional[list["_models.IotHubDefinitionDescription"]] = None,
        device_registry_namespace: Optional["_models.DeviceRegistryNamespaceDescription"] = None,
        allocation_policy: Optional[Union[str, "_models.AllocationPolicy"]] = None,
        authorization_policies: Optional[
            list["_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription"]
        ] = None,
        enable_data_residency: Optional[bool] = None,
        portal_operations_host_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IotDpsSkuDefinition(_Model):
    """Available SKUs of tier and units.

    :ivar name: Sku name. "S1"
    :vartype name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
    """

    name: Optional[Union[str, "_models.IotDpsSku"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Sku name. \"S1\""""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.IotDpsSku"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IotDpsSkuInfo(_Model):
    """List of possible provisioning service SKUs.

    :ivar name: Sku name. "S1"
    :vartype name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
    :ivar tier: Pricing tier name of the provisioning service.
    :vartype tier: str
    :ivar capacity: The number of units to provision.
    :vartype capacity: int
    """

    name: Optional[Union[str, "_models.IotDpsSku"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Sku name. \"S1\""""
    tier: Optional[str] = rest_field(visibility=["read"])
    """Pricing tier name of the provisioning service."""
    capacity: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of units to provision."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.IotDpsSku"]] = None,
        capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IotHubDefinitionDescription(_Model):
    """Description of the IoT hub.

    :ivar apply_allocation_policy: flag for applying allocationPolicy or not for a given iot hub.
    :vartype apply_allocation_policy: bool
    :ivar allocation_weight: weight to apply for a given iot h.
    :vartype allocation_weight: int
    :ivar name: Host name of the IoT hub.
    :vartype name: str
    :ivar connection_string: Connection string of the IoT hub. Required.
    :vartype connection_string: str
    :ivar location: ARM region of the IoT hub. Required.
    :vartype location: str
    """

    apply_allocation_policy: Optional[bool] = rest_field(
        name="applyAllocationPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """flag for applying allocationPolicy or not for a given iot hub."""
    allocation_weight: Optional[int] = rest_field(
        name="allocationWeight", visibility=["read", "create", "update", "delete", "query"]
    )
    """weight to apply for a given iot h."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Host name of the IoT hub."""
    connection_string: str = rest_field(
        name="connectionString", visibility=["read", "create", "update", "delete", "query"]
    )
    """Connection string of the IoT hub. Required."""
    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ARM region of the IoT hub. Required."""

    @overload
    def __init__(
        self,
        *,
        connection_string: str,
        location: str,
        apply_allocation_policy: Optional[bool] = None,
        allocation_weight: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpFilterRule(_Model):
    """The IP filter rules for a provisioning Service.

    :ivar filter_name: The name of the IP filter rule. Required.
    :vartype filter_name: str
    :ivar action: The desired action for requests captured by this rule. Required. Known values
     are: "Accept" and "Reject".
    :vartype action: str or ~azure.mgmt.iothubprovisioningservices.models.IpFilterActionType
    :ivar ip_mask: A string that contains the IP address range in CIDR notation for the rule.
     Required.
    :vartype ip_mask: str
    :ivar target: Target for requests captured by this rule. Known values are: "all", "serviceApi",
     and "deviceApi".
    :vartype target: str or ~azure.mgmt.iothubprovisioningservices.models.IpFilterTargetType
    """

    filter_name: str = rest_field(name="filterName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the IP filter rule. Required."""
    action: Union[str, "_models.IpFilterActionType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired action for requests captured by this rule. Required. Known values are: \"Accept\"
     and \"Reject\"."""
    ip_mask: str = rest_field(name="ipMask", visibility=["read", "create", "update", "delete", "query"])
    """A string that contains the IP address range in CIDR notation for the rule. Required."""
    target: Optional[Union[str, "_models.IpFilterTargetType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Target for requests captured by this rule. Known values are: \"all\", \"serviceApi\", and
     \"deviceApi\"."""

    @overload
    def __init__(
        self,
        *,
        filter_name: str,
        action: Union[str, "_models.IpFilterActionType"],
        ip_mask: str,
        target: Optional[Union[str, "_models.IpFilterTargetType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.iothubprovisioningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.iothubprovisioningservices.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameAvailabilityInfo(_Model):
    """Description of name availability.

    :ivar name_available: specifies if a name is available or not.
    :vartype name_available: bool
    :ivar reason: specifies the reason a name is unavailable. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.iothubprovisioningservices.models.NameUnavailabilityReason
    :ivar message: message containing a detailed reason name is unavailable.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(
        name="nameAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """specifies if a name is available or not."""
    reason: Optional[Union[str, "_models.NameUnavailabilityReason"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """specifies the reason a name is unavailable. Known values are: \"Invalid\" and
     \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """message containing a detailed reason name is unavailable."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.NameUnavailabilityReason"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Represents an operation.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar display: The display information for the operation.
    :vartype display: ~azure.mgmt.iothubprovisioningservices.models.OperationDisplay
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The display information for the operation."""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """OperationDisplay.

    :ivar provider: Service provider: Microsoft Devices.
    :vartype provider: str
    :ivar resource: Resource Type: ProvisioningServices.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """Service provider: Microsoft Devices."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """Resource Type: ProvisioningServices."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """Name of the operation."""


class OperationInputs(_Model):
    """Input values for operation results call.

    :ivar name: The name of the Provisioning Service to check. Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the Provisioning Service to check. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """The private endpoint property of a private endpoint connection.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier."""


class PrivateEndpointConnection(ProxyResource):
    """The private endpoint connection of a provisioning service.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    :ivar properties: The properties of a private endpoint connection. Required.
    :vartype properties:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnectionProperties
    """

    properties: "_models.PrivateEndpointConnectionProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a private endpoint connection. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.PrivateEndpointConnectionProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProperties(_Model):
    """The properties of a private endpoint connection.

    :ivar private_endpoint: The private endpoint property of a private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: The current state of a private endpoint
     connection. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionState
    """

    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint property of a private endpoint connection."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of a private endpoint connection. Required."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """The current state of a private endpoint connection.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
     Required.
    :vartype description: str
    :ivar actions_required: Actions required for a private endpoint connection.
    :vartype actions_required: str
    """

    status: Union[str, "_models.PrivateLinkServiceConnectionStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of a private endpoint connection. Required. Known values are: \"Pending\",
     \"Approved\", \"Rejected\", and \"Disconnected\"."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description for the current state of a private endpoint connection. Required."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actions required for a private endpoint connection."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProvisioningServiceDescription(TrackedResource):
    """The description of the provisioning service.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar etag: The Etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal ETag convention.
    :vartype etag: str
    :ivar resourcegroup: The resource group of the resource.
    :vartype resourcegroup: str
    :ivar subscriptionid: The subscription id of the resource.
    :vartype subscriptionid: str
    :ivar properties: Service specific properties for a provisioning service. Required.
    :vartype properties: ~azure.mgmt.iothubprovisioningservices.models.IotDpsPropertiesDescription
    :ivar sku: Sku info for a provisioning Service. Required.
    :vartype sku: ~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuInfo
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.iothubprovisioningservices.models.ManagedServiceIdentity
    """

    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Etag field is *not* required. If it is provided in the response body, it must also be
     provided as a header per the normal ETag convention."""
    resourcegroup: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource group of the resource."""
    subscriptionid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The subscription id of the resource."""
    properties: "_models.IotDpsPropertiesDescription" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Service specific properties for a provisioning service. Required."""
    sku: "_models.IotDpsSkuInfo" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku info for a provisioning Service. Required."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        properties: "_models.IotDpsPropertiesDescription",
        sku: "_models.IotDpsSkuInfo",
        tags: Optional[dict[str, str]] = None,
        etag: Optional[str] = None,
        resourcegroup: Optional[str] = None,
        subscriptionid: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharedAccessSignatureAuthorizationRuleAccessRightsDescription(_Model):  # pylint: disable=name-too-long
    """Description of the shared access key.

    :ivar key_name: Name of the key. Required.
    :vartype key_name: str
    :ivar primary_key: Primary SAS key value.
    :vartype primary_key: str
    :ivar secondary_key: Secondary SAS key value.
    :vartype secondary_key: str
    :ivar rights: Rights that this key has. Required. Known values are: "ServiceConfig",
     "EnrollmentRead", "EnrollmentWrite", "DeviceConnect", "RegistrationStatusRead", and
     "RegistrationStatusWrite".
    :vartype rights: str or ~azure.mgmt.iothubprovisioningservices.models.AccessRightsDescription
    """

    key_name: str = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the key. Required."""
    primary_key: Optional[str] = rest_field(
        name="primaryKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Primary SAS key value."""
    secondary_key: Optional[str] = rest_field(
        name="secondaryKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Secondary SAS key value."""
    rights: Union[str, "_models.AccessRightsDescription"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Rights that this key has. Required. Known values are: \"ServiceConfig\", \"EnrollmentRead\",
     \"EnrollmentWrite\", \"DeviceConnect\", \"RegistrationStatusRead\", and
     \"RegistrationStatusWrite\"."""

    @overload
    def __init__(
        self,
        *,
        key_name: str,
        rights: Union[str, "_models.AccessRightsDescription"],
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.iothubprovisioningservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.iothubprovisioningservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TagsResource(_Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a
    Provisioning Service instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class VerificationCodeRequest(_Model):
    """The JSON-serialized leaf certificate.

    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: str
    """

    certificate: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """base-64 representation of X509 certificate .cer file or just .pem file content."""

    @overload
    def __init__(
        self,
        *,
        certificate: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VerificationCodeResponse(_Model):
    """Description of the response of the verification code.

    :ivar name: Name of certificate.
    :vartype name: str
    :ivar etag: Request etag.
    :vartype etag: str
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeResponseProperties
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """Name of certificate."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """Request etag."""
    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The resource type."""
    properties: Optional["_models.VerificationCodeResponseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VerificationCodeResponseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VerificationCodeResponseProperties(_Model):
    """VerificationCodeResponseProperties.

    :ivar verification_code: Verification code.
    :vartype verification_code: str
    :ivar subject: Certificate subject.
    :vartype subject: str
    :ivar expiry: Code expiry.
    :vartype expiry: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Indicate if the certificate is verified by owner of private key.
    :vartype is_verified: bool
    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: bytes
    :ivar created: Certificate created time.
    :vartype created: str
    :ivar updated: Certificate updated time.
    :vartype updated: str
    """

    verification_code: Optional[str] = rest_field(
        name="verificationCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Verification code."""
    subject: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate subject."""
    expiry: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Code expiry."""
    thumbprint: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate thumbprint."""
    is_verified: Optional[bool] = rest_field(
        name="isVerified", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicate if the certificate is verified by owner of private key."""
    certificate: Optional[bytes] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="base64"
    )
    """base-64 representation of X509 certificate .cer file or just .pem file content."""
    created: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate created time."""
    updated: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate updated time."""

    @overload
    def __init__(
        self,
        *,
        verification_code: Optional[str] = None,
        subject: Optional[str] = None,
        expiry: Optional[str] = None,
        thumbprint: Optional[str] = None,
        is_verified: Optional[bool] = None,
        certificate: Optional[bytes] = None,
        created: Optional[str] = None,
        updated: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
