# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AadProfile(_serialization.Model):
    """AAD Profile specifies attributes for Azure Active Directory integration.

    :ivar enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
    :vartype enable_azure_rbac: bool
    :ivar admin_group_object_i_ds: The list of AAD group object IDs that will have admin role of
     the cluster.
    :vartype admin_group_object_i_ds: list[str]
    :ivar tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "enable_azure_rbac": {"key": "enableAzureRBAC", "type": "bool"},
        "admin_group_object_i_ds": {"key": "adminGroupObjectIDs", "type": "[str]"},
        "tenant_id": {"key": "tenantID", "type": "str"},
    }

    def __init__(
        self,
        *,
        enable_azure_rbac: Optional[bool] = None,
        admin_group_object_i_ds: Optional[List[str]] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
        :paramtype enable_azure_rbac: bool
        :keyword admin_group_object_i_ds: The list of AAD group object IDs that will have admin role of
         the cluster.
        :paramtype admin_group_object_i_ds: list[str]
        :keyword tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
         tenant of the deployment subscription.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.enable_azure_rbac = enable_azure_rbac
        self.admin_group_object_i_ds = admin_group_object_i_ds
        self.tenant_id = tenant_id


class AgentError(_serialization.Model):
    """Agent Errors if any during agent or system component upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Agent error message.
    :vartype message: str
    :ivar severity: Severity of the error message.
    :vartype severity: str
    :ivar component: Agent component where error message occured.
    :vartype component: str
    :ivar time: The timestamp of error occured (UTC).
    :vartype time: ~datetime.datetime
    """

    _validation = {
        "message": {"readonly": True},
        "severity": {"readonly": True},
        "component": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "component": {"key": "component", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.message = None
        self.severity = None
        self.component = None
        self.time = None


class ArcAgentProfile(_serialization.Model):
    """Defines the Arc Agent properties for the clusters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar desired_agent_version: Version of the Arc agents to be installed on the cluster resource.
    :vartype desired_agent_version: str
    :ivar agent_auto_upgrade: Indicates whether the Arc agents on the be upgraded automatically to
     the latest version. Defaults to Enabled. Known values are: "Enabled" and "Disabled".
    :vartype agent_auto_upgrade: str or ~azure.mgmt.hybridkubernetes.models.AutoUpgradeOptions
    :ivar system_components: List of system extensions that are installed on the cluster resource.
    :vartype system_components: list[~azure.mgmt.hybridkubernetes.models.SystemComponent]
    :ivar agent_errors: List of arc agentry and system components errors on the cluster resource.
    :vartype agent_errors: list[~azure.mgmt.hybridkubernetes.models.AgentError]
    :ivar agent_state: Represents the current state of the Arc agentry and its dependent
     components.
    :vartype agent_state: str
    """

    _validation = {
        "agent_state": {"readonly": True},
    }

    _attribute_map = {
        "desired_agent_version": {"key": "desiredAgentVersion", "type": "str"},
        "agent_auto_upgrade": {"key": "agentAutoUpgrade", "type": "str"},
        "system_components": {"key": "systemComponents", "type": "[SystemComponent]"},
        "agent_errors": {"key": "agentErrors", "type": "[AgentError]"},
        "agent_state": {"key": "agentState", "type": "str"},
    }

    def __init__(
        self,
        *,
        desired_agent_version: Optional[str] = None,
        agent_auto_upgrade: Union[str, "_models.AutoUpgradeOptions"] = "Enabled",
        system_components: Optional[List["_models.SystemComponent"]] = None,
        agent_errors: Optional[List["_models.AgentError"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword desired_agent_version: Version of the Arc agents to be installed on the cluster
         resource.
        :paramtype desired_agent_version: str
        :keyword agent_auto_upgrade: Indicates whether the Arc agents on the be upgraded automatically
         to the latest version. Defaults to Enabled. Known values are: "Enabled" and "Disabled".
        :paramtype agent_auto_upgrade: str or ~azure.mgmt.hybridkubernetes.models.AutoUpgradeOptions
        :keyword system_components: List of system extensions that are installed on the cluster
         resource.
        :paramtype system_components: list[~azure.mgmt.hybridkubernetes.models.SystemComponent]
        :keyword agent_errors: List of arc agentry and system components errors on the cluster
         resource.
        :paramtype agent_errors: list[~azure.mgmt.hybridkubernetes.models.AgentError]
        """
        super().__init__(**kwargs)
        self.desired_agent_version = desired_agent_version
        self.agent_auto_upgrade = agent_auto_upgrade
        self.system_components = system_components
        self.agent_errors = agent_errors
        self.agent_state = None


class ArcAgentryConfigurations(_serialization.Model):
    """ArcAgentryConfigurations.

    :ivar feature: Specifies the name of the feature for the configuration setting.
    :vartype feature: str
    :ivar settings: The configuration settings for the feature that do not contain any sensitive or
     secret information.
    :vartype settings: dict[str, str]
    :ivar protected_settings: The configuration settings for the feature that contain any sensitive
     or secret information.
    :vartype protected_settings: dict[str, str]
    """

    _attribute_map = {
        "feature": {"key": "feature", "type": "str"},
        "settings": {"key": "settings", "type": "{str}"},
        "protected_settings": {"key": "protectedSettings", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        feature: Optional[str] = None,
        settings: Optional[Dict[str, str]] = None,
        protected_settings: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword feature: Specifies the name of the feature for the configuration setting.
        :paramtype feature: str
        :keyword settings: The configuration settings for the feature that do not contain any sensitive
         or secret information.
        :paramtype settings: dict[str, str]
        :keyword protected_settings: The configuration settings for the feature that contain any
         sensitive or secret information.
        :paramtype protected_settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.feature = feature
        self.settings = settings
        self.protected_settings = protected_settings


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class ConnectedCluster(TrackedResource):
    """Represents a connected cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The identity of the connected cluster. Required.
    :vartype identity: ~azure.mgmt.hybridkubernetes.models.ConnectedClusterIdentity
    :ivar kind: The kind of connected cluster. Known values are: "ProvisionedCluster" and "AWS".
    :vartype kind: str or ~azure.mgmt.hybridkubernetes.models.ConnectedClusterKind
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.hybridkubernetes.models.SystemData
    :ivar agent_public_key_certificate: Base64 encoded public certificate used by the agent to do
     the initial handshake to the backend services in Azure. Required.
    :vartype agent_public_key_certificate: str
    :ivar kubernetes_version: The Kubernetes version of the connected cluster resource.
    :vartype kubernetes_version: str
    :ivar total_node_count: Number of nodes present in the connected cluster resource.
    :vartype total_node_count: int
    :ivar total_core_count: Number of CPU cores present in the connected cluster resource.
    :vartype total_core_count: int
    :ivar agent_version: Version of the agent running on the connected cluster resource.
    :vartype agent_version: str
    :ivar provisioning_state: Provisioning state of the connected cluster resource. Known values
     are: "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridkubernetes.models.ProvisioningState
    :ivar distribution: The Kubernetes distribution running on this connected cluster.
    :vartype distribution: str
    :ivar distribution_version: The Kubernetes distribution version on this connected cluster.
    :vartype distribution_version: str
    :ivar infrastructure: The infrastructure on which the Kubernetes cluster represented by this
     connected cluster is running on.
    :vartype infrastructure: str
    :ivar offering: Connected cluster offering.
    :vartype offering: str
    :ivar managed_identity_certificate_expiration_time: Expiration time of the managed identity
     certificate.
    :vartype managed_identity_certificate_expiration_time: ~datetime.datetime
    :ivar last_connectivity_time: Time representing the last instance when heart beat was received
     from the cluster.
    :vartype last_connectivity_time: ~datetime.datetime
    :ivar connectivity_status: Represents the connectivity status of the connected cluster. Known
     values are: "Connecting", "Connected", "Offline", "Expired", and "AgentNotInstalled".
    :vartype connectivity_status: str or ~azure.mgmt.hybridkubernetes.models.ConnectivityStatus
    :ivar private_link_state: Property which describes the state of private link on a connected
     cluster resource. Known values are: "Enabled" and "Disabled".
    :vartype private_link_state: str or ~azure.mgmt.hybridkubernetes.models.PrivateLinkState
    :ivar private_link_scope_resource_id: This is populated only if privateLinkState is enabled.
     The resource id of the private link scope this connected cluster is assigned to, if any.
    :vartype private_link_scope_resource_id: str
    :ivar azure_hybrid_benefit: Indicates whether Azure Hybrid Benefit is opted in. Known values
     are: "True", "False", and "NotApplicable".
    :vartype azure_hybrid_benefit: str or ~azure.mgmt.hybridkubernetes.models.AzureHybridBenefit
    :ivar aad_profile: AAD profile for the connected cluster.
    :vartype aad_profile: ~azure.mgmt.hybridkubernetes.models.AadProfile
    :ivar arc_agent_profile: Arc agentry configuration for the provisioned cluster.
    :vartype arc_agent_profile: ~azure.mgmt.hybridkubernetes.models.ArcAgentProfile
    :ivar security_profile: Security profile for the connected cluster.
    :vartype security_profile: ~azure.mgmt.hybridkubernetes.models.SecurityProfile
    :ivar oidc_issuer_profile: Open ID Connect (OIDC) Issuer Profile for the connected cluster.
    :vartype oidc_issuer_profile: ~azure.mgmt.hybridkubernetes.models.OidcIssuerProfile
    :ivar gateway: Details of the gateway used by the Arc router for connectivity.
    :vartype gateway: ~azure.mgmt.hybridkubernetes.models.Gateway
    :ivar arc_agentry_configurations: Configuration settings for customizing the behavior of the
     connected cluster.
    :vartype arc_agentry_configurations:
     list[~azure.mgmt.hybridkubernetes.models.ArcAgentryConfigurations]
    :ivar miscellaneous_properties: More properties related to the Connected Cluster.
    :vartype miscellaneous_properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "identity": {"required": True},
        "system_data": {"readonly": True},
        "agent_public_key_certificate": {"required": True},
        "kubernetes_version": {"readonly": True},
        "total_node_count": {"readonly": True},
        "total_core_count": {"readonly": True},
        "agent_version": {"readonly": True},
        "offering": {"readonly": True},
        "managed_identity_certificate_expiration_time": {"readonly": True},
        "last_connectivity_time": {"readonly": True},
        "connectivity_status": {"readonly": True},
        "miscellaneous_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ConnectedClusterIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "agent_public_key_certificate": {"key": "properties.agentPublicKeyCertificate", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "total_node_count": {"key": "properties.totalNodeCount", "type": "int"},
        "total_core_count": {"key": "properties.totalCoreCount", "type": "int"},
        "agent_version": {"key": "properties.agentVersion", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "distribution": {"key": "properties.distribution", "type": "str"},
        "distribution_version": {"key": "properties.distributionVersion", "type": "str"},
        "infrastructure": {"key": "properties.infrastructure", "type": "str"},
        "offering": {"key": "properties.offering", "type": "str"},
        "managed_identity_certificate_expiration_time": {
            "key": "properties.managedIdentityCertificateExpirationTime",
            "type": "iso-8601",
        },
        "last_connectivity_time": {"key": "properties.lastConnectivityTime", "type": "iso-8601"},
        "connectivity_status": {"key": "properties.connectivityStatus", "type": "str"},
        "private_link_state": {"key": "properties.privateLinkState", "type": "str"},
        "private_link_scope_resource_id": {"key": "properties.privateLinkScopeResourceId", "type": "str"},
        "azure_hybrid_benefit": {"key": "properties.azureHybridBenefit", "type": "str"},
        "aad_profile": {"key": "properties.aadProfile", "type": "AadProfile"},
        "arc_agent_profile": {"key": "properties.arcAgentProfile", "type": "ArcAgentProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "oidc_issuer_profile": {"key": "properties.oidcIssuerProfile", "type": "OidcIssuerProfile"},
        "gateway": {"key": "properties.gateway", "type": "Gateway"},
        "arc_agentry_configurations": {
            "key": "properties.arcAgentryConfigurations",
            "type": "[ArcAgentryConfigurations]",
        },
        "miscellaneous_properties": {"key": "properties.miscellaneousProperties", "type": "{str}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        identity: "_models.ConnectedClusterIdentity",
        agent_public_key_certificate: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.ConnectedClusterKind"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        distribution: Optional[str] = None,
        distribution_version: Optional[str] = None,
        infrastructure: Optional[str] = None,
        private_link_state: Union[str, "_models.PrivateLinkState"] = "Disabled",
        private_link_scope_resource_id: Optional[str] = None,
        azure_hybrid_benefit: Optional[Union[str, "_models.AzureHybridBenefit"]] = None,
        aad_profile: Optional["_models.AadProfile"] = None,
        arc_agent_profile: Optional["_models.ArcAgentProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        oidc_issuer_profile: Optional["_models.OidcIssuerProfile"] = None,
        gateway: Optional["_models.Gateway"] = None,
        arc_agentry_configurations: Optional[List["_models.ArcAgentryConfigurations"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity of the connected cluster. Required.
        :paramtype identity: ~azure.mgmt.hybridkubernetes.models.ConnectedClusterIdentity
        :keyword kind: The kind of connected cluster. Known values are: "ProvisionedCluster" and "AWS".
        :paramtype kind: str or ~azure.mgmt.hybridkubernetes.models.ConnectedClusterKind
        :keyword agent_public_key_certificate: Base64 encoded public certificate used by the agent to
         do the initial handshake to the backend services in Azure. Required.
        :paramtype agent_public_key_certificate: str
        :keyword provisioning_state: Provisioning state of the connected cluster resource. Known values
         are: "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.hybridkubernetes.models.ProvisioningState
        :keyword distribution: The Kubernetes distribution running on this connected cluster.
        :paramtype distribution: str
        :keyword distribution_version: The Kubernetes distribution version on this connected cluster.
        :paramtype distribution_version: str
        :keyword infrastructure: The infrastructure on which the Kubernetes cluster represented by this
         connected cluster is running on.
        :paramtype infrastructure: str
        :keyword private_link_state: Property which describes the state of private link on a connected
         cluster resource. Known values are: "Enabled" and "Disabled".
        :paramtype private_link_state: str or ~azure.mgmt.hybridkubernetes.models.PrivateLinkState
        :keyword private_link_scope_resource_id: This is populated only if privateLinkState is enabled.
         The resource id of the private link scope this connected cluster is assigned to, if any.
        :paramtype private_link_scope_resource_id: str
        :keyword azure_hybrid_benefit: Indicates whether Azure Hybrid Benefit is opted in. Known values
         are: "True", "False", and "NotApplicable".
        :paramtype azure_hybrid_benefit: str or ~azure.mgmt.hybridkubernetes.models.AzureHybridBenefit
        :keyword aad_profile: AAD profile for the connected cluster.
        :paramtype aad_profile: ~azure.mgmt.hybridkubernetes.models.AadProfile
        :keyword arc_agent_profile: Arc agentry configuration for the provisioned cluster.
        :paramtype arc_agent_profile: ~azure.mgmt.hybridkubernetes.models.ArcAgentProfile
        :keyword security_profile: Security profile for the connected cluster.
        :paramtype security_profile: ~azure.mgmt.hybridkubernetes.models.SecurityProfile
        :keyword oidc_issuer_profile: Open ID Connect (OIDC) Issuer Profile for the connected cluster.
        :paramtype oidc_issuer_profile: ~azure.mgmt.hybridkubernetes.models.OidcIssuerProfile
        :keyword gateway: Details of the gateway used by the Arc router for connectivity.
        :paramtype gateway: ~azure.mgmt.hybridkubernetes.models.Gateway
        :keyword arc_agentry_configurations: Configuration settings for customizing the behavior of the
         connected cluster.
        :paramtype arc_agentry_configurations:
         list[~azure.mgmt.hybridkubernetes.models.ArcAgentryConfigurations]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.system_data = None
        self.agent_public_key_certificate = agent_public_key_certificate
        self.kubernetes_version = None
        self.total_node_count = None
        self.total_core_count = None
        self.agent_version = None
        self.provisioning_state = provisioning_state
        self.distribution = distribution
        self.distribution_version = distribution_version
        self.infrastructure = infrastructure
        self.offering = None
        self.managed_identity_certificate_expiration_time = None
        self.last_connectivity_time = None
        self.connectivity_status = None
        self.private_link_state = private_link_state
        self.private_link_scope_resource_id = private_link_scope_resource_id
        self.azure_hybrid_benefit = azure_hybrid_benefit
        self.aad_profile = aad_profile
        self.arc_agent_profile = arc_agent_profile
        self.security_profile = security_profile
        self.oidc_issuer_profile = oidc_issuer_profile
        self.gateway = gateway
        self.arc_agentry_configurations = arc_agentry_configurations
        self.miscellaneous_properties = None


class ConnectedClusterIdentity(_serialization.Model):
    """Identity for the connected cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The principal id of connected cluster identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the connected cluster. This property will only
     be provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the connected cluster. The type 'SystemAssigned,
     includes a system created identity. The type 'None' means no identity is assigned to the
     connected cluster. Known values are: "None" and "SystemAssigned".
    :vartype type: str or ~azure.mgmt.hybridkubernetes.models.ResourceIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.ResourceIdentityType"] = "SystemAssigned", **kwargs: Any) -> None:
        """
        :keyword type: The type of identity used for the connected cluster. The type 'SystemAssigned,
         includes a system created identity. The type 'None' means no identity is assigned to the
         connected cluster. Known values are: "None" and "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.hybridkubernetes.models.ResourceIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ConnectedClusterList(_serialization.Model):
    """The paginated list of connected Clusters.

    :ivar value: The list of connected clusters.
    :vartype value: list[~azure.mgmt.hybridkubernetes.models.ConnectedCluster]
    :ivar next_link: The link to fetch the next page of connected clusters.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectedCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConnectedCluster"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of connected clusters.
        :paramtype value: list[~azure.mgmt.hybridkubernetes.models.ConnectedCluster]
        :keyword next_link: The link to fetch the next page of connected clusters.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectedClusterPatch(_serialization.Model):
    """Object containing updates for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar distribution: Represents the distribution of the connected cluster.
    :vartype distribution: str
    :ivar distribution_version: Represents the Kubernetes distribution version on this connected
     cluster.
    :vartype distribution_version: str
    :ivar azure_hybrid_benefit: Indicates whether Azure Hybrid Benefit is opted in. Known values
     are: "True", "False", and "NotApplicable".
    :vartype azure_hybrid_benefit: str or ~azure.mgmt.hybridkubernetes.models.AzureHybridBenefit
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "distribution": {"key": "properties.distribution", "type": "str"},
        "distribution_version": {"key": "properties.distributionVersion", "type": "str"},
        "azure_hybrid_benefit": {"key": "properties.azureHybridBenefit", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        distribution: Optional[str] = None,
        distribution_version: Optional[str] = None,
        azure_hybrid_benefit: Optional[Union[str, "_models.AzureHybridBenefit"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword distribution: Represents the distribution of the connected cluster.
        :paramtype distribution: str
        :keyword distribution_version: Represents the Kubernetes distribution version on this connected
         cluster.
        :paramtype distribution_version: str
        :keyword azure_hybrid_benefit: Indicates whether Azure Hybrid Benefit is opted in. Known values
         are: "True", "False", and "NotApplicable".
        :paramtype azure_hybrid_benefit: str or ~azure.mgmt.hybridkubernetes.models.AzureHybridBenefit
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.distribution = distribution
        self.distribution_version = distribution_version
        self.azure_hybrid_benefit = azure_hybrid_benefit


class CredentialResult(_serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "bytearray"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(_serialization.Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hybrid_connection_config: Contains the REP (rendezvous endpoint) and “Sender” access
     token.
    :vartype hybrid_connection_config: ~azure.mgmt.hybridkubernetes.models.HybridConnectionConfig
    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.hybridkubernetes.models.CredentialResult]
    """

    _validation = {
        "hybrid_connection_config": {"readonly": True},
        "kubeconfigs": {"readonly": True},
    }

    _attribute_map = {
        "hybrid_connection_config": {"key": "hybridConnectionConfig", "type": "HybridConnectionConfig"},
        "kubeconfigs": {"key": "kubeconfigs", "type": "[CredentialResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.hybrid_connection_config = None
        self.kubeconfigs = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridkubernetes.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridkubernetes.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hybridkubernetes.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.hybridkubernetes.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Gateway(_serialization.Model):
    """Gateway.

    :ivar enabled: Indicates whether the gateway for arc router connectivity is enabled.
    :vartype enabled: bool
    :ivar resource_id: The resource ID of the gateway used for the Arc router feature.
    :vartype resource_id: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Indicates whether the gateway for arc router connectivity is enabled.
        :paramtype enabled: bool
        :keyword resource_id: The resource ID of the gateway used for the Arc router feature.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.resource_id = resource_id


class HybridConnectionConfig(_serialization.Model):
    """Contains the REP (rendezvous endpoint) and “Sender” access token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_time: Timestamp when this token will be expired.
    :vartype expiration_time: int
    :ivar hybrid_connection_name: Name of the connection.
    :vartype hybrid_connection_name: str
    :ivar relay: Name of the relay.
    :vartype relay: str
    :ivar token: Sender access token.
    :vartype token: str
    :ivar relay_tid: TenantID of the relay.
    :vartype relay_tid: str
    :ivar relay_type: Type of relay.
    :vartype relay_type: str
    """

    _validation = {
        "expiration_time": {"readonly": True},
        "hybrid_connection_name": {"readonly": True},
        "relay": {"readonly": True},
        "token": {"readonly": True},
        "relay_tid": {"readonly": True},
        "relay_type": {"readonly": True},
    }

    _attribute_map = {
        "expiration_time": {"key": "expirationTime", "type": "int"},
        "hybrid_connection_name": {"key": "hybridConnectionName", "type": "str"},
        "relay": {"key": "relay", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "relay_tid": {"key": "relayTid", "type": "str"},
        "relay_type": {"key": "relayType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.expiration_time = None
        self.hybrid_connection_name = None
        self.relay = None
        self.token = None
        self.relay_tid = None
        self.relay_type = None


class ListClusterUserCredentialProperties(_serialization.Model):
    """ListClusterUserCredentialProperties.

    All required parameters must be populated in order to send to server.

    :ivar authentication_method: The mode of client authentication. Required. Known values are:
     "Token" and "AAD".
    :vartype authentication_method: str or ~azure.mgmt.hybridkubernetes.models.AuthenticationMethod
    :ivar client_proxy: Boolean value to indicate whether the request is for client side proxy or
     not. Required.
    :vartype client_proxy: bool
    """

    _validation = {
        "authentication_method": {"required": True},
        "client_proxy": {"required": True},
    }

    _attribute_map = {
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
        "client_proxy": {"key": "clientProxy", "type": "bool"},
    }

    def __init__(
        self, *, authentication_method: Union[str, "_models.AuthenticationMethod"], client_proxy: bool, **kwargs: Any
    ) -> None:
        """
        :keyword authentication_method: The mode of client authentication. Required. Known values are:
         "Token" and "AAD".
        :paramtype authentication_method: str or
         ~azure.mgmt.hybridkubernetes.models.AuthenticationMethod
        :keyword client_proxy: Boolean value to indicate whether the request is for client side proxy
         or not. Required.
        :paramtype client_proxy: bool
        """
        super().__init__(**kwargs)
        self.authentication_method = authentication_method
        self.client_proxy = client_proxy


class OidcIssuerProfile(_serialization.Model):
    """OIDC Issuer Profile specifies attributes for workload identity integration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Whether to enable oidc issuer for workload identity integration.
    :vartype enabled: bool
    :ivar issuer_url: The issuer url for hybrid clusters connected to Arc used for the workload
     identity feature.
    :vartype issuer_url: str
    :ivar self_hosted_issuer_url: The issuer url for public cloud clusters - AKS, EKS, GKE - used
     for the workload identity feature.
    :vartype self_hosted_issuer_url: str
    """

    _validation = {
        "issuer_url": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "issuer_url": {"key": "issuerUrl", "type": "str"},
        "self_hosted_issuer_url": {"key": "selfHostedIssuerUrl", "type": "str"},
    }

    def __init__(
        self, *, enabled: Optional[bool] = None, self_hosted_issuer_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether to enable oidc issuer for workload identity integration.
        :paramtype enabled: bool
        :keyword self_hosted_issuer_url: The issuer url for public cloud clusters - AKS, EKS, GKE -
         used for the workload identity feature.
        :paramtype self_hosted_issuer_url: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.issuer_url = None
        self.self_hosted_issuer_url = self_hosted_issuer_url


class Operation(_serialization.Model):
    """The Connected cluster API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {Microsoft.Kubernetes}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.hybridkubernetes.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display = None


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Kubernetes.
    :vartype provider: str
    :ivar resource: Connected Cluster Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Kubernetes.
        :paramtype provider: str
        :keyword resource: Connected Cluster Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """The paginated list of connected cluster API operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of connected cluster API operations.
    :vartype value: list[~azure.mgmt.hybridkubernetes.models.Operation]
    :ivar next_link: The link to fetch the next page of connected cluster API operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The link to fetch the next page of connected cluster API operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecurityProfile(_serialization.Model):
    """Security Profile specifies attributes for cluster security features.

    :ivar workload_identity: The workload identity feature webhook.
    :vartype workload_identity: ~azure.mgmt.hybridkubernetes.models.SecurityProfileWorkloadIdentity
    """

    _attribute_map = {
        "workload_identity": {"key": "workloadIdentity", "type": "SecurityProfileWorkloadIdentity"},
    }

    def __init__(
        self, *, workload_identity: Optional["_models.SecurityProfileWorkloadIdentity"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity: The workload identity feature webhook.
        :paramtype workload_identity:
         ~azure.mgmt.hybridkubernetes.models.SecurityProfileWorkloadIdentity
        """
        super().__init__(**kwargs)
        self.workload_identity = workload_identity


class SecurityProfileWorkloadIdentity(_serialization.Model):
    """The workload identity feature webhook.

    :ivar enabled: Whether to enable or disable the workload identity Webhook.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable or disable the workload identity Webhook.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class SystemComponent(_serialization.Model):
    """System extensions and its current versions installed on the cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of the system extension.
    :vartype type: str
    :ivar user_specified_version: Version of the system extension to be installed on the cluster
     resource.
    :vartype user_specified_version: str
    :ivar major_version: Major Version of the system extension that is currently installed on the
     cluster resource.
    :vartype major_version: int
    :ivar current_version: Version of the system extension that is currently installed on the
     cluster resource.
    :vartype current_version: str
    """

    _validation = {
        "current_version": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_specified_version": {"key": "userSpecifiedVersion", "type": "str"},
        "major_version": {"key": "majorVersion", "type": "int"},
        "current_version": {"key": "currentVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        user_specified_version: Optional[str] = None,
        major_version: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the system extension.
        :paramtype type: str
        :keyword user_specified_version: Version of the system extension to be installed on the cluster
         resource.
        :paramtype user_specified_version: str
        :keyword major_version: Major Version of the system extension that is currently installed on
         the cluster resource.
        :paramtype major_version: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_specified_version = user_specified_version
        self.major_version = major_version
        self.current_version = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hybridkubernetes.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hybridkubernetes.models.LastModifiedByType
    :ivar last_modified_at: The timestamp of resource modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.LastModifiedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hybridkubernetes.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.hybridkubernetes.models.LastModifiedByType
        :keyword last_modified_at: The timestamp of resource modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
