# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.healthdataaiservices.aio import HealthDataAIServicesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHealthDataAIServicesMgmtDeidServicesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HealthDataAIServicesMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deid_services_get(self, resource_group):
        response = await self.client.deid_services.get(
            resource_group_name=resource_group.name,
            deid_service_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deid_services_list_by_resource_group(self, resource_group):
        response = self.client.deid_services.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deid_services_list_by_subscription(self, resource_group):
        response = self.client.deid_services.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deid_services_begin_create(self, resource_group):
        response = await (
            await self.client.deid_services.begin_create(
                resource_group_name=resource_group.name,
                deid_service_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "properties": {
                        "privateEndpointConnections": [
                            {
                                "id": "str",
                                "name": "str",
                                "properties": {
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",
                                        "description": "str",
                                        "status": "str",
                                    },
                                    "groupIds": ["str"],
                                    "privateEndpoint": {"id": "str"},
                                    "provisioningState": "str",
                                },
                                "systemData": {
                                    "createdAt": "2020-02-20 00:00:00",
                                    "createdBy": "str",
                                    "createdByType": "str",
                                    "lastModifiedAt": "2020-02-20 00:00:00",
                                    "lastModifiedBy": "str",
                                    "lastModifiedByType": "str",
                                },
                                "type": "str",
                            }
                        ],
                        "provisioningState": "str",
                        "publicNetworkAccess": "str",
                        "serviceUrl": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deid_services_begin_update(self, resource_group):
        response = await (
            await self.client.deid_services.begin_update(
                resource_group_name=resource_group.name,
                deid_service_name="str",
                properties={
                    "identity": {
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "properties": {"publicNetworkAccess": "str"},
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deid_services_begin_delete(self, resource_group):
        response = await (
            await self.client.deid_services.begin_delete(
                resource_group_name=resource_group.name,
                deid_service_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
