# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.live_test_only
class TestEventGridManagementEventSubscriptionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_subscription(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_subscription()
        result = [r async for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_subscription_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_subscription_for_topic_type(
            topic_type_name="Microsoft.Resources.Subscriptions",
        )
        result = [r async for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_resource_group(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        assert result == []

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_resource_group_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_resource_group_for_topic_type(
            resource_group_name=resource_group.name,
            topic_type_name="Microsoft.Resources.Subscriptions",
        )
        result = [r async for r in response]
        assert result == []

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_subscription(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_subscription(
            location="eastus",
        )
        result = [r async for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_resource_group(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_resource_group(
            resource_group_name=resource_group.name,
            location="eastus",
        )
        result = [r async for r in response]
        assert result == []

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_subscription_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_subscription_for_topic_type(
            location="eastus",
            topic_type_name="Microsoft.Resources.Subscriptions",
        )
        result = [r async for r in response]
        assert response

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_resource_group_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_resource_group_for_topic_type(
            resource_group_name=resource_group.name,
            location="eastus",
            topic_type_name="Microsoft.Resources.Subscriptions",
        )
        result = [r async for r in response]
        assert result == []
