# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models import (  # type: ignore
    AOAIModelConfig,
    AgentEvaluation,
    AgentEvaluationRedactionConfiguration,
    AgentEvaluationRequest,
    AgentEvaluationResult,
    AgentEvaluationSamplingConfiguration,
    AnnotationDTO,
    ApiKeyCredentials,
    AssetCredentialRequest,
    AssetCredentialResponse,
    AttackObjective,
    AzureAISearchIndex,
    BaseCredentials,
    BlobReferenceForConsumption,
    ChatChoice,
    ChatCompletions,
    ChatResponseMessage,
    CompletionsUsage,
    CompletionsUsageDetails,
    Connection,
    Content,
    CosmosDBIndex,
    CustomCredential,
    CustomizationParameters,
    DatasetVersion,
    Deployment,
    EmbeddingConfiguration,
    EntraIDCredentials,
    Evaluation,
    EvaluationResult,
    EvaluationTarget,
    EvaluationUpload,
    EvaluatorConfiguration,
    FileDatasetVersion,
    FolderDatasetVersion,
    Index,
    InputData,
    InputDataset,
    LongRunningResponse,
    MAASModelConfig,
    ManagedAzureAISearchIndex,
    Message,
    Metadata,
    ModelDeployment,
    NoAuthenticationCredentials,
    PendingUploadRequest,
    PendingUploadResponse,
    PromptUsageDetails,
    RedTeam,
    RedTeamUpload,
    SASCredentials,
    SasCredential,
    SimulationDTO,
    Sku,
    SystemData,
    TargetHarm,
    TargetModelConfig,
)

from ._enums import (  # type: ignore
    AttackStrategy,
    ChatRole,
    CompletionsFinishReason,
    ConnectionType,
    CredentialType,
    DatasetType,
    DeploymentType,
    IndexType,
    ListViewType,
    PendingUploadType,
    ResultType,
    RiskCategory,
    SimulationType,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "AOAIModelConfig",
    "AgentEvaluation",
    "AgentEvaluationRedactionConfiguration",
    "AgentEvaluationRequest",
    "AgentEvaluationResult",
    "AgentEvaluationSamplingConfiguration",
    "AnnotationDTO",
    "ApiKeyCredentials",
    "AssetCredentialRequest",
    "AssetCredentialResponse",
    "AttackObjective",
    "AzureAISearchIndex",
    "BaseCredentials",
    "BlobReferenceForConsumption",
    "ChatChoice",
    "ChatCompletions",
    "ChatResponseMessage",
    "CompletionsUsage",
    "CompletionsUsageDetails",
    "Connection",
    "Content",
    "CosmosDBIndex",
    "CustomCredential",
    "CustomizationParameters",
    "DatasetVersion",
    "Deployment",
    "EmbeddingConfiguration",
    "EntraIDCredentials",
    "Evaluation",
    "EvaluationResult",
    "EvaluationTarget",
    "EvaluationUpload",
    "EvaluatorConfiguration",
    "FileDatasetVersion",
    "FolderDatasetVersion",
    "Index",
    "InputData",
    "InputDataset",
    "LongRunningResponse",
    "MAASModelConfig",
    "ManagedAzureAISearchIndex",
    "Message",
    "Metadata",
    "ModelDeployment",
    "NoAuthenticationCredentials",
    "PendingUploadRequest",
    "PendingUploadResponse",
    "PromptUsageDetails",
    "RedTeam",
    "RedTeamUpload",
    "SASCredentials",
    "SasCredential",
    "SimulationDTO",
    "Sku",
    "SystemData",
    "TargetHarm",
    "TargetModelConfig",
    "AttackStrategy",
    "ChatRole",
    "CompletionsFinishReason",
    "ConnectionType",
    "CredentialType",
    "DatasetType",
    "DeploymentType",
    "IndexType",
    "ListViewType",
    "PendingUploadType",
    "ResultType",
    "RiskCategory",
    "SimulationType",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
