# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.dataprotection import DataProtectionMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-dataprotection
# USAGE
    python put_backup_vault_with_cmk.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DataProtectionMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.backup_vaults.begin_create_or_update(
        resource_group_name="SampleResourceGroup",
        vault_name="swaggerExample",
        parameters={
            "location": "WestUS",
            "properties": {
                "monitoringSettings": {"azureMonitorAlertSettings": {"alertsForAllJobFailures": "Enabled"}},
                "securitySettings": {
                    "encryptionSettings": {
                        "infrastructureEncryption": "Enabled",
                        "kekIdentity": {
                            "identityId": "/subscriptions/85bf5e8c-3084-4f42-add2-746ebb7e97b2/resourcegroups/defaultrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/examplemsi",
                            "identityType": "UserAssigned",
                        },
                        "keyVaultProperties": {
                            "keyUri": "https://cmk2xkv.vault.azure.net/keys/Key1/0767b348bb1a4c07baa6c4ec0055d2b3"
                        },
                        "state": "Enabled",
                    },
                    "immutabilitySettings": {"state": "Disabled"},
                    "softDeleteSettings": {"retentionDurationInDays": 0, "state": "Off"},
                },
                "storageSettings": [{"datastoreType": "VaultStore", "type": "LocallyRedundant"}],
            },
            "tags": {"key1": "val1"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-07-01/VaultCRUD/PutBackupVaultWithCMK.json
if __name__ == "__main__":
    main()
