# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class CostManagementProxyResource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :vartype e_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
    }

    def __init__(self, *, e_tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
         used to determine whether the user is updating the latest version or not.
        :paramtype e_tag: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.e_tag = e_tag


class Alert(CostManagementProxyResource):  # pylint: disable=too-many-instance-attributes
    """An individual alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :vartype e_tag: str
    :ivar definition: defines the type of alert.
    :vartype definition: ~azure.mgmt.costmanagement.models.AlertPropertiesDefinition
    :ivar description: Alert description.
    :vartype description: str
    :ivar source: Source of alert. Known values are: "Preset" and "User".
    :vartype source: str or ~azure.mgmt.costmanagement.models.AlertSource
    :ivar details: Alert details.
    :vartype details: ~azure.mgmt.costmanagement.models.AlertPropertiesDetails
    :ivar cost_entity_id: related budget.
    :vartype cost_entity_id: str
    :ivar status: alert status. Known values are: "None", "Active", "Overridden", "Resolved", and
     "Dismissed".
    :vartype status: str or ~azure.mgmt.costmanagement.models.AlertStatus
    :ivar creation_time: dateTime in which alert was created.
    :vartype creation_time: str
    :ivar close_time: dateTime in which alert was closed.
    :vartype close_time: str
    :ivar modification_time: dateTime in which alert was last modified.
    :vartype modification_time: str
    :ivar status_modification_user_name: User who last modified the alert.
    :vartype status_modification_user_name: str
    :ivar status_modification_time: dateTime in which the alert status was last modified.
    :vartype status_modification_time: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "definition": {"key": "properties.definition", "type": "AlertPropertiesDefinition"},
        "description": {"key": "properties.description", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "details": {"key": "properties.details", "type": "AlertPropertiesDetails"},
        "cost_entity_id": {"key": "properties.costEntityId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "str"},
        "close_time": {"key": "properties.closeTime", "type": "str"},
        "modification_time": {"key": "properties.modificationTime", "type": "str"},
        "status_modification_user_name": {"key": "properties.statusModificationUserName", "type": "str"},
        "status_modification_time": {"key": "properties.statusModificationTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        definition: Optional["_models.AlertPropertiesDefinition"] = None,
        description: Optional[str] = None,
        source: Optional[Union[str, "_models.AlertSource"]] = None,
        details: Optional["_models.AlertPropertiesDetails"] = None,
        cost_entity_id: Optional[str] = None,
        status: Optional[Union[str, "_models.AlertStatus"]] = None,
        creation_time: Optional[str] = None,
        close_time: Optional[str] = None,
        modification_time: Optional[str] = None,
        status_modification_user_name: Optional[str] = None,
        status_modification_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
         used to determine whether the user is updating the latest version or not.
        :paramtype e_tag: str
        :keyword definition: defines the type of alert.
        :paramtype definition: ~azure.mgmt.costmanagement.models.AlertPropertiesDefinition
        :keyword description: Alert description.
        :paramtype description: str
        :keyword source: Source of alert. Known values are: "Preset" and "User".
        :paramtype source: str or ~azure.mgmt.costmanagement.models.AlertSource
        :keyword details: Alert details.
        :paramtype details: ~azure.mgmt.costmanagement.models.AlertPropertiesDetails
        :keyword cost_entity_id: related budget.
        :paramtype cost_entity_id: str
        :keyword status: alert status. Known values are: "None", "Active", "Overridden", "Resolved",
         and "Dismissed".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.AlertStatus
        :keyword creation_time: dateTime in which alert was created.
        :paramtype creation_time: str
        :keyword close_time: dateTime in which alert was closed.
        :paramtype close_time: str
        :keyword modification_time: dateTime in which alert was last modified.
        :paramtype modification_time: str
        :keyword status_modification_user_name: User who last modified the alert.
        :paramtype status_modification_user_name: str
        :keyword status_modification_time: dateTime in which the alert status was last modified.
        :paramtype status_modification_time: str
        """
        super().__init__(e_tag=e_tag, **kwargs)
        self.definition = definition
        self.description = description
        self.source = source
        self.details = details
        self.cost_entity_id = cost_entity_id
        self.status = status
        self.creation_time = creation_time
        self.close_time = close_time
        self.modification_time = modification_time
        self.status_modification_user_name = status_modification_user_name
        self.status_modification_time = status_modification_time


class AlertPropertiesDefinition(_serialization.Model):
    """defines the type of alert.

    :ivar type: type of alert. Known values are: "Budget", "Invoice", "Credit", "Quota", "General",
     "xCloud", and "BudgetForecast".
    :vartype type: str or ~azure.mgmt.costmanagement.models.AlertType
    :ivar category: Alert category. Known values are: "Cost", "Usage", "Billing", and "System".
    :vartype category: str or ~azure.mgmt.costmanagement.models.AlertCategory
    :ivar criteria: Criteria that triggered alert. Known values are: "CostThresholdExceeded",
     "UsageThresholdExceeded", "CreditThresholdApproaching", "CreditThresholdReached",
     "QuotaThresholdApproaching", "QuotaThresholdReached", "MultiCurrency",
     "ForecastCostThresholdExceeded", "ForecastUsageThresholdExceeded", "InvoiceDueDateApproaching",
     "InvoiceDueDateReached", "CrossCloudNewDataAvailable", "CrossCloudCollectionError", and
     "GeneralThresholdError".
    :vartype criteria: str or ~azure.mgmt.costmanagement.models.AlertCriteria
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "criteria": {"key": "criteria", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AlertType"]] = None,
        category: Optional[Union[str, "_models.AlertCategory"]] = None,
        criteria: Optional[Union[str, "_models.AlertCriteria"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: type of alert. Known values are: "Budget", "Invoice", "Credit", "Quota",
         "General", "xCloud", and "BudgetForecast".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.AlertType
        :keyword category: Alert category. Known values are: "Cost", "Usage", "Billing", and "System".
        :paramtype category: str or ~azure.mgmt.costmanagement.models.AlertCategory
        :keyword criteria: Criteria that triggered alert. Known values are: "CostThresholdExceeded",
         "UsageThresholdExceeded", "CreditThresholdApproaching", "CreditThresholdReached",
         "QuotaThresholdApproaching", "QuotaThresholdReached", "MultiCurrency",
         "ForecastCostThresholdExceeded", "ForecastUsageThresholdExceeded", "InvoiceDueDateApproaching",
         "InvoiceDueDateReached", "CrossCloudNewDataAvailable", "CrossCloudCollectionError", and
         "GeneralThresholdError".
        :paramtype criteria: str or ~azure.mgmt.costmanagement.models.AlertCriteria
        """
        super().__init__(**kwargs)
        self.type = type
        self.category = category
        self.criteria = criteria


class AlertPropertiesDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Alert details.

    :ivar time_grain_type: Type of timegrain cadence. Known values are: "None", "Monthly",
     "Quarterly", "Annually", "BillingMonth", "BillingQuarter", and "BillingAnnual".
    :vartype time_grain_type: str or ~azure.mgmt.costmanagement.models.AlertTimeGrainType
    :ivar period_start_date: datetime of periodStartDate.
    :vartype period_start_date: str
    :ivar triggered_by: notificationId that triggered this alert.
    :vartype triggered_by: str
    :ivar resource_group_filter: array of resourceGroups to filter by.
    :vartype resource_group_filter: list[any]
    :ivar resource_filter: array of resources to filter by.
    :vartype resource_filter: list[any]
    :ivar meter_filter: array of meters to filter by.
    :vartype meter_filter: list[any]
    :ivar tag_filter: tags to filter by.
    :vartype tag_filter: JSON
    :ivar threshold: notification threshold percentage as a decimal which activated this alert.
    :vartype threshold: float
    :ivar operator: operator used to compare currentSpend with amount. Known values are: "None",
     "EqualTo", "GreaterThan", "GreaterThanOrEqualTo", "LessThan", and "LessThanOrEqualTo".
    :vartype operator: str or ~azure.mgmt.costmanagement.models.AlertOperator
    :ivar amount: budget threshold amount.
    :vartype amount: float
    :ivar unit: unit of currency being used.
    :vartype unit: str
    :ivar current_spend: current spend.
    :vartype current_spend: float
    :ivar contact_emails: list of emails to contact.
    :vartype contact_emails: list[str]
    :ivar contact_groups: list of action groups to broadcast to.
    :vartype contact_groups: list[str]
    :ivar contact_roles: list of contact roles.
    :vartype contact_roles: list[str]
    :ivar overriding_alert: overriding alert.
    :vartype overriding_alert: str
    :ivar department_name: department name.
    :vartype department_name: str
    :ivar company_name: company name.
    :vartype company_name: str
    :ivar enrollment_number: enrollment number.
    :vartype enrollment_number: str
    :ivar enrollment_start_date: datetime of enrollmentStartDate.
    :vartype enrollment_start_date: str
    :ivar enrollment_end_date: datetime of enrollmentEndDate.
    :vartype enrollment_end_date: str
    :ivar invoicing_threshold: invoicing threshold.
    :vartype invoicing_threshold: float
    """

    _attribute_map = {
        "time_grain_type": {"key": "timeGrainType", "type": "str"},
        "period_start_date": {"key": "periodStartDate", "type": "str"},
        "triggered_by": {"key": "triggeredBy", "type": "str"},
        "resource_group_filter": {"key": "resourceGroupFilter", "type": "[object]"},
        "resource_filter": {"key": "resourceFilter", "type": "[object]"},
        "meter_filter": {"key": "meterFilter", "type": "[object]"},
        "tag_filter": {"key": "tagFilter", "type": "object"},
        "threshold": {"key": "threshold", "type": "float"},
        "operator": {"key": "operator", "type": "str"},
        "amount": {"key": "amount", "type": "float"},
        "unit": {"key": "unit", "type": "str"},
        "current_spend": {"key": "currentSpend", "type": "float"},
        "contact_emails": {"key": "contactEmails", "type": "[str]"},
        "contact_groups": {"key": "contactGroups", "type": "[str]"},
        "contact_roles": {"key": "contactRoles", "type": "[str]"},
        "overriding_alert": {"key": "overridingAlert", "type": "str"},
        "department_name": {"key": "departmentName", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "enrollment_number": {"key": "enrollmentNumber", "type": "str"},
        "enrollment_start_date": {"key": "enrollmentStartDate", "type": "str"},
        "enrollment_end_date": {"key": "enrollmentEndDate", "type": "str"},
        "invoicing_threshold": {"key": "invoicingThreshold", "type": "float"},
    }

    def __init__(
        self,
        *,
        time_grain_type: Optional[Union[str, "_models.AlertTimeGrainType"]] = None,
        period_start_date: Optional[str] = None,
        triggered_by: Optional[str] = None,
        resource_group_filter: Optional[List[Any]] = None,
        resource_filter: Optional[List[Any]] = None,
        meter_filter: Optional[List[Any]] = None,
        tag_filter: Optional[JSON] = None,
        threshold: Optional[float] = None,
        operator: Optional[Union[str, "_models.AlertOperator"]] = None,
        amount: Optional[float] = None,
        unit: Optional[str] = None,
        current_spend: Optional[float] = None,
        contact_emails: Optional[List[str]] = None,
        contact_groups: Optional[List[str]] = None,
        contact_roles: Optional[List[str]] = None,
        overriding_alert: Optional[str] = None,
        department_name: Optional[str] = None,
        company_name: Optional[str] = None,
        enrollment_number: Optional[str] = None,
        enrollment_start_date: Optional[str] = None,
        enrollment_end_date: Optional[str] = None,
        invoicing_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain_type: Type of timegrain cadence. Known values are: "None", "Monthly",
         "Quarterly", "Annually", "BillingMonth", "BillingQuarter", and "BillingAnnual".
        :paramtype time_grain_type: str or ~azure.mgmt.costmanagement.models.AlertTimeGrainType
        :keyword period_start_date: datetime of periodStartDate.
        :paramtype period_start_date: str
        :keyword triggered_by: notificationId that triggered this alert.
        :paramtype triggered_by: str
        :keyword resource_group_filter: array of resourceGroups to filter by.
        :paramtype resource_group_filter: list[any]
        :keyword resource_filter: array of resources to filter by.
        :paramtype resource_filter: list[any]
        :keyword meter_filter: array of meters to filter by.
        :paramtype meter_filter: list[any]
        :keyword tag_filter: tags to filter by.
        :paramtype tag_filter: JSON
        :keyword threshold: notification threshold percentage as a decimal which activated this alert.
        :paramtype threshold: float
        :keyword operator: operator used to compare currentSpend with amount. Known values are: "None",
         "EqualTo", "GreaterThan", "GreaterThanOrEqualTo", "LessThan", and "LessThanOrEqualTo".
        :paramtype operator: str or ~azure.mgmt.costmanagement.models.AlertOperator
        :keyword amount: budget threshold amount.
        :paramtype amount: float
        :keyword unit: unit of currency being used.
        :paramtype unit: str
        :keyword current_spend: current spend.
        :paramtype current_spend: float
        :keyword contact_emails: list of emails to contact.
        :paramtype contact_emails: list[str]
        :keyword contact_groups: list of action groups to broadcast to.
        :paramtype contact_groups: list[str]
        :keyword contact_roles: list of contact roles.
        :paramtype contact_roles: list[str]
        :keyword overriding_alert: overriding alert.
        :paramtype overriding_alert: str
        :keyword department_name: department name.
        :paramtype department_name: str
        :keyword company_name: company name.
        :paramtype company_name: str
        :keyword enrollment_number: enrollment number.
        :paramtype enrollment_number: str
        :keyword enrollment_start_date: datetime of enrollmentStartDate.
        :paramtype enrollment_start_date: str
        :keyword enrollment_end_date: datetime of enrollmentEndDate.
        :paramtype enrollment_end_date: str
        :keyword invoicing_threshold: invoicing threshold.
        :paramtype invoicing_threshold: float
        """
        super().__init__(**kwargs)
        self.time_grain_type = time_grain_type
        self.period_start_date = period_start_date
        self.triggered_by = triggered_by
        self.resource_group_filter = resource_group_filter
        self.resource_filter = resource_filter
        self.meter_filter = meter_filter
        self.tag_filter = tag_filter
        self.threshold = threshold
        self.operator = operator
        self.amount = amount
        self.unit = unit
        self.current_spend = current_spend
        self.contact_emails = contact_emails
        self.contact_groups = contact_groups
        self.contact_roles = contact_roles
        self.overriding_alert = overriding_alert
        self.department_name = department_name
        self.company_name = company_name
        self.enrollment_number = enrollment_number
        self.enrollment_start_date = enrollment_start_date
        self.enrollment_end_date = enrollment_end_date
        self.invoicing_threshold = invoicing_threshold


class AlertsResult(_serialization.Model):
    """Result of alerts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of alerts.
    :vartype value: list[~azure.mgmt.costmanagement.models.Alert]
    :ivar next_link: URL to get the next set of alerts results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Alert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AllSavingsBenefitDetails(_serialization.Model):
    """Benefit recommendation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar overage_cost: The difference between total cost and benefit cost for the 'totalHours' in
     the look-back period.
    :vartype overage_cost: float
    :ivar benefit_cost: The estimated cost with benefit for the 'totalHours' in the look-back
     period. It's equal to (commitmentAmount * totalHours).
    :vartype benefit_cost: float
    :ivar total_cost: Total cost, which is sum of benefit cost and overage cost.
    :vartype total_cost: float
    :ivar savings_amount: The amount saved for the 'totalHours' in the look-back period, by
     purchasing the recommended quantity of the benefit.
    :vartype savings_amount: float
    :ivar savings_percentage: The savings in percentage for the 'totalHours' in the look-back
     period, by purchasing the recommended quantity of benefit.
    :vartype savings_percentage: float
    :ivar coverage_percentage: Estimated benefit coverage percentage for the 'totalHours' in the
     look-back period, with this commitment.
    :vartype coverage_percentage: float
    :ivar commitment_amount: The commitment amount at the commitmentGranularity.
    :vartype commitment_amount: float
    :ivar average_utilization_percentage: Estimated average utilization percentage for the
     'totalHours' in the look-back period, with this commitment.
    :vartype average_utilization_percentage: float
    :ivar wastage_cost: Estimated unused portion of the 'benefitCost'.
    :vartype wastage_cost: float
    """

    _validation = {
        "overage_cost": {"readonly": True},
        "benefit_cost": {"readonly": True},
        "total_cost": {"readonly": True},
        "savings_amount": {"readonly": True},
        "savings_percentage": {"readonly": True},
        "coverage_percentage": {"readonly": True},
        "commitment_amount": {"readonly": True},
        "average_utilization_percentage": {"readonly": True},
        "wastage_cost": {"readonly": True},
    }

    _attribute_map = {
        "overage_cost": {"key": "overageCost", "type": "float"},
        "benefit_cost": {"key": "benefitCost", "type": "float"},
        "total_cost": {"key": "totalCost", "type": "float"},
        "savings_amount": {"key": "savingsAmount", "type": "float"},
        "savings_percentage": {"key": "savingsPercentage", "type": "float"},
        "coverage_percentage": {"key": "coveragePercentage", "type": "float"},
        "commitment_amount": {"key": "commitmentAmount", "type": "float"},
        "average_utilization_percentage": {"key": "averageUtilizationPercentage", "type": "float"},
        "wastage_cost": {"key": "wastageCost", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.overage_cost = None
        self.benefit_cost = None
        self.total_cost = None
        self.savings_amount = None
        self.savings_percentage = None
        self.coverage_percentage = None
        self.commitment_amount = None
        self.average_utilization_percentage = None
        self.wastage_cost = None


class AllSavingsList(_serialization.Model):
    """The list of all benefit recommendations with the recommendation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of benefit recommendations with the recommendation details..
    :vartype value: list[~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails]
    :ivar next_link: The link (URL) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AllSavingsBenefitDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class BenefitResource(Resource):
    """The benefit resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Reservation or SavingsPlan. Known values are: "IncludedQuantity", "Reservation",
     and "SavingsPlan".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[Union[str, "_models.BenefitKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Reservation or SavingsPlan. Known values are: "IncludedQuantity", "Reservation",
         and "SavingsPlan".
        :paramtype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
        """
        super().__init__(**kwargs)
        self.kind = kind


class BenefitRecommendationModel(BenefitResource):
    """benefit plan recommendation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Reservation or SavingsPlan. Known values are: "IncludedQuantity", "Reservation",
     and "SavingsPlan".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar properties: The properties of the benefit recommendations.
    :vartype properties: ~azure.mgmt.costmanagement.models.BenefitRecommendationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "properties": {"key": "properties", "type": "BenefitRecommendationProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.BenefitKind"]] = None,
        properties: Optional["_models.BenefitRecommendationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Reservation or SavingsPlan. Known values are: "IncludedQuantity", "Reservation",
         and "SavingsPlan".
        :paramtype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
        :keyword properties: The properties of the benefit recommendations.
        :paramtype properties: ~azure.mgmt.costmanagement.models.BenefitRecommendationProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class BenefitRecommendationProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The properties of the benefit recommendations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SharedScopeBenefitRecommendationProperties, SingleScopeBenefitRecommendationProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar first_consumption_date: The first usage date used for looking back for computing the
     recommendations.
    :vartype first_consumption_date: ~datetime.datetime
    :ivar last_consumption_date: The last usage date used for looking back for computing the
     recommendations.
    :vartype last_consumption_date: ~datetime.datetime
    :ivar look_back_period: The number of days of usage evaluated for computing the
     recommendations. Known values are: "Last7Days", "Last30Days", and "Last60Days".
    :vartype look_back_period: str or ~azure.mgmt.costmanagement.models.LookBackPeriod
    :ivar total_hours: The total hours for which the cost is covered. Its equal to number of
     records in a property 'properties/usage/charges'.
    :vartype total_hours: int
    :ivar usage: On-demand charges between firstConsumptionDate and lastConsumptionDate that were
     used for computing benefit recommendations.
    :vartype usage: ~azure.mgmt.costmanagement.models.RecommendationUsageDetails
    :ivar arm_sku_name: ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan.
    :vartype arm_sku_name: str
    :ivar term: Term period of the benefit. For example, P1Y or P3Y. Known values are: "P1Y" and
     "P3Y".
    :vartype term: str or ~azure.mgmt.costmanagement.models.Term
    :ivar commitment_granularity: Grain of the proposed commitment amount. Supported values:
     'Hourly'. Known values are: "Hourly", "Daily", and "Monthly".
    :vartype commitment_granularity: str or ~azure.mgmt.costmanagement.models.Grain
    :ivar currency_code: An ISO 4217 currency code identifier for the costs and savings amounts.
    :vartype currency_code: str
    :ivar cost_without_benefit: The current cost without benefit, corresponds to 'totalHours' in
     the look-back period.
    :vartype cost_without_benefit: float
    :ivar recommendation_details: The details of the proposed recommendation.
    :vartype recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails
    :ivar all_recommendation_details: The list of all benefit recommendations with the
     recommendation details.
    :vartype all_recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsList
    :ivar scope: Benefit scope. For example, Single or Shared. Required. Known values are: "Single"
     and "Shared".
    :vartype scope: str or ~azure.mgmt.costmanagement.models.Scope
    """

    _validation = {
        "first_consumption_date": {"readonly": True},
        "last_consumption_date": {"readonly": True},
        "total_hours": {"readonly": True},
        "arm_sku_name": {"readonly": True},
        "currency_code": {"readonly": True},
        "cost_without_benefit": {"readonly": True},
        "all_recommendation_details": {"readonly": True},
        "scope": {"required": True},
    }

    _attribute_map = {
        "first_consumption_date": {"key": "firstConsumptionDate", "type": "iso-8601"},
        "last_consumption_date": {"key": "lastConsumptionDate", "type": "iso-8601"},
        "look_back_period": {"key": "lookBackPeriod", "type": "str"},
        "total_hours": {"key": "totalHours", "type": "int"},
        "usage": {"key": "usage", "type": "RecommendationUsageDetails"},
        "arm_sku_name": {"key": "armSkuName", "type": "str"},
        "term": {"key": "term", "type": "str"},
        "commitment_granularity": {"key": "commitmentGranularity", "type": "str"},
        "currency_code": {"key": "currencyCode", "type": "str"},
        "cost_without_benefit": {"key": "costWithoutBenefit", "type": "float"},
        "recommendation_details": {"key": "recommendationDetails", "type": "AllSavingsBenefitDetails"},
        "all_recommendation_details": {"key": "allRecommendationDetails", "type": "AllSavingsList"},
        "scope": {"key": "scope", "type": "str"},
    }

    _subtype_map = {
        "scope": {
            "Shared": "SharedScopeBenefitRecommendationProperties",
            "Single": "SingleScopeBenefitRecommendationProperties",
        }
    }

    def __init__(
        self,
        *,
        look_back_period: Optional[Union[str, "_models.LookBackPeriod"]] = None,
        usage: Optional["_models.RecommendationUsageDetails"] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        commitment_granularity: Optional[Union[str, "_models.Grain"]] = None,
        recommendation_details: Optional["_models.AllSavingsBenefitDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword look_back_period: The number of days of usage evaluated for computing the
         recommendations. Known values are: "Last7Days", "Last30Days", and "Last60Days".
        :paramtype look_back_period: str or ~azure.mgmt.costmanagement.models.LookBackPeriod
        :keyword usage: On-demand charges between firstConsumptionDate and lastConsumptionDate that
         were used for computing benefit recommendations.
        :paramtype usage: ~azure.mgmt.costmanagement.models.RecommendationUsageDetails
        :keyword term: Term period of the benefit. For example, P1Y or P3Y. Known values are: "P1Y" and
         "P3Y".
        :paramtype term: str or ~azure.mgmt.costmanagement.models.Term
        :keyword commitment_granularity: Grain of the proposed commitment amount. Supported values:
         'Hourly'. Known values are: "Hourly", "Daily", and "Monthly".
        :paramtype commitment_granularity: str or ~azure.mgmt.costmanagement.models.Grain
        :keyword recommendation_details: The details of the proposed recommendation.
        :paramtype recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails
        """
        super().__init__(**kwargs)
        self.first_consumption_date = None
        self.last_consumption_date = None
        self.look_back_period = look_back_period
        self.total_hours = None
        self.usage = usage
        self.arm_sku_name = None
        self.term = term
        self.commitment_granularity = commitment_granularity
        self.currency_code = None
        self.cost_without_benefit = None
        self.recommendation_details = recommendation_details
        self.all_recommendation_details = None
        self.scope: Optional[str] = None


class BenefitRecommendationsListResult(_serialization.Model):
    """Result of listing benefit recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of benefit recommendations.
    :vartype value: list[~azure.mgmt.costmanagement.models.BenefitRecommendationModel]
    :ivar next_link: The link (URL) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BenefitRecommendationModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class BenefitUtilizationSummariesListResult(_serialization.Model):
    """List of benefit utilization summaries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of benefit utilization summaries.
    :vartype value: list[~azure.mgmt.costmanagement.models.BenefitUtilizationSummary]
    :ivar next_link: The link (URL) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BenefitUtilizationSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class BenefitUtilizationSummary(Resource):
    """Benefit utilization summary resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    IncludedQuantityUtilizationSummary, SavingsPlanUtilizationSummary

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Supported values: 'SavingsPlan'. Required. Known values are: "IncludedQuantity",
     "Reservation", and "SavingsPlan".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "IncludedQuantity": "IncludedQuantityUtilizationSummary",
            "SavingsPlan": "SavingsPlanUtilizationSummary",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class BenefitUtilizationSummaryProperties(_serialization.Model):
    """The properties of a benefit utilization summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar arm_sku_name: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
    :vartype arm_sku_name: str
    :ivar benefit_id: The benefit ID is the identifier of the benefit.
    :vartype benefit_id: str
    :ivar benefit_order_id: The benefit order ID is the identifier for a benefit purchase.
    :vartype benefit_order_id: str
    :ivar benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
     "IncludedQuantity", "Reservation", and "SavingsPlan".
    :vartype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar usage_date: Date corresponding to the utilization summary record. If the grain of data is
     monthly, value for this field will be first day of the month.
    :vartype usage_date: ~datetime.datetime
    """

    _validation = {
        "arm_sku_name": {"readonly": True},
        "benefit_id": {"readonly": True},
        "benefit_order_id": {"readonly": True},
        "usage_date": {"readonly": True},
    }

    _attribute_map = {
        "arm_sku_name": {"key": "armSkuName", "type": "str"},
        "benefit_id": {"key": "benefitId", "type": "str"},
        "benefit_order_id": {"key": "benefitOrderId", "type": "str"},
        "benefit_type": {"key": "benefitType", "type": "str"},
        "usage_date": {"key": "usageDate", "type": "iso-8601"},
    }

    def __init__(self, *, benefit_type: Optional[Union[str, "_models.BenefitKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
         "IncludedQuantity", "Reservation", and "SavingsPlan".
        :paramtype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
        """
        super().__init__(**kwargs)
        self.arm_sku_name = None
        self.benefit_id = None
        self.benefit_order_id = None
        self.benefit_type = benefit_type
        self.usage_date = None


class BlobInfo(_serialization.Model):
    """The blob information generated by this operation.

    :ivar blob_link: Link to the blob to download file.
    :vartype blob_link: str
    :ivar byte_count: Bytes in the blob.
    :vartype byte_count: int
    """

    _attribute_map = {
        "blob_link": {"key": "blobLink", "type": "str"},
        "byte_count": {"key": "byteCount", "type": "int"},
    }

    def __init__(self, *, blob_link: Optional[str] = None, byte_count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword blob_link: Link to the blob to download file.
        :paramtype blob_link: str
        :keyword byte_count: Bytes in the blob.
        :paramtype byte_count: int
        """
        super().__init__(**kwargs)
        self.blob_link = blob_link
        self.byte_count = byte_count


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.costmanagement.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates if the resource name is available.
        :paramtype name_available: bool
        :keyword reason: The reason why the given name is not available. Known values are: "Invalid"
         and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.costmanagement.models.CheckNameAvailabilityReason
        :keyword message: Detailed reason why the given name is available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class CommonExportProperties(_serialization.Model):
    """The common properties of the export.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar format: The format of the export being delivered. Currently only 'Csv' is supported.
     "Csv"
    :vartype format: str or ~azure.mgmt.costmanagement.models.FormatType
    :ivar delivery_info: Has delivery information for the export. Required.
    :vartype delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
    :ivar definition: Has the definition for the export. Required.
    :vartype definition: ~azure.mgmt.costmanagement.models.ExportDefinition
    :ivar run_history: If requested, has the most recent run history for the export.
    :vartype run_history: ~azure.mgmt.costmanagement.models.ExportExecutionListResult
    :ivar partition_data: If set to true, exported data will be partitioned by size and placed in a
     blob directory together with a manifest file. Note: this option is currently available only for
     Microsoft Customer Agreement commerce scopes.
    :vartype partition_data: bool
    :ivar next_run_time_estimate: If the export has an active schedule, provides an estimate of the
     next run time.
    :vartype next_run_time_estimate: ~datetime.datetime
    """

    _validation = {
        "delivery_info": {"required": True},
        "definition": {"required": True},
        "next_run_time_estimate": {"readonly": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "delivery_info": {"key": "deliveryInfo", "type": "ExportDeliveryInfo"},
        "definition": {"key": "definition", "type": "ExportDefinition"},
        "run_history": {"key": "runHistory", "type": "ExportExecutionListResult"},
        "partition_data": {"key": "partitionData", "type": "bool"},
        "next_run_time_estimate": {"key": "nextRunTimeEstimate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        delivery_info: "_models.ExportDeliveryInfo",
        definition: "_models.ExportDefinition",
        format: Optional[Union[str, "_models.FormatType"]] = None,
        run_history: Optional["_models.ExportExecutionListResult"] = None,
        partition_data: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: The format of the export being delivered. Currently only 'Csv' is supported.
         "Csv"
        :paramtype format: str or ~azure.mgmt.costmanagement.models.FormatType
        :keyword delivery_info: Has delivery information for the export. Required.
        :paramtype delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
        :keyword definition: Has the definition for the export. Required.
        :paramtype definition: ~azure.mgmt.costmanagement.models.ExportDefinition
        :keyword run_history: If requested, has the most recent run history for the export.
        :paramtype run_history: ~azure.mgmt.costmanagement.models.ExportExecutionListResult
        :keyword partition_data: If set to true, exported data will be partitioned by size and placed
         in a blob directory together with a manifest file. Note: this option is currently available
         only for Microsoft Customer Agreement commerce scopes.
        :paramtype partition_data: bool
        """
        super().__init__(**kwargs)
        self.format = format
        self.delivery_info = delivery_info
        self.definition = definition
        self.run_history = run_history
        self.partition_data = partition_data
        self.next_run_time_estimate = None


class CostDetailsOperationResults(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The result of the long running operation for cost details Api.

    :ivar id: The id of the long running operation.
    :vartype id: str
    :ivar name: The name of the long running operation.
    :vartype name: str
    :ivar type: The type of the long running operation.
    :vartype type: str
    :ivar status: The status of the cost details operation. Known values are: "Completed",
     "NoDataFound", and "Failed".
    :vartype status: str or ~azure.mgmt.costmanagement.models.CostDetailsStatusType
    :ivar valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype valid_till: ~datetime.datetime
    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetails
    :ivar manifest_version: The Manifest version.
    :vartype manifest_version: str
    :ivar data_format: The data format of the report. "Csv"
    :vartype data_format: str or ~azure.mgmt.costmanagement.models.CostDetailsDataFormat
    :ivar byte_count: The total number of bytes in all blobs.
    :vartype byte_count: int
    :ivar blob_count: The total number of blobs.
    :vartype blob_count: int
    :ivar compress_data: Is the data in compressed format.
    :vartype compress_data: bool
    :ivar blobs: List of blob information generated by this operation.
    :vartype blobs: list[~azure.mgmt.costmanagement.models.BlobInfo]
    :ivar request_scope: The request scope of the request.
    :vartype request_scope: str
    :ivar request_body: The request payload body provided in Cost Details call.
    :vartype request_body:
     ~azure.mgmt.costmanagement.models.GenerateCostDetailsReportRequestDefinition
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "valid_till": {"key": "validTill", "type": "iso-8601"},
        "error": {"key": "error", "type": "ErrorDetails"},
        "manifest_version": {"key": "manifest.manifestVersion", "type": "str"},
        "data_format": {"key": "manifest.dataFormat", "type": "str"},
        "byte_count": {"key": "manifest.byteCount", "type": "int"},
        "blob_count": {"key": "manifest.blobCount", "type": "int"},
        "compress_data": {"key": "manifest.compressData", "type": "bool"},
        "blobs": {"key": "manifest.blobs", "type": "[BlobInfo]"},
        "request_scope": {"key": "manifest.requestContext.requestScope", "type": "str"},
        "request_body": {
            "key": "manifest.requestContext.requestBody",
            "type": "GenerateCostDetailsReportRequestDefinition",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        status: Optional[Union[str, "_models.CostDetailsStatusType"]] = None,
        valid_till: Optional[datetime.datetime] = None,
        error: Optional["_models.ErrorDetails"] = None,
        manifest_version: Optional[str] = None,
        data_format: Optional[Union[str, "_models.CostDetailsDataFormat"]] = None,
        byte_count: Optional[int] = None,
        blob_count: Optional[int] = None,
        compress_data: Optional[bool] = None,
        blobs: Optional[List["_models.BlobInfo"]] = None,
        request_scope: Optional[str] = None,
        request_body: Optional["_models.GenerateCostDetailsReportRequestDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the long running operation.
        :paramtype id: str
        :keyword name: The name of the long running operation.
        :paramtype name: str
        :keyword type: The type of the long running operation.
        :paramtype type: str
        :keyword status: The status of the cost details operation. Known values are: "Completed",
         "NoDataFound", and "Failed".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.CostDetailsStatusType
        :keyword valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
         2020-12-08T05:55:59.4394737Z.
        :paramtype valid_till: ~datetime.datetime
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetails
        :keyword manifest_version: The Manifest version.
        :paramtype manifest_version: str
        :keyword data_format: The data format of the report. "Csv"
        :paramtype data_format: str or ~azure.mgmt.costmanagement.models.CostDetailsDataFormat
        :keyword byte_count: The total number of bytes in all blobs.
        :paramtype byte_count: int
        :keyword blob_count: The total number of blobs.
        :paramtype blob_count: int
        :keyword compress_data: Is the data in compressed format.
        :paramtype compress_data: bool
        :keyword blobs: List of blob information generated by this operation.
        :paramtype blobs: list[~azure.mgmt.costmanagement.models.BlobInfo]
        :keyword request_scope: The request scope of the request.
        :paramtype request_scope: str
        :keyword request_body: The request payload body provided in Cost Details call.
        :paramtype request_body:
         ~azure.mgmt.costmanagement.models.GenerateCostDetailsReportRequestDefinition
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.status = status
        self.valid_till = valid_till
        self.error = error
        self.manifest_version = manifest_version
        self.data_format = data_format
        self.byte_count = byte_count
        self.blob_count = blob_count
        self.compress_data = compress_data
        self.blobs = blobs
        self.request_scope = request_scope
        self.request_body = request_body


class CostDetailsTimePeriod(_serialization.Model):
    """The start and end date for pulling data for the cost detailed report. API only allows data to
    be pulled for 1 month or less and no older than 13 months.

    All required parameters must be populated in order to send to Azure.

    :ivar start: The start date to pull data from. example format 2020-03-15. Required.
    :vartype start: str
    :ivar end: The end date to pull data to. example format 2020-03-15. Required.
    :vartype end: str
    """

    _validation = {
        "start": {"required": True},
        "end": {"required": True},
    }

    _attribute_map = {
        "start": {"key": "start", "type": "str"},
        "end": {"key": "end", "type": "str"},
    }

    def __init__(self, *, start: str, end: str, **kwargs: Any) -> None:
        """
        :keyword start: The start date to pull data from. example format 2020-03-15. Required.
        :paramtype start: str
        :keyword end: The end date to pull data to. example format 2020-03-15. Required.
        :paramtype end: str
        """
        super().__init__(**kwargs)
        self.start = start
        self.end = end


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.costmanagement.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.costmanagement.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.costmanagement.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.costmanagement.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class CostManagementOperation(Operation):
    """A Cost management REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.costmanagement.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.costmanagement.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.costmanagement.models.ActionType
    :ivar id: Operation id: {provider}/{resource}/{operation}.
    :vartype id: str
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.costmanagement.models.OperationDisplay
        """
        super().__init__(display=display, **kwargs)
        self.id = None


class CostManagementResource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar sku: SKU of the resource.
    :vartype sku: str
    :ivar e_tag: ETag of the resource.
    :vartype e_tag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "sku": {"readonly": True},
        "e_tag": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.sku = None
        self.e_tag = None
        self.tags = None


class Dimension(CostManagementResource):  # pylint: disable=too-many-instance-attributes
    """List of Dimension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar sku: SKU of the resource.
    :vartype sku: str
    :ivar e_tag: ETag of the resource.
    :vartype e_tag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: Dimension description.
    :vartype description: str
    :ivar filter_enabled: Filter enabled.
    :vartype filter_enabled: bool
    :ivar grouping_enabled: Grouping enabled.
    :vartype grouping_enabled: bool
    :ivar data: Dimension data.
    :vartype data: list[str]
    :ivar total: Total number of data for the dimension.
    :vartype total: int
    :ivar category: Dimension category.
    :vartype category: str
    :ivar usage_start: Usage start.
    :vartype usage_start: ~datetime.datetime
    :ivar usage_end: Usage end.
    :vartype usage_end: ~datetime.datetime
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "sku": {"readonly": True},
        "e_tag": {"readonly": True},
        "tags": {"readonly": True},
        "description": {"readonly": True},
        "filter_enabled": {"readonly": True},
        "grouping_enabled": {"readonly": True},
        "total": {"readonly": True},
        "category": {"readonly": True},
        "usage_start": {"readonly": True},
        "usage_end": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "filter_enabled": {"key": "properties.filterEnabled", "type": "bool"},
        "grouping_enabled": {"key": "properties.groupingEnabled", "type": "bool"},
        "data": {"key": "properties.data", "type": "[str]"},
        "total": {"key": "properties.total", "type": "int"},
        "category": {"key": "properties.category", "type": "str"},
        "usage_start": {"key": "properties.usageStart", "type": "iso-8601"},
        "usage_end": {"key": "properties.usageEnd", "type": "iso-8601"},
        "next_link": {"key": "properties.nextLink", "type": "str"},
    }

    def __init__(self, *, data: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword data: Dimension data.
        :paramtype data: list[str]
        """
        super().__init__(**kwargs)
        self.description = None
        self.filter_enabled = None
        self.grouping_enabled = None
        self.data = data
        self.total = None
        self.category = None
        self.usage_start = None
        self.usage_end = None
        self.next_link = None


class DimensionsListResult(_serialization.Model):
    """Result of listing dimensions. It contains a list of available dimensions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of dimensions.
    :vartype value: list[~azure.mgmt.costmanagement.models.Dimension]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Dimension]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class DismissAlertPayload(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The request payload to update an alert.

    :ivar definition: defines the type of alert.
    :vartype definition: ~azure.mgmt.costmanagement.models.AlertPropertiesDefinition
    :ivar description: Alert description.
    :vartype description: str
    :ivar source: Source of alert. Known values are: "Preset" and "User".
    :vartype source: str or ~azure.mgmt.costmanagement.models.AlertSource
    :ivar details: Alert details.
    :vartype details: ~azure.mgmt.costmanagement.models.AlertPropertiesDetails
    :ivar cost_entity_id: related budget.
    :vartype cost_entity_id: str
    :ivar status: alert status. Known values are: "None", "Active", "Overridden", "Resolved", and
     "Dismissed".
    :vartype status: str or ~azure.mgmt.costmanagement.models.AlertStatus
    :ivar creation_time: dateTime in which alert was created.
    :vartype creation_time: str
    :ivar close_time: dateTime in which alert was closed.
    :vartype close_time: str
    :ivar modification_time: dateTime in which alert was last modified.
    :vartype modification_time: str
    :ivar status_modification_user_name: User who last modified the alert.
    :vartype status_modification_user_name: str
    :ivar status_modification_time: dateTime in which the alert status was last modified.
    :vartype status_modification_time: str
    """

    _attribute_map = {
        "definition": {"key": "properties.definition", "type": "AlertPropertiesDefinition"},
        "description": {"key": "properties.description", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "details": {"key": "properties.details", "type": "AlertPropertiesDetails"},
        "cost_entity_id": {"key": "properties.costEntityId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "str"},
        "close_time": {"key": "properties.closeTime", "type": "str"},
        "modification_time": {"key": "properties.modificationTime", "type": "str"},
        "status_modification_user_name": {"key": "properties.statusModificationUserName", "type": "str"},
        "status_modification_time": {"key": "properties.statusModificationTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        definition: Optional["_models.AlertPropertiesDefinition"] = None,
        description: Optional[str] = None,
        source: Optional[Union[str, "_models.AlertSource"]] = None,
        details: Optional["_models.AlertPropertiesDetails"] = None,
        cost_entity_id: Optional[str] = None,
        status: Optional[Union[str, "_models.AlertStatus"]] = None,
        creation_time: Optional[str] = None,
        close_time: Optional[str] = None,
        modification_time: Optional[str] = None,
        status_modification_user_name: Optional[str] = None,
        status_modification_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword definition: defines the type of alert.
        :paramtype definition: ~azure.mgmt.costmanagement.models.AlertPropertiesDefinition
        :keyword description: Alert description.
        :paramtype description: str
        :keyword source: Source of alert. Known values are: "Preset" and "User".
        :paramtype source: str or ~azure.mgmt.costmanagement.models.AlertSource
        :keyword details: Alert details.
        :paramtype details: ~azure.mgmt.costmanagement.models.AlertPropertiesDetails
        :keyword cost_entity_id: related budget.
        :paramtype cost_entity_id: str
        :keyword status: alert status. Known values are: "None", "Active", "Overridden", "Resolved",
         and "Dismissed".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.AlertStatus
        :keyword creation_time: dateTime in which alert was created.
        :paramtype creation_time: str
        :keyword close_time: dateTime in which alert was closed.
        :paramtype close_time: str
        :keyword modification_time: dateTime in which alert was last modified.
        :paramtype modification_time: str
        :keyword status_modification_user_name: User who last modified the alert.
        :paramtype status_modification_user_name: str
        :keyword status_modification_time: dateTime in which the alert status was last modified.
        :paramtype status_modification_time: str
        """
        super().__init__(**kwargs)
        self.definition = definition
        self.description = description
        self.source = source
        self.details = details
        self.cost_entity_id = cost_entity_id
        self.status = status
        self.creation_time = creation_time
        self.close_time = close_time
        self.modification_time = modification_time
        self.status_modification_user_name = status_modification_user_name
        self.status_modification_time = status_modification_time


class DownloadURL(_serialization.Model):
    """The URL to download the generated report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiry_time: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype expiry_time: ~datetime.datetime
    :ivar valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype valid_till: ~datetime.datetime
    :ivar download_url: The URL to download the generated report.
    :vartype download_url: str
    """

    _validation = {
        "expiry_time": {"readonly": True},
    }

    _attribute_map = {
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
        "valid_till": {"key": "validTill", "type": "iso-8601"},
        "download_url": {"key": "downloadUrl", "type": "str"},
    }

    def __init__(
        self, *, valid_till: Optional[datetime.datetime] = None, download_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
         2020-12-08T05:55:59.4394737Z.
        :paramtype valid_till: ~datetime.datetime
        :keyword download_url: The URL to download the generated report.
        :paramtype download_url: str
        """
        super().__init__(**kwargs)
        self.expiry_time = None
        self.valid_till = valid_till
        self.download_url = download_url


class ErrorDetails(_serialization.Model):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorDetailsWithNestedDetails(ErrorDetails):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    :ivar details: The additional details of the error.
    :vartype details: list[~azure.mgmt.costmanagement.models.ErrorDetailsWithNestedDetails]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailsWithNestedDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.details = None


class ErrorResponse(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The
    reason is provided in the error message.

    Some Error responses:


    *
      429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the
    "x-ms-ratelimit-microsoft.consumption-retry-after" header.

    *
      503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time
    specified in the "Retry-After" header.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseWithNestedDetails(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The
    reason is provided in the error message.

    Some Error responses:


    *
      429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the
    "x-ms-ratelimit-microsoft.consumption-retry-after" header.

    *
      503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time
    specified in the "Retry-After" header.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetailsWithNestedDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetailsWithNestedDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetailsWithNestedDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetailsWithNestedDetails
        """
        super().__init__(**kwargs)
        self.error = error


class Export(CostManagementProxyResource):  # pylint: disable=too-many-instance-attributes
    """An export resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :vartype e_tag: str
    :ivar format: The format of the export being delivered. Currently only 'Csv' is supported.
     "Csv"
    :vartype format: str or ~azure.mgmt.costmanagement.models.FormatType
    :ivar delivery_info: Has delivery information for the export.
    :vartype delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
    :ivar definition: Has the definition for the export.
    :vartype definition: ~azure.mgmt.costmanagement.models.ExportDefinition
    :ivar run_history: If requested, has the most recent run history for the export.
    :vartype run_history: ~azure.mgmt.costmanagement.models.ExportExecutionListResult
    :ivar partition_data: If set to true, exported data will be partitioned by size and placed in a
     blob directory together with a manifest file. Note: this option is currently available only for
     Microsoft Customer Agreement commerce scopes.
    :vartype partition_data: bool
    :ivar next_run_time_estimate: If the export has an active schedule, provides an estimate of the
     next run time.
    :vartype next_run_time_estimate: ~datetime.datetime
    :ivar schedule: Has schedule information for the export.
    :vartype schedule: ~azure.mgmt.costmanagement.models.ExportSchedule
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "next_run_time_estimate": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "format": {"key": "properties.format", "type": "str"},
        "delivery_info": {"key": "properties.deliveryInfo", "type": "ExportDeliveryInfo"},
        "definition": {"key": "properties.definition", "type": "ExportDefinition"},
        "run_history": {"key": "properties.runHistory", "type": "ExportExecutionListResult"},
        "partition_data": {"key": "properties.partitionData", "type": "bool"},
        "next_run_time_estimate": {"key": "properties.nextRunTimeEstimate", "type": "iso-8601"},
        "schedule": {"key": "properties.schedule", "type": "ExportSchedule"},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        format: Optional[Union[str, "_models.FormatType"]] = None,
        delivery_info: Optional["_models.ExportDeliveryInfo"] = None,
        definition: Optional["_models.ExportDefinition"] = None,
        run_history: Optional["_models.ExportExecutionListResult"] = None,
        partition_data: Optional[bool] = None,
        schedule: Optional["_models.ExportSchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
         used to determine whether the user is updating the latest version or not.
        :paramtype e_tag: str
        :keyword format: The format of the export being delivered. Currently only 'Csv' is supported.
         "Csv"
        :paramtype format: str or ~azure.mgmt.costmanagement.models.FormatType
        :keyword delivery_info: Has delivery information for the export.
        :paramtype delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
        :keyword definition: Has the definition for the export.
        :paramtype definition: ~azure.mgmt.costmanagement.models.ExportDefinition
        :keyword run_history: If requested, has the most recent run history for the export.
        :paramtype run_history: ~azure.mgmt.costmanagement.models.ExportExecutionListResult
        :keyword partition_data: If set to true, exported data will be partitioned by size and placed
         in a blob directory together with a manifest file. Note: this option is currently available
         only for Microsoft Customer Agreement commerce scopes.
        :paramtype partition_data: bool
        :keyword schedule: Has schedule information for the export.
        :paramtype schedule: ~azure.mgmt.costmanagement.models.ExportSchedule
        """
        super().__init__(e_tag=e_tag, **kwargs)
        self.format = format
        self.delivery_info = delivery_info
        self.definition = definition
        self.run_history = run_history
        self.partition_data = partition_data
        self.next_run_time_estimate = None
        self.schedule = schedule


class ExportDataset(_serialization.Model):
    """The definition for data in the export.

    :ivar granularity: The granularity of rows in the export. Currently only 'Daily' is supported.
     "Daily"
    :vartype granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
    :ivar configuration: The export dataset configuration.
    :vartype configuration: ~azure.mgmt.costmanagement.models.ExportDatasetConfiguration
    """

    _attribute_map = {
        "granularity": {"key": "granularity", "type": "str"},
        "configuration": {"key": "configuration", "type": "ExportDatasetConfiguration"},
    }

    def __init__(
        self,
        *,
        granularity: Optional[Union[str, "_models.GranularityType"]] = None,
        configuration: Optional["_models.ExportDatasetConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword granularity: The granularity of rows in the export. Currently only 'Daily' is
         supported. "Daily"
        :paramtype granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
        :keyword configuration: The export dataset configuration.
        :paramtype configuration: ~azure.mgmt.costmanagement.models.ExportDatasetConfiguration
        """
        super().__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration


class ExportDatasetConfiguration(_serialization.Model):
    """The export dataset configuration. Allows columns to be selected for the export. If not provided
    then the export will include all available columns.

    :ivar columns: Array of column names to be included in the export. If not provided then the
     export will include all available columns. The available columns can vary by customer channel
     (see examples).
    :vartype columns: list[str]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[str]"},
    }

    def __init__(self, *, columns: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword columns: Array of column names to be included in the export. If not provided then the
         export will include all available columns. The available columns can vary by customer channel
         (see examples).
        :paramtype columns: list[str]
        """
        super().__init__(**kwargs)
        self.columns = columns


class ExportDefinition(_serialization.Model):
    """The definition of an export.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is
     applicable to exports that do not yet provide data for charges or amortization for service
     reservations. Required. Known values are: "Usage", "ActualCost", and "AmortizedCost".
    :vartype type: str or ~azure.mgmt.costmanagement.models.ExportType
    :ivar timeframe: The time frame for pulling data for the export. If custom, then a specific
     time period must be provided. Required. Known values are: "MonthToDate", "BillingMonthToDate",
     "TheLastMonth", "TheLastBillingMonth", "WeekToDate", and "Custom".
    :vartype timeframe: str or ~azure.mgmt.costmanagement.models.TimeframeType
    :ivar time_period: Has time period for pulling data for the export.
    :vartype time_period: ~azure.mgmt.costmanagement.models.ExportTimePeriod
    :ivar data_set: The definition for data in the export.
    :vartype data_set: ~azure.mgmt.costmanagement.models.ExportDataset
    """

    _validation = {
        "type": {"required": True},
        "timeframe": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "timeframe": {"key": "timeframe", "type": "str"},
        "time_period": {"key": "timePeriod", "type": "ExportTimePeriod"},
        "data_set": {"key": "dataSet", "type": "ExportDataset"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ExportType"],
        timeframe: Union[str, "_models.TimeframeType"],
        time_period: Optional["_models.ExportTimePeriod"] = None,
        data_set: Optional["_models.ExportDataset"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is
         applicable to exports that do not yet provide data for charges or amortization for service
         reservations. Required. Known values are: "Usage", "ActualCost", and "AmortizedCost".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.ExportType
        :keyword timeframe: The time frame for pulling data for the export. If custom, then a specific
         time period must be provided. Required. Known values are: "MonthToDate", "BillingMonthToDate",
         "TheLastMonth", "TheLastBillingMonth", "WeekToDate", and "Custom".
        :paramtype timeframe: str or ~azure.mgmt.costmanagement.models.TimeframeType
        :keyword time_period: Has time period for pulling data for the export.
        :paramtype time_period: ~azure.mgmt.costmanagement.models.ExportTimePeriod
        :keyword data_set: The definition for data in the export.
        :paramtype data_set: ~azure.mgmt.costmanagement.models.ExportDataset
        """
        super().__init__(**kwargs)
        self.type = type
        self.timeframe = timeframe
        self.time_period = time_period
        self.data_set = data_set


class ExportDeliveryDestination(_serialization.Model):
    """This represents the blob storage account location where exports of costs will be delivered.
    There are two ways to configure the destination. The approach recommended for most customers is
    to specify the resourceId of the storage account. This requires a one-time registration of the
    account's subscription with the Microsoft.CostManagementExports resource provider in order to
    give Cost Management services access to the storage. When creating an export in the Azure
    portal this registration is performed automatically but API users may need to register the
    subscription explicitly (for more information see
    https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services
    ). Another way to configure the destination is available ONLY to Partners with a Microsoft
    Partner Agreement plan who are global admins of their billing account. These Partners, instead
    of specifying the resourceId of a storage account, can specify the storage account name along
    with a SAS token for the account. This allows exports of costs to a storage account in any
    tenant. The SAS token should be created for the blob service with Service/Container/Object
    resource types and with Read/Write/Delete/List/Add/Create permissions (for more information see
    https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key
    ).

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The resource id of the storage account where exports will be delivered. This
     is not required if a sasToken and storageAccount are specified.
    :vartype resource_id: str
    :ivar container: The name of the container where exports will be uploaded. If the container
     does not exist it will be created. Required.
    :vartype container: str
    :ivar root_folder_path: The name of the directory where exports will be uploaded.
    :vartype root_folder_path: str
    :ivar sas_token: A SAS token for the storage account. For a restricted set of Azure customers
     this together with storageAccount can be specified instead of resourceId. Note: the value
     returned by the API for this property will always be obfuscated. Returning this same obfuscated
     value will not result in the SAS token being updated. To update this value a new SAS token must
     be specified.
    :vartype sas_token: str
    :ivar storage_account: The storage account where exports will be uploaded. For a restricted set
     of Azure customers this together with sasToken can be specified instead of resourceId.
    :vartype storage_account: str
    """

    _validation = {
        "container": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "container": {"key": "container", "type": "str"},
        "root_folder_path": {"key": "rootFolderPath", "type": "str"},
        "sas_token": {"key": "sasToken", "type": "str"},
        "storage_account": {"key": "storageAccount", "type": "str"},
    }

    def __init__(
        self,
        *,
        container: str,
        resource_id: Optional[str] = None,
        root_folder_path: Optional[str] = None,
        sas_token: Optional[str] = None,
        storage_account: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource id of the storage account where exports will be delivered.
         This is not required if a sasToken and storageAccount are specified.
        :paramtype resource_id: str
        :keyword container: The name of the container where exports will be uploaded. If the container
         does not exist it will be created. Required.
        :paramtype container: str
        :keyword root_folder_path: The name of the directory where exports will be uploaded.
        :paramtype root_folder_path: str
        :keyword sas_token: A SAS token for the storage account. For a restricted set of Azure
         customers this together with storageAccount can be specified instead of resourceId. Note: the
         value returned by the API for this property will always be obfuscated. Returning this same
         obfuscated value will not result in the SAS token being updated. To update this value a new SAS
         token must be specified.
        :paramtype sas_token: str
        :keyword storage_account: The storage account where exports will be uploaded. For a restricted
         set of Azure customers this together with sasToken can be specified instead of resourceId.
        :paramtype storage_account: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.container = container
        self.root_folder_path = root_folder_path
        self.sas_token = sas_token
        self.storage_account = storage_account


class ExportDeliveryInfo(_serialization.Model):
    """The delivery information associated with a export.

    All required parameters must be populated in order to send to Azure.

    :ivar destination: Has destination for the export being delivered. Required.
    :vartype destination: ~azure.mgmt.costmanagement.models.ExportDeliveryDestination
    """

    _validation = {
        "destination": {"required": True},
    }

    _attribute_map = {
        "destination": {"key": "destination", "type": "ExportDeliveryDestination"},
    }

    def __init__(self, *, destination: "_models.ExportDeliveryDestination", **kwargs: Any) -> None:
        """
        :keyword destination: Has destination for the export being delivered. Required.
        :paramtype destination: ~azure.mgmt.costmanagement.models.ExportDeliveryDestination
        """
        super().__init__(**kwargs)
        self.destination = destination


class ExportExecutionListResult(_serialization.Model):
    """Result of listing the run history of an export.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of export runs.
    :vartype value: list[~azure.mgmt.costmanagement.models.ExportRun]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExportRun]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class ExportListResult(_serialization.Model):
    """Result of listing exports. It contains a list of available exports in the scope provided.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of exports.
    :vartype value: list[~azure.mgmt.costmanagement.models.Export]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Export]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class ExportProperties(CommonExportProperties):
    """The properties of the export.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar format: The format of the export being delivered. Currently only 'Csv' is supported.
     "Csv"
    :vartype format: str or ~azure.mgmt.costmanagement.models.FormatType
    :ivar delivery_info: Has delivery information for the export. Required.
    :vartype delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
    :ivar definition: Has the definition for the export. Required.
    :vartype definition: ~azure.mgmt.costmanagement.models.ExportDefinition
    :ivar run_history: If requested, has the most recent run history for the export.
    :vartype run_history: ~azure.mgmt.costmanagement.models.ExportExecutionListResult
    :ivar partition_data: If set to true, exported data will be partitioned by size and placed in a
     blob directory together with a manifest file. Note: this option is currently available only for
     Microsoft Customer Agreement commerce scopes.
    :vartype partition_data: bool
    :ivar next_run_time_estimate: If the export has an active schedule, provides an estimate of the
     next run time.
    :vartype next_run_time_estimate: ~datetime.datetime
    :ivar schedule: Has schedule information for the export.
    :vartype schedule: ~azure.mgmt.costmanagement.models.ExportSchedule
    """

    _validation = {
        "delivery_info": {"required": True},
        "definition": {"required": True},
        "next_run_time_estimate": {"readonly": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "delivery_info": {"key": "deliveryInfo", "type": "ExportDeliveryInfo"},
        "definition": {"key": "definition", "type": "ExportDefinition"},
        "run_history": {"key": "runHistory", "type": "ExportExecutionListResult"},
        "partition_data": {"key": "partitionData", "type": "bool"},
        "next_run_time_estimate": {"key": "nextRunTimeEstimate", "type": "iso-8601"},
        "schedule": {"key": "schedule", "type": "ExportSchedule"},
    }

    def __init__(
        self,
        *,
        delivery_info: "_models.ExportDeliveryInfo",
        definition: "_models.ExportDefinition",
        format: Optional[Union[str, "_models.FormatType"]] = None,
        run_history: Optional["_models.ExportExecutionListResult"] = None,
        partition_data: Optional[bool] = None,
        schedule: Optional["_models.ExportSchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword format: The format of the export being delivered. Currently only 'Csv' is supported.
         "Csv"
        :paramtype format: str or ~azure.mgmt.costmanagement.models.FormatType
        :keyword delivery_info: Has delivery information for the export. Required.
        :paramtype delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
        :keyword definition: Has the definition for the export. Required.
        :paramtype definition: ~azure.mgmt.costmanagement.models.ExportDefinition
        :keyword run_history: If requested, has the most recent run history for the export.
        :paramtype run_history: ~azure.mgmt.costmanagement.models.ExportExecutionListResult
        :keyword partition_data: If set to true, exported data will be partitioned by size and placed
         in a blob directory together with a manifest file. Note: this option is currently available
         only for Microsoft Customer Agreement commerce scopes.
        :paramtype partition_data: bool
        :keyword schedule: Has schedule information for the export.
        :paramtype schedule: ~azure.mgmt.costmanagement.models.ExportSchedule
        """
        super().__init__(
            format=format,
            delivery_info=delivery_info,
            definition=definition,
            run_history=run_history,
            partition_data=partition_data,
            **kwargs
        )
        self.schedule = schedule


class ExportRecurrencePeriod(_serialization.Model):
    """The start and end date for recurrence schedule.

    All required parameters must be populated in order to send to Azure.

    :ivar from_property: The start date of recurrence. Required.
    :vartype from_property: ~datetime.datetime
    :ivar to: The end date of recurrence.
    :vartype to: ~datetime.datetime
    """

    _validation = {
        "from_property": {"required": True},
    }

    _attribute_map = {
        "from_property": {"key": "from", "type": "iso-8601"},
        "to": {"key": "to", "type": "iso-8601"},
    }

    def __init__(
        self, *, from_property: datetime.datetime, to: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword from_property: The start date of recurrence. Required.
        :paramtype from_property: ~datetime.datetime
        :keyword to: The end date of recurrence.
        :paramtype to: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class ExportRun(CostManagementProxyResource):  # pylint: disable=too-many-instance-attributes
    """An export run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :vartype e_tag: str
    :ivar execution_type: The type of the export run. Known values are: "OnDemand" and "Scheduled".
    :vartype execution_type: str or ~azure.mgmt.costmanagement.models.ExecutionType
    :ivar status: The last known status of the export run. Known values are: "Queued",
     "InProgress", "Completed", "Failed", "Timeout", "NewDataNotAvailable", and "DataNotAvailable".
    :vartype status: str or ~azure.mgmt.costmanagement.models.ExecutionStatus
    :ivar submitted_by: The identifier for the entity that triggered the export. For on-demand runs
     it is the user email. For scheduled runs it is 'System'.
    :vartype submitted_by: str
    :ivar submitted_time: The time when export was queued to be run.
    :vartype submitted_time: ~datetime.datetime
    :ivar processing_start_time: The time when export was picked up to be run.
    :vartype processing_start_time: ~datetime.datetime
    :ivar processing_end_time: The time when the export run finished.
    :vartype processing_end_time: ~datetime.datetime
    :ivar file_name: The name of the exported file.
    :vartype file_name: str
    :ivar run_settings: The export settings that were in effect for this run.
    :vartype run_settings: ~azure.mgmt.costmanagement.models.CommonExportProperties
    :ivar error: The details of any error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetails
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "execution_type": {"key": "properties.executionType", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "submitted_by": {"key": "properties.submittedBy", "type": "str"},
        "submitted_time": {"key": "properties.submittedTime", "type": "iso-8601"},
        "processing_start_time": {"key": "properties.processingStartTime", "type": "iso-8601"},
        "processing_end_time": {"key": "properties.processingEndTime", "type": "iso-8601"},
        "file_name": {"key": "properties.fileName", "type": "str"},
        "run_settings": {"key": "properties.runSettings", "type": "CommonExportProperties"},
        "error": {"key": "properties.error", "type": "ErrorDetails"},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        execution_type: Optional[Union[str, "_models.ExecutionType"]] = None,
        status: Optional[Union[str, "_models.ExecutionStatus"]] = None,
        submitted_by: Optional[str] = None,
        submitted_time: Optional[datetime.datetime] = None,
        processing_start_time: Optional[datetime.datetime] = None,
        processing_end_time: Optional[datetime.datetime] = None,
        file_name: Optional[str] = None,
        run_settings: Optional["_models.CommonExportProperties"] = None,
        error: Optional["_models.ErrorDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
         used to determine whether the user is updating the latest version or not.
        :paramtype e_tag: str
        :keyword execution_type: The type of the export run. Known values are: "OnDemand" and
         "Scheduled".
        :paramtype execution_type: str or ~azure.mgmt.costmanagement.models.ExecutionType
        :keyword status: The last known status of the export run. Known values are: "Queued",
         "InProgress", "Completed", "Failed", "Timeout", "NewDataNotAvailable", and "DataNotAvailable".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.ExecutionStatus
        :keyword submitted_by: The identifier for the entity that triggered the export. For on-demand
         runs it is the user email. For scheduled runs it is 'System'.
        :paramtype submitted_by: str
        :keyword submitted_time: The time when export was queued to be run.
        :paramtype submitted_time: ~datetime.datetime
        :keyword processing_start_time: The time when export was picked up to be run.
        :paramtype processing_start_time: ~datetime.datetime
        :keyword processing_end_time: The time when the export run finished.
        :paramtype processing_end_time: ~datetime.datetime
        :keyword file_name: The name of the exported file.
        :paramtype file_name: str
        :keyword run_settings: The export settings that were in effect for this run.
        :paramtype run_settings: ~azure.mgmt.costmanagement.models.CommonExportProperties
        :keyword error: The details of any error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetails
        """
        super().__init__(e_tag=e_tag, **kwargs)
        self.execution_type = execution_type
        self.status = status
        self.submitted_by = submitted_by
        self.submitted_time = submitted_time
        self.processing_start_time = processing_start_time
        self.processing_end_time = processing_end_time
        self.file_name = file_name
        self.run_settings = run_settings
        self.error = error


class ExportSchedule(_serialization.Model):
    """The schedule associated with the export.

    :ivar status: The status of the export's schedule. If 'Inactive', the export's schedule is
     paused. Known values are: "Active" and "Inactive".
    :vartype status: str or ~azure.mgmt.costmanagement.models.StatusType
    :ivar recurrence: The schedule recurrence. Known values are: "Daily", "Weekly", "Monthly", and
     "Annually".
    :vartype recurrence: str or ~azure.mgmt.costmanagement.models.RecurrenceType
    :ivar recurrence_period: Has start and end date of the recurrence. The start date must be in
     future. If present, the end date must be greater than start date.
    :vartype recurrence_period: ~azure.mgmt.costmanagement.models.ExportRecurrencePeriod
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "recurrence": {"key": "recurrence", "type": "str"},
        "recurrence_period": {"key": "recurrencePeriod", "type": "ExportRecurrencePeriod"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.StatusType"]] = None,
        recurrence: Optional[Union[str, "_models.RecurrenceType"]] = None,
        recurrence_period: Optional["_models.ExportRecurrencePeriod"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the export's schedule. If 'Inactive', the export's schedule is
         paused. Known values are: "Active" and "Inactive".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.StatusType
        :keyword recurrence: The schedule recurrence. Known values are: "Daily", "Weekly", "Monthly",
         and "Annually".
        :paramtype recurrence: str or ~azure.mgmt.costmanagement.models.RecurrenceType
        :keyword recurrence_period: Has start and end date of the recurrence. The start date must be in
         future. If present, the end date must be greater than start date.
        :paramtype recurrence_period: ~azure.mgmt.costmanagement.models.ExportRecurrencePeriod
        """
        super().__init__(**kwargs)
        self.status = status
        self.recurrence = recurrence
        self.recurrence_period = recurrence_period


class ExportTimePeriod(_serialization.Model):
    """The date range for data in the export. This should only be specified with timeFrame set to
    'Custom'. The maximum date range is 3 months.

    All required parameters must be populated in order to send to Azure.

    :ivar from_property: The start date for export data. Required.
    :vartype from_property: ~datetime.datetime
    :ivar to: The end date for export data. Required.
    :vartype to: ~datetime.datetime
    """

    _validation = {
        "from_property": {"required": True},
        "to": {"required": True},
    }

    _attribute_map = {
        "from_property": {"key": "from", "type": "iso-8601"},
        "to": {"key": "to", "type": "iso-8601"},
    }

    def __init__(self, *, from_property: datetime.datetime, to: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword from_property: The start date for export data. Required.
        :paramtype from_property: ~datetime.datetime
        :keyword to: The end date for export data. Required.
        :paramtype to: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class FileDestination(_serialization.Model):
    """Destination of the view data. This is optional. Currently only CSV format is supported.

    :ivar file_formats: Destination of the view data. Currently only CSV format is supported.
    :vartype file_formats: list[str or ~azure.mgmt.costmanagement.models.FileFormat]
    """

    _attribute_map = {
        "file_formats": {"key": "fileFormats", "type": "[str]"},
    }

    def __init__(self, *, file_formats: Optional[List[Union[str, "_models.FileFormat"]]] = None, **kwargs: Any) -> None:
        """
        :keyword file_formats: Destination of the view data. Currently only CSV format is supported.
        :paramtype file_formats: list[str or ~azure.mgmt.costmanagement.models.FileFormat]
        """
        super().__init__(**kwargs)
        self.file_formats = file_formats


class ForecastAggregation(_serialization.Model):
    """The aggregation expression to be used in the forecast.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the column to aggregate. Required. Known values are: "PreTaxCostUSD",
     "Cost", "CostUSD", and "PreTaxCost".
    :vartype name: str or ~azure.mgmt.costmanagement.models.FunctionName
    :ivar function: The name of the aggregation function to use. Required. "Sum"
    :vartype function: str or ~azure.mgmt.costmanagement.models.FunctionType
    """

    _validation = {
        "name": {"required": True},
        "function": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "function": {"key": "function", "type": "str"},
    }

    def __init__(
        self, *, name: Union[str, "_models.FunctionName"], function: Union[str, "_models.FunctionType"], **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the column to aggregate. Required. Known values are:
         "PreTaxCostUSD", "Cost", "CostUSD", and "PreTaxCost".
        :paramtype name: str or ~azure.mgmt.costmanagement.models.FunctionName
        :keyword function: The name of the aggregation function to use. Required. "Sum"
        :paramtype function: str or ~azure.mgmt.costmanagement.models.FunctionType
        """
        super().__init__(**kwargs)
        self.name = name
        self.function = function


class ForecastColumn(_serialization.Model):
    """Forecast column properties.

    :ivar name: The name of column.
    :vartype name: str
    :ivar type: The type of column.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of column.
        :paramtype name: str
        :keyword type: The type of column.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class ForecastComparisonExpression(_serialization.Model):
    """The comparison expression to be used in the forecast.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the column to use in comparison. Required.
    :vartype name: str
    :ivar operator: The operator to use for comparison. Required. Known values are: "In" and "In".
    :vartype operator: str or ~azure.mgmt.costmanagement.models.ForecastOperatorType
    :ivar values: Array of values to use for comparison. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(
        self, *, name: str, operator: Union[str, "_models.ForecastOperatorType"], values: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the column to use in comparison. Required.
        :paramtype name: str
        :keyword operator: The operator to use for comparison. Required. Known values are: "In" and
         "In".
        :paramtype operator: str or ~azure.mgmt.costmanagement.models.ForecastOperatorType
        :keyword values: Array of values to use for comparison. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class ForecastDataset(_serialization.Model):
    """The definition of data present in the forecast.

    All required parameters must be populated in order to send to Azure.

    :ivar granularity: The granularity of rows in the forecast. "Daily"
    :vartype granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
    :ivar configuration: Has configuration information for the data in the export. The
     configuration will be ignored if aggregation and grouping are provided.
    :vartype configuration: ~azure.mgmt.costmanagement.models.ForecastDatasetConfiguration
    :ivar aggregation: Dictionary of aggregation expression to use in the forecast. The key of each
     item in the dictionary is the alias for the aggregated column. forecast can have up to 2
     aggregation clauses. Required.
    :vartype aggregation: dict[str, ~azure.mgmt.costmanagement.models.ForecastAggregation]
    :ivar filter: Has filter expression to use in the forecast.
    :vartype filter: ~azure.mgmt.costmanagement.models.ForecastFilter
    """

    _validation = {
        "aggregation": {"required": True},
    }

    _attribute_map = {
        "granularity": {"key": "granularity", "type": "str"},
        "configuration": {"key": "configuration", "type": "ForecastDatasetConfiguration"},
        "aggregation": {"key": "aggregation", "type": "{ForecastAggregation}"},
        "filter": {"key": "filter", "type": "ForecastFilter"},
    }

    def __init__(
        self,
        *,
        aggregation: Dict[str, "_models.ForecastAggregation"],
        granularity: Optional[Union[str, "_models.GranularityType"]] = None,
        configuration: Optional["_models.ForecastDatasetConfiguration"] = None,
        filter: Optional["_models.ForecastFilter"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword granularity: The granularity of rows in the forecast. "Daily"
        :paramtype granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
        :keyword configuration: Has configuration information for the data in the export. The
         configuration will be ignored if aggregation and grouping are provided.
        :paramtype configuration: ~azure.mgmt.costmanagement.models.ForecastDatasetConfiguration
        :keyword aggregation: Dictionary of aggregation expression to use in the forecast. The key of
         each item in the dictionary is the alias for the aggregated column. forecast can have up to 2
         aggregation clauses. Required.
        :paramtype aggregation: dict[str, ~azure.mgmt.costmanagement.models.ForecastAggregation]
        :keyword filter: Has filter expression to use in the forecast.
        :paramtype filter: ~azure.mgmt.costmanagement.models.ForecastFilter
        """
        super().__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration
        self.aggregation = aggregation
        self.filter = filter


class ForecastDatasetConfiguration(_serialization.Model):
    """The configuration of dataset in the forecast.

    :ivar columns: Array of column names to be included in the forecast. Any valid forecast column
     name is allowed. If not provided, then forecast includes all columns.
    :vartype columns: list[str]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[str]"},
    }

    def __init__(self, *, columns: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword columns: Array of column names to be included in the forecast. Any valid forecast
         column name is allowed. If not provided, then forecast includes all columns.
        :paramtype columns: list[str]
        """
        super().__init__(**kwargs)
        self.columns = columns


class ForecastDefinition(_serialization.Model):
    """The definition of a forecast.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the forecast. Required. Known values are: "Usage", "ActualCost", and
     "AmortizedCost".
    :vartype type: str or ~azure.mgmt.costmanagement.models.ForecastType
    :ivar timeframe: The time frame for pulling data for the forecast. If custom, then a specific
     time period must be provided. Required. "Custom"
    :vartype timeframe: str or ~azure.mgmt.costmanagement.models.ForecastTimeframe
    :ivar time_period: Has time period for pulling data for the forecast.
    :vartype time_period: ~azure.mgmt.costmanagement.models.ForecastTimePeriod
    :ivar dataset: Has definition for data in this forecast. Required.
    :vartype dataset: ~azure.mgmt.costmanagement.models.ForecastDataset
    :ivar include_actual_cost: A boolean determining if actualCost will be included.
    :vartype include_actual_cost: bool
    :ivar include_fresh_partial_cost: A boolean determining if FreshPartialCost will be included.
    :vartype include_fresh_partial_cost: bool
    """

    _validation = {
        "type": {"required": True},
        "timeframe": {"required": True},
        "dataset": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "timeframe": {"key": "timeframe", "type": "str"},
        "time_period": {"key": "timePeriod", "type": "ForecastTimePeriod"},
        "dataset": {"key": "dataset", "type": "ForecastDataset"},
        "include_actual_cost": {"key": "includeActualCost", "type": "bool"},
        "include_fresh_partial_cost": {"key": "includeFreshPartialCost", "type": "bool"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ForecastType"],
        timeframe: Union[str, "_models.ForecastTimeframe"],
        dataset: "_models.ForecastDataset",
        time_period: Optional["_models.ForecastTimePeriod"] = None,
        include_actual_cost: Optional[bool] = None,
        include_fresh_partial_cost: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the forecast. Required. Known values are: "Usage", "ActualCost", and
         "AmortizedCost".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.ForecastType
        :keyword timeframe: The time frame for pulling data for the forecast. If custom, then a
         specific time period must be provided. Required. "Custom"
        :paramtype timeframe: str or ~azure.mgmt.costmanagement.models.ForecastTimeframe
        :keyword time_period: Has time period for pulling data for the forecast.
        :paramtype time_period: ~azure.mgmt.costmanagement.models.ForecastTimePeriod
        :keyword dataset: Has definition for data in this forecast. Required.
        :paramtype dataset: ~azure.mgmt.costmanagement.models.ForecastDataset
        :keyword include_actual_cost: A boolean determining if actualCost will be included.
        :paramtype include_actual_cost: bool
        :keyword include_fresh_partial_cost: A boolean determining if FreshPartialCost will be
         included.
        :paramtype include_fresh_partial_cost: bool
        """
        super().__init__(**kwargs)
        self.type = type
        self.timeframe = timeframe
        self.time_period = time_period
        self.dataset = dataset
        self.include_actual_cost = include_actual_cost
        self.include_fresh_partial_cost = include_fresh_partial_cost


class ForecastFilter(_serialization.Model):
    """The filter expression to be used in the export.

    :ivar and_property: The logical "AND" expression. Must have at least 2 items.
    :vartype and_property: list[~azure.mgmt.costmanagement.models.ForecastFilter]
    :ivar or_property: The logical "OR" expression. Must have at least 2 items.
    :vartype or_property: list[~azure.mgmt.costmanagement.models.ForecastFilter]
    :ivar dimensions: Has comparison expression for a dimension.
    :vartype dimensions: ~azure.mgmt.costmanagement.models.ForecastComparisonExpression
    :ivar tags: Has comparison expression for a tag.
    :vartype tags: ~azure.mgmt.costmanagement.models.ForecastComparisonExpression
    """

    _validation = {
        "and_property": {"min_items": 2},
        "or_property": {"min_items": 2},
    }

    _attribute_map = {
        "and_property": {"key": "and", "type": "[ForecastFilter]"},
        "or_property": {"key": "or", "type": "[ForecastFilter]"},
        "dimensions": {"key": "dimensions", "type": "ForecastComparisonExpression"},
        "tags": {"key": "tags", "type": "ForecastComparisonExpression"},
    }

    def __init__(
        self,
        *,
        and_property: Optional[List["_models.ForecastFilter"]] = None,
        or_property: Optional[List["_models.ForecastFilter"]] = None,
        dimensions: Optional["_models.ForecastComparisonExpression"] = None,
        tags: Optional["_models.ForecastComparisonExpression"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword and_property: The logical "AND" expression. Must have at least 2 items.
        :paramtype and_property: list[~azure.mgmt.costmanagement.models.ForecastFilter]
        :keyword or_property: The logical "OR" expression. Must have at least 2 items.
        :paramtype or_property: list[~azure.mgmt.costmanagement.models.ForecastFilter]
        :keyword dimensions: Has comparison expression for a dimension.
        :paramtype dimensions: ~azure.mgmt.costmanagement.models.ForecastComparisonExpression
        :keyword tags: Has comparison expression for a tag.
        :paramtype tags: ~azure.mgmt.costmanagement.models.ForecastComparisonExpression
        """
        super().__init__(**kwargs)
        self.and_property = and_property
        self.or_property = or_property
        self.dimensions = dimensions
        self.tags = tags


class ForecastResult(CostManagementResource):
    """Result of forecast. It contains all columns listed under groupings and aggregation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar sku: SKU of the resource.
    :vartype sku: str
    :ivar e_tag: ETag of the resource.
    :vartype e_tag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    :ivar columns: Array of columns.
    :vartype columns: list[~azure.mgmt.costmanagement.models.ForecastColumn]
    :ivar rows: Array of rows.
    :vartype rows: list[list[any]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "sku": {"readonly": True},
        "e_tag": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "next_link": {"key": "properties.nextLink", "type": "str"},
        "columns": {"key": "properties.columns", "type": "[ForecastColumn]"},
        "rows": {"key": "properties.rows", "type": "[[object]]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        columns: Optional[List["_models.ForecastColumn"]] = None,
        rows: Optional[List[List[Any]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link (url) to the next page of results.
        :paramtype next_link: str
        :keyword columns: Array of columns.
        :paramtype columns: list[~azure.mgmt.costmanagement.models.ForecastColumn]
        :keyword rows: Array of rows.
        :paramtype rows: list[list[any]]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.columns = columns
        self.rows = rows


class ForecastTimePeriod(_serialization.Model):
    """Has time period for pulling data for the forecast.

    All required parameters must be populated in order to send to Azure.

    :ivar from_property: The start date to pull data from. Required.
    :vartype from_property: ~datetime.datetime
    :ivar to: The end date to pull data to. Required.
    :vartype to: ~datetime.datetime
    """

    _validation = {
        "from_property": {"required": True},
        "to": {"required": True},
    }

    _attribute_map = {
        "from_property": {"key": "from", "type": "iso-8601"},
        "to": {"key": "to", "type": "iso-8601"},
    }

    def __init__(self, *, from_property: datetime.datetime, to: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword from_property: The start date to pull data from. Required.
        :paramtype from_property: ~datetime.datetime
        :keyword to: The end date to pull data to. Required.
        :paramtype to: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class GenerateCostDetailsReportErrorResponse(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The
    reason is provided in the error message.

    Some Error responses:


    *
      400 Bad Request - Invalid Request Payload. Request payload provided is not in a json format
    or had an invalid member not accepted in the request payload.

    *
      400 Bad Request - Invalid request payload:  can only have either timePeriod or invoiceId or
    billingPeriod. API only allows data to be pulled for either timePeriod or invoiceId or
    billingPeriod. Customer should provide only one of these parameters.

    *
      400 Bad Request - Start date must be after . API only allows data to be pulled no older than
    13 months from now.

    *
      400 Bad Request - The maximum allowed date range is 1 months. API only allows data to be
    pulled for 1 month or less.

    *
      429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the
    "retry-after" header.

    *
      503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time
    specified in the "Retry-After" header.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class GenerateCostDetailsReportRequestDefinition(_serialization.Model):
    """The definition of a cost detailed report.

    :ivar metric: The type of the detailed report. By default ActualCost is provided. Known values
     are: "ActualCost" and "AmortizedCost".
    :vartype metric: str or ~azure.mgmt.costmanagement.models.CostDetailsMetricType
    :ivar time_period: The specific date range of cost details requested for the report. This
     parameter cannot be used alongside either the invoiceId or billingPeriod parameters. If a
     timePeriod, invoiceId or billingPeriod parameter is not provided in the request body the API
     will return the current month's cost. API only allows data to be pulled for 1 month or less and
     no older than 13 months. If no timePeriod or billingPeriod or invoiceId is provided the API
     defaults to the open month time period.
    :vartype time_period: ~azure.mgmt.costmanagement.models.CostDetailsTimePeriod
    :ivar billing_period: This parameter can be used only by Enterprise Agreement customers. Use
     the YearMonth(e.g. 202008) format. This parameter cannot be used alongside either the invoiceId
     or timePeriod parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided
     in the request body the API will return the current month's cost.
    :vartype billing_period: str
    :ivar invoice_id: This parameter can only be used by Microsoft Customer Agreement customers.
     Additionally, it can only be used at the Billing Profile or Customer scope. This parameter
     cannot be used alongside either the billingPeriod or timePeriod parameters. If a timePeriod,
     invoiceId or billingPeriod parameter is not provided in the request body the API will return
     the current month's cost.
    :vartype invoice_id: str
    """

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "time_period": {"key": "timePeriod", "type": "CostDetailsTimePeriod"},
        "billing_period": {"key": "billingPeriod", "type": "str"},
        "invoice_id": {"key": "invoiceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Optional[Union[str, "_models.CostDetailsMetricType"]] = None,
        time_period: Optional["_models.CostDetailsTimePeriod"] = None,
        billing_period: Optional[str] = None,
        invoice_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric: The type of the detailed report. By default ActualCost is provided. Known
         values are: "ActualCost" and "AmortizedCost".
        :paramtype metric: str or ~azure.mgmt.costmanagement.models.CostDetailsMetricType
        :keyword time_period: The specific date range of cost details requested for the report. This
         parameter cannot be used alongside either the invoiceId or billingPeriod parameters. If a
         timePeriod, invoiceId or billingPeriod parameter is not provided in the request body the API
         will return the current month's cost. API only allows data to be pulled for 1 month or less and
         no older than 13 months. If no timePeriod or billingPeriod or invoiceId is provided the API
         defaults to the open month time period.
        :paramtype time_period: ~azure.mgmt.costmanagement.models.CostDetailsTimePeriod
        :keyword billing_period: This parameter can be used only by Enterprise Agreement customers. Use
         the YearMonth(e.g. 202008) format. This parameter cannot be used alongside either the invoiceId
         or timePeriod parameters. If a timePeriod, invoiceId or billingPeriod parameter is not provided
         in the request body the API will return the current month's cost.
        :paramtype billing_period: str
        :keyword invoice_id: This parameter can only be used by Microsoft Customer Agreement customers.
         Additionally, it can only be used at the Billing Profile or Customer scope. This parameter
         cannot be used alongside either the billingPeriod or timePeriod parameters. If a timePeriod,
         invoiceId or billingPeriod parameter is not provided in the request body the API will return
         the current month's cost.
        :paramtype invoice_id: str
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.time_period = time_period
        self.billing_period = billing_period
        self.invoice_id = invoice_id


class GenerateDetailedCostReportDefinition(_serialization.Model):
    """The definition of a cost detailed report.

    :ivar metric: The type of the detailed report. By default ActualCost is provided. Known values
     are: "ActualCost" and "AmortizedCost".
    :vartype metric: str or ~azure.mgmt.costmanagement.models.GenerateDetailedCostReportMetricType
    :ivar time_period: Has time period for pulling data for the cost detailed report. Can only have
     one of either timePeriod or invoiceId or billingPeriod parameters. If none provided current
     month cost is provided.
    :vartype time_period: ~azure.mgmt.costmanagement.models.GenerateDetailedCostReportTimePeriod
    :ivar billing_period: Billing period in YearMonth(e.g. 202008) format. Only for legacy
     enterprise customers can use this. Can only have one of either timePeriod or invoiceId or
     billingPeriod parameters. If none provided current month cost is provided.
    :vartype billing_period: str
    :ivar invoice_id: Invoice ID for Pay-as-you-go and Microsoft Customer Agreement scopes. Can
     only have one of either timePeriod or invoiceId or billingPeriod parameters. If none provided
     current month cost is provided.
    :vartype invoice_id: str
    :ivar customer_id: Customer ID for Microsoft Customer Agreement scopes (Invoice Id is also
     required for this).
    :vartype customer_id: str
    """

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "time_period": {"key": "timePeriod", "type": "GenerateDetailedCostReportTimePeriod"},
        "billing_period": {"key": "billingPeriod", "type": "str"},
        "invoice_id": {"key": "invoiceId", "type": "str"},
        "customer_id": {"key": "customerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Optional[Union[str, "_models.GenerateDetailedCostReportMetricType"]] = None,
        time_period: Optional["_models.GenerateDetailedCostReportTimePeriod"] = None,
        billing_period: Optional[str] = None,
        invoice_id: Optional[str] = None,
        customer_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric: The type of the detailed report. By default ActualCost is provided. Known
         values are: "ActualCost" and "AmortizedCost".
        :paramtype metric: str or
         ~azure.mgmt.costmanagement.models.GenerateDetailedCostReportMetricType
        :keyword time_period: Has time period for pulling data for the cost detailed report. Can only
         have one of either timePeriod or invoiceId or billingPeriod parameters. If none provided
         current month cost is provided.
        :paramtype time_period: ~azure.mgmt.costmanagement.models.GenerateDetailedCostReportTimePeriod
        :keyword billing_period: Billing period in YearMonth(e.g. 202008) format. Only for legacy
         enterprise customers can use this. Can only have one of either timePeriod or invoiceId or
         billingPeriod parameters. If none provided current month cost is provided.
        :paramtype billing_period: str
        :keyword invoice_id: Invoice ID for Pay-as-you-go and Microsoft Customer Agreement scopes. Can
         only have one of either timePeriod or invoiceId or billingPeriod parameters. If none provided
         current month cost is provided.
        :paramtype invoice_id: str
        :keyword customer_id: Customer ID for Microsoft Customer Agreement scopes (Invoice Id is also
         required for this).
        :paramtype customer_id: str
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.time_period = time_period
        self.billing_period = billing_period
        self.invoice_id = invoice_id
        self.customer_id = customer_id


class GenerateDetailedCostReportErrorResponse(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The
    reason is provided in the error message.

    Some Error responses:


    *
      413 Request Entity Too Large - Request is throttled. The amount of data required to fulfill
    the request exceeds the maximum size permitted of 2Gb. Please utilize our Exports feature
    instead.

    *
      429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the
    "x-ms-ratelimit-microsoft.consumption-retry-after" header.

    *
      503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time
    specified in the "Retry-After" header.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class GenerateDetailedCostReportOperationResult(_serialization.Model):
    """The result of the long running operation for cost detailed report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM resource id of the long running operation.
    :vartype id: str
    :ivar name: The name of the long running operation.
    :vartype name: str
    :ivar type: The type of the long running operation.
    :vartype type: str
    :ivar expiry_time: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype expiry_time: ~datetime.datetime
    :ivar valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype valid_till: ~datetime.datetime
    :ivar download_url: The URL to download the generated report.
    :vartype download_url: str
    """

    _validation = {
        "expiry_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "expiry_time": {"key": "properties.expiryTime", "type": "iso-8601"},
        "valid_till": {"key": "properties.validTill", "type": "iso-8601"},
        "download_url": {"key": "properties.downloadUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        valid_till: Optional[datetime.datetime] = None,
        download_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ARM resource id of the long running operation.
        :paramtype id: str
        :keyword name: The name of the long running operation.
        :paramtype name: str
        :keyword type: The type of the long running operation.
        :paramtype type: str
        :keyword valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
         2020-12-08T05:55:59.4394737Z.
        :paramtype valid_till: ~datetime.datetime
        :keyword download_url: The URL to download the generated report.
        :paramtype download_url: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.expiry_time = None
        self.valid_till = valid_till
        self.download_url = download_url


class GenerateDetailedCostReportOperationStatuses(_serialization.Model):
    """The status of the long running operation for cost detailed report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the long running operation.
    :vartype id: str
    :ivar name: The name of the long running operation.
    :vartype name: str
    :ivar status: The status of the long running operation.
    :vartype status: ~azure.mgmt.costmanagement.models.Status
    :ivar start_time: The startTime of the operation.
    :vartype start_time: str
    :ivar end_time: The endTime of the operation.
    :vartype end_time: str
    :ivar type: The type of the long running operation.
    :vartype type: str
    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.costmanagement.models.ErrorDetails
    :ivar expiry_time: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype expiry_time: ~datetime.datetime
    :ivar valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
     2020-12-08T05:55:59.4394737Z.
    :vartype valid_till: ~datetime.datetime
    :ivar download_url: The URL to download the generated report.
    :vartype download_url: str
    """

    _validation = {
        "expiry_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "Status"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "error": {"key": "error", "type": "ErrorDetails"},
        "expiry_time": {"key": "properties.expiryTime", "type": "iso-8601"},
        "valid_till": {"key": "properties.validTill", "type": "iso-8601"},
        "download_url": {"key": "properties.downloadUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional["_models.Status"] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        type: Optional[str] = None,
        error: Optional["_models.ErrorDetails"] = None,
        valid_till: Optional[datetime.datetime] = None,
        download_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the long running operation.
        :paramtype id: str
        :keyword name: The name of the long running operation.
        :paramtype name: str
        :keyword status: The status of the long running operation.
        :paramtype status: ~azure.mgmt.costmanagement.models.Status
        :keyword start_time: The startTime of the operation.
        :paramtype start_time: str
        :keyword end_time: The endTime of the operation.
        :paramtype end_time: str
        :keyword type: The type of the long running operation.
        :paramtype type: str
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.costmanagement.models.ErrorDetails
        :keyword valid_till: The time at which report URL becomes invalid/expires in UTC e.g.
         2020-12-08T05:55:59.4394737Z.
        :paramtype valid_till: ~datetime.datetime
        :keyword download_url: The URL to download the generated report.
        :paramtype download_url: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.type = type
        self.error = error
        self.expiry_time = None
        self.valid_till = valid_till
        self.download_url = download_url


class GenerateDetailedCostReportTimePeriod(_serialization.Model):
    """The start and end date for pulling data for the cost detailed report.

    All required parameters must be populated in order to send to Azure.

    :ivar start: The start date to pull data from. example format 2020-03-15. Required.
    :vartype start: str
    :ivar end: The end date to pull data to. example format 2020-03-15. Required.
    :vartype end: str
    """

    _validation = {
        "start": {"required": True},
        "end": {"required": True},
    }

    _attribute_map = {
        "start": {"key": "start", "type": "str"},
        "end": {"key": "end", "type": "str"},
    }

    def __init__(self, *, start: str, end: str, **kwargs: Any) -> None:
        """
        :keyword start: The start date to pull data from. example format 2020-03-15. Required.
        :paramtype start: str
        :keyword end: The end date to pull data to. example format 2020-03-15. Required.
        :paramtype end: str
        """
        super().__init__(**kwargs)
        self.start = start
        self.end = end


class IncludedQuantityUtilizationSummary(BenefitUtilizationSummary):
    """Included Quantity utilization summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Supported values: 'SavingsPlan'. Required. Known values are: "IncludedQuantity",
     "Reservation", and "SavingsPlan".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar arm_sku_name: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
    :vartype arm_sku_name: str
    :ivar benefit_id: The benefit ID is the identifier of the benefit.
    :vartype benefit_id: str
    :ivar benefit_order_id: The benefit order ID is the identifier for a benefit purchase.
    :vartype benefit_order_id: str
    :ivar benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
     "IncludedQuantity", "Reservation", and "SavingsPlan".
    :vartype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar usage_date: Date corresponding to the utilization summary record. If the grain of data is
     monthly, value for this field will be first day of the month.
    :vartype usage_date: ~datetime.datetime
    :ivar utilization_percentage: This is the utilized percentage for the benefit ID.
    :vartype utilization_percentage: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "arm_sku_name": {"readonly": True},
        "benefit_id": {"readonly": True},
        "benefit_order_id": {"readonly": True},
        "usage_date": {"readonly": True},
        "utilization_percentage": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "arm_sku_name": {"key": "properties.armSkuName", "type": "str"},
        "benefit_id": {"key": "properties.benefitId", "type": "str"},
        "benefit_order_id": {"key": "properties.benefitOrderId", "type": "str"},
        "benefit_type": {"key": "properties.benefitType", "type": "str"},
        "usage_date": {"key": "properties.usageDate", "type": "iso-8601"},
        "utilization_percentage": {"key": "properties.utilizationPercentage", "type": "float"},
    }

    def __init__(self, *, benefit_type: Optional[Union[str, "_models.BenefitKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
         "IncludedQuantity", "Reservation", and "SavingsPlan".
        :paramtype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
        """
        super().__init__(**kwargs)
        self.kind: str = "IncludedQuantity"
        self.arm_sku_name = None
        self.benefit_id = None
        self.benefit_order_id = None
        self.benefit_type = benefit_type
        self.usage_date = None
        self.utilization_percentage = None


class IncludedQuantityUtilizationSummaryProperties(BenefitUtilizationSummaryProperties):
    """Included Quantity utilization summary properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar arm_sku_name: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
    :vartype arm_sku_name: str
    :ivar benefit_id: The benefit ID is the identifier of the benefit.
    :vartype benefit_id: str
    :ivar benefit_order_id: The benefit order ID is the identifier for a benefit purchase.
    :vartype benefit_order_id: str
    :ivar benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
     "IncludedQuantity", "Reservation", and "SavingsPlan".
    :vartype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar usage_date: Date corresponding to the utilization summary record. If the grain of data is
     monthly, value for this field will be first day of the month.
    :vartype usage_date: ~datetime.datetime
    :ivar utilization_percentage: This is the utilized percentage for the benefit ID.
    :vartype utilization_percentage: float
    """

    _validation = {
        "arm_sku_name": {"readonly": True},
        "benefit_id": {"readonly": True},
        "benefit_order_id": {"readonly": True},
        "usage_date": {"readonly": True},
        "utilization_percentage": {"readonly": True},
    }

    _attribute_map = {
        "arm_sku_name": {"key": "armSkuName", "type": "str"},
        "benefit_id": {"key": "benefitId", "type": "str"},
        "benefit_order_id": {"key": "benefitOrderId", "type": "str"},
        "benefit_type": {"key": "benefitType", "type": "str"},
        "usage_date": {"key": "usageDate", "type": "iso-8601"},
        "utilization_percentage": {"key": "utilizationPercentage", "type": "float"},
    }

    def __init__(self, *, benefit_type: Optional[Union[str, "_models.BenefitKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
         "IncludedQuantity", "Reservation", and "SavingsPlan".
        :paramtype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
        """
        super().__init__(benefit_type=benefit_type, **kwargs)
        self.utilization_percentage = None


class KpiProperties(_serialization.Model):
    """Each KPI must contain a 'type' and 'enabled' key.

    :ivar type: KPI type (Forecast, Budget). Known values are: "Forecast" and "Budget".
    :vartype type: str or ~azure.mgmt.costmanagement.models.KpiType
    :ivar id: ID of resource related to metric (budget).
    :vartype id: str
    :ivar enabled: show the KPI in the UI?.
    :vartype enabled: bool
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.KpiType"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: KPI type (Forecast, Budget). Known values are: "Forecast" and "Budget".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.KpiType
        :keyword id: ID of resource related to metric (budget).
        :paramtype id: str
        :keyword enabled: show the KPI in the UI?.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.type = type
        self.id = id
        self.enabled = enabled


class NotificationProperties(_serialization.Model):
    """The properties of the scheduled action notification.

    All required parameters must be populated in order to send to Azure.

    :ivar to: Array of email addresses. Required.
    :vartype to: list[str]
    :ivar language: Locale of the email.
    :vartype language: str
    :ivar message: Optional message to be added in the email. Length is limited to 250 characters.
    :vartype message: str
    :ivar regional_format: Regional format used for formatting date/time and currency values in the
     email.
    :vartype regional_format: str
    :ivar subject: Subject of the email. Length is limited to 70 characters. Required.
    :vartype subject: str
    """

    _validation = {
        "to": {"required": True, "max_items": 20, "min_items": 1},
        "subject": {"required": True},
    }

    _attribute_map = {
        "to": {"key": "to", "type": "[str]"},
        "language": {"key": "language", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "regional_format": {"key": "regionalFormat", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
    }

    def __init__(
        self,
        *,
        to: List[str],
        subject: str,
        language: Optional[str] = None,
        message: Optional[str] = None,
        regional_format: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword to: Array of email addresses. Required.
        :paramtype to: list[str]
        :keyword language: Locale of the email.
        :paramtype language: str
        :keyword message: Optional message to be added in the email. Length is limited to 250
         characters.
        :paramtype message: str
        :keyword regional_format: Regional format used for formatting date/time and currency values in
         the email.
        :paramtype regional_format: str
        :keyword subject: Subject of the email. Length is limited to 70 characters. Required.
        :paramtype subject: str
        """
        super().__init__(**kwargs)
        self.to = to
        self.language = language
        self.message = message
        self.regional_format = regional_format
        self.subject = subject


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """Result of listing cost management operations. It contains a list of operations and a URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of cost management operations supported by the Microsoft.CostManagement
     resource provider.
    :vartype value: list[~azure.mgmt.costmanagement.models.CostManagementOperation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CostManagementOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatus(_serialization.Model):
    """The status of the long running operation.

    :ivar status: The status of the long running operation. Known values are: "Running",
     "Completed", and "Failed".
    :vartype status: str or ~azure.mgmt.costmanagement.models.OperationStatusType
    :ivar report_url: The CSV file from the reportUrl blob link consists of reservation usage data
     with the following schema at daily granularity. Known values are: "InstanceFlexibilityGroup",
     "InstanceFlexibilityRatio", "InstanceId", "Kind", "ReservationId", "ReservationOrderId",
     "ReservedHours", "SkuName", "TotalReservedQuantity", "UsageDate", and "UsedHours".
    :vartype report_url: str or ~azure.mgmt.costmanagement.models.ReservationReportSchema
    :ivar valid_until: The time at which report URL becomes invalid.
    :vartype valid_until: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "report_url": {"key": "properties.reportUrl", "type": "str"},
        "valid_until": {"key": "properties.validUntil", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.OperationStatusType"]] = None,
        report_url: Optional[Union[str, "_models.ReservationReportSchema"]] = None,
        valid_until: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the long running operation. Known values are: "Running",
         "Completed", and "Failed".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.OperationStatusType
        :keyword report_url: The CSV file from the reportUrl blob link consists of reservation usage
         data with the following schema at daily granularity. Known values are:
         "InstanceFlexibilityGroup", "InstanceFlexibilityRatio", "InstanceId", "Kind", "ReservationId",
         "ReservationOrderId", "ReservedHours", "SkuName", "TotalReservedQuantity", "UsageDate", and
         "UsedHours".
        :paramtype report_url: str or ~azure.mgmt.costmanagement.models.ReservationReportSchema
        :keyword valid_until: The time at which report URL becomes invalid.
        :paramtype valid_until: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.report_url = report_url
        self.valid_until = valid_until


class PivotProperties(_serialization.Model):
    """Each pivot must contain a 'type' and 'name'.

    :ivar type: Data type to show in view. Known values are: "Dimension" and "TagKey".
    :vartype type: str or ~azure.mgmt.costmanagement.models.PivotType
    :ivar name: Data field to show in view.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.PivotType"]] = None, name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: Data type to show in view. Known values are: "Dimension" and "TagKey".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.PivotType
        :keyword name: Data field to show in view.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class QueryAggregation(_serialization.Model):
    """The aggregation expression to be used in the query.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the column to aggregate. Required.
    :vartype name: str
    :ivar function: The name of the aggregation function to use. Required. "Sum"
    :vartype function: str or ~azure.mgmt.costmanagement.models.FunctionType
    """

    _validation = {
        "name": {"required": True},
        "function": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "function": {"key": "function", "type": "str"},
    }

    def __init__(self, *, name: str, function: Union[str, "_models.FunctionType"], **kwargs: Any) -> None:
        """
        :keyword name: The name of the column to aggregate. Required.
        :paramtype name: str
        :keyword function: The name of the aggregation function to use. Required. "Sum"
        :paramtype function: str or ~azure.mgmt.costmanagement.models.FunctionType
        """
        super().__init__(**kwargs)
        self.name = name
        self.function = function


class QueryColumn(_serialization.Model):
    """QueryColumn properties.

    :ivar name: The name of column.
    :vartype name: str
    :ivar type: The type of column.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of column.
        :paramtype name: str
        :keyword type: The type of column.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class QueryComparisonExpression(_serialization.Model):
    """The comparison expression to be used in the query.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the column to use in comparison. Required.
    :vartype name: str
    :ivar operator: The operator to use for comparison. Required. Known values are: "In" and "In".
    :vartype operator: str or ~azure.mgmt.costmanagement.models.QueryOperatorType
    :ivar values: Array of values to use for comparison. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(
        self, *, name: str, operator: Union[str, "_models.QueryOperatorType"], values: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the column to use in comparison. Required.
        :paramtype name: str
        :keyword operator: The operator to use for comparison. Required. Known values are: "In" and
         "In".
        :paramtype operator: str or ~azure.mgmt.costmanagement.models.QueryOperatorType
        :keyword values: Array of values to use for comparison. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class QueryDataset(_serialization.Model):
    """The definition of data present in the query.

    :ivar granularity: The granularity of rows in the query. "Daily"
    :vartype granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
    :ivar configuration: Has configuration information for the data in the export. The
     configuration will be ignored if aggregation and grouping are provided.
    :vartype configuration: ~azure.mgmt.costmanagement.models.QueryDatasetConfiguration
    :ivar aggregation: Dictionary of aggregation expression to use in the query. The key of each
     item in the dictionary is the alias for the aggregated column. Query can have up to 2
     aggregation clauses.
    :vartype aggregation: dict[str, ~azure.mgmt.costmanagement.models.QueryAggregation]
    :ivar grouping: Array of group by expression to use in the query. Query can have up to 2 group
     by clauses.
    :vartype grouping: list[~azure.mgmt.costmanagement.models.QueryGrouping]
    :ivar filter: The filter expression to use in the query. Please reference our Query API REST
     documentation for how to properly format the filter.
    :vartype filter: ~azure.mgmt.costmanagement.models.QueryFilter
    """

    _validation = {
        "grouping": {"max_items": 2, "min_items": 0},
    }

    _attribute_map = {
        "granularity": {"key": "granularity", "type": "str"},
        "configuration": {"key": "configuration", "type": "QueryDatasetConfiguration"},
        "aggregation": {"key": "aggregation", "type": "{QueryAggregation}"},
        "grouping": {"key": "grouping", "type": "[QueryGrouping]"},
        "filter": {"key": "filter", "type": "QueryFilter"},
    }

    def __init__(
        self,
        *,
        granularity: Optional[Union[str, "_models.GranularityType"]] = None,
        configuration: Optional["_models.QueryDatasetConfiguration"] = None,
        aggregation: Optional[Dict[str, "_models.QueryAggregation"]] = None,
        grouping: Optional[List["_models.QueryGrouping"]] = None,
        filter: Optional["_models.QueryFilter"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword granularity: The granularity of rows in the query. "Daily"
        :paramtype granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
        :keyword configuration: Has configuration information for the data in the export. The
         configuration will be ignored if aggregation and grouping are provided.
        :paramtype configuration: ~azure.mgmt.costmanagement.models.QueryDatasetConfiguration
        :keyword aggregation: Dictionary of aggregation expression to use in the query. The key of each
         item in the dictionary is the alias for the aggregated column. Query can have up to 2
         aggregation clauses.
        :paramtype aggregation: dict[str, ~azure.mgmt.costmanagement.models.QueryAggregation]
        :keyword grouping: Array of group by expression to use in the query. Query can have up to 2
         group by clauses.
        :paramtype grouping: list[~azure.mgmt.costmanagement.models.QueryGrouping]
        :keyword filter: The filter expression to use in the query. Please reference our Query API REST
         documentation for how to properly format the filter.
        :paramtype filter: ~azure.mgmt.costmanagement.models.QueryFilter
        """
        super().__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration
        self.aggregation = aggregation
        self.grouping = grouping
        self.filter = filter


class QueryDatasetConfiguration(_serialization.Model):
    """The configuration of dataset in the query.

    :ivar columns: Array of column names to be included in the query. Any valid query column name
     is allowed. If not provided, then query includes all columns.
    :vartype columns: list[str]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[str]"},
    }

    def __init__(self, *, columns: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword columns: Array of column names to be included in the query. Any valid query column
         name is allowed. If not provided, then query includes all columns.
        :paramtype columns: list[str]
        """
        super().__init__(**kwargs)
        self.columns = columns


class QueryDefinition(_serialization.Model):
    """The definition of a query.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of the query. Required. Known values are: "Usage", "ActualCost", and
     "AmortizedCost".
    :vartype type: str or ~azure.mgmt.costmanagement.models.ExportType
    :ivar timeframe: The time frame for pulling data for the query. If custom, then a specific time
     period must be provided. Required. Known values are: "MonthToDate", "BillingMonthToDate",
     "TheLastMonth", "TheLastBillingMonth", "WeekToDate", and "Custom".
    :vartype timeframe: str or ~azure.mgmt.costmanagement.models.TimeframeType
    :ivar time_period: Has time period for pulling data for the query.
    :vartype time_period: ~azure.mgmt.costmanagement.models.QueryTimePeriod
    :ivar dataset: Has definition for data in this query. Required.
    :vartype dataset: ~azure.mgmt.costmanagement.models.QueryDataset
    """

    _validation = {
        "type": {"required": True},
        "timeframe": {"required": True},
        "dataset": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "timeframe": {"key": "timeframe", "type": "str"},
        "time_period": {"key": "timePeriod", "type": "QueryTimePeriod"},
        "dataset": {"key": "dataset", "type": "QueryDataset"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ExportType"],
        timeframe: Union[str, "_models.TimeframeType"],
        dataset: "_models.QueryDataset",
        time_period: Optional["_models.QueryTimePeriod"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of the query. Required. Known values are: "Usage", "ActualCost", and
         "AmortizedCost".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.ExportType
        :keyword timeframe: The time frame for pulling data for the query. If custom, then a specific
         time period must be provided. Required. Known values are: "MonthToDate", "BillingMonthToDate",
         "TheLastMonth", "TheLastBillingMonth", "WeekToDate", and "Custom".
        :paramtype timeframe: str or ~azure.mgmt.costmanagement.models.TimeframeType
        :keyword time_period: Has time period for pulling data for the query.
        :paramtype time_period: ~azure.mgmt.costmanagement.models.QueryTimePeriod
        :keyword dataset: Has definition for data in this query. Required.
        :paramtype dataset: ~azure.mgmt.costmanagement.models.QueryDataset
        """
        super().__init__(**kwargs)
        self.type = type
        self.timeframe = timeframe
        self.time_period = time_period
        self.dataset = dataset


class QueryFilter(_serialization.Model):
    """The filter expression to be used in the export.

    :ivar and_property: The logical "AND" expression. Must have at least 2 items.
    :vartype and_property: list[~azure.mgmt.costmanagement.models.QueryFilter]
    :ivar or_property: The logical "OR" expression. Must have at least 2 items.
    :vartype or_property: list[~azure.mgmt.costmanagement.models.QueryFilter]
    :ivar dimensions: Has comparison expression for a dimension.
    :vartype dimensions: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
    :ivar tags: Has comparison expression for a tag.
    :vartype tags: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
    """

    _validation = {
        "and_property": {"min_items": 2},
        "or_property": {"min_items": 2},
    }

    _attribute_map = {
        "and_property": {"key": "and", "type": "[QueryFilter]"},
        "or_property": {"key": "or", "type": "[QueryFilter]"},
        "dimensions": {"key": "dimensions", "type": "QueryComparisonExpression"},
        "tags": {"key": "tags", "type": "QueryComparisonExpression"},
    }

    def __init__(
        self,
        *,
        and_property: Optional[List["_models.QueryFilter"]] = None,
        or_property: Optional[List["_models.QueryFilter"]] = None,
        dimensions: Optional["_models.QueryComparisonExpression"] = None,
        tags: Optional["_models.QueryComparisonExpression"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword and_property: The logical "AND" expression. Must have at least 2 items.
        :paramtype and_property: list[~azure.mgmt.costmanagement.models.QueryFilter]
        :keyword or_property: The logical "OR" expression. Must have at least 2 items.
        :paramtype or_property: list[~azure.mgmt.costmanagement.models.QueryFilter]
        :keyword dimensions: Has comparison expression for a dimension.
        :paramtype dimensions: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
        :keyword tags: Has comparison expression for a tag.
        :paramtype tags: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
        """
        super().__init__(**kwargs)
        self.and_property = and_property
        self.or_property = or_property
        self.dimensions = dimensions
        self.tags = tags


class QueryGrouping(_serialization.Model):
    """The group by expression to be used in the query.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Has type of the column to group. Required. Known values are: "TagKey" and
     "Dimension".
    :vartype type: str or ~azure.mgmt.costmanagement.models.QueryColumnType
    :ivar name: The name of the column to group. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.QueryColumnType"], name: str, **kwargs: Any) -> None:
        """
        :keyword type: Has type of the column to group. Required. Known values are: "TagKey" and
         "Dimension".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.QueryColumnType
        :keyword name: The name of the column to group. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class QueryResult(CostManagementResource):
    """Result of query. It contains all columns listed under groupings and aggregation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar sku: SKU of the resource.
    :vartype sku: str
    :ivar e_tag: ETag of the resource.
    :vartype e_tag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    :ivar columns: Array of columns.
    :vartype columns: list[~azure.mgmt.costmanagement.models.QueryColumn]
    :ivar rows: Array of rows.
    :vartype rows: list[list[any]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "sku": {"readonly": True},
        "e_tag": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "next_link": {"key": "properties.nextLink", "type": "str"},
        "columns": {"key": "properties.columns", "type": "[QueryColumn]"},
        "rows": {"key": "properties.rows", "type": "[[object]]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        columns: Optional[List["_models.QueryColumn"]] = None,
        rows: Optional[List[List[Any]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link (url) to the next page of results.
        :paramtype next_link: str
        :keyword columns: Array of columns.
        :paramtype columns: list[~azure.mgmt.costmanagement.models.QueryColumn]
        :keyword rows: Array of rows.
        :paramtype rows: list[list[any]]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.columns = columns
        self.rows = rows


class QueryTimePeriod(_serialization.Model):
    """The start and end date for pulling data for the query.

    All required parameters must be populated in order to send to Azure.

    :ivar from_property: The start date to pull data from. Required.
    :vartype from_property: ~datetime.datetime
    :ivar to: The end date to pull data to. Required.
    :vartype to: ~datetime.datetime
    """

    _validation = {
        "from_property": {"required": True},
        "to": {"required": True},
    }

    _attribute_map = {
        "from_property": {"key": "from", "type": "iso-8601"},
        "to": {"key": "to", "type": "iso-8601"},
    }

    def __init__(self, *, from_property: datetime.datetime, to: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword from_property: The start date to pull data from. Required.
        :paramtype from_property: ~datetime.datetime
        :keyword to: The end date to pull data to. Required.
        :paramtype to: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class RecommendationUsageDetails(_serialization.Model):
    """On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for
    computing benefit recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar usage_grain: The grain of the usage. Supported values: 'Hourly'. Known values are:
     "Hourly", "Daily", and "Monthly".
    :vartype usage_grain: str or ~azure.mgmt.costmanagement.models.Grain
    :ivar charges: On-demand charges for each hour between firstConsumptionDate and
     lastConsumptionDate that were used for computing benefit recommendations.
    :vartype charges: list[float]
    """

    _validation = {
        "charges": {"readonly": True},
    }

    _attribute_map = {
        "usage_grain": {"key": "usageGrain", "type": "str"},
        "charges": {"key": "charges", "type": "[float]"},
    }

    def __init__(self, *, usage_grain: Optional[Union[str, "_models.Grain"]] = None, **kwargs: Any) -> None:
        """
        :keyword usage_grain: The grain of the usage. Supported values: 'Hourly'. Known values are:
         "Hourly", "Daily", and "Monthly".
        :paramtype usage_grain: str or ~azure.mgmt.costmanagement.models.Grain
        """
        super().__init__(**kwargs)
        self.usage_grain = usage_grain
        self.charges = None


class ReportConfigAggregation(_serialization.Model):
    """The aggregation expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the column to aggregate. Required.
    :vartype name: str
    :ivar function: The name of the aggregation function to use. Required. "Sum"
    :vartype function: str or ~azure.mgmt.costmanagement.models.FunctionType
    """

    _validation = {
        "name": {"required": True},
        "function": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "function": {"key": "function", "type": "str"},
    }

    def __init__(self, *, name: str, function: Union[str, "_models.FunctionType"], **kwargs: Any) -> None:
        """
        :keyword name: The name of the column to aggregate. Required.
        :paramtype name: str
        :keyword function: The name of the aggregation function to use. Required. "Sum"
        :paramtype function: str or ~azure.mgmt.costmanagement.models.FunctionType
        """
        super().__init__(**kwargs)
        self.name = name
        self.function = function


class ReportConfigComparisonExpression(_serialization.Model):
    """The comparison expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the column to use in comparison. Required.
    :vartype name: str
    :ivar operator: The operator to use for comparison. Required. Known values are: "In",
     "Contains", and "In".
    :vartype operator: str or ~azure.mgmt.costmanagement.models.OperatorType
    :ivar values: Array of values to use for comparison. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(
        self, *, name: str, operator: Union[str, "_models.OperatorType"], values: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the column to use in comparison. Required.
        :paramtype name: str
        :keyword operator: The operator to use for comparison. Required. Known values are: "In",
         "Contains", and "In".
        :paramtype operator: str or ~azure.mgmt.costmanagement.models.OperatorType
        :keyword values: Array of values to use for comparison. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class ReportConfigDataset(_serialization.Model):
    """The definition of data present in the report.

    :ivar granularity: The granularity of rows in the report. Known values are: "Daily" and
     "Monthly".
    :vartype granularity: str or ~azure.mgmt.costmanagement.models.ReportGranularityType
    :ivar configuration: Has configuration information for the data in the report. The
     configuration will be ignored if aggregation and grouping are provided.
    :vartype configuration: ~azure.mgmt.costmanagement.models.ReportConfigDatasetConfiguration
    :ivar aggregation: Dictionary of aggregation expression to use in the report. The key of each
     item in the dictionary is the alias for the aggregated column. Report can have up to 2
     aggregation clauses.
    :vartype aggregation: dict[str, ~azure.mgmt.costmanagement.models.ReportConfigAggregation]
    :ivar grouping: Array of group by expression to use in the report. Report can have up to 2
     group by clauses.
    :vartype grouping: list[~azure.mgmt.costmanagement.models.ReportConfigGrouping]
    :ivar sorting: Array of order by expression to use in the report.
    :vartype sorting: list[~azure.mgmt.costmanagement.models.ReportConfigSorting]
    :ivar filter: Has filter expression to use in the report.
    :vartype filter: ~azure.mgmt.costmanagement.models.ReportConfigFilter
    """

    _validation = {
        "grouping": {"max_items": 2, "min_items": 0},
    }

    _attribute_map = {
        "granularity": {"key": "granularity", "type": "str"},
        "configuration": {"key": "configuration", "type": "ReportConfigDatasetConfiguration"},
        "aggregation": {"key": "aggregation", "type": "{ReportConfigAggregation}"},
        "grouping": {"key": "grouping", "type": "[ReportConfigGrouping]"},
        "sorting": {"key": "sorting", "type": "[ReportConfigSorting]"},
        "filter": {"key": "filter", "type": "ReportConfigFilter"},
    }

    def __init__(
        self,
        *,
        granularity: Optional[Union[str, "_models.ReportGranularityType"]] = None,
        configuration: Optional["_models.ReportConfigDatasetConfiguration"] = None,
        aggregation: Optional[Dict[str, "_models.ReportConfigAggregation"]] = None,
        grouping: Optional[List["_models.ReportConfigGrouping"]] = None,
        sorting: Optional[List["_models.ReportConfigSorting"]] = None,
        filter: Optional["_models.ReportConfigFilter"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword granularity: The granularity of rows in the report. Known values are: "Daily" and
         "Monthly".
        :paramtype granularity: str or ~azure.mgmt.costmanagement.models.ReportGranularityType
        :keyword configuration: Has configuration information for the data in the report. The
         configuration will be ignored if aggregation and grouping are provided.
        :paramtype configuration: ~azure.mgmt.costmanagement.models.ReportConfigDatasetConfiguration
        :keyword aggregation: Dictionary of aggregation expression to use in the report. The key of
         each item in the dictionary is the alias for the aggregated column. Report can have up to 2
         aggregation clauses.
        :paramtype aggregation: dict[str, ~azure.mgmt.costmanagement.models.ReportConfigAggregation]
        :keyword grouping: Array of group by expression to use in the report. Report can have up to 2
         group by clauses.
        :paramtype grouping: list[~azure.mgmt.costmanagement.models.ReportConfigGrouping]
        :keyword sorting: Array of order by expression to use in the report.
        :paramtype sorting: list[~azure.mgmt.costmanagement.models.ReportConfigSorting]
        :keyword filter: Has filter expression to use in the report.
        :paramtype filter: ~azure.mgmt.costmanagement.models.ReportConfigFilter
        """
        super().__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration
        self.aggregation = aggregation
        self.grouping = grouping
        self.sorting = sorting
        self.filter = filter


class ReportConfigDatasetConfiguration(_serialization.Model):
    """The configuration of dataset in the report.

    :ivar columns: Array of column names to be included in the report. Any valid report column name
     is allowed. If not provided, then report includes all columns.
    :vartype columns: list[str]
    """

    _attribute_map = {
        "columns": {"key": "columns", "type": "[str]"},
    }

    def __init__(self, *, columns: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword columns: Array of column names to be included in the report. Any valid report column
         name is allowed. If not provided, then report includes all columns.
        :paramtype columns: list[str]
        """
        super().__init__(**kwargs)
        self.columns = columns


class ReportConfigFilter(_serialization.Model):
    """The filter expression to be used in the report.

    :ivar and_property: The logical "AND" expression. Must have at least 2 items.
    :vartype and_property: list[~azure.mgmt.costmanagement.models.ReportConfigFilter]
    :ivar or_property: The logical "OR" expression. Must have at least 2 items.
    :vartype or_property: list[~azure.mgmt.costmanagement.models.ReportConfigFilter]
    :ivar dimensions: Has comparison expression for a dimension.
    :vartype dimensions: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
    :ivar tags: Has comparison expression for a tag.
    :vartype tags: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
    """

    _validation = {
        "and_property": {"min_items": 2},
        "or_property": {"min_items": 2},
    }

    _attribute_map = {
        "and_property": {"key": "and", "type": "[ReportConfigFilter]"},
        "or_property": {"key": "or", "type": "[ReportConfigFilter]"},
        "dimensions": {"key": "dimensions", "type": "ReportConfigComparisonExpression"},
        "tags": {"key": "tags", "type": "ReportConfigComparisonExpression"},
    }

    def __init__(
        self,
        *,
        and_property: Optional[List["_models.ReportConfigFilter"]] = None,
        or_property: Optional[List["_models.ReportConfigFilter"]] = None,
        dimensions: Optional["_models.ReportConfigComparisonExpression"] = None,
        tags: Optional["_models.ReportConfigComparisonExpression"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword and_property: The logical "AND" expression. Must have at least 2 items.
        :paramtype and_property: list[~azure.mgmt.costmanagement.models.ReportConfigFilter]
        :keyword or_property: The logical "OR" expression. Must have at least 2 items.
        :paramtype or_property: list[~azure.mgmt.costmanagement.models.ReportConfigFilter]
        :keyword dimensions: Has comparison expression for a dimension.
        :paramtype dimensions: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
        :keyword tags: Has comparison expression for a tag.
        :paramtype tags: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
        """
        super().__init__(**kwargs)
        self.and_property = and_property
        self.or_property = or_property
        self.dimensions = dimensions
        self.tags = tags


class ReportConfigGrouping(_serialization.Model):
    """The group by expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Has type of the column to group. Required. Known values are: "TagKey" and
     "Dimension".
    :vartype type: str or ~azure.mgmt.costmanagement.models.QueryColumnType
    :ivar name: The name of the column to group. This version supports subscription lowest possible
     grain. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.QueryColumnType"], name: str, **kwargs: Any) -> None:
        """
        :keyword type: Has type of the column to group. Required. Known values are: "TagKey" and
         "Dimension".
        :paramtype type: str or ~azure.mgmt.costmanagement.models.QueryColumnType
        :keyword name: The name of the column to group. This version supports subscription lowest
         possible grain. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class ReportConfigSorting(_serialization.Model):
    """The order by expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :ivar direction: Direction of sort. Known values are: "Ascending" and "Descending".
    :vartype direction: str or ~azure.mgmt.costmanagement.models.ReportConfigSortingType
    :ivar name: The name of the column to sort. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, name: str, direction: Optional[Union[str, "_models.ReportConfigSortingType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword direction: Direction of sort. Known values are: "Ascending" and "Descending".
        :paramtype direction: str or ~azure.mgmt.costmanagement.models.ReportConfigSortingType
        :keyword name: The name of the column to sort. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.name = name


class ReportConfigTimePeriod(_serialization.Model):
    """The start and end date for pulling data for the report.

    All required parameters must be populated in order to send to Azure.

    :ivar from_property: The start date to pull data from. Required.
    :vartype from_property: ~datetime.datetime
    :ivar to: The end date to pull data to. Required.
    :vartype to: ~datetime.datetime
    """

    _validation = {
        "from_property": {"required": True},
        "to": {"required": True},
    }

    _attribute_map = {
        "from_property": {"key": "from", "type": "iso-8601"},
        "to": {"key": "to", "type": "iso-8601"},
    }

    def __init__(self, *, from_property: datetime.datetime, to: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword from_property: The start date to pull data from. Required.
        :paramtype from_property: ~datetime.datetime
        :keyword to: The end date to pull data to. Required.
        :paramtype to: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class SavingsPlanUtilizationSummary(BenefitUtilizationSummary):  # pylint: disable=too-many-instance-attributes
    """Savings plan utilization summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Supported values: 'SavingsPlan'. Required. Known values are: "IncludedQuantity",
     "Reservation", and "SavingsPlan".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar arm_sku_name: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
    :vartype arm_sku_name: str
    :ivar benefit_id: The benefit ID is the identifier of the benefit.
    :vartype benefit_id: str
    :ivar benefit_order_id: The benefit order ID is the identifier for a benefit purchase.
    :vartype benefit_order_id: str
    :ivar benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
     "IncludedQuantity", "Reservation", and "SavingsPlan".
    :vartype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar usage_date: Date corresponding to the utilization summary record. If the grain of data is
     monthly, value for this field will be first day of the month.
    :vartype usage_date: ~datetime.datetime
    :ivar avg_utilization_percentage: This is the average hourly utilization for each date range
     that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate >
     2022-10-01 and usageDate < 2022-10-31 at a daily granularity. There will be one record per
     benefit id for each day. For a single day, the avgUtilizationPercentage value will be equal to
     the average of the set of values where the set contains 24 utilization percentage entries one
     for each hour in a specific day.
    :vartype avg_utilization_percentage: float
    :ivar min_utilization_percentage: This is the minimum hourly utilization for each date range
     that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate >
     2022-10-01 and usageDate < 2022-10-31 at a daily granularity. There will be one record per
     benefit id for each day. For a single day, the minUtilizationPercentage value will be equal to
     the smallest in the set of values where the set contains 24 utilization percentage entries one
     for each hour in a specific day. If on the day 2022-10-18, the lowest utilization percentage
     was 10% at hour 4, then the value for the minUtilizationPercentage in the response will be 10%.
    :vartype min_utilization_percentage: float
    :ivar max_utilization_percentage: This is the maximum hourly utilization for each date range
     that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate >
     2022-10-01 and usageDate < 2022-10-31 at a daily granularity. There will be one record per
     benefit id for each day. For a single day, the maxUtilizationPercentage value will be equal to
     the largest in the set of values where the set contains 24 utilization percentage entries one
     for each hour in a specific day. If on the day 2022-10-18, the largest utilization percentage
     was 90% at hour 5, then the value for the maxUtilizationPercentage in the response will be 90%.
    :vartype max_utilization_percentage: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "arm_sku_name": {"readonly": True},
        "benefit_id": {"readonly": True},
        "benefit_order_id": {"readonly": True},
        "usage_date": {"readonly": True},
        "avg_utilization_percentage": {"readonly": True},
        "min_utilization_percentage": {"readonly": True},
        "max_utilization_percentage": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "arm_sku_name": {"key": "properties.armSkuName", "type": "str"},
        "benefit_id": {"key": "properties.benefitId", "type": "str"},
        "benefit_order_id": {"key": "properties.benefitOrderId", "type": "str"},
        "benefit_type": {"key": "properties.benefitType", "type": "str"},
        "usage_date": {"key": "properties.usageDate", "type": "iso-8601"},
        "avg_utilization_percentage": {"key": "properties.avgUtilizationPercentage", "type": "float"},
        "min_utilization_percentage": {"key": "properties.minUtilizationPercentage", "type": "float"},
        "max_utilization_percentage": {"key": "properties.maxUtilizationPercentage", "type": "float"},
    }

    def __init__(self, *, benefit_type: Optional[Union[str, "_models.BenefitKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
         "IncludedQuantity", "Reservation", and "SavingsPlan".
        :paramtype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
        """
        super().__init__(**kwargs)
        self.kind: str = "SavingsPlan"
        self.arm_sku_name = None
        self.benefit_id = None
        self.benefit_order_id = None
        self.benefit_type = benefit_type
        self.usage_date = None
        self.avg_utilization_percentage = None
        self.min_utilization_percentage = None
        self.max_utilization_percentage = None


class SavingsPlanUtilizationSummaryProperties(BenefitUtilizationSummaryProperties):
    """Savings plan utilization summary properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar arm_sku_name: ARM SKU name. For example, 'Compute_Savings_Plan' for savings plan.
    :vartype arm_sku_name: str
    :ivar benefit_id: The benefit ID is the identifier of the benefit.
    :vartype benefit_id: str
    :ivar benefit_order_id: The benefit order ID is the identifier for a benefit purchase.
    :vartype benefit_order_id: str
    :ivar benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
     "IncludedQuantity", "Reservation", and "SavingsPlan".
    :vartype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
    :ivar usage_date: Date corresponding to the utilization summary record. If the grain of data is
     monthly, value for this field will be first day of the month.
    :vartype usage_date: ~datetime.datetime
    :ivar avg_utilization_percentage: This is the average hourly utilization for each date range
     that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate >
     2022-10-01 and usageDate < 2022-10-31 at a daily granularity. There will be one record per
     benefit id for each day. For a single day, the avgUtilizationPercentage value will be equal to
     the average of the set of values where the set contains 24 utilization percentage entries one
     for each hour in a specific day.
    :vartype avg_utilization_percentage: float
    :ivar min_utilization_percentage: This is the minimum hourly utilization for each date range
     that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate >
     2022-10-01 and usageDate < 2022-10-31 at a daily granularity. There will be one record per
     benefit id for each day. For a single day, the minUtilizationPercentage value will be equal to
     the smallest in the set of values where the set contains 24 utilization percentage entries one
     for each hour in a specific day. If on the day 2022-10-18, the lowest utilization percentage
     was 10% at hour 4, then the value for the minUtilizationPercentage in the response will be 10%.
    :vartype min_utilization_percentage: float
    :ivar max_utilization_percentage: This is the maximum hourly utilization for each date range
     that corresponds to given grain (Daily, Monthly). Suppose the API call is for usageDate >
     2022-10-01 and usageDate < 2022-10-31 at a daily granularity. There will be one record per
     benefit id for each day. For a single day, the maxUtilizationPercentage value will be equal to
     the largest in the set of values where the set contains 24 utilization percentage entries one
     for each hour in a specific day. If on the day 2022-10-18, the largest utilization percentage
     was 90% at hour 5, then the value for the maxUtilizationPercentage in the response will be 90%.
    :vartype max_utilization_percentage: float
    """

    _validation = {
        "arm_sku_name": {"readonly": True},
        "benefit_id": {"readonly": True},
        "benefit_order_id": {"readonly": True},
        "usage_date": {"readonly": True},
        "avg_utilization_percentage": {"readonly": True},
        "min_utilization_percentage": {"readonly": True},
        "max_utilization_percentage": {"readonly": True},
    }

    _attribute_map = {
        "arm_sku_name": {"key": "armSkuName", "type": "str"},
        "benefit_id": {"key": "benefitId", "type": "str"},
        "benefit_order_id": {"key": "benefitOrderId", "type": "str"},
        "benefit_type": {"key": "benefitType", "type": "str"},
        "usage_date": {"key": "usageDate", "type": "iso-8601"},
        "avg_utilization_percentage": {"key": "avgUtilizationPercentage", "type": "float"},
        "min_utilization_percentage": {"key": "minUtilizationPercentage", "type": "float"},
        "max_utilization_percentage": {"key": "maxUtilizationPercentage", "type": "float"},
    }

    def __init__(self, *, benefit_type: Optional[Union[str, "_models.BenefitKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword benefit_type: The benefit type. Supported values: 'SavingsPlan'. Known values are:
         "IncludedQuantity", "Reservation", and "SavingsPlan".
        :paramtype benefit_type: str or ~azure.mgmt.costmanagement.models.BenefitKind
        """
        super().__init__(benefit_type=benefit_type, **kwargs)
        self.avg_utilization_percentage = None
        self.min_utilization_percentage = None
        self.max_utilization_percentage = None


class ScheduledActionProxyResource(ProxyResource):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar e_tag: Resource Etag. For update calls, eTag is optional and can be specified to achieve
     optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then
     including the latest eTag as part of the request body or 'If-Match' header while performing the
     update. For create calls, eTag is not required.
    :vartype e_tag: str
    :ivar kind: Kind of the scheduled action. Known values are: "Email" and "InsightAlert".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.ScheduledActionKind
    :ivar system_data: Kind of the scheduled action.
    :vartype system_data: ~azure.mgmt.costmanagement.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "e_tag": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, kind: Optional[Union[str, "_models.ScheduledActionKind"]] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of the scheduled action. Known values are: "Email" and "InsightAlert".
        :paramtype kind: str or ~azure.mgmt.costmanagement.models.ScheduledActionKind
        """
        super().__init__(**kwargs)
        self.e_tag = None
        self.kind = kind
        self.system_data = None


class ScheduledAction(ScheduledActionProxyResource):  # pylint: disable=too-many-instance-attributes
    """Scheduled action definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar e_tag: Resource Etag. For update calls, eTag is optional and can be specified to achieve
     optimistic concurrency. Fetch the resource's eTag by doing a 'GET' call first and then
     including the latest eTag as part of the request body or 'If-Match' header while performing the
     update. For create calls, eTag is not required.
    :vartype e_tag: str
    :ivar kind: Kind of the scheduled action. Known values are: "Email" and "InsightAlert".
    :vartype kind: str or ~azure.mgmt.costmanagement.models.ScheduledActionKind
    :ivar system_data: Kind of the scheduled action.
    :vartype system_data: ~azure.mgmt.costmanagement.models.SystemData
    :ivar display_name: Scheduled action name.
    :vartype display_name: str
    :ivar file_destination: Destination format of the view data. This is optional.
    :vartype file_destination: ~azure.mgmt.costmanagement.models.FileDestination
    :ivar notification: Notification properties based on scheduled action kind.
    :vartype notification: ~azure.mgmt.costmanagement.models.NotificationProperties
    :ivar notification_email: Email address of the point of contact that should get the unsubscribe
     requests and notification emails.
    :vartype notification_email: str
    :ivar schedule: Schedule of the scheduled action.
    :vartype schedule: ~azure.mgmt.costmanagement.models.ScheduleProperties
    :ivar scope: Cost Management scope like 'subscriptions/{subscriptionId}' for subscription
     scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
     scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account
     scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
     Department scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     for EnrollmentAccount scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
     for BillingProfile scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
     for InvoiceSection scope,
     '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
     ExternalBillingAccount scope, and
     '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
     ExternalSubscription scope.
    :vartype scope: str
    :ivar status: Status of the scheduled action. Known values are: "Disabled", "Enabled", and
     "Expired".
    :vartype status: str or ~azure.mgmt.costmanagement.models.ScheduledActionStatus
    :ivar view_id: Cost analysis viewId used for scheduled action. For example,
     '/providers/Microsoft.CostManagement/views/swaggerExample'.
    :vartype view_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "e_tag": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "file_destination": {"key": "properties.fileDestination", "type": "FileDestination"},
        "notification": {"key": "properties.notification", "type": "NotificationProperties"},
        "notification_email": {"key": "properties.notificationEmail", "type": "str"},
        "schedule": {"key": "properties.schedule", "type": "ScheduleProperties"},
        "scope": {"key": "properties.scope", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "view_id": {"key": "properties.viewId", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ScheduledActionKind"]] = None,
        display_name: Optional[str] = None,
        file_destination: Optional["_models.FileDestination"] = None,
        notification: Optional["_models.NotificationProperties"] = None,
        notification_email: Optional[str] = None,
        schedule: Optional["_models.ScheduleProperties"] = None,
        scope: Optional[str] = None,
        status: Optional[Union[str, "_models.ScheduledActionStatus"]] = None,
        view_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of the scheduled action. Known values are: "Email" and "InsightAlert".
        :paramtype kind: str or ~azure.mgmt.costmanagement.models.ScheduledActionKind
        :keyword display_name: Scheduled action name.
        :paramtype display_name: str
        :keyword file_destination: Destination format of the view data. This is optional.
        :paramtype file_destination: ~azure.mgmt.costmanagement.models.FileDestination
        :keyword notification: Notification properties based on scheduled action kind.
        :paramtype notification: ~azure.mgmt.costmanagement.models.NotificationProperties
        :keyword notification_email: Email address of the point of contact that should get the
         unsubscribe requests and notification emails.
        :paramtype notification_email: str
        :keyword schedule: Schedule of the scheduled action.
        :paramtype schedule: ~azure.mgmt.costmanagement.models.ScheduleProperties
        :keyword scope: Cost Management scope like 'subscriptions/{subscriptionId}' for subscription
         scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup
         scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account
         scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope,
         '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         ExternalBillingAccount scope, and
         '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         ExternalSubscription scope.
        :paramtype scope: str
        :keyword status: Status of the scheduled action. Known values are: "Disabled", "Enabled", and
         "Expired".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.ScheduledActionStatus
        :keyword view_id: Cost analysis viewId used for scheduled action. For example,
         '/providers/Microsoft.CostManagement/views/swaggerExample'.
        :paramtype view_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name = display_name
        self.file_destination = file_destination
        self.notification = notification
        self.notification_email = notification_email
        self.schedule = schedule
        self.scope = scope
        self.status = status
        self.view_id = view_id


class ScheduledActionListResult(_serialization.Model):
    """Scheduled actions list result. It contains a list of scheduled actions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of scheduled actions.
    :vartype value: list[~azure.mgmt.costmanagement.models.ScheduledAction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScheduledAction]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ScheduleProperties(_serialization.Model):
    """The properties of the schedule.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency: Frequency of the schedule. Required. Known values are: "Daily", "Weekly", and
     "Monthly".
    :vartype frequency: str or ~azure.mgmt.costmanagement.models.ScheduleFrequency
    :ivar hour_of_day: UTC time at which cost analysis data will be emailed.
    :vartype hour_of_day: int
    :ivar days_of_week: Day names in english on which cost analysis data will be emailed. This
     property is applicable when frequency is Weekly or Monthly.
    :vartype days_of_week: list[str or ~azure.mgmt.costmanagement.models.DaysOfWeek]
    :ivar weeks_of_month: Weeks in which cost analysis data will be emailed. This property is
     applicable when frequency is Monthly and used in combination with daysOfWeek.
    :vartype weeks_of_month: list[str or ~azure.mgmt.costmanagement.models.WeeksOfMonth]
    :ivar day_of_month: UTC day on which cost analysis data will be emailed. Must be between 1 and
     31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or
     daysOfWeek.
    :vartype day_of_month: int
    :ivar start_date: The start date and time of the scheduled action (UTC). Required.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The end date and time of the scheduled action (UTC). Required.
    :vartype end_date: ~datetime.datetime
    """

    _validation = {
        "frequency": {"required": True},
        "start_date": {"required": True},
        "end_date": {"required": True},
    }

    _attribute_map = {
        "frequency": {"key": "frequency", "type": "str"},
        "hour_of_day": {"key": "hourOfDay", "type": "int"},
        "days_of_week": {"key": "daysOfWeek", "type": "[str]"},
        "weeks_of_month": {"key": "weeksOfMonth", "type": "[str]"},
        "day_of_month": {"key": "dayOfMonth", "type": "int"},
        "start_date": {"key": "startDate", "type": "iso-8601"},
        "end_date": {"key": "endDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        frequency: Union[str, "_models.ScheduleFrequency"],
        start_date: datetime.datetime,
        end_date: datetime.datetime,
        hour_of_day: Optional[int] = None,
        days_of_week: Optional[List[Union[str, "_models.DaysOfWeek"]]] = None,
        weeks_of_month: Optional[List[Union[str, "_models.WeeksOfMonth"]]] = None,
        day_of_month: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword frequency: Frequency of the schedule. Required. Known values are: "Daily", "Weekly",
         and "Monthly".
        :paramtype frequency: str or ~azure.mgmt.costmanagement.models.ScheduleFrequency
        :keyword hour_of_day: UTC time at which cost analysis data will be emailed.
        :paramtype hour_of_day: int
        :keyword days_of_week: Day names in english on which cost analysis data will be emailed. This
         property is applicable when frequency is Weekly or Monthly.
        :paramtype days_of_week: list[str or ~azure.mgmt.costmanagement.models.DaysOfWeek]
        :keyword weeks_of_month: Weeks in which cost analysis data will be emailed. This property is
         applicable when frequency is Monthly and used in combination with daysOfWeek.
        :paramtype weeks_of_month: list[str or ~azure.mgmt.costmanagement.models.WeeksOfMonth]
        :keyword day_of_month: UTC day on which cost analysis data will be emailed. Must be between 1
         and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or
         daysOfWeek.
        :paramtype day_of_month: int
        :keyword start_date: The start date and time of the scheduled action (UTC). Required.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The end date and time of the scheduled action (UTC). Required.
        :paramtype end_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.frequency = frequency
        self.hour_of_day = hour_of_day
        self.days_of_week = days_of_week
        self.weeks_of_month = weeks_of_month
        self.day_of_month = day_of_month
        self.start_date = start_date
        self.end_date = end_date


class SharedScopeBenefitRecommendationProperties(
    BenefitRecommendationProperties
):  # pylint: disable=too-many-instance-attributes
    """The properties of the benefit recommendation when scope is 'Shared'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar first_consumption_date: The first usage date used for looking back for computing the
     recommendations.
    :vartype first_consumption_date: ~datetime.datetime
    :ivar last_consumption_date: The last usage date used for looking back for computing the
     recommendations.
    :vartype last_consumption_date: ~datetime.datetime
    :ivar look_back_period: The number of days of usage evaluated for computing the
     recommendations. Known values are: "Last7Days", "Last30Days", and "Last60Days".
    :vartype look_back_period: str or ~azure.mgmt.costmanagement.models.LookBackPeriod
    :ivar total_hours: The total hours for which the cost is covered. Its equal to number of
     records in a property 'properties/usage/charges'.
    :vartype total_hours: int
    :ivar usage: On-demand charges between firstConsumptionDate and lastConsumptionDate that were
     used for computing benefit recommendations.
    :vartype usage: ~azure.mgmt.costmanagement.models.RecommendationUsageDetails
    :ivar arm_sku_name: ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan.
    :vartype arm_sku_name: str
    :ivar term: Term period of the benefit. For example, P1Y or P3Y. Known values are: "P1Y" and
     "P3Y".
    :vartype term: str or ~azure.mgmt.costmanagement.models.Term
    :ivar commitment_granularity: Grain of the proposed commitment amount. Supported values:
     'Hourly'. Known values are: "Hourly", "Daily", and "Monthly".
    :vartype commitment_granularity: str or ~azure.mgmt.costmanagement.models.Grain
    :ivar currency_code: An ISO 4217 currency code identifier for the costs and savings amounts.
    :vartype currency_code: str
    :ivar cost_without_benefit: The current cost without benefit, corresponds to 'totalHours' in
     the look-back period.
    :vartype cost_without_benefit: float
    :ivar recommendation_details: The details of the proposed recommendation.
    :vartype recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails
    :ivar all_recommendation_details: The list of all benefit recommendations with the
     recommendation details.
    :vartype all_recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsList
    :ivar scope: Benefit scope. For example, Single or Shared. Required. Known values are: "Single"
     and "Shared".
    :vartype scope: str or ~azure.mgmt.costmanagement.models.Scope
    """

    _validation = {
        "first_consumption_date": {"readonly": True},
        "last_consumption_date": {"readonly": True},
        "total_hours": {"readonly": True},
        "arm_sku_name": {"readonly": True},
        "currency_code": {"readonly": True},
        "cost_without_benefit": {"readonly": True},
        "all_recommendation_details": {"readonly": True},
        "scope": {"required": True},
    }

    _attribute_map = {
        "first_consumption_date": {"key": "firstConsumptionDate", "type": "iso-8601"},
        "last_consumption_date": {"key": "lastConsumptionDate", "type": "iso-8601"},
        "look_back_period": {"key": "lookBackPeriod", "type": "str"},
        "total_hours": {"key": "totalHours", "type": "int"},
        "usage": {"key": "usage", "type": "RecommendationUsageDetails"},
        "arm_sku_name": {"key": "armSkuName", "type": "str"},
        "term": {"key": "term", "type": "str"},
        "commitment_granularity": {"key": "commitmentGranularity", "type": "str"},
        "currency_code": {"key": "currencyCode", "type": "str"},
        "cost_without_benefit": {"key": "costWithoutBenefit", "type": "float"},
        "recommendation_details": {"key": "recommendationDetails", "type": "AllSavingsBenefitDetails"},
        "all_recommendation_details": {"key": "allRecommendationDetails", "type": "AllSavingsList"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        look_back_period: Optional[Union[str, "_models.LookBackPeriod"]] = None,
        usage: Optional["_models.RecommendationUsageDetails"] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        commitment_granularity: Optional[Union[str, "_models.Grain"]] = None,
        recommendation_details: Optional["_models.AllSavingsBenefitDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword look_back_period: The number of days of usage evaluated for computing the
         recommendations. Known values are: "Last7Days", "Last30Days", and "Last60Days".
        :paramtype look_back_period: str or ~azure.mgmt.costmanagement.models.LookBackPeriod
        :keyword usage: On-demand charges between firstConsumptionDate and lastConsumptionDate that
         were used for computing benefit recommendations.
        :paramtype usage: ~azure.mgmt.costmanagement.models.RecommendationUsageDetails
        :keyword term: Term period of the benefit. For example, P1Y or P3Y. Known values are: "P1Y" and
         "P3Y".
        :paramtype term: str or ~azure.mgmt.costmanagement.models.Term
        :keyword commitment_granularity: Grain of the proposed commitment amount. Supported values:
         'Hourly'. Known values are: "Hourly", "Daily", and "Monthly".
        :paramtype commitment_granularity: str or ~azure.mgmt.costmanagement.models.Grain
        :keyword recommendation_details: The details of the proposed recommendation.
        :paramtype recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails
        """
        super().__init__(
            look_back_period=look_back_period,
            usage=usage,
            term=term,
            commitment_granularity=commitment_granularity,
            recommendation_details=recommendation_details,
            **kwargs
        )
        self.scope: str = "Shared"


class SingleScopeBenefitRecommendationProperties(
    BenefitRecommendationProperties
):  # pylint: disable=too-many-instance-attributes
    """The properties of the benefit recommendations when scope is 'Single'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar first_consumption_date: The first usage date used for looking back for computing the
     recommendations.
    :vartype first_consumption_date: ~datetime.datetime
    :ivar last_consumption_date: The last usage date used for looking back for computing the
     recommendations.
    :vartype last_consumption_date: ~datetime.datetime
    :ivar look_back_period: The number of days of usage evaluated for computing the
     recommendations. Known values are: "Last7Days", "Last30Days", and "Last60Days".
    :vartype look_back_period: str or ~azure.mgmt.costmanagement.models.LookBackPeriod
    :ivar total_hours: The total hours for which the cost is covered. Its equal to number of
     records in a property 'properties/usage/charges'.
    :vartype total_hours: int
    :ivar usage: On-demand charges between firstConsumptionDate and lastConsumptionDate that were
     used for computing benefit recommendations.
    :vartype usage: ~azure.mgmt.costmanagement.models.RecommendationUsageDetails
    :ivar arm_sku_name: ARM SKU name. 'Compute_Savings_Plan' for SavingsPlan.
    :vartype arm_sku_name: str
    :ivar term: Term period of the benefit. For example, P1Y or P3Y. Known values are: "P1Y" and
     "P3Y".
    :vartype term: str or ~azure.mgmt.costmanagement.models.Term
    :ivar commitment_granularity: Grain of the proposed commitment amount. Supported values:
     'Hourly'. Known values are: "Hourly", "Daily", and "Monthly".
    :vartype commitment_granularity: str or ~azure.mgmt.costmanagement.models.Grain
    :ivar currency_code: An ISO 4217 currency code identifier for the costs and savings amounts.
    :vartype currency_code: str
    :ivar cost_without_benefit: The current cost without benefit, corresponds to 'totalHours' in
     the look-back period.
    :vartype cost_without_benefit: float
    :ivar recommendation_details: The details of the proposed recommendation.
    :vartype recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails
    :ivar all_recommendation_details: The list of all benefit recommendations with the
     recommendation details.
    :vartype all_recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsList
    :ivar scope: Benefit scope. For example, Single or Shared. Required. Known values are: "Single"
     and "Shared".
    :vartype scope: str or ~azure.mgmt.costmanagement.models.Scope
    :ivar subscription_id: The subscription ID that this single scope recommendation is for.
     Applicable only if recommendation is for 'Single' scope.
    :vartype subscription_id: str
    :ivar resource_group: The resource group that this single scope recommendation is for.
     Applicable only if recommendation is for 'Single' scope and 'ResourceGroup' request scope.
    :vartype resource_group: str
    """

    _validation = {
        "first_consumption_date": {"readonly": True},
        "last_consumption_date": {"readonly": True},
        "total_hours": {"readonly": True},
        "arm_sku_name": {"readonly": True},
        "currency_code": {"readonly": True},
        "cost_without_benefit": {"readonly": True},
        "all_recommendation_details": {"readonly": True},
        "scope": {"required": True},
        "subscription_id": {"readonly": True},
        "resource_group": {"readonly": True},
    }

    _attribute_map = {
        "first_consumption_date": {"key": "firstConsumptionDate", "type": "iso-8601"},
        "last_consumption_date": {"key": "lastConsumptionDate", "type": "iso-8601"},
        "look_back_period": {"key": "lookBackPeriod", "type": "str"},
        "total_hours": {"key": "totalHours", "type": "int"},
        "usage": {"key": "usage", "type": "RecommendationUsageDetails"},
        "arm_sku_name": {"key": "armSkuName", "type": "str"},
        "term": {"key": "term", "type": "str"},
        "commitment_granularity": {"key": "commitmentGranularity", "type": "str"},
        "currency_code": {"key": "currencyCode", "type": "str"},
        "cost_without_benefit": {"key": "costWithoutBenefit", "type": "float"},
        "recommendation_details": {"key": "recommendationDetails", "type": "AllSavingsBenefitDetails"},
        "all_recommendation_details": {"key": "allRecommendationDetails", "type": "AllSavingsList"},
        "scope": {"key": "scope", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        look_back_period: Optional[Union[str, "_models.LookBackPeriod"]] = None,
        usage: Optional["_models.RecommendationUsageDetails"] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        commitment_granularity: Optional[Union[str, "_models.Grain"]] = None,
        recommendation_details: Optional["_models.AllSavingsBenefitDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword look_back_period: The number of days of usage evaluated for computing the
         recommendations. Known values are: "Last7Days", "Last30Days", and "Last60Days".
        :paramtype look_back_period: str or ~azure.mgmt.costmanagement.models.LookBackPeriod
        :keyword usage: On-demand charges between firstConsumptionDate and lastConsumptionDate that
         were used for computing benefit recommendations.
        :paramtype usage: ~azure.mgmt.costmanagement.models.RecommendationUsageDetails
        :keyword term: Term period of the benefit. For example, P1Y or P3Y. Known values are: "P1Y" and
         "P3Y".
        :paramtype term: str or ~azure.mgmt.costmanagement.models.Term
        :keyword commitment_granularity: Grain of the proposed commitment amount. Supported values:
         'Hourly'. Known values are: "Hourly", "Daily", and "Monthly".
        :paramtype commitment_granularity: str or ~azure.mgmt.costmanagement.models.Grain
        :keyword recommendation_details: The details of the proposed recommendation.
        :paramtype recommendation_details: ~azure.mgmt.costmanagement.models.AllSavingsBenefitDetails
        """
        super().__init__(
            look_back_period=look_back_period,
            usage=usage,
            term=term,
            commitment_granularity=commitment_granularity,
            recommendation_details=recommendation_details,
            **kwargs
        )
        self.scope: str = "Single"
        self.subscription_id = None
        self.resource_group = None


class Status(_serialization.Model):
    """The status of the long running operation.

    :ivar status: The status of the long running operation. Known values are: "InProgress",
     "Completed", "Failed", "Queued", "NoDataFound", "ReadyToDownload", and "TimedOut".
    :vartype status: str or ~azure.mgmt.costmanagement.models.ReportOperationStatusType
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, status: Optional[Union[str, "_models.ReportOperationStatusType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the long running operation. Known values are: "InProgress",
         "Completed", "Failed", "Queued", "NoDataFound", "ReadyToDownload", and "TimedOut".
        :paramtype status: str or ~azure.mgmt.costmanagement.models.ReportOperationStatusType
        """
        super().__init__(**kwargs)
        self.status = status


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.costmanagement.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.costmanagement.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.costmanagement.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.costmanagement.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class View(CostManagementProxyResource):  # pylint: disable=too-many-instance-attributes
    """States and configurations of Cost Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :vartype e_tag: str
    :ivar display_name: User input name of the view. Required.
    :vartype display_name: str
    :ivar scope: Cost Management scope to save the view on. This includes
     'subscriptions/{subscriptionId}' for subscription scope,
     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
     Department scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     for EnrollmentAccount scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
     for BillingProfile scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
     for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
     for Management Group scope,
     '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
     ExternalBillingAccount scope, and
     '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
     ExternalSubscription scope.
    :vartype scope: str
    :ivar created_on: Date the user created this view.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: Date when the user last modified this view.
    :vartype modified_on: ~datetime.datetime
    :ivar date_range: Date range of the current view.
    :vartype date_range: str
    :ivar currency: Currency of the current view.
    :vartype currency: str
    :ivar chart: Chart type of the main view in Cost Analysis. Required. Known values are: "Area",
     "Line", "StackedColumn", "GroupedColumn", and "Table".
    :vartype chart: str or ~azure.mgmt.costmanagement.models.ChartType
    :ivar accumulated: Show costs accumulated over time. Known values are: "true" and "false".
    :vartype accumulated: str or ~azure.mgmt.costmanagement.models.AccumulatedType
    :ivar metric: Metric to use when displaying costs. Known values are: "ActualCost",
     "AmortizedCost", and "AHUB".
    :vartype metric: str or ~azure.mgmt.costmanagement.models.MetricType
    :ivar kpis: List of KPIs to show in Cost Analysis UI.
    :vartype kpis: list[~azure.mgmt.costmanagement.models.KpiProperties]
    :ivar pivots: Configuration of 3 sub-views in the Cost Analysis UI.
    :vartype pivots: list[~azure.mgmt.costmanagement.models.PivotProperties]
    :ivar type_properties_query_type: The type of the report. Usage represents actual usage,
     forecast represents forecasted data and UsageAndForecast represents both usage and forecasted
     data. Actual usage and forecasted data can be differentiated based on dates. "Usage"
    :vartype type_properties_query_type: str or ~azure.mgmt.costmanagement.models.ReportType
    :ivar timeframe: The time frame for pulling data for the report. If custom, then a specific
     time period must be provided. Known values are: "WeekToDate", "MonthToDate", "YearToDate", and
     "Custom".
    :vartype timeframe: str or ~azure.mgmt.costmanagement.models.ReportTimeframeType
    :ivar time_period: Has time period for pulling data for the report.
    :vartype time_period: ~azure.mgmt.costmanagement.models.ReportConfigTimePeriod
    :ivar data_set: Has definition for data in this report config.
    :vartype data_set: ~azure.mgmt.costmanagement.models.ReportConfigDataset
    :ivar include_monetary_commitment: If true, report includes monetary commitment.
    :vartype include_monetary_commitment: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "currency": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "modified_on": {"key": "properties.modifiedOn", "type": "iso-8601"},
        "date_range": {"key": "properties.dateRange", "type": "str"},
        "currency": {"key": "properties.currency", "type": "str"},
        "chart": {"key": "properties.chart", "type": "str"},
        "accumulated": {"key": "properties.accumulated", "type": "str"},
        "metric": {"key": "properties.metric", "type": "str"},
        "kpis": {"key": "properties.kpis", "type": "[KpiProperties]"},
        "pivots": {"key": "properties.pivots", "type": "[PivotProperties]"},
        "type_properties_query_type": {"key": "properties.query.type", "type": "str"},
        "timeframe": {"key": "properties.query.timeframe", "type": "str"},
        "time_period": {"key": "properties.query.timePeriod", "type": "ReportConfigTimePeriod"},
        "data_set": {"key": "properties.query.dataSet", "type": "ReportConfigDataset"},
        "include_monetary_commitment": {"key": "properties.query.includeMonetaryCommitment", "type": "bool"},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        display_name: Optional[str] = None,
        scope: Optional[str] = None,
        date_range: Optional[str] = None,
        chart: Optional[Union[str, "_models.ChartType"]] = None,
        accumulated: Optional[Union[str, "_models.AccumulatedType"]] = None,
        metric: Optional[Union[str, "_models.MetricType"]] = None,
        kpis: Optional[List["_models.KpiProperties"]] = None,
        pivots: Optional[List["_models.PivotProperties"]] = None,
        type_properties_query_type: Optional[Union[str, "_models.ReportType"]] = None,
        timeframe: Optional[Union[str, "_models.ReportTimeframeType"]] = None,
        time_period: Optional["_models.ReportConfigTimePeriod"] = None,
        data_set: Optional["_models.ReportConfigDataset"] = None,
        include_monetary_commitment: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
         used to determine whether the user is updating the latest version or not.
        :paramtype e_tag: str
        :keyword display_name: User input name of the view. Required.
        :paramtype display_name: str
        :keyword scope: Cost Management scope to save the view on. This includes
         'subscriptions/{subscriptionId}' for subscription scope,
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
         Department scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
         for EnrollmentAccount scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
         for BillingProfile scope,
         'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
         for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
         for Management Group scope,
         '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
         ExternalBillingAccount scope, and
         '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
         ExternalSubscription scope.
        :paramtype scope: str
        :keyword date_range: Date range of the current view.
        :paramtype date_range: str
        :keyword chart: Chart type of the main view in Cost Analysis. Required. Known values are:
         "Area", "Line", "StackedColumn", "GroupedColumn", and "Table".
        :paramtype chart: str or ~azure.mgmt.costmanagement.models.ChartType
        :keyword accumulated: Show costs accumulated over time. Known values are: "true" and "false".
        :paramtype accumulated: str or ~azure.mgmt.costmanagement.models.AccumulatedType
        :keyword metric: Metric to use when displaying costs. Known values are: "ActualCost",
         "AmortizedCost", and "AHUB".
        :paramtype metric: str or ~azure.mgmt.costmanagement.models.MetricType
        :keyword kpis: List of KPIs to show in Cost Analysis UI.
        :paramtype kpis: list[~azure.mgmt.costmanagement.models.KpiProperties]
        :keyword pivots: Configuration of 3 sub-views in the Cost Analysis UI.
        :paramtype pivots: list[~azure.mgmt.costmanagement.models.PivotProperties]
        :keyword type_properties_query_type: The type of the report. Usage represents actual usage,
         forecast represents forecasted data and UsageAndForecast represents both usage and forecasted
         data. Actual usage and forecasted data can be differentiated based on dates. "Usage"
        :paramtype type_properties_query_type: str or ~azure.mgmt.costmanagement.models.ReportType
        :keyword timeframe: The time frame for pulling data for the report. If custom, then a specific
         time period must be provided. Known values are: "WeekToDate", "MonthToDate", "YearToDate", and
         "Custom".
        :paramtype timeframe: str or ~azure.mgmt.costmanagement.models.ReportTimeframeType
        :keyword time_period: Has time period for pulling data for the report.
        :paramtype time_period: ~azure.mgmt.costmanagement.models.ReportConfigTimePeriod
        :keyword data_set: Has definition for data in this report config.
        :paramtype data_set: ~azure.mgmt.costmanagement.models.ReportConfigDataset
        :keyword include_monetary_commitment: If true, report includes monetary commitment.
        :paramtype include_monetary_commitment: bool
        """
        super().__init__(e_tag=e_tag, **kwargs)
        self.display_name = display_name
        self.scope = scope
        self.created_on = None
        self.modified_on = None
        self.date_range = date_range
        self.currency = None
        self.chart = chart
        self.accumulated = accumulated
        self.metric = metric
        self.kpis = kpis
        self.pivots = pivots
        self.type_properties_query_type = type_properties_query_type
        self.timeframe = timeframe
        self.time_period = time_period
        self.data_set = data_set
        self.include_monetary_commitment = include_monetary_commitment


class ViewListResult(_serialization.Model):
    """Result of listing views. It contains a list of available views.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of views.
    :vartype value: list[~azure.mgmt.costmanagement.models.View]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[View]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None
