# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.compute import ComputeManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-compute
# USAGE
    python gallery_image_version_create_with_vhd.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="{subscription-id}",
    )

    response = client.gallery_image_versions.begin_create_or_update(
        resource_group_name="myResourceGroup",
        gallery_name="myGalleryName",
        gallery_image_name="myGalleryImageName",
        gallery_image_version_name="1.0.0",
        gallery_image_version={
            "location": "West US",
            "properties": {
                "publishingProfile": {
                    "targetRegions": [
                        {
                            "encryption": {
                                "dataDiskImages": [
                                    {
                                        "diskEncryptionSetId": "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myOtherDiskEncryptionSet",
                                        "lun": 1,
                                    }
                                ],
                                "osDiskImage": {
                                    "diskEncryptionSetId": "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSet/myDiskEncryptionSet"
                                },
                            },
                            "excludeFromLatest": False,
                            "name": "West US",
                            "regionalReplicaCount": 1,
                        },
                        {
                            "excludeFromLatest": False,
                            "name": "East US",
                            "regionalReplicaCount": 2,
                            "storageAccountType": "Standard_ZRS",
                        },
                    ]
                },
                "safetyProfile": {"allowDeletionOfReplicatedLocations": False, "blockDeletionBeforeEndOfLife": False},
                "storageProfile": {
                    "dataDiskImages": [
                        {
                            "hostCaching": "None",
                            "lun": 1,
                            "source": {
                                "storageAccountId": "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}",
                                "uri": "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd",
                            },
                        }
                    ],
                    "osDiskImage": {
                        "hostCaching": "ReadOnly",
                        "source": {
                            "storageAccountId": "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/{storageAccount}",
                            "uri": "https://gallerysourcencus.blob.core.windows.net/myvhds/Windows-Server-2012-R2-20171216-en.us-128GB.vhd",
                        },
                    },
                },
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2024-03-03/examples/galleryExamples/GalleryImageVersion_Create_WithVHD.json
if __name__ == "__main__":
    main()
