# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._ssh_public_keys_operations import (
    build_create_request,
    build_delete_request,
    build_generate_key_pair_request,
    build_get_request,
    build_list_by_resource_group_request,
    build_list_by_subscription_request,
    build_update_request,
)
from .._configuration import ComputeManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
List = list


class SshPublicKeysOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.compute.aio.ComputeManagementClient`'s
        :attr:`ssh_public_keys` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ComputeManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncItemPaged["_models.SshPublicKeyResource"]:
        """Lists all of the SSH public keys in the subscription. Use the nextLink property in the response
        to get the next page of SSH public keys.

        :return: An iterator like instance of either SshPublicKeyResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.compute.models.SshPublicKeyResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        cls: ClsType[_models.SshPublicKeysGroupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SshPublicKeysGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.SshPublicKeyResource"]:
        """Lists all of the SSH public keys in the specified resource group. Use the nextLink property in
        the response to get the next page of SSH public keys.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of either SshPublicKeyResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.compute.models.SshPublicKeyResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        cls: ClsType[_models.SshPublicKeysGroupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SshPublicKeysGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, ssh_public_key_name: str, **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Retrieves information about an SSH public key.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        cls: ClsType[_models.SshPublicKeyResource] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            ssh_public_key_name=ssh_public_key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SshPublicKeyResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: _models.SshPublicKeyResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Creates a new SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to create the SSH public key. Required.
        :type parameters: ~azure.mgmt.compute.models.SshPublicKeyResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Creates a new SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to create the SSH public key. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: Union[_models.SshPublicKeyResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Creates a new SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to create the SSH public key. Is either a
         SshPublicKeyResource type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.compute.models.SshPublicKeyResource or IO[bytes]
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SshPublicKeyResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SshPublicKeyResource")

        _request = build_create_request(
            resource_group_name=resource_group_name,
            ssh_public_key_name=ssh_public_key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SshPublicKeyResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: _models.SshPublicKeyUpdateResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Updates a new SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to update the SSH public key. Required.
        :type parameters: ~azure.mgmt.compute.models.SshPublicKeyUpdateResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Updates a new SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to update the SSH public key. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: Union[_models.SshPublicKeyUpdateResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SshPublicKeyResource:
        """Updates a new SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to update the SSH public key. Is either a
         SshPublicKeyUpdateResource type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.compute.models.SshPublicKeyUpdateResource or IO[bytes]
        :return: SshPublicKeyResource or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SshPublicKeyResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SshPublicKeyUpdateResource")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            ssh_public_key_name=ssh_public_key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SshPublicKeyResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, resource_group_name: str, ssh_public_key_name: str, **kwargs: Any) -> None:
        """Delete an SSH public key.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            ssh_public_key_name=ssh_public_key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def generate_key_pair(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: Optional[_models.SshGenerateKeyPairInputParameters] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SshPublicKeyGenerateKeyPairResult:
        """Generates and returns a public/private key pair and populates the SSH public key resource with
        the public key. The length of the key will be 3072 bits. This operation can only be performed
        once per SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to generate the SSH public key. Default value is None.
        :type parameters: ~azure.mgmt.compute.models.SshGenerateKeyPairInputParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SshPublicKeyGenerateKeyPairResult or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyGenerateKeyPairResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def generate_key_pair(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SshPublicKeyGenerateKeyPairResult:
        """Generates and returns a public/private key pair and populates the SSH public key resource with
        the public key. The length of the key will be 3072 bits. This operation can only be performed
        once per SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to generate the SSH public key. Default value is None.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SshPublicKeyGenerateKeyPairResult or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyGenerateKeyPairResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def generate_key_pair(
        self,
        resource_group_name: str,
        ssh_public_key_name: str,
        parameters: Optional[Union[_models.SshGenerateKeyPairInputParameters, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.SshPublicKeyGenerateKeyPairResult:
        """Generates and returns a public/private key pair and populates the SSH public key resource with
        the public key. The length of the key will be 3072 bits. This operation can only be performed
        once per SSH public key resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param ssh_public_key_name: The name of the SSH public key. Required.
        :type ssh_public_key_name: str
        :param parameters: Parameters supplied to generate the SSH public key. Is either a
         SshGenerateKeyPairInputParameters type or a IO[bytes] type. Default value is None.
        :type parameters: ~azure.mgmt.compute.models.SshGenerateKeyPairInputParameters or IO[bytes]
        :return: SshPublicKeyGenerateKeyPairResult or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.SshPublicKeyGenerateKeyPairResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if parameters else None
        cls: ClsType[_models.SshPublicKeyGenerateKeyPairResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if parameters else None
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "SshGenerateKeyPairInputParameters")
            else:
                _json = None

        _request = build_generate_key_pair_request(
            resource_group_name=resource_group_name,
            ssh_public_key_name=ssh_public_key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SshPublicKeyGenerateKeyPairResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
