# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing.aio import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingSubscriptionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_billing_profile(self, resource_group):
        response = await self.client.billing_subscriptions.get_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            billing_subscription_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_billing_profile(self, resource_group):
        response = self.client.billing_subscriptions.list_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_customer(self, resource_group):
        response = self.client.billing_subscriptions.list_by_customer(
            billing_account_name="str",
            billing_profile_name="str",
            customer_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_invoice_section(self, resource_group):
        response = self.client.billing_subscriptions.list_by_invoice_section(
            billing_account_name="str",
            billing_profile_name="str",
            invoice_section_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_cancel(self, resource_group):
        response = await (
            await self.client.billing_subscriptions.begin_cancel(
                billing_account_name="str",
                billing_subscription_name="str",
                parameters={"cancellationReason": "str", "customerId": "str"},
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_merge(self, resource_group):
        response = await (
            await self.client.billing_subscriptions.begin_merge(
                billing_account_name="str",
                billing_subscription_name="str",
                parameters={"quantity": 0, "targetBillingSubscriptionName": "str"},
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_move(self, resource_group):
        response = await (
            await self.client.billing_subscriptions.begin_move(
                billing_account_name="str",
                billing_subscription_name="str",
                parameters={"destinationEnrollmentAccountId": "str", "destinationInvoiceSectionId": "str"},
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_split(self, resource_group):
        response = await (
            await self.client.billing_subscriptions.begin_split(
                billing_account_name="str",
                billing_subscription_name="str",
                parameters={
                    "billingFrequency": "str",
                    "quantity": 0,
                    "targetProductTypeId": "str",
                    "targetSkuId": "str",
                    "termDuration": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_validate_move_eligibility(self, resource_group):
        response = await self.client.billing_subscriptions.validate_move_eligibility(
            billing_account_name="str",
            billing_subscription_name="str",
            parameters={"destinationEnrollmentAccountId": "str", "destinationInvoiceSectionId": "str"},
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.billing_subscriptions.begin_delete(
                billing_account_name="str",
                billing_subscription_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.billing_subscriptions.get(
            billing_account_name="str",
            billing_subscription_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.billing_subscriptions.begin_update(
                billing_account_name="str",
                billing_subscription_name="str",
                parameters={
                    "autoRenew": "str",
                    "beneficiary": {"objectId": "str", "tenantId": "str"},
                    "beneficiaryTenantId": "str",
                    "billingFrequency": "str",
                    "billingPolicies": {"str": "str"},
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingProfileName": "str",
                    "consumptionCostCenter": "str",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "customerName": "str",
                    "displayName": "str",
                    "enrollmentAccountDisplayName": "str",
                    "enrollmentAccountId": "str",
                    "enrollmentAccountStartDate": "2020-02-20 00:00:00",
                    "id": "str",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "invoiceSectionName": "str",
                    "lastMonthCharges": {"currency": "str", "value": 0.0},
                    "monthToDateCharges": {"currency": "str", "value": 0.0},
                    "name": "str",
                    "nextBillingCycleDetails": {"billingFrequency": "str"},
                    "offerId": "str",
                    "operationStatus": "str",
                    "productCategory": "str",
                    "productType": "str",
                    "productTypeId": "str",
                    "provisioningState": "str",
                    "provisioningTenantId": "str",
                    "purchaseDate": "2020-02-20 00:00:00",
                    "quantity": 0,
                    "renewalTermDetails": {
                        "billingFrequency": "str",
                        "productId": "str",
                        "productTypeId": "str",
                        "quantity": 0,
                        "skuId": "str",
                        "termDuration": "str",
                        "termEndDate": "2020-02-20 00:00:00",
                    },
                    "reseller": {"description": "str", "resellerId": "str"},
                    "resourceUri": "str",
                    "skuDescription": "str",
                    "skuId": "str",
                    "status": "str",
                    "subscriptionEnrollmentAccountStatus": "str",
                    "subscriptionId": "str",
                    "suspensionReasonDetails": [{"effectiveDate": "2020-02-20 00:00:00", "reason": "str"}],
                    "suspensionReasons": ["str"],
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "systemOverrides": {"cancellation": "str", "cancellationAllowedEndDate": "2020-02-20 00:00:00"},
                    "tags": {"str": "str"},
                    "termDuration": "str",
                    "termEndDate": "2020-02-20 00:00:00",
                    "termStartDate": "2020-02-20 00:00:00",
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_billing_account(self, resource_group):
        response = self.client.billing_subscriptions.list_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_customer_at_billing_account(self, resource_group):
        response = self.client.billing_subscriptions.list_by_customer_at_billing_account(
            billing_account_name="str",
            customer_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_enrollment_account(self, resource_group):
        response = self.client.billing_subscriptions.list_by_enrollment_account(
            billing_account_name="str",
            enrollment_account_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
