# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingAccountsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_add_payment_terms(self, resource_group):
        response = self.client.billing_accounts.begin_add_payment_terms(
            billing_account_name="str",
            parameters=[
                {"endDate": "2020-02-20 00:00:00", "isDefault": bool, "startDate": "2020-02-20 00:00:00", "term": "str"}
            ],
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_cancel_payment_terms(self, resource_group):
        response = self.client.billing_accounts.begin_cancel_payment_terms(
            billing_account_name="str",
            parameters="2020-02-20 00:00:00",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_confirm_transition(self, resource_group):
        response = self.client.billing_accounts.confirm_transition(
            billing_account_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_invoice_sections_by_create_subscription_permission(self, resource_group):
        response = self.client.billing_accounts.list_invoice_sections_by_create_subscription_permission(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_validate_payment_terms(self, resource_group):
        response = self.client.billing_accounts.validate_payment_terms(
            billing_account_name="str",
            parameters=[
                {"endDate": "2020-02-20 00:00:00", "isDefault": bool, "startDate": "2020-02-20 00:00:00", "term": "str"}
            ],
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.billing_accounts.get(
            billing_account_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.billing_accounts.begin_update(
            billing_account_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "accountStatus": "str",
                    "accountStatusReasonCode": "str",
                    "accountSubType": "str",
                    "accountType": "str",
                    "agreementType": "str",
                    "billingRelationshipTypes": ["str"],
                    "displayName": "str",
                    "enrollmentDetails": {
                        "billingCycle": "str",
                        "channel": "str",
                        "cloud": "str",
                        "countryCode": "str",
                        "currency": "str",
                        "endDate": "2020-02-20 00:00:00",
                        "extendedTermOption": "str",
                        "indirectRelationshipInfo": {
                            "billingAccountName": "str",
                            "billingProfileName": "str",
                            "displayName": "str",
                        },
                        "invoiceRecipient": "str",
                        "language": "str",
                        "markupStatus": "str",
                        "poNumber": "str",
                        "startDate": "2020-02-20 00:00:00",
                        "supportCoverage": "str",
                        "supportLevel": "str",
                    },
                    "hasNoBillingProfiles": bool,
                    "hasReadAccess": bool,
                    "notificationEmailAddress": "str",
                    "primaryBillingTenantId": "str",
                    "provisioningState": "str",
                    "qualifications": ["str"],
                    "registrationNumber": {"id": "str", "required": bool, "type": ["str"]},
                    "soldTo": {
                        "addressLine1": "str",
                        "country": "str",
                        "addressLine2": "str",
                        "addressLine3": "str",
                        "city": "str",
                        "companyName": "str",
                        "district": "str",
                        "email": "str",
                        "firstName": "str",
                        "isValidAddress": bool,
                        "lastName": "str",
                        "middleName": "str",
                        "phoneNumber": "str",
                        "postalCode": "str",
                        "region": "str",
                    },
                    "taxIds": [{"country": "str", "id": "str", "scope": "str", "status": "str", "type": "str"}],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.billing_accounts.list(
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
