# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AttestationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Intel Software Guard eXtensions.
    SGX_ENCLAVE = "SgxEnclave"
    #: OpenEnclave extensions to SGX.
    OPEN_ENCLAVE = "OpenEnclave"
    #: Edge TPM Virtualization Based Security.
    TPM = "Tpm"

class CertificateModification(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The result of the operation
    """

    #: After the operation was performed, the certificate is in the set of certificates.
    IS_PRESENT = "IsPresent"
    #: After the operation was performed, the certificate is no longer present in the set of
    #: certificates.
    IS_ABSENT = "IsAbsent"

class DataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the data encoded contained within the "data" field of a "RuntimeData" or
    "InitTimeData" object
    """

    #: The contents of the field should be treated as binary and not interpreted by MAA.
    BINARY = "Binary"
    #: The contents of the field should be treated as a JSON object and may be further interpreted by
    #: MAA.
    JSON = "JSON"

class PolicyModification(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The result of the operation
    """

    #: The specified policy object was updated.
    UPDATED = "Updated"
    #: The specified policy object was removed.
    REMOVED = "Removed"
