# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementComponentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_list(self, resource_group):
        response = self.client.components.list(
            api_version="2020-02-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_list_by_resource_group(self, resource_group):
        response = self.client.components.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2020-02-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_delete(self, resource_group):
        response = self.client.components.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2020-02-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_get(self, resource_group):
        response = self.client.components.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2020-02-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_create_or_update(self, resource_group):
        response = self.client.components.create_or_update(
            resource_group_name=resource_group.name,
            resource_name="str",
            insight_properties={
                "kind": "str",
                "location": "str",
                "AppId": "str",
                "ApplicationId": "str",
                "Application_Type": "web",
                "ConnectionString": "str",
                "CreationDate": "2020-02-20 00:00:00",
                "DisableIpMasking": bool,
                "DisableLocalAuth": bool,
                "Flow_Type": "Bluefield",
                "ForceCustomerStorageForProfiler": bool,
                "HockeyAppId": "str",
                "HockeyAppToken": "str",
                "ImmediatePurgeDataOn30Days": bool,
                "IngestionMode": "LogAnalytics",
                "InstrumentationKey": "str",
                "LaMigrationDate": "2020-02-20 00:00:00",
                "Name": "str",
                "PrivateLinkScopedResources": [{"ResourceId": "str", "ScopeId": "str"}],
                "Request_Source": "rest",
                "RetentionInDays": 0,
                "SamplingPercentage": 0.0,
                "TenantId": "str",
                "WorkspaceResourceId": "str",
                "etag": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "publicNetworkAccessForIngestion": "Enabled",
                "publicNetworkAccessForQuery": "Enabled",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2020-02-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_update_tags(self, resource_group):
        response = self.client.components.update_tags(
            resource_group_name=resource_group.name,
            resource_name="str",
            component_tags={"tags": {"str": "str"}},
            api_version="2020-02-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_purge(self, resource_group):
        response = self.client.components.purge(
            resource_group_name=resource_group.name,
            resource_name="str",
            body={"filters": [{"column": "str", "key": "str", "operator": "str", "value": {}}], "table": "str"},
            api_version="2020-02-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_components_get_purge_status(self, resource_group):
        response = self.client.components.get_purge_status(
            resource_group_name=resource_group.name,
            resource_name="str",
            purge_id="str",
            api_version="2020-02-02",
        )

        # please add some check logic here by yourself
        # ...
