# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementApiGatewayOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_gateway_begin_create_or_update(self, resource_group):
        response = self.client.api_gateway.begin_create_or_update(
            resource_group_name=resource_group.name,
            gateway_name="str",
            parameters={
                "location": "str",
                "sku": {"name": "str", "capacity": 0},
                "backend": {"subnet": {"id": "str"}},
                "configurationApi": {"hostname": "str"},
                "createdAtUtc": "2020-02-20 00:00:00",
                "etag": "str",
                "frontend": {"defaultHostname": "str"},
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "targetProvisioningState": "str",
                "type": "str",
                "virtualNetworkType": "str",
            },
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_gateway_begin_update(self, resource_group):
        response = self.client.api_gateway.begin_update(
            resource_group_name=resource_group.name,
            gateway_name="str",
            parameters={
                "backend": {"subnet": {"id": "str"}},
                "configurationApi": {"hostname": "str"},
                "createdAtUtc": "2020-02-20 00:00:00",
                "etag": "str",
                "frontend": {"defaultHostname": "str"},
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "sku": {"capacity": 0, "name": "str"},
                "tags": {"str": "str"},
                "targetProvisioningState": "str",
                "type": "str",
                "virtualNetworkType": "str",
            },
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_gateway_get(self, resource_group):
        response = self.client.api_gateway.get(
            resource_group_name=resource_group.name,
            gateway_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_gateway_begin_delete(self, resource_group):
        response = self.client.api_gateway.begin_delete(
            resource_group_name=resource_group.name,
            gateway_name="str",
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_gateway_list_by_resource_group(self, resource_group):
        response = self.client.api_gateway.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_gateway_list(self, resource_group):
        response = self.client.api_gateway.list(
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
