////////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2025 OVITO GmbH, Germany
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify it either under the
//  terms of the GNU General Public License version 3 as published by the Free Software
//  Foundation (the "GPL") or, at your option, under the terms of the MIT License.
//  If you do not alter this notice, a recipient may use your version of this
//  file under either the GPL or the MIT License.
//
//  You should have received a copy of the GPL along with this program in a
//  file LICENSE.GPL.txt.  You should have received a copy of the MIT License along
//  with this program in a file LICENSE.MIT.txt
//
//  This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
//  either express or implied. See the GPL or the MIT License for the specific language
//  governing rights and limitations.
//
////////////////////////////////////////////////////////////////////////////////////////

#pragma once


#include <ovito/gui/desktop/GUI.h>
#include <ovito/core/oo/RefTarget.h>
#include <ovito/gui/desktop/properties/PropertiesEditor.h>
#include <ovito/gui/desktop/widgets/general/RolloutContainer.h>

namespace Ovito {

/******************************************************************************
* This panel lets the user edit the properties of some RefTarget derived object.
******************************************************************************/
class OVITO_GUI_EXPORT PropertiesPanel : public RolloutContainer
{
    Q_OBJECT

public:

    /// Constructs the panel.
    explicit PropertiesPanel(MainWindow& mainWindow, QWidget* parent = nullptr);

    /// Destructs the panel.
    virtual ~PropertiesPanel();

    /// Returns the target object being edited in the panel.
    RefTarget* editObject() const;

    /// Sets the target object being edited in the panel.
    void setEditObject(RefTarget* editObject, OORef<PropertiesEditor> newEditor = {});

    /// Returns the editor that is responsible for the object being edited.
    PropertiesEditor* editor() const { return _editor; }

    /// Returns the main window this properties panel is associated with.
    MainWindow& mainWindow() const { return _mainWindow; }

public Q_SLOTS:

    /// Close the editor that is currently open.
    void close() { setEditObject(nullptr); }

protected:

    /// The editor for the current object.
    OORef<PropertiesEditor> _editor;

    /// The main window this properties panel is associated with.
    MainWindow& _mainWindow;
};

}   // End of namespace
