#pragma once
/*
 *  $Id: layer-utils.h 29060 2026-01-02 14:38:05Z yeti-dn $
 *  Copyright (C) 2012-2024; David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_LAYER_UTILS_H__
#define __GWYUI_LAYER_UTILS_H__

#include "libgwyui/gwydataview.h"

G_BEGIN_DECLS

#define PROXIMITY_DISTANCE 8.0
#define CROSS_SIZE 8.0

G_GNUC_INTERNAL
void _gwy_transform_line_to_target(GwyDataView *view,
                                   gdouble xfrom,
                                   gdouble yfrom,
                                   gdouble xto,
                                   gdouble yto,
                                   gdouble *xifrom,
                                   gdouble *yifrom,
                                   gdouble *xito,
                                   gdouble *yito);

G_GNUC_UNUSED
static gint
find_nearest_horizontally(gdouble x, G_GNUC_UNUSED gdouble y, gdouble *d2min,
                          const gdouble *coords, gint n,
                          const gdouble *metric)
{
    g_return_val_if_fail(n > 0, -1);
    g_return_val_if_fail(coords, -1);

    gdouble d2m = G_MAXDOUBLE, m0 = metric ? metric[0] : 1.0;
    gint m = -1;
    for (gint i = 0; i < n; i++, coords += 2) {
        gdouble v = coords[0] - x;
        gdouble d = v*v*m0;
        if (d < d2m) {
            d2m = d;
            m = i;
        }
    }
    if (d2min)
        *d2min = d2m;
    return m;
}

G_GNUC_UNUSED
static gint
find_nearest_vertically(G_GNUC_UNUSED gdouble x, gdouble y, gdouble *d2min,
                        const gdouble *coords, gint n,
                        const gdouble *metric)
{
    g_return_val_if_fail(n > 0, -1);
    g_return_val_if_fail(coords, -1);

    gdouble d2m = G_MAXDOUBLE, m3 = metric ? metric[3] : 1.0;
    gint m = -1;
    for (gint i = 0; i < n; i++, coords += 2) {
        gdouble v = coords[1] - y;
        gdouble d = v*v*m3;
        if (d < d2m) {
            d2m = d;
            m = i;
        }
    }
    if (d2min)
        *d2min = d2m;
    return m;
}

static inline gboolean
just_choose_object(GwyVectorLayer *layer, gint iobj)
{
    if (gwy_vector_layer_get_editable(layer))
        return FALSE;

    if (iobj >= 0)
        gwy_vector_layer_set_current_object(layer, iobj);
    return TRUE;
}

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
