#pragma once
/*
 *  $Id: unit.h 28911 2025-11-24 18:27:42Z yeti-dn $
 *  Copyright (C) 2004-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_UNIT_H__
#define __GWY_UNIT_H__

#include <glib-object.h>
#include <libgwyddion/value-format.h>

G_BEGIN_DECLS

typedef enum {
    GWY_UNIT_FORMAT_NONE      = 0,
    GWY_UNIT_FORMAT_PLAIN     = 1,
    GWY_UNIT_FORMAT_MARKUP    = 2,
    GWY_UNIT_FORMAT_VFMARKUP  = 3,
    GWY_UNIT_FORMAT_TEX       = 4,
    GWY_UNIT_FORMAT_VFTEX     = 5,
    GWY_UNIT_FORMAT_UNICODE   = 6,
    GWY_UNIT_FORMAT_VFUNICODE = 7,
} GwyUnitFormatStyle;

#define GWY_TYPE_UNIT            (gwy_unit_get_type())
#define GWY_UNIT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_UNIT, GwyUnit))
#define GWY_UNIT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_UNIT, GwyUnitClass))
#define GWY_IS_UNIT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_UNIT))
#define GWY_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_UNIT))
#define GWY_UNIT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_UNIT, GwyUnitClass))

typedef struct _GwyUnit GwyUnit;
typedef struct _GwyUnitClass GwyUnitClass;
typedef struct _GwyUnitPrivate GwyUnitPrivate;

struct _GwyUnit {
    GObject parent_instance;
    GwyUnitPrivate *priv;
};

struct _GwyUnitClass {
    GObjectClass parent_class;

    void (*value_changed)(GwyUnit *siunit);

    /*< private >*/
    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType           gwy_unit_get_type                  (void)                      G_GNUC_CONST;
GwyUnit*        gwy_unit_new                       (const gchar *unit_string)  G_GNUC_MALLOC;
GwyUnit*        gwy_unit_new_parse                 (const gchar *unit_string,
                                                    gint *power10);
void            gwy_unit_clear                     (GwyUnit *siunit);
gint            gwy_unit_set_from_string           (GwyUnit *siunit,
                                                    const gchar *unit_string);
gchar*          gwy_unit_get_string                (GwyUnit *siunit,
                                                    GwyUnitFormatStyle style);
GwyUnit*        gwy_unit_multiply                  (GwyUnit *siunit1,
                                                    GwyUnit *siunit2,
                                                    GwyUnit *result);
GwyUnit*        gwy_unit_divide                    (GwyUnit *siunit1,
                                                    GwyUnit *siunit2,
                                                    GwyUnit *result);
GwyUnit*        gwy_unit_power                     (GwyUnit *siunit,
                                                    gint power,
                                                    GwyUnit *result);
GwyUnit*        gwy_unit_nth_root                  (GwyUnit *siunit,
                                                    gint ipower,
                                                    GwyUnit *result);
GwyUnit*        gwy_unit_power_multiply            (GwyUnit *siunit1,
                                                    gint power1,
                                                    GwyUnit *siunit2,
                                                    gint power2,
                                                    GwyUnit *result);
GwyUnit*        gwy_unit_factor_to_base            (GwyUnit *siunit,
                                                    GwyUnit *result,
                                                    gdouble *mfactor);
gboolean        gwy_unit_equal                     (GwyUnit *siunit,
                                                    GwyUnit *siunit2);
gboolean        gwy_unit_equal_string              (GwyUnit *siunit,
                                                    const gchar *unit_string);
GwyValueFormat* gwy_unit_get_format                (GwyUnit *siunit,
                                                    GwyUnitFormatStyle style,
                                                    gdouble value,
                                                    GwyValueFormat *format);
GwyValueFormat* gwy_unit_get_format_for_power10    (GwyUnit *siunit,
                                                    GwyUnitFormatStyle style,
                                                    gint power10,
                                                    GwyValueFormat *format);
GwyValueFormat* gwy_unit_get_format_with_resolution(GwyUnit *siunit,
                                                    GwyUnitFormatStyle style,
                                                    gdouble maximum,
                                                    gdouble resolution,
                                                    GwyValueFormat *format);
GwyValueFormat* gwy_unit_get_format_with_digits    (GwyUnit *siunit,
                                                    GwyUnitFormatStyle style,
                                                    gdouble maximum,
                                                    gint sdigits,
                                                    GwyValueFormat *format);
GwyUnit*        gwy_unit_copy                      (GwyUnit *unit)             G_GNUC_MALLOC;
void            gwy_unit_assign                    (GwyUnit *destination,
                                                    GwyUnit *source);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
