// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/notifications/v1beta/notificationsapi.proto

package notificationspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum to specify the resource that is being changed to notify the merchant
// about.
type Resource int32

const (
	// Unspecified resource
	Resource_RESOURCE_UNSPECIFIED Resource = 0
	// Resource type : product
	Resource_PRODUCT Resource = 1
)

// Enum value maps for Resource.
var (
	Resource_name = map[int32]string{
		0: "RESOURCE_UNSPECIFIED",
		1: "PRODUCT",
	}
	Resource_value = map[string]int32{
		"RESOURCE_UNSPECIFIED": 0,
		"PRODUCT":              1,
	}
)

func (x Resource) Enum() *Resource {
	p := new(Resource)
	*p = x
	return p
}

func (x Resource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Resource) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes[0].Descriptor()
}

func (Resource) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes[0]
}

func (x Resource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Resource.Descriptor instead.
func (Resource) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{0}
}

// Enum to specify the attribute in the resource that is being changed to
// notify the merchant about.
type Attribute int32

const (
	// Unspecified attribute
	Attribute_ATTRIBUTE_UNSPECIFIED Attribute = 0
	// Status of the changed entity
	Attribute_STATUS Attribute = 1
)

// Enum value maps for Attribute.
var (
	Attribute_name = map[int32]string{
		0: "ATTRIBUTE_UNSPECIFIED",
		1: "STATUS",
	}
	Attribute_value = map[string]int32{
		"ATTRIBUTE_UNSPECIFIED": 0,
		"STATUS":                1,
	}
)

func (x Attribute) Enum() *Attribute {
	p := new(Attribute)
	*p = x
	return p
}

func (x Attribute) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Attribute) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes[1].Descriptor()
}

func (Attribute) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes[1]
}

func (x Attribute) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Attribute.Descriptor instead.
func (Attribute) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{1}
}

// Represents the event type that the merchant is interested in receiving
// notifications for.
type NotificationSubscription_NotificationEventType int32

const (
	// Notifications event type is unspecified.
	NotificationSubscription_NOTIFICATION_EVENT_TYPE_UNSPECIFIED NotificationSubscription_NotificationEventType = 0
	// Notification of product status changes, for example when product becomes
	// disapproved.
	NotificationSubscription_PRODUCT_STATUS_CHANGE NotificationSubscription_NotificationEventType = 1
)

// Enum value maps for NotificationSubscription_NotificationEventType.
var (
	NotificationSubscription_NotificationEventType_name = map[int32]string{
		0: "NOTIFICATION_EVENT_TYPE_UNSPECIFIED",
		1: "PRODUCT_STATUS_CHANGE",
	}
	NotificationSubscription_NotificationEventType_value = map[string]int32{
		"NOTIFICATION_EVENT_TYPE_UNSPECIFIED": 0,
		"PRODUCT_STATUS_CHANGE":               1,
	}
)

func (x NotificationSubscription_NotificationEventType) Enum() *NotificationSubscription_NotificationEventType {
	p := new(NotificationSubscription_NotificationEventType)
	*p = x
	return p
}

func (x NotificationSubscription_NotificationEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationSubscription_NotificationEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes[2].Descriptor()
}

func (NotificationSubscription_NotificationEventType) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes[2]
}

func (x NotificationSubscription_NotificationEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationSubscription_NotificationEventType.Descriptor instead.
func (NotificationSubscription_NotificationEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{6, 0}
}

// Request message for the GetNotificationSubscription method.
type GetNotificationSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` of the notification subscription.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNotificationSubscriptionRequest) Reset() {
	*x = GetNotificationSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNotificationSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotificationSubscriptionRequest) ProtoMessage() {}

func (x *GetNotificationSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotificationSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*GetNotificationSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{0}
}

func (x *GetNotificationSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the CreateNotificationSubscription method.
type CreateNotificationSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The merchant account that owns the new notification subscription.
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The notification subscription to create.
	NotificationSubscription *NotificationSubscription `protobuf:"bytes,2,opt,name=notification_subscription,json=notificationSubscription,proto3" json:"notification_subscription,omitempty"`
}

func (x *CreateNotificationSubscriptionRequest) Reset() {
	*x = CreateNotificationSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNotificationSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNotificationSubscriptionRequest) ProtoMessage() {}

func (x *CreateNotificationSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNotificationSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*CreateNotificationSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{1}
}

func (x *CreateNotificationSubscriptionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNotificationSubscriptionRequest) GetNotificationSubscription() *NotificationSubscription {
	if x != nil {
		return x.NotificationSubscription
	}
	return nil
}

// Request message for the UpdateNotificationSubscription method.
type UpdateNotificationSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new version of the notification subscription that should be
	// updated.
	NotificationSubscription *NotificationSubscription `protobuf:"bytes,1,opt,name=notification_subscription,json=notificationSubscription,proto3" json:"notification_subscription,omitempty"`
	// List of fields being updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNotificationSubscriptionRequest) Reset() {
	*x = UpdateNotificationSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNotificationSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNotificationSubscriptionRequest) ProtoMessage() {}

func (x *UpdateNotificationSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNotificationSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*UpdateNotificationSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateNotificationSubscriptionRequest) GetNotificationSubscription() *NotificationSubscription {
	if x != nil {
		return x.NotificationSubscription
	}
	return nil
}

func (x *UpdateNotificationSubscriptionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for the DeleteNotificationSubscription method.
type DeleteNotificationSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the notification subscription to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNotificationSubscriptionRequest) Reset() {
	*x = DeleteNotificationSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNotificationSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNotificationSubscriptionRequest) ProtoMessage() {}

func (x *DeleteNotificationSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNotificationSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*DeleteNotificationSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteNotificationSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListNotificationSubscription method.
type ListNotificationSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The merchant account who owns the notification subscriptions.
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of notification subscriptions to return in a page.
	// The default value for `page_size` is 100. The
	// maximum value is `200`. Values above `200` will be coerced to `200`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token (if provided) to retrieve the subsequent page. All other parameters
	// must match the original call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNotificationSubscriptionsRequest) Reset() {
	*x = ListNotificationSubscriptionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationSubscriptionsRequest) ProtoMessage() {}

func (x *ListNotificationSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*ListNotificationSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{4}
}

func (x *ListNotificationSubscriptionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNotificationSubscriptionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNotificationSubscriptionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the ListNotificationSubscription method.
type ListNotificationSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of notification subscriptions requested by the merchant.
	NotificationSubscriptions []*NotificationSubscription `protobuf:"bytes,1,rep,name=notification_subscriptions,json=notificationSubscriptions,proto3" json:"notification_subscriptions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNotificationSubscriptionsResponse) Reset() {
	*x = ListNotificationSubscriptionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationSubscriptionsResponse) ProtoMessage() {}

func (x *ListNotificationSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*ListNotificationSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{5}
}

func (x *ListNotificationSubscriptionsResponse) GetNotificationSubscriptions() []*NotificationSubscription {
	if x != nil {
		return x.NotificationSubscriptions
	}
	return nil
}

func (x *ListNotificationSubscriptionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a notification subscription owned by a Merchant account.
type NotificationSubscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to InterestedIn:
	//
	//	*NotificationSubscription_AllManagedAccounts
	//	*NotificationSubscription_TargetAccount
	InterestedIn isNotificationSubscription_InterestedIn `protobuf_oneof:"interested_in"`
	// Output only. The `name` of the notification configuration. Generated by the
	// Content API upon creation of a new `NotificationSubscription`. The
	// `account` represents the merchant ID of the merchant that owns the
	// configuration. Format:
	// `accounts/{account}/notificationsubscriptions/{notification_subscription}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The event that the merchant wants to be notified about.
	RegisteredEvent NotificationSubscription_NotificationEventType `protobuf:"varint,2,opt,name=registered_event,json=registeredEvent,proto3,enum=google.shopping.merchant.notifications.v1beta.NotificationSubscription_NotificationEventType" json:"registered_event,omitempty"`
	// URL to be used to push the notification to the merchant.
	CallBackUri string `protobuf:"bytes,5,opt,name=call_back_uri,json=callBackUri,proto3" json:"call_back_uri,omitempty"`
}

func (x *NotificationSubscription) Reset() {
	*x = NotificationSubscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationSubscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationSubscription) ProtoMessage() {}

func (x *NotificationSubscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationSubscription.ProtoReflect.Descriptor instead.
func (*NotificationSubscription) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{6}
}

func (m *NotificationSubscription) GetInterestedIn() isNotificationSubscription_InterestedIn {
	if m != nil {
		return m.InterestedIn
	}
	return nil
}

func (x *NotificationSubscription) GetAllManagedAccounts() bool {
	if x, ok := x.GetInterestedIn().(*NotificationSubscription_AllManagedAccounts); ok {
		return x.AllManagedAccounts
	}
	return false
}

func (x *NotificationSubscription) GetTargetAccount() string {
	if x, ok := x.GetInterestedIn().(*NotificationSubscription_TargetAccount); ok {
		return x.TargetAccount
	}
	return ""
}

func (x *NotificationSubscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NotificationSubscription) GetRegisteredEvent() NotificationSubscription_NotificationEventType {
	if x != nil {
		return x.RegisteredEvent
	}
	return NotificationSubscription_NOTIFICATION_EVENT_TYPE_UNSPECIFIED
}

func (x *NotificationSubscription) GetCallBackUri() string {
	if x != nil {
		return x.CallBackUri
	}
	return ""
}

type isNotificationSubscription_InterestedIn interface {
	isNotificationSubscription_InterestedIn()
}

type NotificationSubscription_AllManagedAccounts struct {
	// If this value is true, the requesting account is notified of the
	// specified event for all managed accounts (can be subaccounts or other
	// linked accounts) including newly added accounts on a daily basis.
	AllManagedAccounts bool `protobuf:"varint,3,opt,name=all_managed_accounts,json=allManagedAccounts,proto3,oneof"`
}

type NotificationSubscription_TargetAccount struct {
	// The `name` of the account you want to receive notifications for.
	// Format: `accounts/{account}`
	TargetAccount string `protobuf:"bytes,4,opt,name=target_account,json=targetAccount,proto3,oneof"`
}

func (*NotificationSubscription_AllManagedAccounts) isNotificationSubscription_InterestedIn() {}

func (*NotificationSubscription_TargetAccount) isNotificationSubscription_InterestedIn() {}

// The change that happened to the product including old value, new value,
// country code as the region code and reporting context.
type ProductChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The old value of the changed resource or attribute.
	OldValue *string `protobuf:"bytes,1,opt,name=old_value,json=oldValue,proto3,oneof" json:"old_value,omitempty"`
	// The new value of the changed resource or attribute.
	NewValue *string `protobuf:"bytes,2,opt,name=new_value,json=newValue,proto3,oneof" json:"new_value,omitempty"`
	// Countries that have the change (if applicable)
	RegionCode *string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3,oneof" json:"region_code,omitempty"`
	// Reporting contexts that have the change (if applicable)
	ReportingContext *typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,4,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum,oneof" json:"reporting_context,omitempty"`
}

func (x *ProductChange) Reset() {
	*x = ProductChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductChange) ProtoMessage() {}

func (x *ProductChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductChange.ProtoReflect.Descriptor instead.
func (*ProductChange) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{7}
}

func (x *ProductChange) GetOldValue() string {
	if x != nil && x.OldValue != nil {
		return *x.OldValue
	}
	return ""
}

func (x *ProductChange) GetNewValue() string {
	if x != nil && x.NewValue != nil {
		return *x.NewValue
	}
	return ""
}

func (x *ProductChange) GetRegionCode() string {
	if x != nil && x.RegionCode != nil {
		return *x.RegionCode
	}
	return ""
}

func (x *ProductChange) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil && x.ReportingContext != nil {
		return *x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

// The message that the merchant will receive to notify about product status
// change event
type ProductStatusChangeMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target account that owns the entity that changed.
	// Format : `accounts/{merchant_id}`
	Account *string `protobuf:"bytes,1,opt,name=account,proto3,oneof" json:"account,omitempty"`
	// The account that manages the merchant's account. can be the same as
	// merchant id if it is standalone account. Format :
	// `accounts/{service_provider_id}`
	ManagingAccount *string `protobuf:"bytes,2,opt,name=managing_account,json=managingAccount,proto3,oneof" json:"managing_account,omitempty"`
	// The resource that changed, in this case it will always be `Product`.
	ResourceType *Resource `protobuf:"varint,3,opt,name=resource_type,json=resourceType,proto3,enum=google.shopping.merchant.notifications.v1beta.Resource,oneof" json:"resource_type,omitempty"`
	// The attribute in the resource that changed, in this case it will be always
	// `Status`.
	Attribute *Attribute `protobuf:"varint,4,opt,name=attribute,proto3,enum=google.shopping.merchant.notifications.v1beta.Attribute,oneof" json:"attribute,omitempty"`
	// A message to describe the change that happened to the product
	Changes []*ProductChange `protobuf:"bytes,5,rep,name=changes,proto3" json:"changes,omitempty"`
	// The product id.
	ResourceId *string `protobuf:"bytes,6,opt,name=resource_id,json=resourceId,proto3,oneof" json:"resource_id,omitempty"`
	// The product name.
	// Format: `{product.name=accounts/{account}/products/{product}}`
	Resource *string `protobuf:"bytes,7,opt,name=resource,proto3,oneof" json:"resource,omitempty"`
}

func (x *ProductStatusChangeMessage) Reset() {
	*x = ProductStatusChangeMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductStatusChangeMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductStatusChangeMessage) ProtoMessage() {}

func (x *ProductStatusChangeMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductStatusChangeMessage.ProtoReflect.Descriptor instead.
func (*ProductStatusChangeMessage) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP(), []int{8}
}

func (x *ProductStatusChangeMessage) GetAccount() string {
	if x != nil && x.Account != nil {
		return *x.Account
	}
	return ""
}

func (x *ProductStatusChangeMessage) GetManagingAccount() string {
	if x != nil && x.ManagingAccount != nil {
		return *x.ManagingAccount
	}
	return ""
}

func (x *ProductStatusChangeMessage) GetResourceType() Resource {
	if x != nil && x.ResourceType != nil {
		return *x.ResourceType
	}
	return Resource_RESOURCE_UNSPECIFIED
}

func (x *ProductStatusChangeMessage) GetAttribute() Attribute {
	if x != nil && x.Attribute != nil {
		return *x.Attribute
	}
	return Attribute_ATTRIBUTE_UNSPECIFIED
}

func (x *ProductStatusChangeMessage) GetChanges() []*ProductChange {
	if x != nil {
		return x.Changes
	}
	return nil
}

func (x *ProductStatusChangeMessage) GetResourceId() string {
	if x != nil && x.ResourceId != nil {
		return *x.ResourceId
	}
	return ""
}

func (x *ProductStatusChangeMessage) GetResource() string {
	if x != nil && x.Resource != nil {
		return *x.Resource
	}
	return ""
}

var File_google_shopping_merchant_notifications_v1beta_notificationsapi_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x70, 0x69,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x75, 0x0a, 0x22, 0x47, 0x65, 0x74,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x88, 0x02, 0x0a, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x35, 0x12, 0x33, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x89, 0x01, 0x0a, 0x19, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x18, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf0, 0x01, 0x0a, 0x25,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x89, 0x01, 0x0a, 0x19, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x78,
	0x0a, 0x25, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x12, 0x33, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xd8, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x86, 0x01, 0x0a,
	0x1a, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb2, 0x04,
	0x0a, 0x18, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x14, 0x61, 0x6c,
	0x6c, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x27,
	0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x88, 0x01, 0x0a, 0x10, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0d, 0x63,
	0x61, 0x6c, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x63, 0x61, 0x6c, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x55, 0x72, 0x69, 0x22,
	0x5b, 0x0a, 0x15, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x4e, 0x4f, 0x54, 0x49,
	0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x55, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x01, 0x3a, 0x82, 0x01, 0xea,
	0x41, 0x7f, 0x0a, 0x33, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f,
	0x69, 0x6e, 0x22, 0xaa, 0x02, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x6f, 0x6c, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x08, 0x6e, 0x65, 0x77,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52,
	0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x6d,
	0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x48, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f,
	0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22,
	0xa8, 0x04, 0x0a, 0x1a, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d,
	0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a,
	0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x61, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x02, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x5b, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x48, 0x03, 0x52,
	0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a,
	0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x07, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x0a, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x0b, 0x0a,
	0x09, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2a, 0x31, 0x0a, 0x08, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x10, 0x01, 0x2a, 0x32, 0x0a,
	0x09, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x54,
	0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10,
	0x01, 0x32, 0xb5, 0x0c, 0x0a, 0x17, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8d, 0x02,
	0x0a, 0x1b, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcb, 0x02,
	0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x89, 0x01, 0xda, 0x41, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x19, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xea, 0x02, 0x0a, 0x1e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01,
	0xda, 0x41, 0x25, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x3a, 0x19,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x5d, 0x2f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x2a, 0x43, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa0, 0x02,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xe6, 0x01, 0xea, 0x41, 0x38, 0x0a,
	0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x15, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41, 0x70, 0x69, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x70, 0x62, 0x3b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescData = file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDesc
)

func file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescData)
	})
	return file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDescData
}

var file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_goTypes = []interface{}{
	(Resource)(0),  // 0: google.shopping.merchant.notifications.v1beta.Resource
	(Attribute)(0), // 1: google.shopping.merchant.notifications.v1beta.Attribute
	(NotificationSubscription_NotificationEventType)(0), // 2: google.shopping.merchant.notifications.v1beta.NotificationSubscription.NotificationEventType
	(*GetNotificationSubscriptionRequest)(nil),          // 3: google.shopping.merchant.notifications.v1beta.GetNotificationSubscriptionRequest
	(*CreateNotificationSubscriptionRequest)(nil),       // 4: google.shopping.merchant.notifications.v1beta.CreateNotificationSubscriptionRequest
	(*UpdateNotificationSubscriptionRequest)(nil),       // 5: google.shopping.merchant.notifications.v1beta.UpdateNotificationSubscriptionRequest
	(*DeleteNotificationSubscriptionRequest)(nil),       // 6: google.shopping.merchant.notifications.v1beta.DeleteNotificationSubscriptionRequest
	(*ListNotificationSubscriptionsRequest)(nil),        // 7: google.shopping.merchant.notifications.v1beta.ListNotificationSubscriptionsRequest
	(*ListNotificationSubscriptionsResponse)(nil),       // 8: google.shopping.merchant.notifications.v1beta.ListNotificationSubscriptionsResponse
	(*NotificationSubscription)(nil),                    // 9: google.shopping.merchant.notifications.v1beta.NotificationSubscription
	(*ProductChange)(nil),                               // 10: google.shopping.merchant.notifications.v1beta.ProductChange
	(*ProductStatusChangeMessage)(nil),                  // 11: google.shopping.merchant.notifications.v1beta.ProductStatusChangeMessage
	(*fieldmaskpb.FieldMask)(nil),                       // 12: google.protobuf.FieldMask
	(typepb.ReportingContext_ReportingContextEnum)(0),   // 13: google.shopping.type.ReportingContext.ReportingContextEnum
	(*emptypb.Empty)(nil),                               // 14: google.protobuf.Empty
}
var file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_depIdxs = []int32{
	9,  // 0: google.shopping.merchant.notifications.v1beta.CreateNotificationSubscriptionRequest.notification_subscription:type_name -> google.shopping.merchant.notifications.v1beta.NotificationSubscription
	9,  // 1: google.shopping.merchant.notifications.v1beta.UpdateNotificationSubscriptionRequest.notification_subscription:type_name -> google.shopping.merchant.notifications.v1beta.NotificationSubscription
	12, // 2: google.shopping.merchant.notifications.v1beta.UpdateNotificationSubscriptionRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 3: google.shopping.merchant.notifications.v1beta.ListNotificationSubscriptionsResponse.notification_subscriptions:type_name -> google.shopping.merchant.notifications.v1beta.NotificationSubscription
	2,  // 4: google.shopping.merchant.notifications.v1beta.NotificationSubscription.registered_event:type_name -> google.shopping.merchant.notifications.v1beta.NotificationSubscription.NotificationEventType
	13, // 5: google.shopping.merchant.notifications.v1beta.ProductChange.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	0,  // 6: google.shopping.merchant.notifications.v1beta.ProductStatusChangeMessage.resource_type:type_name -> google.shopping.merchant.notifications.v1beta.Resource
	1,  // 7: google.shopping.merchant.notifications.v1beta.ProductStatusChangeMessage.attribute:type_name -> google.shopping.merchant.notifications.v1beta.Attribute
	10, // 8: google.shopping.merchant.notifications.v1beta.ProductStatusChangeMessage.changes:type_name -> google.shopping.merchant.notifications.v1beta.ProductChange
	3,  // 9: google.shopping.merchant.notifications.v1beta.NotificationsApiService.GetNotificationSubscription:input_type -> google.shopping.merchant.notifications.v1beta.GetNotificationSubscriptionRequest
	4,  // 10: google.shopping.merchant.notifications.v1beta.NotificationsApiService.CreateNotificationSubscription:input_type -> google.shopping.merchant.notifications.v1beta.CreateNotificationSubscriptionRequest
	5,  // 11: google.shopping.merchant.notifications.v1beta.NotificationsApiService.UpdateNotificationSubscription:input_type -> google.shopping.merchant.notifications.v1beta.UpdateNotificationSubscriptionRequest
	6,  // 12: google.shopping.merchant.notifications.v1beta.NotificationsApiService.DeleteNotificationSubscription:input_type -> google.shopping.merchant.notifications.v1beta.DeleteNotificationSubscriptionRequest
	7,  // 13: google.shopping.merchant.notifications.v1beta.NotificationsApiService.ListNotificationSubscriptions:input_type -> google.shopping.merchant.notifications.v1beta.ListNotificationSubscriptionsRequest
	9,  // 14: google.shopping.merchant.notifications.v1beta.NotificationsApiService.GetNotificationSubscription:output_type -> google.shopping.merchant.notifications.v1beta.NotificationSubscription
	9,  // 15: google.shopping.merchant.notifications.v1beta.NotificationsApiService.CreateNotificationSubscription:output_type -> google.shopping.merchant.notifications.v1beta.NotificationSubscription
	9,  // 16: google.shopping.merchant.notifications.v1beta.NotificationsApiService.UpdateNotificationSubscription:output_type -> google.shopping.merchant.notifications.v1beta.NotificationSubscription
	14, // 17: google.shopping.merchant.notifications.v1beta.NotificationsApiService.DeleteNotificationSubscription:output_type -> google.protobuf.Empty
	8,  // 18: google.shopping.merchant.notifications.v1beta.NotificationsApiService.ListNotificationSubscriptions:output_type -> google.shopping.merchant.notifications.v1beta.ListNotificationSubscriptionsResponse
	14, // [14:19] is the sub-list for method output_type
	9,  // [9:14] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_init() }
func file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_init() {
	if File_google_shopping_merchant_notifications_v1beta_notificationsapi_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNotificationSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNotificationSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNotificationSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNotificationSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationSubscriptionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationSubscriptionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationSubscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductStatusChangeMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*NotificationSubscription_AllManagedAccounts)(nil),
		(*NotificationSubscription_TargetAccount)(nil),
	}
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes[8].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_notifications_v1beta_notificationsapi_proto = out.File
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_rawDesc = nil
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_goTypes = nil
	file_google_shopping_merchant_notifications_v1beta_notificationsapi_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NotificationsApiServiceClient is the client API for NotificationsApiService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NotificationsApiServiceClient interface {
	// Gets notification subscriptions for an account.
	GetNotificationSubscription(ctx context.Context, in *GetNotificationSubscriptionRequest, opts ...grpc.CallOption) (*NotificationSubscription, error)
	// Creates a notification subscription for a merchant. We will allow the
	// following types of notification subscriptions to exist together (per
	// merchant as a subscriber per event type):
	// 1. Subscription for all managed accounts + subscription for self
	// 2. Multiple "partial" subscriptions for managed accounts + subscription
	// for self
	//
	// we will not allow (per merchant as a subscriber per event type):
	// 1. multiple self subscriptions.
	// 2. multiple "all managed accounts" subscriptions.
	// 3. all and partial subscriptions at the same time.
	// 4. multiple partial subscriptions for the same target account
	CreateNotificationSubscription(ctx context.Context, in *CreateNotificationSubscriptionRequest, opts ...grpc.CallOption) (*NotificationSubscription, error)
	// Updates an existing notification subscription for a merchant.
	UpdateNotificationSubscription(ctx context.Context, in *UpdateNotificationSubscriptionRequest, opts ...grpc.CallOption) (*NotificationSubscription, error)
	// Deletes a notification subscription for a merchant.
	DeleteNotificationSubscription(ctx context.Context, in *DeleteNotificationSubscriptionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets all the notification subscriptions for a merchant.
	ListNotificationSubscriptions(ctx context.Context, in *ListNotificationSubscriptionsRequest, opts ...grpc.CallOption) (*ListNotificationSubscriptionsResponse, error)
}

type notificationsApiServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNotificationsApiServiceClient(cc grpc.ClientConnInterface) NotificationsApiServiceClient {
	return &notificationsApiServiceClient{cc}
}

func (c *notificationsApiServiceClient) GetNotificationSubscription(ctx context.Context, in *GetNotificationSubscriptionRequest, opts ...grpc.CallOption) (*NotificationSubscription, error) {
	out := new(NotificationSubscription)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/GetNotificationSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationsApiServiceClient) CreateNotificationSubscription(ctx context.Context, in *CreateNotificationSubscriptionRequest, opts ...grpc.CallOption) (*NotificationSubscription, error) {
	out := new(NotificationSubscription)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/CreateNotificationSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationsApiServiceClient) UpdateNotificationSubscription(ctx context.Context, in *UpdateNotificationSubscriptionRequest, opts ...grpc.CallOption) (*NotificationSubscription, error) {
	out := new(NotificationSubscription)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/UpdateNotificationSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationsApiServiceClient) DeleteNotificationSubscription(ctx context.Context, in *DeleteNotificationSubscriptionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/DeleteNotificationSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationsApiServiceClient) ListNotificationSubscriptions(ctx context.Context, in *ListNotificationSubscriptionsRequest, opts ...grpc.CallOption) (*ListNotificationSubscriptionsResponse, error) {
	out := new(ListNotificationSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/ListNotificationSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NotificationsApiServiceServer is the server API for NotificationsApiService service.
type NotificationsApiServiceServer interface {
	// Gets notification subscriptions for an account.
	GetNotificationSubscription(context.Context, *GetNotificationSubscriptionRequest) (*NotificationSubscription, error)
	// Creates a notification subscription for a merchant. We will allow the
	// following types of notification subscriptions to exist together (per
	// merchant as a subscriber per event type):
	// 1. Subscription for all managed accounts + subscription for self
	// 2. Multiple "partial" subscriptions for managed accounts + subscription
	// for self
	//
	// we will not allow (per merchant as a subscriber per event type):
	// 1. multiple self subscriptions.
	// 2. multiple "all managed accounts" subscriptions.
	// 3. all and partial subscriptions at the same time.
	// 4. multiple partial subscriptions for the same target account
	CreateNotificationSubscription(context.Context, *CreateNotificationSubscriptionRequest) (*NotificationSubscription, error)
	// Updates an existing notification subscription for a merchant.
	UpdateNotificationSubscription(context.Context, *UpdateNotificationSubscriptionRequest) (*NotificationSubscription, error)
	// Deletes a notification subscription for a merchant.
	DeleteNotificationSubscription(context.Context, *DeleteNotificationSubscriptionRequest) (*emptypb.Empty, error)
	// Gets all the notification subscriptions for a merchant.
	ListNotificationSubscriptions(context.Context, *ListNotificationSubscriptionsRequest) (*ListNotificationSubscriptionsResponse, error)
}

// UnimplementedNotificationsApiServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNotificationsApiServiceServer struct {
}

func (*UnimplementedNotificationsApiServiceServer) GetNotificationSubscription(context.Context, *GetNotificationSubscriptionRequest) (*NotificationSubscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationSubscription not implemented")
}
func (*UnimplementedNotificationsApiServiceServer) CreateNotificationSubscription(context.Context, *CreateNotificationSubscriptionRequest) (*NotificationSubscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotificationSubscription not implemented")
}
func (*UnimplementedNotificationsApiServiceServer) UpdateNotificationSubscription(context.Context, *UpdateNotificationSubscriptionRequest) (*NotificationSubscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationSubscription not implemented")
}
func (*UnimplementedNotificationsApiServiceServer) DeleteNotificationSubscription(context.Context, *DeleteNotificationSubscriptionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotificationSubscription not implemented")
}
func (*UnimplementedNotificationsApiServiceServer) ListNotificationSubscriptions(context.Context, *ListNotificationSubscriptionsRequest) (*ListNotificationSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationSubscriptions not implemented")
}

func RegisterNotificationsApiServiceServer(s *grpc.Server, srv NotificationsApiServiceServer) {
	s.RegisterService(&_NotificationsApiService_serviceDesc, srv)
}

func _NotificationsApiService_GetNotificationSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationsApiServiceServer).GetNotificationSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/GetNotificationSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationsApiServiceServer).GetNotificationSubscription(ctx, req.(*GetNotificationSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationsApiService_CreateNotificationSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationsApiServiceServer).CreateNotificationSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/CreateNotificationSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationsApiServiceServer).CreateNotificationSubscription(ctx, req.(*CreateNotificationSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationsApiService_UpdateNotificationSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationsApiServiceServer).UpdateNotificationSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/UpdateNotificationSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationsApiServiceServer).UpdateNotificationSubscription(ctx, req.(*UpdateNotificationSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationsApiService_DeleteNotificationSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationsApiServiceServer).DeleteNotificationSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/DeleteNotificationSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationsApiServiceServer).DeleteNotificationSubscription(ctx, req.(*DeleteNotificationSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationsApiService_ListNotificationSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationsApiServiceServer).ListNotificationSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.notifications.v1beta.NotificationsApiService/ListNotificationSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationsApiServiceServer).ListNotificationSubscriptions(ctx, req.(*ListNotificationSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NotificationsApiService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.notifications.v1beta.NotificationsApiService",
	HandlerType: (*NotificationsApiServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNotificationSubscription",
			Handler:    _NotificationsApiService_GetNotificationSubscription_Handler,
		},
		{
			MethodName: "CreateNotificationSubscription",
			Handler:    _NotificationsApiService_CreateNotificationSubscription_Handler,
		},
		{
			MethodName: "UpdateNotificationSubscription",
			Handler:    _NotificationsApiService_UpdateNotificationSubscription_Handler,
		},
		{
			MethodName: "DeleteNotificationSubscription",
			Handler:    _NotificationsApiService_DeleteNotificationSubscription_Handler,
		},
		{
			MethodName: "ListNotificationSubscriptions",
			Handler:    _NotificationsApiService_ListNotificationSubscriptions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/notifications/v1beta/notificationsapi.proto",
}
