// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/retail/v2/export_config.proto

package retailpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The output configuration setting.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration of destination for holding output data.
	//
	// Types that are assignable to Destination:
	//
	//	*OutputConfig_GcsDestination_
	//	*OutputConfig_BigqueryDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{0}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *OutputConfig_GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBigqueryDestination() *OutputConfig_BigQueryDestination {
	if x, ok := x.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination_ struct {
	// The Google Cloud Storage location where the output is to be written to.
	GcsDestination *OutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	// The BigQuery location where the output is to be written to.
	BigqueryDestination *OutputConfig_BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination_) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

// Configuration of destination for Export related errors.
type ExportErrorsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Errors destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportErrorsConfig_GcsPrefix
	Destination isExportErrorsConfig_Destination `protobuf_oneof:"destination"`
}

func (x *ExportErrorsConfig) Reset() {
	*x = ExportErrorsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportErrorsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportErrorsConfig) ProtoMessage() {}

func (x *ExportErrorsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportErrorsConfig.ProtoReflect.Descriptor instead.
func (*ExportErrorsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{1}
}

func (m *ExportErrorsConfig) GetDestination() isExportErrorsConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportErrorsConfig) GetGcsPrefix() string {
	if x, ok := x.GetDestination().(*ExportErrorsConfig_GcsPrefix); ok {
		return x.GcsPrefix
	}
	return ""
}

type isExportErrorsConfig_Destination interface {
	isExportErrorsConfig_Destination()
}

type ExportErrorsConfig_GcsPrefix struct {
	// Google Cloud Storage path for import errors. This must be an empty,
	// existing Cloud Storage bucket. Export errors will be written to a file in
	// this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3,oneof"`
}

func (*ExportErrorsConfig_GcsPrefix) isExportErrorsConfig_Destination() {}

// Request message for the `ExportAnalyticsMetrics` method.
type ExportAnalyticsMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of the parent catalog.
	// Expected format: `projects/*/locations/*/catalogs/*`
	Catalog string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
	// Required. The output location of the data.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A filtering expression to specify restrictions on returned metrics.
	// The expression is a sequence of terms. Each term applies a restriction to
	// the returned metrics. Use this expression to restrict results to a
	// specific time range.
	//
	//	Currently we expect only one types of fields:
	//
	//	 * `timestamp`: This can be specified twice, once with a
	//	   less than operator and once with a greater than operator. The
	//	   `timestamp` restriction should result in one, contiguous, valid,
	//	   `timestamp` range.
	//
	//	Some examples of valid filters expressions:
	//
	//	* Example 1: `timestamp > "2012-04-23T18:25:43.511Z"
	//	          timestamp < "2012-04-23T18:30:43.511Z"`
	//	* Example 2: `timestamp > "2012-04-23T18:25:43.511Z"`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ExportAnalyticsMetricsRequest) Reset() {
	*x = ExportAnalyticsMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAnalyticsMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAnalyticsMetricsRequest) ProtoMessage() {}

func (x *ExportAnalyticsMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAnalyticsMetricsRequest.ProtoReflect.Descriptor instead.
func (*ExportAnalyticsMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{2}
}

func (x *ExportAnalyticsMetricsRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

func (x *ExportAnalyticsMetricsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAnalyticsMetricsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Metadata related to the progress of the Export operation. This is
// returned by the google.longrunning.Operation.metadata field.
type ExportMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ExportMetadata) Reset() {
	*x = ExportMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportMetadata) ProtoMessage() {}

func (x *ExportMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportMetadata.ProtoReflect.Descriptor instead.
func (*ExportMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{3}
}

func (x *ExportMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExportMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Response of the ExportAnalyticsMetricsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ExportAnalyticsMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// This field is never set.
	ErrorsConfig *ExportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Output result indicating where the data were exported to.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportAnalyticsMetricsResponse) Reset() {
	*x = ExportAnalyticsMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAnalyticsMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAnalyticsMetricsResponse) ProtoMessage() {}

func (x *ExportAnalyticsMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAnalyticsMetricsResponse.ProtoReflect.Descriptor instead.
func (*ExportAnalyticsMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{4}
}

func (x *ExportAnalyticsMetricsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ExportAnalyticsMetricsResponse) GetErrorsConfig() *ExportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

func (x *ExportAnalyticsMetricsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// Output result that stores the information about where the exported data is
// stored.
type OutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BigQuery location where the result is stored.
	BigqueryResult []*BigQueryOutputResult `protobuf:"bytes,1,rep,name=bigquery_result,json=bigqueryResult,proto3" json:"bigquery_result,omitempty"`
	// The Google Cloud Storage location where the result is stored.
	GcsResult []*GcsOutputResult `protobuf:"bytes,2,rep,name=gcs_result,json=gcsResult,proto3" json:"gcs_result,omitempty"`
}

func (x *OutputResult) Reset() {
	*x = OutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputResult) ProtoMessage() {}

func (x *OutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputResult.ProtoReflect.Descriptor instead.
func (*OutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{5}
}

func (x *OutputResult) GetBigqueryResult() []*BigQueryOutputResult {
	if x != nil {
		return x.BigqueryResult
	}
	return nil
}

func (x *OutputResult) GetGcsResult() []*GcsOutputResult {
	if x != nil {
		return x.GcsResult
	}
	return nil
}

// A BigQuery output result.
type BigQueryOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a BigQuery Dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The ID of a BigQuery Table.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
}

func (x *BigQueryOutputResult) Reset() {
	*x = BigQueryOutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryOutputResult) ProtoMessage() {}

func (x *BigQueryOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryOutputResult.ProtoReflect.Descriptor instead.
func (*BigQueryOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{6}
}

func (x *BigQueryOutputResult) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *BigQueryOutputResult) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

// A Gcs output result.
type GcsOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The uri of Gcs output
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *GcsOutputResult) Reset() {
	*x = GcsOutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsOutputResult) ProtoMessage() {}

func (x *GcsOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsOutputResult.ProtoReflect.Descriptor instead.
func (*GcsOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{7}
}

func (x *GcsOutputResult) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

// The Google Cloud Storage output destination configuration.
type OutputConfig_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The output uri prefix for saving output data to json files.
	// Some mapping examples are as follows:
	// output_uri_prefix         sample output(assuming the object is foo.json)
	// ========================  =============================================
	// gs://bucket/              gs://bucket/foo.json
	// gs://bucket/folder/       gs://bucket/folder/foo.json
	// gs://bucket/folder/item_  gs://bucket/folder/item_foo.json
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *OutputConfig_GcsDestination) Reset() {
	*x = OutputConfig_GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig_GcsDestination) ProtoMessage() {}

func (x *OutputConfig_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig_GcsDestination.ProtoReflect.Descriptor instead.
func (*OutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *OutputConfig_GcsDestination) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// The BigQuery output destination configuration.
type OutputConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of a BigQuery Dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The prefix of exported BigQuery tables.
	TableIdPrefix string `protobuf:"bytes,2,opt,name=table_id_prefix,json=tableIdPrefix,proto3" json:"table_id_prefix,omitempty"`
	// Required. Describes the table type. The following values are supported:
	//
	// * `table`: A BigQuery native table.
	// * `view`: A virtual table defined by a SQL query.
	TableType string `protobuf:"bytes,3,opt,name=table_type,json=tableType,proto3" json:"table_type,omitempty"`
}

func (x *OutputConfig_BigQueryDestination) Reset() {
	*x = OutputConfig_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig_BigQueryDestination) ProtoMessage() {}

func (x *OutputConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_export_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*OutputConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_export_config_proto_rawDescGZIP(), []int{0, 1}
}

func (x *OutputConfig_BigQueryDestination) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *OutputConfig_BigQueryDestination) GetTableIdPrefix() string {
	if x != nil {
		return x.TableIdPrefix
	}
	return ""
}

func (x *OutputConfig_BigQueryDestination) GetTableType() string {
	if x != nil {
		return x.TableType
	}
	return ""
}

var File_google_cloud_retail_v2_export_config_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2_export_config_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbc, 0x03, 0x0a, 0x0c, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x0f, 0x67,
	0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x14, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x41, 0x0a, 0x0e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x8a, 0x01,
	0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x0f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x0a, 0x12, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1f, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa6, 0x01, 0x0a, 0x1d, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x12, 0x4e, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x0e, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf5, 0x01, 0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x49, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xad, 0x01,
	0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x55,
	0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x46, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x2e, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x09, 0x67, 0x63, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x50, 0x0a,
	0x14, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x22,
	0x30, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72,
	0x69, 0x42, 0xbc, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x42, 0x11, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62,
	0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41,
	0x49, 0x4c, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x16, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2_export_config_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2_export_config_proto_rawDescData = file_google_cloud_retail_v2_export_config_proto_rawDesc
)

func file_google_cloud_retail_v2_export_config_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2_export_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2_export_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2_export_config_proto_rawDescData)
	})
	return file_google_cloud_retail_v2_export_config_proto_rawDescData
}

var file_google_cloud_retail_v2_export_config_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_retail_v2_export_config_proto_goTypes = []interface{}{
	(*OutputConfig)(nil),                     // 0: google.cloud.retail.v2.OutputConfig
	(*ExportErrorsConfig)(nil),               // 1: google.cloud.retail.v2.ExportErrorsConfig
	(*ExportAnalyticsMetricsRequest)(nil),    // 2: google.cloud.retail.v2.ExportAnalyticsMetricsRequest
	(*ExportMetadata)(nil),                   // 3: google.cloud.retail.v2.ExportMetadata
	(*ExportAnalyticsMetricsResponse)(nil),   // 4: google.cloud.retail.v2.ExportAnalyticsMetricsResponse
	(*OutputResult)(nil),                     // 5: google.cloud.retail.v2.OutputResult
	(*BigQueryOutputResult)(nil),             // 6: google.cloud.retail.v2.BigQueryOutputResult
	(*GcsOutputResult)(nil),                  // 7: google.cloud.retail.v2.GcsOutputResult
	(*OutputConfig_GcsDestination)(nil),      // 8: google.cloud.retail.v2.OutputConfig.GcsDestination
	(*OutputConfig_BigQueryDestination)(nil), // 9: google.cloud.retail.v2.OutputConfig.BigQueryDestination
	(*timestamppb.Timestamp)(nil),            // 10: google.protobuf.Timestamp
	(*status.Status)(nil),                    // 11: google.rpc.Status
}
var file_google_cloud_retail_v2_export_config_proto_depIdxs = []int32{
	8,  // 0: google.cloud.retail.v2.OutputConfig.gcs_destination:type_name -> google.cloud.retail.v2.OutputConfig.GcsDestination
	9,  // 1: google.cloud.retail.v2.OutputConfig.bigquery_destination:type_name -> google.cloud.retail.v2.OutputConfig.BigQueryDestination
	0,  // 2: google.cloud.retail.v2.ExportAnalyticsMetricsRequest.output_config:type_name -> google.cloud.retail.v2.OutputConfig
	10, // 3: google.cloud.retail.v2.ExportMetadata.create_time:type_name -> google.protobuf.Timestamp
	10, // 4: google.cloud.retail.v2.ExportMetadata.update_time:type_name -> google.protobuf.Timestamp
	11, // 5: google.cloud.retail.v2.ExportAnalyticsMetricsResponse.error_samples:type_name -> google.rpc.Status
	1,  // 6: google.cloud.retail.v2.ExportAnalyticsMetricsResponse.errors_config:type_name -> google.cloud.retail.v2.ExportErrorsConfig
	5,  // 7: google.cloud.retail.v2.ExportAnalyticsMetricsResponse.output_result:type_name -> google.cloud.retail.v2.OutputResult
	6,  // 8: google.cloud.retail.v2.OutputResult.bigquery_result:type_name -> google.cloud.retail.v2.BigQueryOutputResult
	7,  // 9: google.cloud.retail.v2.OutputResult.gcs_result:type_name -> google.cloud.retail.v2.GcsOutputResult
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2_export_config_proto_init() }
func file_google_cloud_retail_v2_export_config_proto_init() {
	if File_google_cloud_retail_v2_export_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2_export_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportErrorsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAnalyticsMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAnalyticsMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryOutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsOutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig_GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_export_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_retail_v2_export_config_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination_)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_retail_v2_export_config_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ExportErrorsConfig_GcsPrefix)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2_export_config_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2_export_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2_export_config_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2_export_config_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2_export_config_proto = out.File
	file_google_cloud_retail_v2_export_config_proto_rawDesc = nil
	file_google_cloud_retail_v2_export_config_proto_goTypes = nil
	file_google_cloud_retail_v2_export_config_proto_depIdxs = nil
}
