//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armvmwarecloudsimple.ClientFactory type.
type ServerFactory struct {
	CustomizationPoliciesServer   CustomizationPoliciesServer
	DedicatedCloudNodesServer     DedicatedCloudNodesServer
	DedicatedCloudServicesServer  DedicatedCloudServicesServer
	OperationsServer              OperationsServer
	PrivateCloudsServer           PrivateCloudsServer
	ResourcePoolsServer           ResourcePoolsServer
	SKUsAvailabilityServer        SKUsAvailabilityServer
	UsagesServer                  UsagesServer
	VirtualMachineTemplatesServer VirtualMachineTemplatesServer
	VirtualMachinesServer         VirtualMachinesServer
	VirtualNetworksServer         VirtualNetworksServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armvmwarecloudsimple.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armvmwarecloudsimple.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                             *ServerFactory
	trMu                            sync.Mutex
	trCustomizationPoliciesServer   *CustomizationPoliciesServerTransport
	trDedicatedCloudNodesServer     *DedicatedCloudNodesServerTransport
	trDedicatedCloudServicesServer  *DedicatedCloudServicesServerTransport
	trOperationsServer              *OperationsServerTransport
	trPrivateCloudsServer           *PrivateCloudsServerTransport
	trResourcePoolsServer           *ResourcePoolsServerTransport
	trSKUsAvailabilityServer        *SKUsAvailabilityServerTransport
	trUsagesServer                  *UsagesServerTransport
	trVirtualMachineTemplatesServer *VirtualMachineTemplatesServerTransport
	trVirtualMachinesServer         *VirtualMachinesServerTransport
	trVirtualNetworksServer         *VirtualNetworksServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "CustomizationPoliciesClient":
		initServer(s, &s.trCustomizationPoliciesServer, func() *CustomizationPoliciesServerTransport {
			return NewCustomizationPoliciesServerTransport(&s.srv.CustomizationPoliciesServer)
		})
		resp, err = s.trCustomizationPoliciesServer.Do(req)
	case "DedicatedCloudNodesClient":
		initServer(s, &s.trDedicatedCloudNodesServer, func() *DedicatedCloudNodesServerTransport {
			return NewDedicatedCloudNodesServerTransport(&s.srv.DedicatedCloudNodesServer)
		})
		resp, err = s.trDedicatedCloudNodesServer.Do(req)
	case "DedicatedCloudServicesClient":
		initServer(s, &s.trDedicatedCloudServicesServer, func() *DedicatedCloudServicesServerTransport {
			return NewDedicatedCloudServicesServerTransport(&s.srv.DedicatedCloudServicesServer)
		})
		resp, err = s.trDedicatedCloudServicesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateCloudsClient":
		initServer(s, &s.trPrivateCloudsServer, func() *PrivateCloudsServerTransport {
			return NewPrivateCloudsServerTransport(&s.srv.PrivateCloudsServer)
		})
		resp, err = s.trPrivateCloudsServer.Do(req)
	case "ResourcePoolsClient":
		initServer(s, &s.trResourcePoolsServer, func() *ResourcePoolsServerTransport {
			return NewResourcePoolsServerTransport(&s.srv.ResourcePoolsServer)
		})
		resp, err = s.trResourcePoolsServer.Do(req)
	case "SKUsAvailabilityClient":
		initServer(s, &s.trSKUsAvailabilityServer, func() *SKUsAvailabilityServerTransport {
			return NewSKUsAvailabilityServerTransport(&s.srv.SKUsAvailabilityServer)
		})
		resp, err = s.trSKUsAvailabilityServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	case "VirtualMachineTemplatesClient":
		initServer(s, &s.trVirtualMachineTemplatesServer, func() *VirtualMachineTemplatesServerTransport {
			return NewVirtualMachineTemplatesServerTransport(&s.srv.VirtualMachineTemplatesServer)
		})
		resp, err = s.trVirtualMachineTemplatesServer.Do(req)
	case "VirtualMachinesClient":
		initServer(s, &s.trVirtualMachinesServer, func() *VirtualMachinesServerTransport {
			return NewVirtualMachinesServerTransport(&s.srv.VirtualMachinesServer)
		})
		resp, err = s.trVirtualMachinesServer.Do(req)
	case "VirtualNetworksClient":
		initServer(s, &s.trVirtualNetworksServer, func() *VirtualNetworksServerTransport {
			return NewVirtualNetworksServerTransport(&s.srv.VirtualNetworksServer)
		})
		resp, err = s.trVirtualNetworksServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
