//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkanalytics

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DataTypesClient contains the methods for the DataTypes group.
// Don't use this type directly, use NewDataTypesClient() instead.
type DataTypesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDataTypesClient creates a new instance of DataTypesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDataTypesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DataTypesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DataTypesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Create data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - dataTypeName - The data type name.
//   - resource - Resource create parameters.
//   - options - DataTypesClientBeginCreateOptions contains the optional parameters for the DataTypesClient.BeginCreate method.
func (client *DataTypesClient) BeginCreate(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, resource DataType, options *DataTypesClientBeginCreateOptions) (*runtime.Poller[DataTypesClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, dataProductName, dataTypeName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataTypesClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataTypesClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataTypesClient) create(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, resource DataType, options *DataTypesClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "DataTypesClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, dataProductName, dataTypeName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *DataTypesClient) createCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, resource DataType, options *DataTypesClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	if dataTypeName == "" {
		return nil, errors.New("parameter dataTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataTypeName}", url.PathEscape(dataTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - dataTypeName - The data type name.
//   - options - DataTypesClientBeginDeleteOptions contains the optional parameters for the DataTypesClient.BeginDelete method.
func (client *DataTypesClient) BeginDelete(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *DataTypesClientBeginDeleteOptions) (*runtime.Poller[DataTypesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, dataProductName, dataTypeName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataTypesClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataTypesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataTypesClient) deleteOperation(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *DataTypesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "DataTypesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, dataProductName, dataTypeName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DataTypesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *DataTypesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	if dataTypeName == "" {
		return nil, errors.New("parameter dataTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataTypeName}", url.PathEscape(dataTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteData - Delete data for data type.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - dataTypeName - The data type name.
//   - body - The content of the action request
//   - options - DataTypesClientBeginDeleteDataOptions contains the optional parameters for the DataTypesClient.BeginDeleteData
//     method.
func (client *DataTypesClient) BeginDeleteData(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body any, options *DataTypesClientBeginDeleteDataOptions) (*runtime.Poller[DataTypesClientDeleteDataResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteData(ctx, resourceGroupName, dataProductName, dataTypeName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataTypesClientDeleteDataResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataTypesClientDeleteDataResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteData - Delete data for data type.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataTypesClient) deleteData(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body any, options *DataTypesClientBeginDeleteDataOptions) (*http.Response, error) {
	var err error
	const operationName = "DataTypesClient.BeginDeleteData"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteDataCreateRequest(ctx, resourceGroupName, dataProductName, dataTypeName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteDataCreateRequest creates the DeleteData request.
func (client *DataTypesClient) deleteDataCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body any, options *DataTypesClientBeginDeleteDataOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}/deleteData"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	if dataTypeName == "" {
		return nil, errors.New("parameter dataTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataTypeName}", url.PathEscape(dataTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// GenerateStorageContainerSasToken - Generate sas token for storage container.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - dataTypeName - The data type name.
//   - body - The content of the action request
//   - options - DataTypesClientGenerateStorageContainerSasTokenOptions contains the optional parameters for the DataTypesClient.GenerateStorageContainerSasToken
//     method.
func (client *DataTypesClient) GenerateStorageContainerSasToken(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body ContainerSaS, options *DataTypesClientGenerateStorageContainerSasTokenOptions) (DataTypesClientGenerateStorageContainerSasTokenResponse, error) {
	var err error
	const operationName = "DataTypesClient.GenerateStorageContainerSasToken"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateStorageContainerSasTokenCreateRequest(ctx, resourceGroupName, dataProductName, dataTypeName, body, options)
	if err != nil {
		return DataTypesClientGenerateStorageContainerSasTokenResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataTypesClientGenerateStorageContainerSasTokenResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataTypesClientGenerateStorageContainerSasTokenResponse{}, err
	}
	resp, err := client.generateStorageContainerSasTokenHandleResponse(httpResp)
	return resp, err
}

// generateStorageContainerSasTokenCreateRequest creates the GenerateStorageContainerSasToken request.
func (client *DataTypesClient) generateStorageContainerSasTokenCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body ContainerSaS, options *DataTypesClientGenerateStorageContainerSasTokenOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}/generateStorageContainerSasToken"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	if dataTypeName == "" {
		return nil, errors.New("parameter dataTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataTypeName}", url.PathEscape(dataTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// generateStorageContainerSasTokenHandleResponse handles the GenerateStorageContainerSasToken response.
func (client *DataTypesClient) generateStorageContainerSasTokenHandleResponse(resp *http.Response) (DataTypesClientGenerateStorageContainerSasTokenResponse, error) {
	result := DataTypesClientGenerateStorageContainerSasTokenResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ContainerSasToken); err != nil {
		return DataTypesClientGenerateStorageContainerSasTokenResponse{}, err
	}
	return result, nil
}

// Get - Retrieve data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - dataTypeName - The data type name.
//   - options - DataTypesClientGetOptions contains the optional parameters for the DataTypesClient.Get method.
func (client *DataTypesClient) Get(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *DataTypesClientGetOptions) (DataTypesClientGetResponse, error) {
	var err error
	const operationName = "DataTypesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, dataProductName, dataTypeName, options)
	if err != nil {
		return DataTypesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataTypesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataTypesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DataTypesClient) getCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *DataTypesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	if dataTypeName == "" {
		return nil, errors.New("parameter dataTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataTypeName}", url.PathEscape(dataTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DataTypesClient) getHandleResponse(resp *http.Response) (DataTypesClientGetResponse, error) {
	result := DataTypesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DataType); err != nil {
		return DataTypesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDataProductPager - List data type by parent resource.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - options - DataTypesClientListByDataProductOptions contains the optional parameters for the DataTypesClient.NewListByDataProductPager
//     method.
func (client *DataTypesClient) NewListByDataProductPager(resourceGroupName string, dataProductName string, options *DataTypesClientListByDataProductOptions) *runtime.Pager[DataTypesClientListByDataProductResponse] {
	return runtime.NewPager(runtime.PagingHandler[DataTypesClientListByDataProductResponse]{
		More: func(page DataTypesClientListByDataProductResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DataTypesClientListByDataProductResponse) (DataTypesClientListByDataProductResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DataTypesClient.NewListByDataProductPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByDataProductCreateRequest(ctx, resourceGroupName, dataProductName, options)
			}, nil)
			if err != nil {
				return DataTypesClientListByDataProductResponse{}, err
			}
			return client.listByDataProductHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByDataProductCreateRequest creates the ListByDataProduct request.
func (client *DataTypesClient) listByDataProductCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, options *DataTypesClientListByDataProductOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDataProductHandleResponse handles the ListByDataProduct response.
func (client *DataTypesClient) listByDataProductHandleResponse(resp *http.Response) (DataTypesClientListByDataProductResponse, error) {
	result := DataTypesClientListByDataProductResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DataTypeListResult); err != nil {
		return DataTypesClientListByDataProductResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - dataTypeName - The data type name.
//   - properties - The resource properties to be updated.
//   - options - DataTypesClientBeginUpdateOptions contains the optional parameters for the DataTypesClient.BeginUpdate method.
func (client *DataTypesClient) BeginUpdate(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, properties DataTypeUpdate, options *DataTypesClientBeginUpdateOptions) (*runtime.Poller[DataTypesClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, dataProductName, dataTypeName, properties, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataTypesClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataTypesClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update data type resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataTypesClient) update(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, properties DataTypeUpdate, options *DataTypesClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "DataTypesClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, dataProductName, dataTypeName, properties, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *DataTypesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, properties DataTypeUpdate, options *DataTypesClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	if dataTypeName == "" {
		return nil, errors.New("parameter dataTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataTypeName}", url.PathEscape(dataTypeName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}
