//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ComponentsClient contains the methods for the Components group.
// Don't use this type directly, use NewComponentsClient() instead.
type ComponentsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewComponentsClient creates a new instance of ComponentsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewComponentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ComponentsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ComponentsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets information about the specified application instance resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFunctionName - The name of the network function.
//   - componentName - The name of the component.
//   - options - ComponentsClientGetOptions contains the optional parameters for the ComponentsClient.Get method.
func (client *ComponentsClient) Get(ctx context.Context, resourceGroupName string, networkFunctionName string, componentName string, options *ComponentsClientGetOptions) (ComponentsClientGetResponse, error) {
	var err error
	const operationName = "ComponentsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, networkFunctionName, componentName, options)
	if err != nil {
		return ComponentsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ComponentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ComponentsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ComponentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, networkFunctionName string, componentName string, options *ComponentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/networkFunctions/{networkFunctionName}/components/{componentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if networkFunctionName == "" {
		return nil, errors.New("parameter networkFunctionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFunctionName}", url.PathEscape(networkFunctionName))
	if componentName == "" {
		return nil, errors.New("parameter componentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{componentName}", url.PathEscape(componentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ComponentsClient) getHandleResponse(resp *http.Response) (ComponentsClientGetResponse, error) {
	result := ComponentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Component); err != nil {
		return ComponentsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByNetworkFunctionPager - Lists all the component resources in a network function.
//
// Generated from API version 2023-09-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - networkFunctionName - The name of the network function.
//   - options - ComponentsClientListByNetworkFunctionOptions contains the optional parameters for the ComponentsClient.NewListByNetworkFunctionPager
//     method.
func (client *ComponentsClient) NewListByNetworkFunctionPager(resourceGroupName string, networkFunctionName string, options *ComponentsClientListByNetworkFunctionOptions) *runtime.Pager[ComponentsClientListByNetworkFunctionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ComponentsClientListByNetworkFunctionResponse]{
		More: func(page ComponentsClientListByNetworkFunctionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ComponentsClientListByNetworkFunctionResponse) (ComponentsClientListByNetworkFunctionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ComponentsClient.NewListByNetworkFunctionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByNetworkFunctionCreateRequest(ctx, resourceGroupName, networkFunctionName, options)
			}, nil)
			if err != nil {
				return ComponentsClientListByNetworkFunctionResponse{}, err
			}
			return client.listByNetworkFunctionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByNetworkFunctionCreateRequest creates the ListByNetworkFunction request.
func (client *ComponentsClient) listByNetworkFunctionCreateRequest(ctx context.Context, resourceGroupName string, networkFunctionName string, options *ComponentsClientListByNetworkFunctionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/networkFunctions/{networkFunctionName}/components"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if networkFunctionName == "" {
		return nil, errors.New("parameter networkFunctionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{networkFunctionName}", url.PathEscape(networkFunctionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByNetworkFunctionHandleResponse handles the ListByNetworkFunction response.
func (client *ComponentsClient) listByNetworkFunctionHandleResponse(resp *http.Response) (ComponentsClientListByNetworkFunctionResponse, error) {
	result := ComponentsClientListByNetworkFunctionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComponentListResult); err != nil {
		return ComponentsClientListByNetworkFunctionResponse{}, err
	}
	return result, nil
}
