//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIDefinitionInfo.
func (a APIDefinitionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIDefinitionInfo.
func (a *APIDefinitionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificate.
func (a AppCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificate.
func (a *AppCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificateCollection.
func (a AppCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificateCollection.
func (a *AppCertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificatePatchResource.
func (a AppCertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificatePatchResource.
func (a *AppCertificatePatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificatePatchResourceProperties.
func (a AppCertificatePatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "cerBlob", a.CerBlob, runtime.Base64StdFormat)
	populateTimeRFC3339(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "hostNames", a.HostNames)
	populate(objectMap, "hostingEnvironmentProfile", a.HostingEnvironmentProfile)
	populateTimeRFC3339(objectMap, "issueDate", a.IssueDate)
	populate(objectMap, "issuer", a.Issuer)
	populate(objectMap, "keyVaultId", a.KeyVaultID)
	populate(objectMap, "keyVaultSecretName", a.KeyVaultSecretName)
	populate(objectMap, "keyVaultSecretStatus", a.KeyVaultSecretStatus)
	populate(objectMap, "password", a.Password)
	populateByteArray(objectMap, "pfxBlob", a.PfxBlob, runtime.Base64StdFormat)
	populate(objectMap, "publicKeyHash", a.PublicKeyHash)
	populate(objectMap, "selfLink", a.SelfLink)
	populate(objectMap, "serverFarmId", a.ServerFarmID)
	populate(objectMap, "siteName", a.SiteName)
	populate(objectMap, "subjectName", a.SubjectName)
	populate(objectMap, "thumbprint", a.Thumbprint)
	populate(objectMap, "valid", a.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificatePatchResourceProperties.
func (a *AppCertificatePatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cerBlob":
			err = runtime.DecodeByteArray(string(val), &a.CerBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &a.HostNames)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &a.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "issueDate":
			err = unpopulateTimeRFC3339(val, "IssueDate", &a.IssueDate)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &a.Issuer)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &a.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultSecretName":
			err = unpopulate(val, "KeyVaultSecretName", &a.KeyVaultSecretName)
			delete(rawMsg, key)
		case "keyVaultSecretStatus":
			err = unpopulate(val, "KeyVaultSecretStatus", &a.KeyVaultSecretStatus)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "pfxBlob":
			err = runtime.DecodeByteArray(string(val), &a.PfxBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "publicKeyHash":
			err = unpopulate(val, "PublicKeyHash", &a.PublicKeyHash)
			delete(rawMsg, key)
		case "selfLink":
			err = unpopulate(val, "SelfLink", &a.SelfLink)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &a.ServerFarmID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &a.SiteName)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &a.SubjectName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &a.Thumbprint)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &a.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppCertificateProperties.
func (a AppCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "cerBlob", a.CerBlob, runtime.Base64StdFormat)
	populateTimeRFC3339(objectMap, "expirationDate", a.ExpirationDate)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "hostNames", a.HostNames)
	populate(objectMap, "hostingEnvironmentProfile", a.HostingEnvironmentProfile)
	populateTimeRFC3339(objectMap, "issueDate", a.IssueDate)
	populate(objectMap, "issuer", a.Issuer)
	populate(objectMap, "keyVaultId", a.KeyVaultID)
	populate(objectMap, "keyVaultSecretName", a.KeyVaultSecretName)
	populate(objectMap, "keyVaultSecretStatus", a.KeyVaultSecretStatus)
	populate(objectMap, "password", a.Password)
	populateByteArray(objectMap, "pfxBlob", a.PfxBlob, runtime.Base64StdFormat)
	populate(objectMap, "publicKeyHash", a.PublicKeyHash)
	populate(objectMap, "selfLink", a.SelfLink)
	populate(objectMap, "serverFarmId", a.ServerFarmID)
	populate(objectMap, "siteName", a.SiteName)
	populate(objectMap, "subjectName", a.SubjectName)
	populate(objectMap, "thumbprint", a.Thumbprint)
	populate(objectMap, "valid", a.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppCertificateProperties.
func (a *AppCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cerBlob":
			err = runtime.DecodeByteArray(string(val), &a.CerBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &a.ExpirationDate)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &a.HostNames)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &a.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "issueDate":
			err = unpopulateTimeRFC3339(val, "IssueDate", &a.IssueDate)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &a.Issuer)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &a.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultSecretName":
			err = unpopulate(val, "KeyVaultSecretName", &a.KeyVaultSecretName)
			delete(rawMsg, key)
		case "keyVaultSecretStatus":
			err = unpopulate(val, "KeyVaultSecretStatus", &a.KeyVaultSecretStatus)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "pfxBlob":
			err = runtime.DecodeByteArray(string(val), &a.PfxBlob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "publicKeyHash":
			err = unpopulate(val, "PublicKeyHash", &a.PublicKeyHash)
			delete(rawMsg, key)
		case "selfLink":
			err = unpopulate(val, "SelfLink", &a.SelfLink)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &a.ServerFarmID)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &a.SiteName)
			delete(rawMsg, key)
		case "subjectName":
			err = unpopulate(val, "SubjectName", &a.SubjectName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &a.Thumbprint)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &a.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationLogsConfig.
func (a ApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlobStorage", a.AzureBlobStorage)
	populate(objectMap, "azureTableStorage", a.AzureTableStorage)
	populate(objectMap, "fileSystem", a.FileSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationLogsConfig.
func (a *ApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlobStorage":
			err = unpopulate(val, "AzureBlobStorage", &a.AzureBlobStorage)
			delete(rawMsg, key)
		case "azureTableStorage":
			err = unpopulate(val, "AzureTableStorage", &a.AzureTableStorage)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &a.FileSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationStack.
func (a ApplicationStack) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependency", a.Dependency)
	populate(objectMap, "display", a.Display)
	populate(objectMap, "frameworks", a.Frameworks)
	populate(objectMap, "majorVersions", a.MajorVersions)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationStack.
func (a *ApplicationStack) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependency":
			err = unpopulate(val, "Dependency", &a.Dependency)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &a.Display)
			delete(rawMsg, key)
		case "frameworks":
			err = unpopulate(val, "Frameworks", &a.Frameworks)
			delete(rawMsg, key)
		case "majorVersions":
			err = unpopulate(val, "MajorVersions", &a.MajorVersions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationStackCollection.
func (a ApplicationStackCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationStackCollection.
func (a *ApplicationStackCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealActions.
func (a AutoHealActions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", a.ActionType)
	populate(objectMap, "customAction", a.CustomAction)
	populate(objectMap, "minProcessExecutionTime", a.MinProcessExecutionTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealActions.
func (a *AutoHealActions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "customAction":
			err = unpopulate(val, "CustomAction", &a.CustomAction)
			delete(rawMsg, key)
		case "minProcessExecutionTime":
			err = unpopulate(val, "MinProcessExecutionTime", &a.MinProcessExecutionTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealCustomAction.
func (a AutoHealCustomAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exe", a.Exe)
	populate(objectMap, "parameters", a.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealCustomAction.
func (a *AutoHealCustomAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exe":
			err = unpopulate(val, "Exe", &a.Exe)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealRules.
func (a AutoHealRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "triggers", a.Triggers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealRules.
func (a *AutoHealRules) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &a.Actions)
			delete(rawMsg, key)
		case "triggers":
			err = unpopulate(val, "Triggers", &a.Triggers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoHealTriggers.
func (a AutoHealTriggers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateBytesInKB", a.PrivateBytesInKB)
	populate(objectMap, "requests", a.Requests)
	populate(objectMap, "slowRequests", a.SlowRequests)
	populate(objectMap, "statusCodes", a.StatusCodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoHealTriggers.
func (a *AutoHealTriggers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateBytesInKB":
			err = unpopulate(val, "PrivateBytesInKB", &a.PrivateBytesInKB)
			delete(rawMsg, key)
		case "requests":
			err = unpopulate(val, "Requests", &a.Requests)
			delete(rawMsg, key)
		case "slowRequests":
			err = unpopulate(val, "SlowRequests", &a.SlowRequests)
			delete(rawMsg, key)
		case "statusCodes":
			err = unpopulate(val, "StatusCodes", &a.StatusCodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageApplicationLogsConfig.
func (a AzureBlobStorageApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "level", a.Level)
	populate(objectMap, "retentionInDays", a.RetentionInDays)
	populate(objectMap, "sasUrl", a.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageApplicationLogsConfig.
func (a *AzureBlobStorageApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &a.Level)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &a.RetentionInDays)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &a.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageHTTPLogsConfig.
func (a AzureBlobStorageHTTPLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "retentionInDays", a.RetentionInDays)
	populate(objectMap, "sasUrl", a.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageHTTPLogsConfig.
func (a *AzureBlobStorageHTTPLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &a.RetentionInDays)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &a.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageInfoValue.
func (a AzureStorageInfoValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", a.AccessKey)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "mountPath", a.MountPath)
	populate(objectMap, "shareName", a.ShareName)
	populate(objectMap, "state", a.State)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageInfoValue.
func (a *AzureStorageInfoValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			err = unpopulate(val, "AccessKey", &a.AccessKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "mountPath":
			err = unpopulate(val, "MountPath", &a.MountPath)
			delete(rawMsg, key)
		case "shareName":
			err = unpopulate(val, "ShareName", &a.ShareName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStoragePropertyDictionaryResource.
func (a AzureStoragePropertyDictionaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStoragePropertyDictionaryResource.
func (a *AzureStoragePropertyDictionaryResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableStorageApplicationLogsConfig.
func (a AzureTableStorageApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "level", a.Level)
	populate(objectMap, "sasUrl", a.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableStorageApplicationLogsConfig.
func (a *AzureTableStorageApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &a.Level)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &a.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupItem.
func (b BackupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupItem.
func (b *BackupItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupItemCollection.
func (b BackupItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupItemCollection.
func (b *BackupItemCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupItemProperties.
func (b BackupItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.BackupID)
	populate(objectMap, "blobName", b.BlobName)
	populate(objectMap, "correlationId", b.CorrelationID)
	populateTimeRFC3339(objectMap, "created", b.Created)
	populate(objectMap, "databases", b.Databases)
	populateTimeRFC3339(objectMap, "finishedTimeStamp", b.FinishedTimeStamp)
	populateTimeRFC3339(objectMap, "lastRestoreTimeStamp", b.LastRestoreTimeStamp)
	populate(objectMap, "log", b.Log)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "scheduled", b.Scheduled)
	populate(objectMap, "sizeInBytes", b.SizeInBytes)
	populate(objectMap, "status", b.Status)
	populate(objectMap, "storageAccountUrl", b.StorageAccountURL)
	populate(objectMap, "websiteSizeInBytes", b.WebsiteSizeInBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupItemProperties.
func (b *BackupItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "BackupID", &b.BackupID)
			delete(rawMsg, key)
		case "blobName":
			err = unpopulate(val, "BlobName", &b.BlobName)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &b.CorrelationID)
			delete(rawMsg, key)
		case "created":
			err = unpopulateTimeRFC3339(val, "Created", &b.Created)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &b.Databases)
			delete(rawMsg, key)
		case "finishedTimeStamp":
			err = unpopulateTimeRFC3339(val, "FinishedTimeStamp", &b.FinishedTimeStamp)
			delete(rawMsg, key)
		case "lastRestoreTimeStamp":
			err = unpopulateTimeRFC3339(val, "LastRestoreTimeStamp", &b.LastRestoreTimeStamp)
			delete(rawMsg, key)
		case "log":
			err = unpopulate(val, "Log", &b.Log)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "scheduled":
			err = unpopulate(val, "Scheduled", &b.Scheduled)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &b.SizeInBytes)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &b.Status)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &b.StorageAccountURL)
			delete(rawMsg, key)
		case "websiteSizeInBytes":
			err = unpopulate(val, "WebsiteSizeInBytes", &b.WebsiteSizeInBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupRequest.
func (b BackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupRequest.
func (b *BackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupRequestProperties.
func (b BackupRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupName", b.BackupName)
	populate(objectMap, "backupSchedule", b.BackupSchedule)
	populate(objectMap, "databases", b.Databases)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "storageAccountUrl", b.StorageAccountURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupRequestProperties.
func (b *BackupRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupName":
			err = unpopulate(val, "BackupName", &b.BackupName)
			delete(rawMsg, key)
		case "backupSchedule":
			err = unpopulate(val, "BackupSchedule", &b.BackupSchedule)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &b.Databases)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &b.StorageAccountURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSchedule.
func (b BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frequencyInterval", b.FrequencyInterval)
	populate(objectMap, "frequencyUnit", b.FrequencyUnit)
	populate(objectMap, "keepAtLeastOneBackup", b.KeepAtLeastOneBackup)
	populateTimeRFC3339(objectMap, "lastExecutionTime", b.LastExecutionTime)
	populate(objectMap, "retentionPeriodInDays", b.RetentionPeriodInDays)
	populateTimeRFC3339(objectMap, "startTime", b.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSchedule.
func (b *BackupSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frequencyInterval":
			err = unpopulate(val, "FrequencyInterval", &b.FrequencyInterval)
			delete(rawMsg, key)
		case "frequencyUnit":
			err = unpopulate(val, "FrequencyUnit", &b.FrequencyUnit)
			delete(rawMsg, key)
		case "keepAtLeastOneBackup":
			err = unpopulate(val, "KeepAtLeastOneBackup", &b.KeepAtLeastOneBackup)
			delete(rawMsg, key)
		case "lastExecutionTime":
			err = unpopulateTimeRFC3339(val, "LastExecutionTime", &b.LastExecutionTime)
			delete(rawMsg, key)
		case "retentionPeriodInDays":
			err = unpopulate(val, "RetentionPeriodInDays", &b.RetentionPeriodInDays)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &b.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeter.
func (b BillingMeter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeter.
func (b *BillingMeter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterCollection.
func (b BillingMeterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterCollection.
func (b *BillingMeterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterProperties.
func (b BillingMeterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingLocation", b.BillingLocation)
	populate(objectMap, "friendlyName", b.FriendlyName)
	populate(objectMap, "meterId", b.MeterID)
	populate(objectMap, "osType", b.OSType)
	populate(objectMap, "resourceType", b.ResourceType)
	populate(objectMap, "shortName", b.ShortName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterProperties.
func (b *BillingMeterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingLocation":
			err = unpopulate(val, "BillingLocation", &b.BillingLocation)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &b.FriendlyName)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &b.MeterID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &b.OSType)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &b.ResourceType)
			delete(rawMsg, key)
		case "shortName":
			err = unpopulate(val, "ShortName", &b.ShortName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Capability.
func (c Capability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "reason", c.Reason)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Capability.
func (c *Capability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloningInfo.
func (c CloningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSettingsOverrides", c.AppSettingsOverrides)
	populate(objectMap, "cloneCustomHostNames", c.CloneCustomHostNames)
	populate(objectMap, "cloneSourceControl", c.CloneSourceControl)
	populate(objectMap, "configureLoadBalancing", c.ConfigureLoadBalancing)
	populate(objectMap, "correlationId", c.CorrelationID)
	populate(objectMap, "hostingEnvironment", c.HostingEnvironment)
	populate(objectMap, "overwrite", c.Overwrite)
	populate(objectMap, "sourceWebAppId", c.SourceWebAppID)
	populate(objectMap, "sourceWebAppLocation", c.SourceWebAppLocation)
	populate(objectMap, "trafficManagerProfileId", c.TrafficManagerProfileID)
	populate(objectMap, "trafficManagerProfileName", c.TrafficManagerProfileName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloningInfo.
func (c *CloningInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSettingsOverrides":
			err = unpopulate(val, "AppSettingsOverrides", &c.AppSettingsOverrides)
			delete(rawMsg, key)
		case "cloneCustomHostNames":
			err = unpopulate(val, "CloneCustomHostNames", &c.CloneCustomHostNames)
			delete(rawMsg, key)
		case "cloneSourceControl":
			err = unpopulate(val, "CloneSourceControl", &c.CloneSourceControl)
			delete(rawMsg, key)
		case "configureLoadBalancing":
			err = unpopulate(val, "ConfigureLoadBalancing", &c.ConfigureLoadBalancing)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &c.CorrelationID)
			delete(rawMsg, key)
		case "hostingEnvironment":
			err = unpopulate(val, "HostingEnvironment", &c.HostingEnvironment)
			delete(rawMsg, key)
		case "overwrite":
			err = unpopulate(val, "Overwrite", &c.Overwrite)
			delete(rawMsg, key)
		case "sourceWebAppId":
			err = unpopulate(val, "SourceWebAppID", &c.SourceWebAppID)
			delete(rawMsg, key)
		case "sourceWebAppLocation":
			err = unpopulate(val, "SourceWebAppLocation", &c.SourceWebAppLocation)
			delete(rawMsg, key)
		case "trafficManagerProfileId":
			err = unpopulate(val, "TrafficManagerProfileID", &c.TrafficManagerProfileID)
			delete(rawMsg, key)
		case "trafficManagerProfileName":
			err = unpopulate(val, "TrafficManagerProfileName", &c.TrafficManagerProfileName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "principalId", c.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c *Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnStringInfo.
func (c ConnStringInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnStringInfo.
func (c *ConnStringInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnStringValueTypePair.
func (c ConnStringValueTypePair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnStringValueTypePair.
func (c *ConnStringValueTypePair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionStringDictionary.
func (c ConnectionStringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionStringDictionary.
func (c *ConnectionStringDictionary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinuousWebJob.
func (c ContinuousWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinuousWebJob.
func (c *ContinuousWebJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinuousWebJobCollection.
func (c ContinuousWebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinuousWebJobCollection.
func (c *ContinuousWebJobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContinuousWebJobProperties.
func (c ContinuousWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detailed_status", c.DetailedStatus)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "extra_info_url", c.ExtraInfoURL)
	populate(objectMap, "log_url", c.LogURL)
	populate(objectMap, "run_command", c.RunCommand)
	populate(objectMap, "settings", c.Settings)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "url", c.URL)
	populate(objectMap, "using_sdk", c.UsingSdk)
	populate(objectMap, "web_job_type", c.WebJobType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContinuousWebJobProperties.
func (c *ContinuousWebJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detailed_status":
			err = unpopulate(val, "DetailedStatus", &c.DetailedStatus)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "extra_info_url":
			err = unpopulate(val, "ExtraInfoURL", &c.ExtraInfoURL)
			delete(rawMsg, key)
		case "log_url":
			err = unpopulate(val, "LogURL", &c.LogURL)
			delete(rawMsg, key)
		case "run_command":
			err = unpopulate(val, "RunCommand", &c.RunCommand)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &c.Settings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		case "using_sdk":
			err = unpopulate(val, "UsingSdk", &c.UsingSdk)
			delete(rawMsg, key)
		case "web_job_type":
			err = unpopulate(val, "WebJobType", &c.WebJobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CorsSettings.
func (c CorsSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedOrigins", c.AllowedOrigins)
	populate(objectMap, "supportCredentials", c.SupportCredentials)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CorsSettings.
func (c *CorsSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOrigins":
			err = unpopulate(val, "AllowedOrigins", &c.AllowedOrigins)
			delete(rawMsg, key)
		case "supportCredentials":
			err = unpopulate(val, "SupportCredentials", &c.SupportCredentials)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmMoveResourceEnvelope.
func (c CsmMoveResourceEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resources", c.Resources)
	populate(objectMap, "targetResourceGroup", c.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmMoveResourceEnvelope.
func (c *CsmMoveResourceEnvelope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resources":
			err = unpopulate(val, "Resources", &c.Resources)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &c.TargetResourceGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationCollection.
func (c CsmOperationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationCollection.
func (c *CsmOperationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationDescription.
func (c CsmOperationDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", c.Display)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "origin", c.Origin)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationDescription.
func (c *CsmOperationDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &c.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &c.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationDescriptionProperties.
func (c CsmOperationDescriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", c.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationDescriptionProperties.
func (c *CsmOperationDescriptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &c.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmOperationDisplay.
func (c CsmOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "operation", c.Operation)
	populate(objectMap, "provider", c.Provider)
	populate(objectMap, "resource", c.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmOperationDisplay.
func (c *CsmOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &c.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &c.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &c.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmPublishingProfileOptions.
func (c CsmPublishingProfileOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "format", c.Format)
	populate(objectMap, "includeDisasterRecoveryEndpoints", c.IncludeDisasterRecoveryEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmPublishingProfileOptions.
func (c *CsmPublishingProfileOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "format":
			err = unpopulate(val, "Format", &c.Format)
			delete(rawMsg, key)
		case "includeDisasterRecoveryEndpoints":
			err = unpopulate(val, "IncludeDisasterRecoveryEndpoints", &c.IncludeDisasterRecoveryEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmSlotEntity.
func (c CsmSlotEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preserveVnet", c.PreserveVnet)
	populate(objectMap, "targetSlot", c.TargetSlot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmSlotEntity.
func (c *CsmSlotEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preserveVnet":
			err = unpopulate(val, "PreserveVnet", &c.PreserveVnet)
			delete(rawMsg, key)
		case "targetSlot":
			err = unpopulate(val, "TargetSlot", &c.TargetSlot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmUsageQuota.
func (c CsmUsageQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", c.CurrentValue)
	populate(objectMap, "limit", c.Limit)
	populate(objectMap, "name", c.Name)
	populateTimeRFC3339(objectMap, "nextResetTime", c.NextResetTime)
	populate(objectMap, "unit", c.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmUsageQuota.
func (c *CsmUsageQuota) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &c.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &c.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "nextResetTime":
			err = unpopulateTimeRFC3339(val, "NextResetTime", &c.NextResetTime)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &c.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CsmUsageQuotaCollection.
func (c CsmUsageQuotaCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CsmUsageQuotaCollection.
func (c *CsmUsageQuotaCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResult.
func (c CustomHostnameAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResult.
func (c *CustomHostnameAnalysisResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomHostnameAnalysisResultProperties.
func (c CustomHostnameAnalysisResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aRecords", c.ARecords)
	populate(objectMap, "alternateCNameRecords", c.AlternateCNameRecords)
	populate(objectMap, "alternateTxtRecords", c.AlternateTxtRecords)
	populate(objectMap, "cNameRecords", c.CNameRecords)
	populate(objectMap, "conflictingAppResourceId", c.ConflictingAppResourceID)
	populate(objectMap, "customDomainVerificationFailureInfo", c.CustomDomainVerificationFailureInfo)
	populate(objectMap, "customDomainVerificationTest", c.CustomDomainVerificationTest)
	populate(objectMap, "hasConflictAcrossSubscription", c.HasConflictAcrossSubscription)
	populate(objectMap, "hasConflictOnScaleUnit", c.HasConflictOnScaleUnit)
	populate(objectMap, "isHostnameAlreadyVerified", c.IsHostnameAlreadyVerified)
	populate(objectMap, "txtRecords", c.TxtRecords)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomHostnameAnalysisResultProperties.
func (c *CustomHostnameAnalysisResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aRecords":
			err = unpopulate(val, "ARecords", &c.ARecords)
			delete(rawMsg, key)
		case "alternateCNameRecords":
			err = unpopulate(val, "AlternateCNameRecords", &c.AlternateCNameRecords)
			delete(rawMsg, key)
		case "alternateTxtRecords":
			err = unpopulate(val, "AlternateTxtRecords", &c.AlternateTxtRecords)
			delete(rawMsg, key)
		case "cNameRecords":
			err = unpopulate(val, "CNameRecords", &c.CNameRecords)
			delete(rawMsg, key)
		case "conflictingAppResourceId":
			err = unpopulate(val, "ConflictingAppResourceID", &c.ConflictingAppResourceID)
			delete(rawMsg, key)
		case "customDomainVerificationFailureInfo":
			err = unpopulate(val, "CustomDomainVerificationFailureInfo", &c.CustomDomainVerificationFailureInfo)
			delete(rawMsg, key)
		case "customDomainVerificationTest":
			err = unpopulate(val, "CustomDomainVerificationTest", &c.CustomDomainVerificationTest)
			delete(rawMsg, key)
		case "hasConflictAcrossSubscription":
			err = unpopulate(val, "HasConflictAcrossSubscription", &c.HasConflictAcrossSubscription)
			delete(rawMsg, key)
		case "hasConflictOnScaleUnit":
			err = unpopulate(val, "HasConflictOnScaleUnit", &c.HasConflictOnScaleUnit)
			delete(rawMsg, key)
		case "isHostnameAlreadyVerified":
			err = unpopulate(val, "IsHostnameAlreadyVerified", &c.IsHostnameAlreadyVerified)
			delete(rawMsg, key)
		case "txtRecords":
			err = unpopulate(val, "TxtRecords", &c.TxtRecords)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabaseBackupSetting.
func (d DatabaseBackupSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", d.ConnectionString)
	populate(objectMap, "connectionStringName", d.ConnectionStringName)
	populate(objectMap, "databaseType", d.DatabaseType)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabaseBackupSetting.
func (d *DatabaseBackupSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &d.ConnectionString)
			delete(rawMsg, key)
		case "connectionStringName":
			err = unpopulate(val, "ConnectionStringName", &d.ConnectionStringName)
			delete(rawMsg, key)
		case "databaseType":
			err = unpopulate(val, "DatabaseType", &d.DatabaseType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponse.
func (d DefaultErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", d.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponse.
func (d *DefaultErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &d.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseError.
func (d DefaultErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "details", d.Details)
	populate(objectMap, "innererror", d.Innererror)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "target", d.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseError.
func (d *DefaultErrorResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &d.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultErrorResponseErrorDetailsItem.
func (d DefaultErrorResponseErrorDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "message", d.Message)
	populate(objectMap, "target", d.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultErrorResponseErrorDetailsItem.
func (d *DefaultErrorResponseErrorDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &d.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAppRestoreRequest.
func (d DeletedAppRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAppRestoreRequest.
func (d *DeletedAppRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedAppRestoreRequestProperties.
func (d DeletedAppRestoreRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deletedSiteId", d.DeletedSiteID)
	populate(objectMap, "recoverConfiguration", d.RecoverConfiguration)
	populate(objectMap, "snapshotTime", d.SnapshotTime)
	populate(objectMap, "useDRSecondary", d.UseDRSecondary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedAppRestoreRequestProperties.
func (d *DeletedAppRestoreRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletedSiteId":
			err = unpopulate(val, "DeletedSiteID", &d.DeletedSiteID)
			delete(rawMsg, key)
		case "recoverConfiguration":
			err = unpopulate(val, "RecoverConfiguration", &d.RecoverConfiguration)
			delete(rawMsg, key)
		case "snapshotTime":
			err = unpopulate(val, "SnapshotTime", &d.SnapshotTime)
			delete(rawMsg, key)
		case "useDRSecondary":
			err = unpopulate(val, "UseDRSecondary", &d.UseDRSecondary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Deployment.
func (d *Deployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentCollection.
func (d DeploymentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentCollection.
func (d *DeploymentCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentLocations.
func (d DeploymentLocations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostingEnvironmentDeploymentInfos", d.HostingEnvironmentDeploymentInfos)
	populate(objectMap, "hostingEnvironments", d.HostingEnvironments)
	populate(objectMap, "locations", d.Locations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentLocations.
func (d *DeploymentLocations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostingEnvironmentDeploymentInfos":
			err = unpopulate(val, "HostingEnvironmentDeploymentInfos", &d.HostingEnvironmentDeploymentInfos)
			delete(rawMsg, key)
		case "hostingEnvironments":
			err = unpopulate(val, "HostingEnvironments", &d.HostingEnvironments)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &d.Locations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentProperties.
func (d DeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "active", d.Active)
	populate(objectMap, "author", d.Author)
	populate(objectMap, "author_email", d.AuthorEmail)
	populate(objectMap, "deployer", d.Deployer)
	populate(objectMap, "details", d.Details)
	populateTimeRFC3339(objectMap, "end_time", d.EndTime)
	populate(objectMap, "message", d.Message)
	populateTimeRFC3339(objectMap, "start_time", d.StartTime)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentProperties.
func (d *DeploymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "active":
			err = unpopulate(val, "Active", &d.Active)
			delete(rawMsg, key)
		case "author":
			err = unpopulate(val, "Author", &d.Author)
			delete(rawMsg, key)
		case "author_email":
			err = unpopulate(val, "AuthorEmail", &d.AuthorEmail)
			delete(rawMsg, key)
		case "deployer":
			err = unpopulate(val, "Deployer", &d.Deployer)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "end_time":
			err = unpopulateTimeRFC3339(val, "EndTime", &d.EndTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateTimeRFC3339(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "internalName", d.InternalName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "toBeExportedForShoebox", d.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &d.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &d.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnabledConfig.
func (e EnabledConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", e.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnabledConfig.
func (e *EnabledConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &e.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Environment.
func (e Environment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiManagementAccountId", e.APIManagementAccountID)
	populate(objectMap, "allowedMultiSizes", e.AllowedMultiSizes)
	populate(objectMap, "allowedWorkerSizes", e.AllowedWorkerSizes)
	populate(objectMap, "clusterSettings", e.ClusterSettings)
	populate(objectMap, "dnsSuffix", e.DNSSuffix)
	populate(objectMap, "databaseEdition", e.DatabaseEdition)
	populate(objectMap, "databaseServiceObjective", e.DatabaseServiceObjective)
	populate(objectMap, "defaultFrontEndScaleFactor", e.DefaultFrontEndScaleFactor)
	populate(objectMap, "dynamicCacheEnabled", e.DynamicCacheEnabled)
	populate(objectMap, "environmentCapacities", e.EnvironmentCapacities)
	populate(objectMap, "environmentIsHealthy", e.EnvironmentIsHealthy)
	populate(objectMap, "environmentStatus", e.EnvironmentStatus)
	populate(objectMap, "frontEndScaleFactor", e.FrontEndScaleFactor)
	populate(objectMap, "hasLinuxWorkers", e.HasLinuxWorkers)
	populate(objectMap, "internalLoadBalancingMode", e.InternalLoadBalancingMode)
	populate(objectMap, "ipsslAddressCount", e.IpsslAddressCount)
	populate(objectMap, "lastAction", e.LastAction)
	populate(objectMap, "lastActionResult", e.LastActionResult)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "maximumNumberOfMachines", e.MaximumNumberOfMachines)
	populate(objectMap, "multiRoleCount", e.MultiRoleCount)
	populate(objectMap, "multiSize", e.MultiSize)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "networkAccessControlList", e.NetworkAccessControlList)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "resourceGroup", e.ResourceGroup)
	populate(objectMap, "sslCertKeyVaultId", e.SSLCertKeyVaultID)
	populate(objectMap, "sslCertKeyVaultSecretName", e.SSLCertKeyVaultSecretName)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "subscriptionId", e.SubscriptionID)
	populate(objectMap, "suspended", e.Suspended)
	populate(objectMap, "upgradeDomains", e.UpgradeDomains)
	populate(objectMap, "userWhitelistedIpRanges", e.UserWhitelistedIPRanges)
	populate(objectMap, "vipMappings", e.VipMappings)
	populate(objectMap, "virtualNetwork", e.VirtualNetwork)
	populate(objectMap, "vnetName", e.VnetName)
	populate(objectMap, "vnetResourceGroupName", e.VnetResourceGroupName)
	populate(objectMap, "vnetSubnetName", e.VnetSubnetName)
	populate(objectMap, "workerPools", e.WorkerPools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Environment.
func (e *Environment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiManagementAccountId":
			err = unpopulate(val, "APIManagementAccountID", &e.APIManagementAccountID)
			delete(rawMsg, key)
		case "allowedMultiSizes":
			err = unpopulate(val, "AllowedMultiSizes", &e.AllowedMultiSizes)
			delete(rawMsg, key)
		case "allowedWorkerSizes":
			err = unpopulate(val, "AllowedWorkerSizes", &e.AllowedWorkerSizes)
			delete(rawMsg, key)
		case "clusterSettings":
			err = unpopulate(val, "ClusterSettings", &e.ClusterSettings)
			delete(rawMsg, key)
		case "dnsSuffix":
			err = unpopulate(val, "DNSSuffix", &e.DNSSuffix)
			delete(rawMsg, key)
		case "databaseEdition":
			err = unpopulate(val, "DatabaseEdition", &e.DatabaseEdition)
			delete(rawMsg, key)
		case "databaseServiceObjective":
			err = unpopulate(val, "DatabaseServiceObjective", &e.DatabaseServiceObjective)
			delete(rawMsg, key)
		case "defaultFrontEndScaleFactor":
			err = unpopulate(val, "DefaultFrontEndScaleFactor", &e.DefaultFrontEndScaleFactor)
			delete(rawMsg, key)
		case "dynamicCacheEnabled":
			err = unpopulate(val, "DynamicCacheEnabled", &e.DynamicCacheEnabled)
			delete(rawMsg, key)
		case "environmentCapacities":
			err = unpopulate(val, "EnvironmentCapacities", &e.EnvironmentCapacities)
			delete(rawMsg, key)
		case "environmentIsHealthy":
			err = unpopulate(val, "EnvironmentIsHealthy", &e.EnvironmentIsHealthy)
			delete(rawMsg, key)
		case "environmentStatus":
			err = unpopulate(val, "EnvironmentStatus", &e.EnvironmentStatus)
			delete(rawMsg, key)
		case "frontEndScaleFactor":
			err = unpopulate(val, "FrontEndScaleFactor", &e.FrontEndScaleFactor)
			delete(rawMsg, key)
		case "hasLinuxWorkers":
			err = unpopulate(val, "HasLinuxWorkers", &e.HasLinuxWorkers)
			delete(rawMsg, key)
		case "internalLoadBalancingMode":
			err = unpopulate(val, "InternalLoadBalancingMode", &e.InternalLoadBalancingMode)
			delete(rawMsg, key)
		case "ipsslAddressCount":
			err = unpopulate(val, "IpsslAddressCount", &e.IpsslAddressCount)
			delete(rawMsg, key)
		case "lastAction":
			err = unpopulate(val, "LastAction", &e.LastAction)
			delete(rawMsg, key)
		case "lastActionResult":
			err = unpopulate(val, "LastActionResult", &e.LastActionResult)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "maximumNumberOfMachines":
			err = unpopulate(val, "MaximumNumberOfMachines", &e.MaximumNumberOfMachines)
			delete(rawMsg, key)
		case "multiRoleCount":
			err = unpopulate(val, "MultiRoleCount", &e.MultiRoleCount)
			delete(rawMsg, key)
		case "multiSize":
			err = unpopulate(val, "MultiSize", &e.MultiSize)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "networkAccessControlList":
			err = unpopulate(val, "NetworkAccessControlList", &e.NetworkAccessControlList)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &e.ResourceGroup)
			delete(rawMsg, key)
		case "sslCertKeyVaultId":
			err = unpopulate(val, "SSLCertKeyVaultID", &e.SSLCertKeyVaultID)
			delete(rawMsg, key)
		case "sslCertKeyVaultSecretName":
			err = unpopulate(val, "SSLCertKeyVaultSecretName", &e.SSLCertKeyVaultSecretName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &e.SubscriptionID)
			delete(rawMsg, key)
		case "suspended":
			err = unpopulate(val, "Suspended", &e.Suspended)
			delete(rawMsg, key)
		case "upgradeDomains":
			err = unpopulate(val, "UpgradeDomains", &e.UpgradeDomains)
			delete(rawMsg, key)
		case "userWhitelistedIpRanges":
			err = unpopulate(val, "UserWhitelistedIPRanges", &e.UserWhitelistedIPRanges)
			delete(rawMsg, key)
		case "vipMappings":
			err = unpopulate(val, "VipMappings", &e.VipMappings)
			delete(rawMsg, key)
		case "virtualNetwork":
			err = unpopulate(val, "VirtualNetwork", &e.VirtualNetwork)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &e.VnetName)
			delete(rawMsg, key)
		case "vnetResourceGroupName":
			err = unpopulate(val, "VnetResourceGroupName", &e.VnetResourceGroupName)
			delete(rawMsg, key)
		case "vnetSubnetName":
			err = unpopulate(val, "VnetSubnetName", &e.VnetSubnetName)
			delete(rawMsg, key)
		case "workerPools":
			err = unpopulate(val, "WorkerPools", &e.WorkerPools)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorEntity.
func (e ErrorEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "extendedCode", e.ExtendedCode)
	populate(objectMap, "innerErrors", e.InnerErrors)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "messageTemplate", e.MessageTemplate)
	populate(objectMap, "parameters", e.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorEntity.
func (e *ErrorEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "extendedCode":
			err = unpopulate(val, "ExtendedCode", &e.ExtendedCode)
			delete(rawMsg, key)
		case "innerErrors":
			err = unpopulate(val, "InnerErrors", &e.InnerErrors)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "messageTemplate":
			err = unpopulate(val, "MessageTemplate", &e.MessageTemplate)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Experiments.
func (e Experiments) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rampUpRules", e.RampUpRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Experiments.
func (e *Experiments) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rampUpRules":
			err = unpopulate(val, "RampUpRules", &e.RampUpRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemApplicationLogsConfig.
func (f FileSystemApplicationLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "level", f.Level)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemApplicationLogsConfig.
func (f *FileSystemApplicationLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &f.Level)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemHTTPLogsConfig.
func (f FileSystemHTTPLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", f.Enabled)
	populate(objectMap, "retentionInDays", f.RetentionInDays)
	populate(objectMap, "retentionInMb", f.RetentionInMb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemHTTPLogsConfig.
func (f *FileSystemHTTPLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "retentionInDays":
			err = unpopulate(val, "RetentionInDays", &f.RetentionInDays)
			delete(rawMsg, key)
		case "retentionInMb":
			err = unpopulate(val, "RetentionInMb", &f.RetentionInMb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionEnvelope.
func (f FunctionEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "kind", f.Kind)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionEnvelope.
func (f *FunctionEnvelope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionEnvelopeCollection.
func (f FunctionEnvelopeCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionEnvelopeCollection.
func (f *FunctionEnvelopeCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionEnvelopeProperties.
func (f FunctionEnvelopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "config", &f.Config)
	populate(objectMap, "config_href", f.ConfigHref)
	populate(objectMap, "files", f.Files)
	populate(objectMap, "function_app_id", f.FunctionAppID)
	populate(objectMap, "href", f.Href)
	populate(objectMap, "invoke_url_template", f.InvokeURLTemplate)
	populate(objectMap, "isDisabled", f.IsDisabled)
	populate(objectMap, "language", f.Language)
	populate(objectMap, "script_href", f.ScriptHref)
	populate(objectMap, "script_root_path_href", f.ScriptRootPathHref)
	populate(objectMap, "secrets_file_href", f.SecretsFileHref)
	populate(objectMap, "test_data", f.TestData)
	populate(objectMap, "test_data_href", f.TestDataHref)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionEnvelopeProperties.
func (f *FunctionEnvelopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "config":
			err = unpopulate(val, "Config", &f.Config)
			delete(rawMsg, key)
		case "config_href":
			err = unpopulate(val, "ConfigHref", &f.ConfigHref)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &f.Files)
			delete(rawMsg, key)
		case "function_app_id":
			err = unpopulate(val, "FunctionAppID", &f.FunctionAppID)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &f.Href)
			delete(rawMsg, key)
		case "invoke_url_template":
			err = unpopulate(val, "InvokeURLTemplate", &f.InvokeURLTemplate)
			delete(rawMsg, key)
		case "isDisabled":
			err = unpopulate(val, "IsDisabled", &f.IsDisabled)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &f.Language)
			delete(rawMsg, key)
		case "script_href":
			err = unpopulate(val, "ScriptHref", &f.ScriptHref)
			delete(rawMsg, key)
		case "script_root_path_href":
			err = unpopulate(val, "ScriptRootPathHref", &f.ScriptRootPathHref)
			delete(rawMsg, key)
		case "secrets_file_href":
			err = unpopulate(val, "SecretsFileHref", &f.SecretsFileHref)
			delete(rawMsg, key)
		case "test_data":
			err = unpopulate(val, "TestData", &f.TestData)
			delete(rawMsg, key)
		case "test_data_href":
			err = unpopulate(val, "TestDataHref", &f.TestDataHref)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionSecrets.
func (f FunctionSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "kind", f.Kind)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionSecrets.
func (f *FunctionSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FunctionSecretsProperties.
func (f FunctionSecretsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", f.Key)
	populate(objectMap, "trigger_url", f.TriggerURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FunctionSecretsProperties.
func (f *FunctionSecretsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &f.Key)
			delete(rawMsg, key)
		case "trigger_url":
			err = unpopulate(val, "TriggerURL", &f.TriggerURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoDistribution.
func (g GeoDistribution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "numberOfWorkers", g.NumberOfWorkers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoDistribution.
func (g *GeoDistribution) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &g.NumberOfWorkers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoRegion.
func (g GeoRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "kind", g.Kind)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoRegion.
func (g *GeoRegion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &g.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoRegionCollection.
func (g GeoRegionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoRegionCollection.
func (g *GeoRegionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoRegionProperties.
func (g GeoRegionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "displayName", g.DisplayName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoRegionProperties.
func (g *GeoRegionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &g.DisplayName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalCsmSKUDescription.
func (g GlobalCsmSKUDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", g.Capabilities)
	populate(objectMap, "capacity", g.Capacity)
	populate(objectMap, "family", g.Family)
	populate(objectMap, "locations", g.Locations)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "size", g.Size)
	populate(objectMap, "tier", g.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalCsmSKUDescription.
func (g *GlobalCsmSKUDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &g.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &g.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &g.Family)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &g.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &g.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &g.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPLogsConfig.
func (h HTTPLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlobStorage", h.AzureBlobStorage)
	populate(objectMap, "fileSystem", h.FileSystem)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPLogsConfig.
func (h *HTTPLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlobStorage":
			err = unpopulate(val, "AzureBlobStorage", &h.AzureBlobStorage)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &h.FileSystem)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HandlerMapping.
func (h HandlerMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", h.Arguments)
	populate(objectMap, "extension", h.Extension)
	populate(objectMap, "scriptProcessor", h.ScriptProcessor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HandlerMapping.
func (h *HandlerMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "extension":
			err = unpopulate(val, "Extension", &h.Extension)
			delete(rawMsg, key)
		case "scriptProcessor":
			err = unpopulate(val, "ScriptProcessor", &h.ScriptProcessor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostKeys.
func (h HostKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "functionKeys", h.FunctionKeys)
	populate(objectMap, "masterKey", h.MasterKey)
	populate(objectMap, "systemKeys", h.SystemKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostKeys.
func (h *HostKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "functionKeys":
			err = unpopulate(val, "FunctionKeys", &h.FunctionKeys)
			delete(rawMsg, key)
		case "masterKey":
			err = unpopulate(val, "MasterKey", &h.MasterKey)
			delete(rawMsg, key)
		case "systemKeys":
			err = unpopulate(val, "SystemKeys", &h.SystemKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameBinding.
func (h HostNameBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameBinding.
func (h *HostNameBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameBindingCollection.
func (h HostNameBindingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameBindingCollection.
func (h *HostNameBindingCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameBindingProperties.
func (h HostNameBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureResourceName", h.AzureResourceName)
	populate(objectMap, "azureResourceType", h.AzureResourceType)
	populate(objectMap, "customHostNameDnsRecordType", h.CustomHostNameDNSRecordType)
	populate(objectMap, "domainId", h.DomainID)
	populate(objectMap, "hostNameType", h.HostNameType)
	populate(objectMap, "sslState", h.SSLState)
	populate(objectMap, "siteName", h.SiteName)
	populate(objectMap, "thumbprint", h.Thumbprint)
	populate(objectMap, "virtualIP", h.VirtualIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameBindingProperties.
func (h *HostNameBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureResourceName":
			err = unpopulate(val, "AzureResourceName", &h.AzureResourceName)
			delete(rawMsg, key)
		case "azureResourceType":
			err = unpopulate(val, "AzureResourceType", &h.AzureResourceType)
			delete(rawMsg, key)
		case "customHostNameDnsRecordType":
			err = unpopulate(val, "CustomHostNameDNSRecordType", &h.CustomHostNameDNSRecordType)
			delete(rawMsg, key)
		case "domainId":
			err = unpopulate(val, "DomainID", &h.DomainID)
			delete(rawMsg, key)
		case "hostNameType":
			err = unpopulate(val, "HostNameType", &h.HostNameType)
			delete(rawMsg, key)
		case "sslState":
			err = unpopulate(val, "SSLState", &h.SSLState)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &h.SiteName)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &h.Thumbprint)
			delete(rawMsg, key)
		case "virtualIP":
			err = unpopulate(val, "VirtualIP", &h.VirtualIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostNameSSLState.
func (h HostNameSSLState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostType", h.HostType)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "sslState", h.SSLState)
	populate(objectMap, "thumbprint", h.Thumbprint)
	populate(objectMap, "toUpdate", h.ToUpdate)
	populate(objectMap, "virtualIP", h.VirtualIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostNameSSLState.
func (h *HostNameSSLState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostType":
			err = unpopulate(val, "HostType", &h.HostType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "sslState":
			err = unpopulate(val, "SSLState", &h.SSLState)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &h.Thumbprint)
			delete(rawMsg, key)
		case "toUpdate":
			err = unpopulate(val, "ToUpdate", &h.ToUpdate)
			delete(rawMsg, key)
		case "virtualIP":
			err = unpopulate(val, "VirtualIP", &h.VirtualIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostingEnvironmentDeploymentInfo.
func (h HostingEnvironmentDeploymentInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", h.Location)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostingEnvironmentDeploymentInfo.
func (h *HostingEnvironmentDeploymentInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &h.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostingEnvironmentProfile.
func (h HostingEnvironmentProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostingEnvironmentProfile.
func (h *HostingEnvironmentProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnection.
func (h HybridConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnection.
func (h *HybridConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionCollection.
func (h HybridConnectionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionCollection.
func (h *HybridConnectionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionKey.
func (h HybridConnectionKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionKey.
func (h *HybridConnectionKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionKeyProperties.
func (h HybridConnectionKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sendKeyName", h.SendKeyName)
	populate(objectMap, "sendKeyValue", h.SendKeyValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionKeyProperties.
func (h *HybridConnectionKeyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sendKeyName":
			err = unpopulate(val, "SendKeyName", &h.SendKeyName)
			delete(rawMsg, key)
		case "sendKeyValue":
			err = unpopulate(val, "SendKeyValue", &h.SendKeyValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionLimits.
func (h HybridConnectionLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionLimits.
func (h *HybridConnectionLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionLimitsProperties.
func (h HybridConnectionLimitsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "current", h.Current)
	populate(objectMap, "maximum", h.Maximum)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionLimitsProperties.
func (h *HybridConnectionLimitsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "current":
			err = unpopulate(val, "Current", &h.Current)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &h.Maximum)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionProperties.
func (h HybridConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostname", h.Hostname)
	populate(objectMap, "port", h.Port)
	populate(objectMap, "relayArmUri", h.RelayArmURI)
	populate(objectMap, "relayName", h.RelayName)
	populate(objectMap, "sendKeyName", h.SendKeyName)
	populate(objectMap, "sendKeyValue", h.SendKeyValue)
	populate(objectMap, "serviceBusNamespace", h.ServiceBusNamespace)
	populate(objectMap, "serviceBusSuffix", h.ServiceBusSuffix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionProperties.
func (h *HybridConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostname":
			err = unpopulate(val, "Hostname", &h.Hostname)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &h.Port)
			delete(rawMsg, key)
		case "relayArmUri":
			err = unpopulate(val, "RelayArmURI", &h.RelayArmURI)
			delete(rawMsg, key)
		case "relayName":
			err = unpopulate(val, "RelayName", &h.RelayName)
			delete(rawMsg, key)
		case "sendKeyName":
			err = unpopulate(val, "SendKeyName", &h.SendKeyName)
			delete(rawMsg, key)
		case "sendKeyValue":
			err = unpopulate(val, "SendKeyValue", &h.SendKeyValue)
			delete(rawMsg, key)
		case "serviceBusNamespace":
			err = unpopulate(val, "ServiceBusNamespace", &h.ServiceBusNamespace)
			delete(rawMsg, key)
		case "serviceBusSuffix":
			err = unpopulate(val, "ServiceBusSuffix", &h.ServiceBusSuffix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPSecurityRestriction.
func (i IPSecurityRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", i.Action)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "ipAddress", i.IPAddress)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "priority", i.Priority)
	populate(objectMap, "subnetMask", i.SubnetMask)
	populate(objectMap, "subnetTrafficTag", i.SubnetTrafficTag)
	populate(objectMap, "tag", i.Tag)
	populate(objectMap, "vnetSubnetResourceId", i.VnetSubnetResourceID)
	populate(objectMap, "vnetTrafficTag", i.VnetTrafficTag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPSecurityRestriction.
func (i *IPSecurityRestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &i.Action)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &i.Priority)
			delete(rawMsg, key)
		case "subnetMask":
			err = unpopulate(val, "SubnetMask", &i.SubnetMask)
			delete(rawMsg, key)
		case "subnetTrafficTag":
			err = unpopulate(val, "SubnetTrafficTag", &i.SubnetTrafficTag)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &i.Tag)
			delete(rawMsg, key)
		case "vnetSubnetResourceId":
			err = unpopulate(val, "VnetSubnetResourceID", &i.VnetSubnetResourceID)
			delete(rawMsg, key)
		case "vnetTrafficTag":
			err = unpopulate(val, "VnetTrafficTag", &i.VnetTrafficTag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identifier.
func (i Identifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "kind", i.Kind)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identifier.
func (i *Identifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentifierCollection.
func (i IdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentifierCollection.
func (i *IdentifierCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentifierProperties.
func (i IdentifierProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentifierProperties.
func (i *IdentifierProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyInfo.
func (k KeyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyInfo.
func (k *KeyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalizableString.
func (l LocalizableString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", l.LocalizedValue)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalizableString.
func (l *LocalizableString) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &l.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeploy.
func (m MSDeploy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeploy.
func (m *MSDeploy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployCore.
func (m MSDeployCore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appOffline", m.AppOffline)
	populate(objectMap, "connectionString", m.ConnectionString)
	populate(objectMap, "dbType", m.DbType)
	populate(objectMap, "packageUri", m.PackageURI)
	populate(objectMap, "setParameters", m.SetParameters)
	populate(objectMap, "setParametersXmlFileUri", m.SetParametersXMLFileURI)
	populate(objectMap, "skipAppData", m.SkipAppData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployCore.
func (m *MSDeployCore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appOffline":
			err = unpopulate(val, "AppOffline", &m.AppOffline)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &m.ConnectionString)
			delete(rawMsg, key)
		case "dbType":
			err = unpopulate(val, "DbType", &m.DbType)
			delete(rawMsg, key)
		case "packageUri":
			err = unpopulate(val, "PackageURI", &m.PackageURI)
			delete(rawMsg, key)
		case "setParameters":
			err = unpopulate(val, "SetParameters", &m.SetParameters)
			delete(rawMsg, key)
		case "setParametersXmlFileUri":
			err = unpopulate(val, "SetParametersXMLFileURI", &m.SetParametersXMLFileURI)
			delete(rawMsg, key)
		case "skipAppData":
			err = unpopulate(val, "SkipAppData", &m.SkipAppData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployLog.
func (m MSDeployLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployLog.
func (m *MSDeployLog) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployLogEntry.
func (m MSDeployLogEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", m.Message)
	populateTimeRFC3339(objectMap, "time", m.Time)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployLogEntry.
func (m *MSDeployLogEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &m.Time)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployLogProperties.
func (m MSDeployLogProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entries", m.Entries)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployLogProperties.
func (m *MSDeployLogProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entries":
			err = unpopulate(val, "Entries", &m.Entries)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployStatus.
func (m MSDeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployStatus.
func (m *MSDeployStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSDeployStatusProperties.
func (m MSDeployStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complete", m.Complete)
	populate(objectMap, "deployer", m.Deployer)
	populateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populateTimeRFC3339(objectMap, "startTime", m.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSDeployStatusProperties.
func (m *MSDeployStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complete":
			err = unpopulate(val, "Complete", &m.Complete)
			delete(rawMsg, key)
		case "deployer":
			err = unpopulate(val, "Deployer", &m.Deployer)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricAvailability.
func (m MetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", m.BlobDuration)
	populate(objectMap, "timeGrain", m.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAvailability.
func (m *MetricAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &m.BlobDuration)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "availabilities", m.Availabilities)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "metricFilterPattern", m.MetricFilterPattern)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "supportsInstanceLevelAggregation", m.SupportsInstanceLevelAggregation)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "availabilities":
			err = unpopulate(val, "Availabilities", &m.Availabilities)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &m.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "supportsInstanceLevelAggregation":
			err = unpopulate(val, "SupportsInstanceLevelAggregation", &m.SupportsInstanceLevelAggregation)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLRequest.
func (m MigrateMySQLRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLRequest.
func (m *MigrateMySQLRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLRequestProperties.
func (m MigrateMySQLRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionString", m.ConnectionString)
	populate(objectMap, "migrationType", m.MigrationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLRequestProperties.
func (m *MigrateMySQLRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &m.ConnectionString)
			delete(rawMsg, key)
		case "migrationType":
			err = unpopulate(val, "MigrationType", &m.MigrationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLStatus.
func (m MigrateMySQLStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "kind", m.Kind)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLStatus.
func (m *MigrateMySQLStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateMySQLStatusProperties.
func (m MigrateMySQLStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localMySqlEnabled", m.LocalMySQLEnabled)
	populate(objectMap, "migrationOperationStatus", m.MigrationOperationStatus)
	populate(objectMap, "operationId", m.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateMySQLStatusProperties.
func (m *MigrateMySQLStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localMySqlEnabled":
			err = unpopulate(val, "LocalMySQLEnabled", &m.LocalMySQLEnabled)
			delete(rawMsg, key)
		case "migrationOperationStatus":
			err = unpopulate(val, "MigrationOperationStatus", &m.MigrationOperationStatus)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &m.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameIdentifier.
func (n NameIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameIdentifier.
func (n *NameIdentifier) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameValuePair.
func (n NameValuePair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameValuePair.
func (n *NameValuePair) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAccessControlEntry.
func (n NetworkAccessControlEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", n.Action)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "order", n.Order)
	populate(objectMap, "remoteSubnet", n.RemoteSubnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkAccessControlEntry.
func (n *NetworkAccessControlEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &n.Action)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &n.Order)
			delete(rawMsg, key)
		case "remoteSubnet":
			err = unpopulate(val, "RemoteSubnet", &n.RemoteSubnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFeatures.
func (n NetworkFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "kind", n.Kind)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFeatures.
func (n *NetworkFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &n.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkFeaturesProperties.
func (n NetworkFeaturesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hybridConnections", n.HybridConnections)
	populate(objectMap, "hybridConnectionsV2", n.HybridConnectionsV2)
	populate(objectMap, "virtualNetworkConnection", n.VirtualNetworkConnection)
	populate(objectMap, "virtualNetworkName", n.VirtualNetworkName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkFeaturesProperties.
func (n *NetworkFeaturesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hybridConnections":
			err = unpopulate(val, "HybridConnections", &n.HybridConnections)
			delete(rawMsg, key)
		case "hybridConnectionsV2":
			err = unpopulate(val, "HybridConnectionsV2", &n.HybridConnectionsV2)
			delete(rawMsg, key)
		case "virtualNetworkConnection":
			err = unpopulate(val, "VirtualNetworkConnection", &n.VirtualNetworkConnection)
			delete(rawMsg, key)
		case "virtualNetworkName":
			err = unpopulate(val, "VirtualNetworkName", &n.VirtualNetworkName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkTrace.
func (n NetworkTrace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "path", n.Path)
	populate(objectMap, "status", n.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkTrace.
func (n *NetworkTrace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &n.Path)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &n.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC3339(objectMap, "createdTime", o.CreatedTime)
	populate(objectMap, "errors", o.Errors)
	populateTimeRFC3339(objectMap, "expirationTime", o.ExpirationTime)
	populate(objectMap, "geoMasterOperationId", o.GeoMasterOperationID)
	populate(objectMap, "id", o.ID)
	populateTimeRFC3339(objectMap, "modifiedTime", o.ModifiedTime)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &o.CreatedTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &o.Errors)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateTimeRFC3339(val, "ExpirationTime", &o.ExpirationTime)
			delete(rawMsg, key)
		case "geoMasterOperationId":
			err = unpopulate(val, "GeoMasterOperationID", &o.GeoMasterOperationID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "modifiedTime":
			err = unpopulateTimeRFC3339(val, "ModifiedTime", &o.ModifiedTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonCounterCollection.
func (p PerfMonCounterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonCounterCollection.
func (p *PerfMonCounterCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonResponse.
func (p PerfMonResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", p.Code)
	populate(objectMap, "data", p.Data)
	populate(objectMap, "message", p.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonResponse.
func (p *PerfMonResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &p.Data)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonSample.
func (p PerfMonSample) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceName", p.InstanceName)
	populateTimeRFC3339(objectMap, "time", p.Time)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonSample.
func (p *PerfMonSample) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceName":
			err = unpopulate(val, "InstanceName", &p.InstanceName)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &p.Time)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PerfMonSet.
func (p PerfMonSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populate(objectMap, "name", p.Name)
	populateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "timeGrain", p.TimeGrain)
	populate(objectMap, "values", p.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PerfMonSet.
func (p *PerfMonSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &p.TimeGrain)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &p.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Plan.
func (p Plan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Plan.
func (p *Plan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanCollection.
func (p PlanCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanCollection.
func (p *PlanCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanPatchResource.
func (p PlanPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanPatchResource.
func (p *PlanPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanPatchResourceProperties.
func (p PlanPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC3339(objectMap, "freeOfferExpirationTime", p.FreeOfferExpirationTime)
	populate(objectMap, "geoRegion", p.GeoRegion)
	populate(objectMap, "hostingEnvironmentProfile", p.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", p.HyperV)
	populate(objectMap, "isSpot", p.IsSpot)
	populate(objectMap, "isXenon", p.IsXenon)
	populate(objectMap, "maximumElasticWorkerCount", p.MaximumElasticWorkerCount)
	populate(objectMap, "maximumNumberOfWorkers", p.MaximumNumberOfWorkers)
	populate(objectMap, "numberOfSites", p.NumberOfSites)
	populate(objectMap, "perSiteScaling", p.PerSiteScaling)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "reserved", p.Reserved)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	populateTimeRFC3339(objectMap, "spotExpirationTime", p.SpotExpirationTime)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "subscription", p.Subscription)
	populate(objectMap, "targetWorkerCount", p.TargetWorkerCount)
	populate(objectMap, "targetWorkerSizeId", p.TargetWorkerSizeID)
	populate(objectMap, "workerTierName", p.WorkerTierName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanPatchResourceProperties.
func (p *PlanPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "freeOfferExpirationTime":
			err = unpopulateTimeRFC3339(val, "FreeOfferExpirationTime", &p.FreeOfferExpirationTime)
			delete(rawMsg, key)
		case "geoRegion":
			err = unpopulate(val, "GeoRegion", &p.GeoRegion)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &p.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &p.HyperV)
			delete(rawMsg, key)
		case "isSpot":
			err = unpopulate(val, "IsSpot", &p.IsSpot)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &p.IsXenon)
			delete(rawMsg, key)
		case "maximumElasticWorkerCount":
			err = unpopulate(val, "MaximumElasticWorkerCount", &p.MaximumElasticWorkerCount)
			delete(rawMsg, key)
		case "maximumNumberOfWorkers":
			err = unpopulate(val, "MaximumNumberOfWorkers", &p.MaximumNumberOfWorkers)
			delete(rawMsg, key)
		case "numberOfSites":
			err = unpopulate(val, "NumberOfSites", &p.NumberOfSites)
			delete(rawMsg, key)
		case "perSiteScaling":
			err = unpopulate(val, "PerSiteScaling", &p.PerSiteScaling)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &p.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &p.ResourceGroup)
			delete(rawMsg, key)
		case "spotExpirationTime":
			err = unpopulateTimeRFC3339(val, "SpotExpirationTime", &p.SpotExpirationTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "subscription":
			err = unpopulate(val, "Subscription", &p.Subscription)
			delete(rawMsg, key)
		case "targetWorkerCount":
			err = unpopulate(val, "TargetWorkerCount", &p.TargetWorkerCount)
			delete(rawMsg, key)
		case "targetWorkerSizeId":
			err = unpopulate(val, "TargetWorkerSizeID", &p.TargetWorkerSizeID)
			delete(rawMsg, key)
		case "workerTierName":
			err = unpopulate(val, "WorkerTierName", &p.WorkerTierName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanProperties.
func (p PlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC3339(objectMap, "freeOfferExpirationTime", p.FreeOfferExpirationTime)
	populate(objectMap, "geoRegion", p.GeoRegion)
	populate(objectMap, "hostingEnvironmentProfile", p.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", p.HyperV)
	populate(objectMap, "isSpot", p.IsSpot)
	populate(objectMap, "isXenon", p.IsXenon)
	populate(objectMap, "maximumElasticWorkerCount", p.MaximumElasticWorkerCount)
	populate(objectMap, "maximumNumberOfWorkers", p.MaximumNumberOfWorkers)
	populate(objectMap, "numberOfSites", p.NumberOfSites)
	populate(objectMap, "perSiteScaling", p.PerSiteScaling)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "reserved", p.Reserved)
	populate(objectMap, "resourceGroup", p.ResourceGroup)
	populateTimeRFC3339(objectMap, "spotExpirationTime", p.SpotExpirationTime)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "subscription", p.Subscription)
	populate(objectMap, "targetWorkerCount", p.TargetWorkerCount)
	populate(objectMap, "targetWorkerSizeId", p.TargetWorkerSizeID)
	populate(objectMap, "workerTierName", p.WorkerTierName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanProperties.
func (p *PlanProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "freeOfferExpirationTime":
			err = unpopulateTimeRFC3339(val, "FreeOfferExpirationTime", &p.FreeOfferExpirationTime)
			delete(rawMsg, key)
		case "geoRegion":
			err = unpopulate(val, "GeoRegion", &p.GeoRegion)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &p.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &p.HyperV)
			delete(rawMsg, key)
		case "isSpot":
			err = unpopulate(val, "IsSpot", &p.IsSpot)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &p.IsXenon)
			delete(rawMsg, key)
		case "maximumElasticWorkerCount":
			err = unpopulate(val, "MaximumElasticWorkerCount", &p.MaximumElasticWorkerCount)
			delete(rawMsg, key)
		case "maximumNumberOfWorkers":
			err = unpopulate(val, "MaximumNumberOfWorkers", &p.MaximumNumberOfWorkers)
			delete(rawMsg, key)
		case "numberOfSites":
			err = unpopulate(val, "NumberOfSites", &p.NumberOfSites)
			delete(rawMsg, key)
		case "perSiteScaling":
			err = unpopulate(val, "PerSiteScaling", &p.PerSiteScaling)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &p.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &p.ResourceGroup)
			delete(rawMsg, key)
		case "spotExpirationTime":
			err = unpopulateTimeRFC3339(val, "SpotExpirationTime", &p.SpotExpirationTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "subscription":
			err = unpopulate(val, "Subscription", &p.Subscription)
			delete(rawMsg, key)
		case "targetWorkerCount":
			err = unpopulate(val, "TargetWorkerCount", &p.TargetWorkerCount)
			delete(rawMsg, key)
		case "targetWorkerSizeId":
			err = unpopulate(val, "TargetWorkerSizeID", &p.TargetWorkerSizeID)
			delete(rawMsg, key)
		case "workerTierName":
			err = unpopulate(val, "WorkerTierName", &p.WorkerTierName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOn.
func (p PremierAddOn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOn.
func (p *PremierAddOn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnOffer.
func (p PremierAddOnOffer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnOffer.
func (p *PremierAddOnOffer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnOfferCollection.
func (p PremierAddOnOfferCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnOfferCollection.
func (p *PremierAddOnOfferCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnOfferProperties.
func (p PremierAddOnOfferProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "legalTermsUrl", p.LegalTermsURL)
	populate(objectMap, "marketplaceOffer", p.MarketplaceOffer)
	populate(objectMap, "marketplacePublisher", p.MarketplacePublisher)
	populate(objectMap, "privacyPolicyUrl", p.PrivacyPolicyURL)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "promoCodeRequired", p.PromoCodeRequired)
	populate(objectMap, "quota", p.Quota)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "vendor", p.Vendor)
	populate(objectMap, "webHostingPlanRestrictions", p.WebHostingPlanRestrictions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnOfferProperties.
func (p *PremierAddOnOfferProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "legalTermsUrl":
			err = unpopulate(val, "LegalTermsURL", &p.LegalTermsURL)
			delete(rawMsg, key)
		case "marketplaceOffer":
			err = unpopulate(val, "MarketplaceOffer", &p.MarketplaceOffer)
			delete(rawMsg, key)
		case "marketplacePublisher":
			err = unpopulate(val, "MarketplacePublisher", &p.MarketplacePublisher)
			delete(rawMsg, key)
		case "privacyPolicyUrl":
			err = unpopulate(val, "PrivacyPolicyURL", &p.PrivacyPolicyURL)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "promoCodeRequired":
			err = unpopulate(val, "PromoCodeRequired", &p.PromoCodeRequired)
			delete(rawMsg, key)
		case "quota":
			err = unpopulate(val, "Quota", &p.Quota)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &p.Vendor)
			delete(rawMsg, key)
		case "webHostingPlanRestrictions":
			err = unpopulate(val, "WebHostingPlanRestrictions", &p.WebHostingPlanRestrictions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnPatchResource.
func (p PremierAddOnPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnPatchResource.
func (p *PremierAddOnPatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnPatchResourceProperties.
func (p PremierAddOnPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "marketplaceOffer", p.MarketplaceOffer)
	populate(objectMap, "marketplacePublisher", p.MarketplacePublisher)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "vendor", p.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnPatchResourceProperties.
func (p *PremierAddOnPatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "marketplaceOffer":
			err = unpopulate(val, "MarketplaceOffer", &p.MarketplaceOffer)
			delete(rawMsg, key)
		case "marketplacePublisher":
			err = unpopulate(val, "MarketplacePublisher", &p.MarketplacePublisher)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &p.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PremierAddOnProperties.
func (p PremierAddOnProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "marketplaceOffer", p.MarketplaceOffer)
	populate(objectMap, "marketplacePublisher", p.MarketplacePublisher)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "vendor", p.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PremierAddOnProperties.
func (p *PremierAddOnProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "marketplaceOffer":
			err = unpopulate(val, "MarketplaceOffer", &p.MarketplaceOffer)
			delete(rawMsg, key)
		case "marketplacePublisher":
			err = unpopulate(val, "MarketplacePublisher", &p.MarketplacePublisher)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &p.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccess.
func (p PrivateAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccess.
func (p *PrivateAccess) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccessProperties.
func (p PrivateAccessProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", p.Enabled)
	populate(objectMap, "virtualNetworks", p.VirtualNetworks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccessProperties.
func (p *PrivateAccessProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &p.Enabled)
			delete(rawMsg, key)
		case "virtualNetworks":
			err = unpopulate(val, "VirtualNetworks", &p.VirtualNetworks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccessSubnet.
func (p PrivateAccessSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", p.Key)
	populate(objectMap, "name", p.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccessSubnet.
func (p *PrivateAccessSubnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &p.Key)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateAccessVirtualNetwork.
func (p PrivateAccessVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", p.Key)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "resourceId", p.ResourceID)
	populate(objectMap, "subnets", p.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateAccessVirtualNetwork.
func (p *PrivateAccessVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &p.Key)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &p.ResourceID)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &p.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessInfo.
func (p ProcessInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessInfo.
func (p *ProcessInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessInfoCollection.
func (p ProcessInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessInfoCollection.
func (p *ProcessInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessInfoProperties.
func (p ProcessInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "children", p.Children)
	populate(objectMap, "command_line", p.CommandLine)
	populate(objectMap, "deployment_name", p.DeploymentName)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "environment_variables", p.EnvironmentVariables)
	populate(objectMap, "file_name", p.FileName)
	populate(objectMap, "handle_count", p.HandleCount)
	populate(objectMap, "href", p.Href)
	populate(objectMap, "identifier", p.Identifier)
	populate(objectMap, "iis_profile_timeout_in_seconds", p.IisProfileTimeoutInSeconds)
	populate(objectMap, "is_iis_profile_running", p.IsIisProfileRunning)
	populate(objectMap, "is_profile_running", p.IsProfileRunning)
	populate(objectMap, "is_scm_site", p.IsScmSite)
	populate(objectMap, "is_webjob", p.IsWebjob)
	populate(objectMap, "minidump", p.Minidump)
	populate(objectMap, "module_count", p.ModuleCount)
	populate(objectMap, "modules", p.Modules)
	populate(objectMap, "non_paged_system_memory", p.NonPagedSystemMemory)
	populate(objectMap, "open_file_handles", p.OpenFileHandles)
	populate(objectMap, "paged_memory", p.PagedMemory)
	populate(objectMap, "paged_system_memory", p.PagedSystemMemory)
	populate(objectMap, "parent", p.Parent)
	populate(objectMap, "peak_paged_memory", p.PeakPagedMemory)
	populate(objectMap, "peak_virtual_memory", p.PeakVirtualMemory)
	populate(objectMap, "peak_working_set", p.PeakWorkingSet)
	populate(objectMap, "private_memory", p.PrivateMemory)
	populate(objectMap, "privileged_cpu_time", p.PrivilegedCPUTime)
	populateTimeRFC3339(objectMap, "start_time", p.StartTime)
	populate(objectMap, "thread_count", p.ThreadCount)
	populate(objectMap, "threads", p.Threads)
	populateTimeRFC3339(objectMap, "time_stamp", p.TimeStamp)
	populate(objectMap, "total_cpu_time", p.TotalCPUTime)
	populate(objectMap, "user_cpu_time", p.UserCPUTime)
	populate(objectMap, "user_name", p.UserName)
	populate(objectMap, "virtual_memory", p.VirtualMemory)
	populate(objectMap, "working_set", p.WorkingSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessInfoProperties.
func (p *ProcessInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "children":
			err = unpopulate(val, "Children", &p.Children)
			delete(rawMsg, key)
		case "command_line":
			err = unpopulate(val, "CommandLine", &p.CommandLine)
			delete(rawMsg, key)
		case "deployment_name":
			err = unpopulate(val, "DeploymentName", &p.DeploymentName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "environment_variables":
			err = unpopulate(val, "EnvironmentVariables", &p.EnvironmentVariables)
			delete(rawMsg, key)
		case "file_name":
			err = unpopulate(val, "FileName", &p.FileName)
			delete(rawMsg, key)
		case "handle_count":
			err = unpopulate(val, "HandleCount", &p.HandleCount)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &p.Href)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &p.Identifier)
			delete(rawMsg, key)
		case "iis_profile_timeout_in_seconds":
			err = unpopulate(val, "IisProfileTimeoutInSeconds", &p.IisProfileTimeoutInSeconds)
			delete(rawMsg, key)
		case "is_iis_profile_running":
			err = unpopulate(val, "IsIisProfileRunning", &p.IsIisProfileRunning)
			delete(rawMsg, key)
		case "is_profile_running":
			err = unpopulate(val, "IsProfileRunning", &p.IsProfileRunning)
			delete(rawMsg, key)
		case "is_scm_site":
			err = unpopulate(val, "IsScmSite", &p.IsScmSite)
			delete(rawMsg, key)
		case "is_webjob":
			err = unpopulate(val, "IsWebjob", &p.IsWebjob)
			delete(rawMsg, key)
		case "minidump":
			err = unpopulate(val, "Minidump", &p.Minidump)
			delete(rawMsg, key)
		case "module_count":
			err = unpopulate(val, "ModuleCount", &p.ModuleCount)
			delete(rawMsg, key)
		case "modules":
			err = unpopulate(val, "Modules", &p.Modules)
			delete(rawMsg, key)
		case "non_paged_system_memory":
			err = unpopulate(val, "NonPagedSystemMemory", &p.NonPagedSystemMemory)
			delete(rawMsg, key)
		case "open_file_handles":
			err = unpopulate(val, "OpenFileHandles", &p.OpenFileHandles)
			delete(rawMsg, key)
		case "paged_memory":
			err = unpopulate(val, "PagedMemory", &p.PagedMemory)
			delete(rawMsg, key)
		case "paged_system_memory":
			err = unpopulate(val, "PagedSystemMemory", &p.PagedSystemMemory)
			delete(rawMsg, key)
		case "parent":
			err = unpopulate(val, "Parent", &p.Parent)
			delete(rawMsg, key)
		case "peak_paged_memory":
			err = unpopulate(val, "PeakPagedMemory", &p.PeakPagedMemory)
			delete(rawMsg, key)
		case "peak_virtual_memory":
			err = unpopulate(val, "PeakVirtualMemory", &p.PeakVirtualMemory)
			delete(rawMsg, key)
		case "peak_working_set":
			err = unpopulate(val, "PeakWorkingSet", &p.PeakWorkingSet)
			delete(rawMsg, key)
		case "private_memory":
			err = unpopulate(val, "PrivateMemory", &p.PrivateMemory)
			delete(rawMsg, key)
		case "privileged_cpu_time":
			err = unpopulate(val, "PrivilegedCPUTime", &p.PrivilegedCPUTime)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "thread_count":
			err = unpopulate(val, "ThreadCount", &p.ThreadCount)
			delete(rawMsg, key)
		case "threads":
			err = unpopulate(val, "Threads", &p.Threads)
			delete(rawMsg, key)
		case "time_stamp":
			err = unpopulateTimeRFC3339(val, "TimeStamp", &p.TimeStamp)
			delete(rawMsg, key)
		case "total_cpu_time":
			err = unpopulate(val, "TotalCPUTime", &p.TotalCPUTime)
			delete(rawMsg, key)
		case "user_cpu_time":
			err = unpopulate(val, "UserCPUTime", &p.UserCPUTime)
			delete(rawMsg, key)
		case "user_name":
			err = unpopulate(val, "UserName", &p.UserName)
			delete(rawMsg, key)
		case "virtual_memory":
			err = unpopulate(val, "VirtualMemory", &p.VirtualMemory)
			delete(rawMsg, key)
		case "working_set":
			err = unpopulate(val, "WorkingSet", &p.WorkingSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessModuleInfo.
func (p ProcessModuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessModuleInfo.
func (p *ProcessModuleInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessModuleInfoCollection.
func (p ProcessModuleInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessModuleInfoCollection.
func (p *ProcessModuleInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessModuleInfoProperties.
func (p ProcessModuleInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "base_address", p.BaseAddress)
	populate(objectMap, "file_description", p.FileDescription)
	populate(objectMap, "file_name", p.FileName)
	populate(objectMap, "file_path", p.FilePath)
	populate(objectMap, "file_version", p.FileVersion)
	populate(objectMap, "href", p.Href)
	populate(objectMap, "is_debug", p.IsDebug)
	populate(objectMap, "language", p.Language)
	populate(objectMap, "module_memory_size", p.ModuleMemorySize)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "product_version", p.ProductVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessModuleInfoProperties.
func (p *ProcessModuleInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base_address":
			err = unpopulate(val, "BaseAddress", &p.BaseAddress)
			delete(rawMsg, key)
		case "file_description":
			err = unpopulate(val, "FileDescription", &p.FileDescription)
			delete(rawMsg, key)
		case "file_name":
			err = unpopulate(val, "FileName", &p.FileName)
			delete(rawMsg, key)
		case "file_path":
			err = unpopulate(val, "FilePath", &p.FilePath)
			delete(rawMsg, key)
		case "file_version":
			err = unpopulate(val, "FileVersion", &p.FileVersion)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &p.Href)
			delete(rawMsg, key)
		case "is_debug":
			err = unpopulate(val, "IsDebug", &p.IsDebug)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &p.Language)
			delete(rawMsg, key)
		case "module_memory_size":
			err = unpopulate(val, "ModuleMemorySize", &p.ModuleMemorySize)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "product_version":
			err = unpopulate(val, "ProductVersion", &p.ProductVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessThreadInfo.
func (p ProcessThreadInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessThreadInfo.
func (p *ProcessThreadInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessThreadInfoCollection.
func (p ProcessThreadInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessThreadInfoCollection.
func (p *ProcessThreadInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessThreadInfoProperties.
func (p ProcessThreadInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "base_priority", p.BasePriority)
	populate(objectMap, "current_priority", p.CurrentPriority)
	populate(objectMap, "href", p.Href)
	populate(objectMap, "identifier", p.Identifier)
	populate(objectMap, "priority_level", p.PriorityLevel)
	populate(objectMap, "priviledged_processor_time", p.PriviledgedProcessorTime)
	populate(objectMap, "process", p.Process)
	populate(objectMap, "start_address", p.StartAddress)
	populateTimeRFC3339(objectMap, "start_time", p.StartTime)
	populate(objectMap, "state", p.State)
	populate(objectMap, "total_processor_time", p.TotalProcessorTime)
	populate(objectMap, "user_processor_time", p.UserProcessorTime)
	populate(objectMap, "wait_reason", p.WaitReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessThreadInfoProperties.
func (p *ProcessThreadInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "base_priority":
			err = unpopulate(val, "BasePriority", &p.BasePriority)
			delete(rawMsg, key)
		case "current_priority":
			err = unpopulate(val, "CurrentPriority", &p.CurrentPriority)
			delete(rawMsg, key)
		case "href":
			err = unpopulate(val, "Href", &p.Href)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &p.Identifier)
			delete(rawMsg, key)
		case "priority_level":
			err = unpopulate(val, "PriorityLevel", &p.PriorityLevel)
			delete(rawMsg, key)
		case "priviledged_processor_time":
			err = unpopulate(val, "PriviledgedProcessorTime", &p.PriviledgedProcessorTime)
			delete(rawMsg, key)
		case "process":
			err = unpopulate(val, "Process", &p.Process)
			delete(rawMsg, key)
		case "start_address":
			err = unpopulate(val, "StartAddress", &p.StartAddress)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "total_processor_time":
			err = unpopulate(val, "TotalProcessorTime", &p.TotalProcessorTime)
			delete(rawMsg, key)
		case "user_processor_time":
			err = unpopulate(val, "UserProcessorTime", &p.UserProcessorTime)
			delete(rawMsg, key)
		case "wait_reason":
			err = unpopulate(val, "WaitReason", &p.WaitReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyOnlyResource.
func (p ProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyOnlyResource.
func (p *ProxyOnlyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicCertificate.
func (p PublicCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicCertificate.
func (p *PublicCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicCertificateCollection.
func (p PublicCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicCertificateCollection.
func (p *PublicCertificateCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicCertificateProperties.
func (p PublicCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "blob", p.Blob, runtime.Base64StdFormat)
	populate(objectMap, "publicCertificateLocation", p.PublicCertificateLocation)
	populate(objectMap, "thumbprint", p.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicCertificateProperties.
func (p *PublicCertificateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blob":
			err = runtime.DecodeByteArray(string(val), &p.Blob, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "publicCertificateLocation":
			err = unpopulate(val, "PublicCertificateLocation", &p.PublicCertificateLocation)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &p.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PushSettings.
func (p PushSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PushSettings.
func (p *PushSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PushSettingsProperties.
func (p PushSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dynamicTagsJson", p.DynamicTagsJSON)
	populate(objectMap, "isPushEnabled", p.IsPushEnabled)
	populate(objectMap, "tagWhitelistJson", p.TagWhitelistJSON)
	populate(objectMap, "tagsRequiringAuth", p.TagsRequiringAuth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PushSettingsProperties.
func (p *PushSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dynamicTagsJson":
			err = unpopulate(val, "DynamicTagsJSON", &p.DynamicTagsJSON)
			delete(rawMsg, key)
		case "isPushEnabled":
			err = unpopulate(val, "IsPushEnabled", &p.IsPushEnabled)
			delete(rawMsg, key)
		case "tagWhitelistJson":
			err = unpopulate(val, "TagWhitelistJSON", &p.TagWhitelistJSON)
			delete(rawMsg, key)
		case "tagsRequiringAuth":
			err = unpopulate(val, "TagsRequiringAuth", &p.TagsRequiringAuth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RampUpRule.
func (r RampUpRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionHostName", r.ActionHostName)
	populate(objectMap, "changeDecisionCallbackUrl", r.ChangeDecisionCallbackURL)
	populate(objectMap, "changeIntervalInMinutes", r.ChangeIntervalInMinutes)
	populate(objectMap, "changeStep", r.ChangeStep)
	populate(objectMap, "maxReroutePercentage", r.MaxReroutePercentage)
	populate(objectMap, "minReroutePercentage", r.MinReroutePercentage)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "reroutePercentage", r.ReroutePercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RampUpRule.
func (r *RampUpRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionHostName":
			err = unpopulate(val, "ActionHostName", &r.ActionHostName)
			delete(rawMsg, key)
		case "changeDecisionCallbackUrl":
			err = unpopulate(val, "ChangeDecisionCallbackURL", &r.ChangeDecisionCallbackURL)
			delete(rawMsg, key)
		case "changeIntervalInMinutes":
			err = unpopulate(val, "ChangeIntervalInMinutes", &r.ChangeIntervalInMinutes)
			delete(rawMsg, key)
		case "changeStep":
			err = unpopulate(val, "ChangeStep", &r.ChangeStep)
			delete(rawMsg, key)
		case "maxReroutePercentage":
			err = unpopulate(val, "MaxReroutePercentage", &r.MaxReroutePercentage)
			delete(rawMsg, key)
		case "minReroutePercentage":
			err = unpopulate(val, "MinReroutePercentage", &r.MinReroutePercentage)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "reroutePercentage":
			err = unpopulate(val, "ReroutePercentage", &r.ReroutePercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Recommendation.
func (r Recommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Recommendation.
func (r *Recommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationCollection.
func (r RecommendationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationCollection.
func (r *RecommendationCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationProperties.
func (r RecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", r.ActionName)
	populate(objectMap, "bladeName", r.BladeName)
	populate(objectMap, "categoryTags", r.CategoryTags)
	populate(objectMap, "channels", r.Channels)
	populateTimeRFC3339(objectMap, "creationTime", r.CreationTime)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "enabled", r.Enabled)
	populateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "extensionName", r.ExtensionName)
	populate(objectMap, "forwardLink", r.ForwardLink)
	populate(objectMap, "isDynamic", r.IsDynamic)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "message", r.Message)
	populateTimeRFC3339(objectMap, "nextNotificationTime", r.NextNotificationTime)
	populateTimeRFC3339(objectMap, "notificationExpirationTime", r.NotificationExpirationTime)
	populateTimeRFC3339(objectMap, "notifiedTime", r.NotifiedTime)
	populate(objectMap, "recommendationId", r.RecommendationID)
	populate(objectMap, "resourceId", r.ResourceID)
	populate(objectMap, "resourceScope", r.ResourceScope)
	populate(objectMap, "ruleName", r.RuleName)
	populate(objectMap, "score", r.Score)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	populate(objectMap, "states", r.States)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationProperties.
func (r *RecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &r.ActionName)
			delete(rawMsg, key)
		case "bladeName":
			err = unpopulate(val, "BladeName", &r.BladeName)
			delete(rawMsg, key)
		case "categoryTags":
			err = unpopulate(val, "CategoryTags", &r.CategoryTags)
			delete(rawMsg, key)
		case "channels":
			err = unpopulate(val, "Channels", &r.Channels)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &r.CreationTime)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "extensionName":
			err = unpopulate(val, "ExtensionName", &r.ExtensionName)
			delete(rawMsg, key)
		case "forwardLink":
			err = unpopulate(val, "ForwardLink", &r.ForwardLink)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &r.IsDynamic)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "nextNotificationTime":
			err = unpopulateTimeRFC3339(val, "NextNotificationTime", &r.NextNotificationTime)
			delete(rawMsg, key)
		case "notificationExpirationTime":
			err = unpopulateTimeRFC3339(val, "NotificationExpirationTime", &r.NotificationExpirationTime)
			delete(rawMsg, key)
		case "notifiedTime":
			err = unpopulateTimeRFC3339(val, "NotifiedTime", &r.NotifiedTime)
			delete(rawMsg, key)
		case "recommendationId":
			err = unpopulate(val, "RecommendationID", &r.RecommendationID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		case "resourceScope":
			err = unpopulate(val, "ResourceScope", &r.ResourceScope)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &r.RuleName)
			delete(rawMsg, key)
		case "score":
			err = unpopulate(val, "Score", &r.Score)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "states":
			err = unpopulate(val, "States", &r.States)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationRule.
func (r RecommendationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationRule.
func (r *RecommendationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationRuleProperties.
func (r RecommendationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", r.ActionName)
	populate(objectMap, "bladeName", r.BladeName)
	populate(objectMap, "categoryTags", r.CategoryTags)
	populate(objectMap, "channels", r.Channels)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "extensionName", r.ExtensionName)
	populate(objectMap, "forwardLink", r.ForwardLink)
	populate(objectMap, "isDynamic", r.IsDynamic)
	populate(objectMap, "level", r.Level)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "recommendationId", r.RecommendationID)
	populate(objectMap, "recommendationName", r.RecommendationName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationRuleProperties.
func (r *RecommendationRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &r.ActionName)
			delete(rawMsg, key)
		case "bladeName":
			err = unpopulate(val, "BladeName", &r.BladeName)
			delete(rawMsg, key)
		case "categoryTags":
			err = unpopulate(val, "CategoryTags", &r.CategoryTags)
			delete(rawMsg, key)
		case "channels":
			err = unpopulate(val, "Channels", &r.Channels)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "extensionName":
			err = unpopulate(val, "ExtensionName", &r.ExtensionName)
			delete(rawMsg, key)
		case "forwardLink":
			err = unpopulate(val, "ForwardLink", &r.ForwardLink)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &r.IsDynamic)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &r.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "recommendationId":
			err = unpopulate(val, "RecommendationID", &r.RecommendationID)
			delete(rawMsg, key)
		case "recommendationName":
			err = unpopulate(val, "RecommendationName", &r.RecommendationName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelayServiceConnectionEntity.
func (r RelayServiceConnectionEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelayServiceConnectionEntity.
func (r *RelayServiceConnectionEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelayServiceConnectionEntityProperties.
func (r RelayServiceConnectionEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biztalkUri", r.BiztalkURI)
	populate(objectMap, "entityConnectionString", r.EntityConnectionString)
	populate(objectMap, "entityName", r.EntityName)
	populate(objectMap, "hostname", r.Hostname)
	populate(objectMap, "port", r.Port)
	populate(objectMap, "resourceConnectionString", r.ResourceConnectionString)
	populate(objectMap, "resourceType", r.ResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelayServiceConnectionEntityProperties.
func (r *RelayServiceConnectionEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biztalkUri":
			err = unpopulate(val, "BiztalkURI", &r.BiztalkURI)
			delete(rawMsg, key)
		case "entityConnectionString":
			err = unpopulate(val, "EntityConnectionString", &r.EntityConnectionString)
			delete(rawMsg, key)
		case "entityName":
			err = unpopulate(val, "EntityName", &r.EntityName)
			delete(rawMsg, key)
		case "hostname":
			err = unpopulate(val, "Hostname", &r.Hostname)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &r.Port)
			delete(rawMsg, key)
		case "resourceConnectionString":
			err = unpopulate(val, "ResourceConnectionString", &r.ResourceConnectionString)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestsBasedTrigger.
func (r RequestsBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "timeInterval", r.TimeInterval)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestsBasedTrigger.
func (r *RequestsBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &r.TimeInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceCollection.
func (r ResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceCollection.
func (r *ResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetric.
func (r ResourceMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC3339(objectMap, "endTime", r.EndTime)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "metricValues", r.MetricValues)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "resourceId", r.ResourceID)
	populateTimeRFC3339(objectMap, "startTime", r.StartTime)
	populate(objectMap, "timeGrain", r.TimeGrain)
	populate(objectMap, "unit", r.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetric.
func (r *ResourceMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "metricValues":
			err = unpopulate(val, "MetricValues", &r.MetricValues)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &r.TimeGrain)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricAvailability.
func (r ResourceMetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "retention", r.Retention)
	populate(objectMap, "timeGrain", r.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricAvailability.
func (r *ResourceMetricAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retention":
			err = unpopulate(val, "Retention", &r.Retention)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &r.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricCollection.
func (r ResourceMetricCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricCollection.
func (r *ResourceMetricCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricDefinition.
func (r ResourceMetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricDefinition.
func (r *ResourceMetricDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricDefinitionCollection.
func (r ResourceMetricDefinitionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricDefinitionCollection.
func (r *ResourceMetricDefinitionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricDefinitionProperties.
func (r ResourceMetricDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metricAvailabilities", r.MetricAvailabilities)
	populate(objectMap, "primaryAggregationType", r.PrimaryAggregationType)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "unit", r.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricDefinitionProperties.
func (r *ResourceMetricDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricAvailabilities":
			err = unpopulate(val, "MetricAvailabilities", &r.MetricAvailabilities)
			delete(rawMsg, key)
		case "primaryAggregationType":
			err = unpopulate(val, "PrimaryAggregationType", &r.PrimaryAggregationType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricName.
func (r ResourceMetricName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", r.LocalizedValue)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricName.
func (r *ResourceMetricName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &r.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricProperty.
func (r ResourceMetricProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", r.Key)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricProperty.
func (r *ResourceMetricProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &r.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMetricValue.
func (r ResourceMetricValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "average", r.Average)
	populate(objectMap, "count", r.Count)
	populate(objectMap, "maximum", r.Maximum)
	populate(objectMap, "minimum", r.Minimum)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "timestamp", r.Timestamp)
	populate(objectMap, "total", r.Total)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMetricValue.
func (r *ResourceMetricValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "average":
			err = unpopulate(val, "Average", &r.Average)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &r.Count)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &r.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &r.Minimum)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulate(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		case "total":
			err = unpopulate(val, "Total", &r.Total)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNameAvailability.
func (r ResourceNameAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "nameAvailable", r.NameAvailable)
	populate(objectMap, "reason", r.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNameAvailability.
func (r *ResourceNameAvailability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &r.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &r.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNameAvailabilityRequest.
func (r ResourceNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isFqdn", r.IsFqdn)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNameAvailabilityRequest.
func (r *ResourceNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isFqdn":
			err = unpopulate(val, "IsFqdn", &r.IsFqdn)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreRequest.
func (r RestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreRequest.
func (r *RestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreRequestProperties.
func (r RestoreRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adjustConnectionStrings", r.AdjustConnectionStrings)
	populate(objectMap, "appServicePlan", r.AppServicePlan)
	populate(objectMap, "blobName", r.BlobName)
	populate(objectMap, "databases", r.Databases)
	populate(objectMap, "hostingEnvironment", r.HostingEnvironment)
	populate(objectMap, "ignoreConflictingHostNames", r.IgnoreConflictingHostNames)
	populate(objectMap, "ignoreDatabases", r.IgnoreDatabases)
	populate(objectMap, "operationType", r.OperationType)
	populate(objectMap, "overwrite", r.Overwrite)
	populate(objectMap, "siteName", r.SiteName)
	populate(objectMap, "storageAccountUrl", r.StorageAccountURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreRequestProperties.
func (r *RestoreRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adjustConnectionStrings":
			err = unpopulate(val, "AdjustConnectionStrings", &r.AdjustConnectionStrings)
			delete(rawMsg, key)
		case "appServicePlan":
			err = unpopulate(val, "AppServicePlan", &r.AppServicePlan)
			delete(rawMsg, key)
		case "blobName":
			err = unpopulate(val, "BlobName", &r.BlobName)
			delete(rawMsg, key)
		case "databases":
			err = unpopulate(val, "Databases", &r.Databases)
			delete(rawMsg, key)
		case "hostingEnvironment":
			err = unpopulate(val, "HostingEnvironment", &r.HostingEnvironment)
			delete(rawMsg, key)
		case "ignoreConflictingHostNames":
			err = unpopulate(val, "IgnoreConflictingHostNames", &r.IgnoreConflictingHostNames)
			delete(rawMsg, key)
		case "ignoreDatabases":
			err = unpopulate(val, "IgnoreDatabases", &r.IgnoreDatabases)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &r.OperationType)
			delete(rawMsg, key)
		case "overwrite":
			err = unpopulate(val, "Overwrite", &r.Overwrite)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &r.SiteName)
			delete(rawMsg, key)
		case "storageAccountUrl":
			err = unpopulate(val, "StorageAccountURL", &r.StorageAccountURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUDescription.
func (s SKUDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "skuCapacity", s.SKUCapacity)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUDescription.
func (s *SKUDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "skuCapacity":
			err = unpopulate(val, "SKUCapacity", &s.SKUCapacity)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUInfos.
func (s SKUInfos) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "skus", s.SKUs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUInfos.
func (s *SKUInfos) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "skus":
			err = unpopulate(val, "SKUs", &s.SKUs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Site.
func (s *Site) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteAuthSettings.
func (s SiteAuthSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteAuthSettings.
func (s *SiteAuthSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteAuthSettingsProperties.
func (s SiteAuthSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalLoginParams", s.AdditionalLoginParams)
	populate(objectMap, "allowedAudiences", s.AllowedAudiences)
	populate(objectMap, "allowedExternalRedirectUrls", s.AllowedExternalRedirectUrls)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "clientSecret", s.ClientSecret)
	populate(objectMap, "clientSecretCertificateThumbprint", s.ClientSecretCertificateThumbprint)
	populate(objectMap, "defaultProvider", s.DefaultProvider)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "facebookAppId", s.FacebookAppID)
	populate(objectMap, "facebookAppSecret", s.FacebookAppSecret)
	populate(objectMap, "facebookOAuthScopes", s.FacebookOAuthScopes)
	populate(objectMap, "googleClientId", s.GoogleClientID)
	populate(objectMap, "googleClientSecret", s.GoogleClientSecret)
	populate(objectMap, "googleOAuthScopes", s.GoogleOAuthScopes)
	populate(objectMap, "issuer", s.Issuer)
	populate(objectMap, "microsoftAccountClientId", s.MicrosoftAccountClientID)
	populate(objectMap, "microsoftAccountClientSecret", s.MicrosoftAccountClientSecret)
	populate(objectMap, "microsoftAccountOAuthScopes", s.MicrosoftAccountOAuthScopes)
	populate(objectMap, "runtimeVersion", s.RuntimeVersion)
	populate(objectMap, "tokenRefreshExtensionHours", s.TokenRefreshExtensionHours)
	populate(objectMap, "tokenStoreEnabled", s.TokenStoreEnabled)
	populate(objectMap, "twitterConsumerKey", s.TwitterConsumerKey)
	populate(objectMap, "twitterConsumerSecret", s.TwitterConsumerSecret)
	populate(objectMap, "unauthenticatedClientAction", s.UnauthenticatedClientAction)
	populate(objectMap, "validateIssuer", s.ValidateIssuer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteAuthSettingsProperties.
func (s *SiteAuthSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalLoginParams":
			err = unpopulate(val, "AdditionalLoginParams", &s.AdditionalLoginParams)
			delete(rawMsg, key)
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &s.AllowedAudiences)
			delete(rawMsg, key)
		case "allowedExternalRedirectUrls":
			err = unpopulate(val, "AllowedExternalRedirectUrls", &s.AllowedExternalRedirectUrls)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &s.ClientSecret)
			delete(rawMsg, key)
		case "clientSecretCertificateThumbprint":
			err = unpopulate(val, "ClientSecretCertificateThumbprint", &s.ClientSecretCertificateThumbprint)
			delete(rawMsg, key)
		case "defaultProvider":
			err = unpopulate(val, "DefaultProvider", &s.DefaultProvider)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "facebookAppId":
			err = unpopulate(val, "FacebookAppID", &s.FacebookAppID)
			delete(rawMsg, key)
		case "facebookAppSecret":
			err = unpopulate(val, "FacebookAppSecret", &s.FacebookAppSecret)
			delete(rawMsg, key)
		case "facebookOAuthScopes":
			err = unpopulate(val, "FacebookOAuthScopes", &s.FacebookOAuthScopes)
			delete(rawMsg, key)
		case "googleClientId":
			err = unpopulate(val, "GoogleClientID", &s.GoogleClientID)
			delete(rawMsg, key)
		case "googleClientSecret":
			err = unpopulate(val, "GoogleClientSecret", &s.GoogleClientSecret)
			delete(rawMsg, key)
		case "googleOAuthScopes":
			err = unpopulate(val, "GoogleOAuthScopes", &s.GoogleOAuthScopes)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &s.Issuer)
			delete(rawMsg, key)
		case "microsoftAccountClientId":
			err = unpopulate(val, "MicrosoftAccountClientID", &s.MicrosoftAccountClientID)
			delete(rawMsg, key)
		case "microsoftAccountClientSecret":
			err = unpopulate(val, "MicrosoftAccountClientSecret", &s.MicrosoftAccountClientSecret)
			delete(rawMsg, key)
		case "microsoftAccountOAuthScopes":
			err = unpopulate(val, "MicrosoftAccountOAuthScopes", &s.MicrosoftAccountOAuthScopes)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &s.RuntimeVersion)
			delete(rawMsg, key)
		case "tokenRefreshExtensionHours":
			err = unpopulate(val, "TokenRefreshExtensionHours", &s.TokenRefreshExtensionHours)
			delete(rawMsg, key)
		case "tokenStoreEnabled":
			err = unpopulate(val, "TokenStoreEnabled", &s.TokenStoreEnabled)
			delete(rawMsg, key)
		case "twitterConsumerKey":
			err = unpopulate(val, "TwitterConsumerKey", &s.TwitterConsumerKey)
			delete(rawMsg, key)
		case "twitterConsumerSecret":
			err = unpopulate(val, "TwitterConsumerSecret", &s.TwitterConsumerSecret)
			delete(rawMsg, key)
		case "unauthenticatedClientAction":
			err = unpopulate(val, "UnauthenticatedClientAction", &s.UnauthenticatedClientAction)
			delete(rawMsg, key)
		case "validateIssuer":
			err = unpopulate(val, "ValidateIssuer", &s.ValidateIssuer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteCloneability.
func (s SiteCloneability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blockingCharacteristics", s.BlockingCharacteristics)
	populate(objectMap, "blockingFeatures", s.BlockingFeatures)
	populate(objectMap, "result", s.Result)
	populate(objectMap, "unsupportedFeatures", s.UnsupportedFeatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteCloneability.
func (s *SiteCloneability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blockingCharacteristics":
			err = unpopulate(val, "BlockingCharacteristics", &s.BlockingCharacteristics)
			delete(rawMsg, key)
		case "blockingFeatures":
			err = unpopulate(val, "BlockingFeatures", &s.BlockingFeatures)
			delete(rawMsg, key)
		case "result":
			err = unpopulate(val, "Result", &s.Result)
			delete(rawMsg, key)
		case "unsupportedFeatures":
			err = unpopulate(val, "UnsupportedFeatures", &s.UnsupportedFeatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteCloneabilityCriterion.
func (s SiteCloneabilityCriterion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteCloneabilityCriterion.
func (s *SiteCloneabilityCriterion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfig.
func (s SiteConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiDefinition", s.APIDefinition)
	populate(objectMap, "alwaysOn", s.AlwaysOn)
	populate(objectMap, "appCommandLine", s.AppCommandLine)
	populate(objectMap, "appSettings", s.AppSettings)
	populate(objectMap, "autoHealEnabled", s.AutoHealEnabled)
	populate(objectMap, "autoHealRules", s.AutoHealRules)
	populate(objectMap, "autoSwapSlotName", s.AutoSwapSlotName)
	populate(objectMap, "azureStorageAccounts", s.AzureStorageAccounts)
	populate(objectMap, "connectionStrings", s.ConnectionStrings)
	populate(objectMap, "cors", s.Cors)
	populate(objectMap, "defaultDocuments", s.DefaultDocuments)
	populate(objectMap, "detailedErrorLoggingEnabled", s.DetailedErrorLoggingEnabled)
	populate(objectMap, "documentRoot", s.DocumentRoot)
	populate(objectMap, "experiments", s.Experiments)
	populate(objectMap, "ftpsState", s.FtpsState)
	populate(objectMap, "httpLoggingEnabled", s.HTTPLoggingEnabled)
	populate(objectMap, "handlerMappings", s.HandlerMappings)
	populate(objectMap, "http20Enabled", s.Http20Enabled)
	populate(objectMap, "ipSecurityRestrictions", s.IPSecurityRestrictions)
	populate(objectMap, "javaContainer", s.JavaContainer)
	populate(objectMap, "javaContainerVersion", s.JavaContainerVersion)
	populate(objectMap, "javaVersion", s.JavaVersion)
	populate(objectMap, "limits", s.Limits)
	populate(objectMap, "linuxFxVersion", s.LinuxFxVersion)
	populate(objectMap, "loadBalancing", s.LoadBalancing)
	populate(objectMap, "localMySqlEnabled", s.LocalMySQLEnabled)
	populate(objectMap, "logsDirectorySizeLimit", s.LogsDirectorySizeLimit)
	populate(objectMap, "machineKey", s.MachineKey)
	populate(objectMap, "managedPipelineMode", s.ManagedPipelineMode)
	populate(objectMap, "managedServiceIdentityId", s.ManagedServiceIdentityID)
	populate(objectMap, "minTlsVersion", s.MinTLSVersion)
	populate(objectMap, "netFrameworkVersion", s.NetFrameworkVersion)
	populate(objectMap, "nodeVersion", s.NodeVersion)
	populate(objectMap, "numberOfWorkers", s.NumberOfWorkers)
	populate(objectMap, "phpVersion", s.PhpVersion)
	populate(objectMap, "publishingUsername", s.PublishingUsername)
	populate(objectMap, "push", s.Push)
	populate(objectMap, "pythonVersion", s.PythonVersion)
	populate(objectMap, "remoteDebuggingEnabled", s.RemoteDebuggingEnabled)
	populate(objectMap, "remoteDebuggingVersion", s.RemoteDebuggingVersion)
	populate(objectMap, "requestTracingEnabled", s.RequestTracingEnabled)
	populateTimeRFC3339(objectMap, "requestTracingExpirationTime", s.RequestTracingExpirationTime)
	populate(objectMap, "reservedInstanceCount", s.ReservedInstanceCount)
	populate(objectMap, "scmIpSecurityRestrictions", s.ScmIPSecurityRestrictions)
	populate(objectMap, "scmIpSecurityRestrictionsUseMain", s.ScmIPSecurityRestrictionsUseMain)
	populate(objectMap, "scmType", s.ScmType)
	populate(objectMap, "tracingOptions", s.TracingOptions)
	populate(objectMap, "use32BitWorkerProcess", s.Use32BitWorkerProcess)
	populate(objectMap, "virtualApplications", s.VirtualApplications)
	populate(objectMap, "vnetName", s.VnetName)
	populate(objectMap, "webSocketsEnabled", s.WebSocketsEnabled)
	populate(objectMap, "windowsFxVersion", s.WindowsFxVersion)
	populate(objectMap, "xManagedServiceIdentityId", s.XManagedServiceIdentityID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfig.
func (s *SiteConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiDefinition":
			err = unpopulate(val, "APIDefinition", &s.APIDefinition)
			delete(rawMsg, key)
		case "alwaysOn":
			err = unpopulate(val, "AlwaysOn", &s.AlwaysOn)
			delete(rawMsg, key)
		case "appCommandLine":
			err = unpopulate(val, "AppCommandLine", &s.AppCommandLine)
			delete(rawMsg, key)
		case "appSettings":
			err = unpopulate(val, "AppSettings", &s.AppSettings)
			delete(rawMsg, key)
		case "autoHealEnabled":
			err = unpopulate(val, "AutoHealEnabled", &s.AutoHealEnabled)
			delete(rawMsg, key)
		case "autoHealRules":
			err = unpopulate(val, "AutoHealRules", &s.AutoHealRules)
			delete(rawMsg, key)
		case "autoSwapSlotName":
			err = unpopulate(val, "AutoSwapSlotName", &s.AutoSwapSlotName)
			delete(rawMsg, key)
		case "azureStorageAccounts":
			err = unpopulate(val, "AzureStorageAccounts", &s.AzureStorageAccounts)
			delete(rawMsg, key)
		case "connectionStrings":
			err = unpopulate(val, "ConnectionStrings", &s.ConnectionStrings)
			delete(rawMsg, key)
		case "cors":
			err = unpopulate(val, "Cors", &s.Cors)
			delete(rawMsg, key)
		case "defaultDocuments":
			err = unpopulate(val, "DefaultDocuments", &s.DefaultDocuments)
			delete(rawMsg, key)
		case "detailedErrorLoggingEnabled":
			err = unpopulate(val, "DetailedErrorLoggingEnabled", &s.DetailedErrorLoggingEnabled)
			delete(rawMsg, key)
		case "documentRoot":
			err = unpopulate(val, "DocumentRoot", &s.DocumentRoot)
			delete(rawMsg, key)
		case "experiments":
			err = unpopulate(val, "Experiments", &s.Experiments)
			delete(rawMsg, key)
		case "ftpsState":
			err = unpopulate(val, "FtpsState", &s.FtpsState)
			delete(rawMsg, key)
		case "httpLoggingEnabled":
			err = unpopulate(val, "HTTPLoggingEnabled", &s.HTTPLoggingEnabled)
			delete(rawMsg, key)
		case "handlerMappings":
			err = unpopulate(val, "HandlerMappings", &s.HandlerMappings)
			delete(rawMsg, key)
		case "http20Enabled":
			err = unpopulate(val, "Http20Enabled", &s.Http20Enabled)
			delete(rawMsg, key)
		case "ipSecurityRestrictions":
			err = unpopulate(val, "IPSecurityRestrictions", &s.IPSecurityRestrictions)
			delete(rawMsg, key)
		case "javaContainer":
			err = unpopulate(val, "JavaContainer", &s.JavaContainer)
			delete(rawMsg, key)
		case "javaContainerVersion":
			err = unpopulate(val, "JavaContainerVersion", &s.JavaContainerVersion)
			delete(rawMsg, key)
		case "javaVersion":
			err = unpopulate(val, "JavaVersion", &s.JavaVersion)
			delete(rawMsg, key)
		case "limits":
			err = unpopulate(val, "Limits", &s.Limits)
			delete(rawMsg, key)
		case "linuxFxVersion":
			err = unpopulate(val, "LinuxFxVersion", &s.LinuxFxVersion)
			delete(rawMsg, key)
		case "loadBalancing":
			err = unpopulate(val, "LoadBalancing", &s.LoadBalancing)
			delete(rawMsg, key)
		case "localMySqlEnabled":
			err = unpopulate(val, "LocalMySQLEnabled", &s.LocalMySQLEnabled)
			delete(rawMsg, key)
		case "logsDirectorySizeLimit":
			err = unpopulate(val, "LogsDirectorySizeLimit", &s.LogsDirectorySizeLimit)
			delete(rawMsg, key)
		case "machineKey":
			err = unpopulate(val, "MachineKey", &s.MachineKey)
			delete(rawMsg, key)
		case "managedPipelineMode":
			err = unpopulate(val, "ManagedPipelineMode", &s.ManagedPipelineMode)
			delete(rawMsg, key)
		case "managedServiceIdentityId":
			err = unpopulate(val, "ManagedServiceIdentityID", &s.ManagedServiceIdentityID)
			delete(rawMsg, key)
		case "minTlsVersion":
			err = unpopulate(val, "MinTLSVersion", &s.MinTLSVersion)
			delete(rawMsg, key)
		case "netFrameworkVersion":
			err = unpopulate(val, "NetFrameworkVersion", &s.NetFrameworkVersion)
			delete(rawMsg, key)
		case "nodeVersion":
			err = unpopulate(val, "NodeVersion", &s.NodeVersion)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &s.NumberOfWorkers)
			delete(rawMsg, key)
		case "phpVersion":
			err = unpopulate(val, "PhpVersion", &s.PhpVersion)
			delete(rawMsg, key)
		case "publishingUsername":
			err = unpopulate(val, "PublishingUsername", &s.PublishingUsername)
			delete(rawMsg, key)
		case "push":
			err = unpopulate(val, "Push", &s.Push)
			delete(rawMsg, key)
		case "pythonVersion":
			err = unpopulate(val, "PythonVersion", &s.PythonVersion)
			delete(rawMsg, key)
		case "remoteDebuggingEnabled":
			err = unpopulate(val, "RemoteDebuggingEnabled", &s.RemoteDebuggingEnabled)
			delete(rawMsg, key)
		case "remoteDebuggingVersion":
			err = unpopulate(val, "RemoteDebuggingVersion", &s.RemoteDebuggingVersion)
			delete(rawMsg, key)
		case "requestTracingEnabled":
			err = unpopulate(val, "RequestTracingEnabled", &s.RequestTracingEnabled)
			delete(rawMsg, key)
		case "requestTracingExpirationTime":
			err = unpopulateTimeRFC3339(val, "RequestTracingExpirationTime", &s.RequestTracingExpirationTime)
			delete(rawMsg, key)
		case "reservedInstanceCount":
			err = unpopulate(val, "ReservedInstanceCount", &s.ReservedInstanceCount)
			delete(rawMsg, key)
		case "scmIpSecurityRestrictions":
			err = unpopulate(val, "ScmIPSecurityRestrictions", &s.ScmIPSecurityRestrictions)
			delete(rawMsg, key)
		case "scmIpSecurityRestrictionsUseMain":
			err = unpopulate(val, "ScmIPSecurityRestrictionsUseMain", &s.ScmIPSecurityRestrictionsUseMain)
			delete(rawMsg, key)
		case "scmType":
			err = unpopulate(val, "ScmType", &s.ScmType)
			delete(rawMsg, key)
		case "tracingOptions":
			err = unpopulate(val, "TracingOptions", &s.TracingOptions)
			delete(rawMsg, key)
		case "use32BitWorkerProcess":
			err = unpopulate(val, "Use32BitWorkerProcess", &s.Use32BitWorkerProcess)
			delete(rawMsg, key)
		case "virtualApplications":
			err = unpopulate(val, "VirtualApplications", &s.VirtualApplications)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &s.VnetName)
			delete(rawMsg, key)
		case "webSocketsEnabled":
			err = unpopulate(val, "WebSocketsEnabled", &s.WebSocketsEnabled)
			delete(rawMsg, key)
		case "windowsFxVersion":
			err = unpopulate(val, "WindowsFxVersion", &s.WindowsFxVersion)
			delete(rawMsg, key)
		case "xManagedServiceIdentityId":
			err = unpopulate(val, "XManagedServiceIdentityID", &s.XManagedServiceIdentityID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigResource.
func (s SiteConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigResource.
func (s *SiteConfigResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigResourceCollection.
func (s SiteConfigResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigResourceCollection.
func (s *SiteConfigResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigurationSnapshotInfo.
func (s SiteConfigurationSnapshotInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigurationSnapshotInfo.
func (s *SiteConfigurationSnapshotInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigurationSnapshotInfoCollection.
func (s SiteConfigurationSnapshotInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigurationSnapshotInfoCollection.
func (s *SiteConfigurationSnapshotInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteConfigurationSnapshotInfoProperties.
func (s SiteConfigurationSnapshotInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "snapshotId", s.SnapshotID)
	populateTimeRFC3339(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteConfigurationSnapshotInfoProperties.
func (s *SiteConfigurationSnapshotInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "snapshotId":
			err = unpopulate(val, "SnapshotID", &s.SnapshotID)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteExtensionInfo.
func (s SiteExtensionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteExtensionInfo.
func (s *SiteExtensionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteExtensionInfoCollection.
func (s SiteExtensionInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteExtensionInfoCollection.
func (s *SiteExtensionInfoCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteExtensionInfoProperties.
func (s SiteExtensionInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authors", s.Authors)
	populate(objectMap, "comment", s.Comment)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "download_count", s.DownloadCount)
	populate(objectMap, "extension_id", s.ExtensionID)
	populate(objectMap, "extension_type", s.ExtensionType)
	populate(objectMap, "extension_url", s.ExtensionURL)
	populate(objectMap, "feed_url", s.FeedURL)
	populate(objectMap, "icon_url", s.IconURL)
	populateTimeRFC3339(objectMap, "installed_date_time", s.InstalledDateTime)
	populate(objectMap, "installer_command_line_params", s.InstallerCommandLineParams)
	populate(objectMap, "license_url", s.LicenseURL)
	populate(objectMap, "local_is_latest_version", s.LocalIsLatestVersion)
	populate(objectMap, "local_path", s.LocalPath)
	populate(objectMap, "project_url", s.ProjectURL)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateTimeRFC3339(objectMap, "published_date_time", s.PublishedDateTime)
	populate(objectMap, "summary", s.Summary)
	populate(objectMap, "title", s.Title)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteExtensionInfoProperties.
func (s *SiteExtensionInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authors":
			err = unpopulate(val, "Authors", &s.Authors)
			delete(rawMsg, key)
		case "comment":
			err = unpopulate(val, "Comment", &s.Comment)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "download_count":
			err = unpopulate(val, "DownloadCount", &s.DownloadCount)
			delete(rawMsg, key)
		case "extension_id":
			err = unpopulate(val, "ExtensionID", &s.ExtensionID)
			delete(rawMsg, key)
		case "extension_type":
			err = unpopulate(val, "ExtensionType", &s.ExtensionType)
			delete(rawMsg, key)
		case "extension_url":
			err = unpopulate(val, "ExtensionURL", &s.ExtensionURL)
			delete(rawMsg, key)
		case "feed_url":
			err = unpopulate(val, "FeedURL", &s.FeedURL)
			delete(rawMsg, key)
		case "icon_url":
			err = unpopulate(val, "IconURL", &s.IconURL)
			delete(rawMsg, key)
		case "installed_date_time":
			err = unpopulateTimeRFC3339(val, "InstalledDateTime", &s.InstalledDateTime)
			delete(rawMsg, key)
		case "installer_command_line_params":
			err = unpopulate(val, "InstallerCommandLineParams", &s.InstallerCommandLineParams)
			delete(rawMsg, key)
		case "license_url":
			err = unpopulate(val, "LicenseURL", &s.LicenseURL)
			delete(rawMsg, key)
		case "local_is_latest_version":
			err = unpopulate(val, "LocalIsLatestVersion", &s.LocalIsLatestVersion)
			delete(rawMsg, key)
		case "local_path":
			err = unpopulate(val, "LocalPath", &s.LocalPath)
			delete(rawMsg, key)
		case "project_url":
			err = unpopulate(val, "ProjectURL", &s.ProjectURL)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "published_date_time":
			err = unpopulateTimeRFC3339(val, "PublishedDateTime", &s.PublishedDateTime)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &s.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteInstance.
func (s SiteInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteInstance.
func (s *SiteInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteInstanceProperties.
func (s SiteInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "siteInstanceName", s.SiteInstanceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteInstanceProperties.
func (s *SiteInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "siteInstanceName":
			err = unpopulate(val, "SiteInstanceName", &s.SiteInstanceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteLimits.
func (s SiteLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxDiskSizeInMb", s.MaxDiskSizeInMb)
	populate(objectMap, "maxMemoryInMb", s.MaxMemoryInMb)
	populate(objectMap, "maxPercentageCpu", s.MaxPercentageCPU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteLimits.
func (s *SiteLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxDiskSizeInMb":
			err = unpopulate(val, "MaxDiskSizeInMb", &s.MaxDiskSizeInMb)
			delete(rawMsg, key)
		case "maxMemoryInMb":
			err = unpopulate(val, "MaxMemoryInMb", &s.MaxMemoryInMb)
			delete(rawMsg, key)
		case "maxPercentageCpu":
			err = unpopulate(val, "MaxPercentageCPU", &s.MaxPercentageCPU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteLogsConfig.
func (s SiteLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteLogsConfig.
func (s *SiteLogsConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteLogsConfigProperties.
func (s SiteLogsConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationLogs", s.ApplicationLogs)
	populate(objectMap, "detailedErrorMessages", s.DetailedErrorMessages)
	populate(objectMap, "failedRequestsTracing", s.FailedRequestsTracing)
	populate(objectMap, "httpLogs", s.HTTPLogs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteLogsConfigProperties.
func (s *SiteLogsConfigProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationLogs":
			err = unpopulate(val, "ApplicationLogs", &s.ApplicationLogs)
			delete(rawMsg, key)
		case "detailedErrorMessages":
			err = unpopulate(val, "DetailedErrorMessages", &s.DetailedErrorMessages)
			delete(rawMsg, key)
		case "failedRequestsTracing":
			err = unpopulate(val, "FailedRequestsTracing", &s.FailedRequestsTracing)
			delete(rawMsg, key)
		case "httpLogs":
			err = unpopulate(val, "HTTPLogs", &s.HTTPLogs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteMachineKey.
func (s SiteMachineKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "decryption", s.Decryption)
	populate(objectMap, "decryptionKey", s.DecryptionKey)
	populate(objectMap, "validation", s.Validation)
	populate(objectMap, "validationKey", s.ValidationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteMachineKey.
func (s *SiteMachineKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "decryption":
			err = unpopulate(val, "Decryption", &s.Decryption)
			delete(rawMsg, key)
		case "decryptionKey":
			err = unpopulate(val, "DecryptionKey", &s.DecryptionKey)
			delete(rawMsg, key)
		case "validation":
			err = unpopulate(val, "Validation", &s.Validation)
			delete(rawMsg, key)
		case "validationKey":
			err = unpopulate(val, "ValidationKey", &s.ValidationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePatchResource.
func (s SitePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePatchResource.
func (s *SitePatchResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePatchResourceProperties.
func (s SitePatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityState", s.AvailabilityState)
	populate(objectMap, "clientAffinityEnabled", s.ClientAffinityEnabled)
	populate(objectMap, "clientCertEnabled", s.ClientCertEnabled)
	populate(objectMap, "clientCertExclusionPaths", s.ClientCertExclusionPaths)
	populate(objectMap, "cloningInfo", s.CloningInfo)
	populate(objectMap, "containerSize", s.ContainerSize)
	populate(objectMap, "dailyMemoryTimeQuota", s.DailyMemoryTimeQuota)
	populate(objectMap, "defaultHostName", s.DefaultHostName)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "enabledHostNames", s.EnabledHostNames)
	populate(objectMap, "geoDistributions", s.GeoDistributions)
	populate(objectMap, "httpsOnly", s.HTTPSOnly)
	populate(objectMap, "hostNameSslStates", s.HostNameSSLStates)
	populate(objectMap, "hostNames", s.HostNames)
	populate(objectMap, "hostNamesDisabled", s.HostNamesDisabled)
	populate(objectMap, "hostingEnvironmentProfile", s.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", s.HyperV)
	populate(objectMap, "inProgressOperationId", s.InProgressOperationID)
	populate(objectMap, "isDefaultContainer", s.IsDefaultContainer)
	populate(objectMap, "isXenon", s.IsXenon)
	populateTimeRFC3339(objectMap, "lastModifiedTimeUtc", s.LastModifiedTimeUTC)
	populate(objectMap, "maxNumberOfWorkers", s.MaxNumberOfWorkers)
	populate(objectMap, "outboundIpAddresses", s.OutboundIPAddresses)
	populate(objectMap, "possibleOutboundIpAddresses", s.PossibleOutboundIPAddresses)
	populate(objectMap, "redundancyMode", s.RedundancyMode)
	populate(objectMap, "repositorySiteName", s.RepositorySiteName)
	populate(objectMap, "reserved", s.Reserved)
	populate(objectMap, "resourceGroup", s.ResourceGroup)
	populate(objectMap, "scmSiteAlsoStopped", s.ScmSiteAlsoStopped)
	populate(objectMap, "serverFarmId", s.ServerFarmID)
	populate(objectMap, "siteConfig", s.SiteConfig)
	populate(objectMap, "slotSwapStatus", s.SlotSwapStatus)
	populate(objectMap, "state", s.State)
	populateTimeRFC3339(objectMap, "suspendedTill", s.SuspendedTill)
	populate(objectMap, "targetSwapSlot", s.TargetSwapSlot)
	populate(objectMap, "trafficManagerHostNames", s.TrafficManagerHostNames)
	populate(objectMap, "usageState", s.UsageState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePatchResourceProperties.
func (s *SitePatchResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &s.AvailabilityState)
			delete(rawMsg, key)
		case "clientAffinityEnabled":
			err = unpopulate(val, "ClientAffinityEnabled", &s.ClientAffinityEnabled)
			delete(rawMsg, key)
		case "clientCertEnabled":
			err = unpopulate(val, "ClientCertEnabled", &s.ClientCertEnabled)
			delete(rawMsg, key)
		case "clientCertExclusionPaths":
			err = unpopulate(val, "ClientCertExclusionPaths", &s.ClientCertExclusionPaths)
			delete(rawMsg, key)
		case "cloningInfo":
			err = unpopulate(val, "CloningInfo", &s.CloningInfo)
			delete(rawMsg, key)
		case "containerSize":
			err = unpopulate(val, "ContainerSize", &s.ContainerSize)
			delete(rawMsg, key)
		case "dailyMemoryTimeQuota":
			err = unpopulate(val, "DailyMemoryTimeQuota", &s.DailyMemoryTimeQuota)
			delete(rawMsg, key)
		case "defaultHostName":
			err = unpopulate(val, "DefaultHostName", &s.DefaultHostName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "enabledHostNames":
			err = unpopulate(val, "EnabledHostNames", &s.EnabledHostNames)
			delete(rawMsg, key)
		case "geoDistributions":
			err = unpopulate(val, "GeoDistributions", &s.GeoDistributions)
			delete(rawMsg, key)
		case "httpsOnly":
			err = unpopulate(val, "HTTPSOnly", &s.HTTPSOnly)
			delete(rawMsg, key)
		case "hostNameSslStates":
			err = unpopulate(val, "HostNameSSLStates", &s.HostNameSSLStates)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &s.HostNames)
			delete(rawMsg, key)
		case "hostNamesDisabled":
			err = unpopulate(val, "HostNamesDisabled", &s.HostNamesDisabled)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &s.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &s.HyperV)
			delete(rawMsg, key)
		case "inProgressOperationId":
			err = unpopulate(val, "InProgressOperationID", &s.InProgressOperationID)
			delete(rawMsg, key)
		case "isDefaultContainer":
			err = unpopulate(val, "IsDefaultContainer", &s.IsDefaultContainer)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &s.IsXenon)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateTimeRFC3339(val, "LastModifiedTimeUTC", &s.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "maxNumberOfWorkers":
			err = unpopulate(val, "MaxNumberOfWorkers", &s.MaxNumberOfWorkers)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &s.OutboundIPAddresses)
			delete(rawMsg, key)
		case "possibleOutboundIpAddresses":
			err = unpopulate(val, "PossibleOutboundIPAddresses", &s.PossibleOutboundIPAddresses)
			delete(rawMsg, key)
		case "redundancyMode":
			err = unpopulate(val, "RedundancyMode", &s.RedundancyMode)
			delete(rawMsg, key)
		case "repositorySiteName":
			err = unpopulate(val, "RepositorySiteName", &s.RepositorySiteName)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &s.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &s.ResourceGroup)
			delete(rawMsg, key)
		case "scmSiteAlsoStopped":
			err = unpopulate(val, "ScmSiteAlsoStopped", &s.ScmSiteAlsoStopped)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &s.ServerFarmID)
			delete(rawMsg, key)
		case "siteConfig":
			err = unpopulate(val, "SiteConfig", &s.SiteConfig)
			delete(rawMsg, key)
		case "slotSwapStatus":
			err = unpopulate(val, "SlotSwapStatus", &s.SlotSwapStatus)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "suspendedTill":
			err = unpopulateTimeRFC3339(val, "SuspendedTill", &s.SuspendedTill)
			delete(rawMsg, key)
		case "targetSwapSlot":
			err = unpopulate(val, "TargetSwapSlot", &s.TargetSwapSlot)
			delete(rawMsg, key)
		case "trafficManagerHostNames":
			err = unpopulate(val, "TrafficManagerHostNames", &s.TrafficManagerHostNames)
			delete(rawMsg, key)
		case "usageState":
			err = unpopulate(val, "UsageState", &s.UsageState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePhpErrorLogFlag.
func (s SitePhpErrorLogFlag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePhpErrorLogFlag.
func (s *SitePhpErrorLogFlag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SitePhpErrorLogFlagProperties.
func (s SitePhpErrorLogFlagProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localLogErrors", s.LocalLogErrors)
	populate(objectMap, "localLogErrorsMaxLength", s.LocalLogErrorsMaxLength)
	populate(objectMap, "masterLogErrors", s.MasterLogErrors)
	populate(objectMap, "masterLogErrorsMaxLength", s.MasterLogErrorsMaxLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SitePhpErrorLogFlagProperties.
func (s *SitePhpErrorLogFlagProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localLogErrors":
			err = unpopulate(val, "LocalLogErrors", &s.LocalLogErrors)
			delete(rawMsg, key)
		case "localLogErrorsMaxLength":
			err = unpopulate(val, "LocalLogErrorsMaxLength", &s.LocalLogErrorsMaxLength)
			delete(rawMsg, key)
		case "masterLogErrors":
			err = unpopulate(val, "MasterLogErrors", &s.MasterLogErrors)
			delete(rawMsg, key)
		case "masterLogErrorsMaxLength":
			err = unpopulate(val, "MasterLogErrorsMaxLength", &s.MasterLogErrorsMaxLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteProperties.
func (s SiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityState", s.AvailabilityState)
	populate(objectMap, "clientAffinityEnabled", s.ClientAffinityEnabled)
	populate(objectMap, "clientCertEnabled", s.ClientCertEnabled)
	populate(objectMap, "clientCertExclusionPaths", s.ClientCertExclusionPaths)
	populate(objectMap, "cloningInfo", s.CloningInfo)
	populate(objectMap, "containerSize", s.ContainerSize)
	populate(objectMap, "dailyMemoryTimeQuota", s.DailyMemoryTimeQuota)
	populate(objectMap, "defaultHostName", s.DefaultHostName)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "enabledHostNames", s.EnabledHostNames)
	populate(objectMap, "geoDistributions", s.GeoDistributions)
	populate(objectMap, "httpsOnly", s.HTTPSOnly)
	populate(objectMap, "hostNameSslStates", s.HostNameSSLStates)
	populate(objectMap, "hostNames", s.HostNames)
	populate(objectMap, "hostNamesDisabled", s.HostNamesDisabled)
	populate(objectMap, "hostingEnvironmentProfile", s.HostingEnvironmentProfile)
	populate(objectMap, "hyperV", s.HyperV)
	populate(objectMap, "inProgressOperationId", s.InProgressOperationID)
	populate(objectMap, "isDefaultContainer", s.IsDefaultContainer)
	populate(objectMap, "isXenon", s.IsXenon)
	populateTimeRFC3339(objectMap, "lastModifiedTimeUtc", s.LastModifiedTimeUTC)
	populate(objectMap, "maxNumberOfWorkers", s.MaxNumberOfWorkers)
	populate(objectMap, "outboundIpAddresses", s.OutboundIPAddresses)
	populate(objectMap, "possibleOutboundIpAddresses", s.PossibleOutboundIPAddresses)
	populate(objectMap, "redundancyMode", s.RedundancyMode)
	populate(objectMap, "repositorySiteName", s.RepositorySiteName)
	populate(objectMap, "reserved", s.Reserved)
	populate(objectMap, "resourceGroup", s.ResourceGroup)
	populate(objectMap, "scmSiteAlsoStopped", s.ScmSiteAlsoStopped)
	populate(objectMap, "serverFarmId", s.ServerFarmID)
	populate(objectMap, "siteConfig", s.SiteConfig)
	populate(objectMap, "slotSwapStatus", s.SlotSwapStatus)
	populate(objectMap, "state", s.State)
	populateTimeRFC3339(objectMap, "suspendedTill", s.SuspendedTill)
	populate(objectMap, "targetSwapSlot", s.TargetSwapSlot)
	populate(objectMap, "trafficManagerHostNames", s.TrafficManagerHostNames)
	populate(objectMap, "usageState", s.UsageState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteProperties.
func (s *SiteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &s.AvailabilityState)
			delete(rawMsg, key)
		case "clientAffinityEnabled":
			err = unpopulate(val, "ClientAffinityEnabled", &s.ClientAffinityEnabled)
			delete(rawMsg, key)
		case "clientCertEnabled":
			err = unpopulate(val, "ClientCertEnabled", &s.ClientCertEnabled)
			delete(rawMsg, key)
		case "clientCertExclusionPaths":
			err = unpopulate(val, "ClientCertExclusionPaths", &s.ClientCertExclusionPaths)
			delete(rawMsg, key)
		case "cloningInfo":
			err = unpopulate(val, "CloningInfo", &s.CloningInfo)
			delete(rawMsg, key)
		case "containerSize":
			err = unpopulate(val, "ContainerSize", &s.ContainerSize)
			delete(rawMsg, key)
		case "dailyMemoryTimeQuota":
			err = unpopulate(val, "DailyMemoryTimeQuota", &s.DailyMemoryTimeQuota)
			delete(rawMsg, key)
		case "defaultHostName":
			err = unpopulate(val, "DefaultHostName", &s.DefaultHostName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "enabledHostNames":
			err = unpopulate(val, "EnabledHostNames", &s.EnabledHostNames)
			delete(rawMsg, key)
		case "geoDistributions":
			err = unpopulate(val, "GeoDistributions", &s.GeoDistributions)
			delete(rawMsg, key)
		case "httpsOnly":
			err = unpopulate(val, "HTTPSOnly", &s.HTTPSOnly)
			delete(rawMsg, key)
		case "hostNameSslStates":
			err = unpopulate(val, "HostNameSSLStates", &s.HostNameSSLStates)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &s.HostNames)
			delete(rawMsg, key)
		case "hostNamesDisabled":
			err = unpopulate(val, "HostNamesDisabled", &s.HostNamesDisabled)
			delete(rawMsg, key)
		case "hostingEnvironmentProfile":
			err = unpopulate(val, "HostingEnvironmentProfile", &s.HostingEnvironmentProfile)
			delete(rawMsg, key)
		case "hyperV":
			err = unpopulate(val, "HyperV", &s.HyperV)
			delete(rawMsg, key)
		case "inProgressOperationId":
			err = unpopulate(val, "InProgressOperationID", &s.InProgressOperationID)
			delete(rawMsg, key)
		case "isDefaultContainer":
			err = unpopulate(val, "IsDefaultContainer", &s.IsDefaultContainer)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &s.IsXenon)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateTimeRFC3339(val, "LastModifiedTimeUTC", &s.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "maxNumberOfWorkers":
			err = unpopulate(val, "MaxNumberOfWorkers", &s.MaxNumberOfWorkers)
			delete(rawMsg, key)
		case "outboundIpAddresses":
			err = unpopulate(val, "OutboundIPAddresses", &s.OutboundIPAddresses)
			delete(rawMsg, key)
		case "possibleOutboundIpAddresses":
			err = unpopulate(val, "PossibleOutboundIPAddresses", &s.PossibleOutboundIPAddresses)
			delete(rawMsg, key)
		case "redundancyMode":
			err = unpopulate(val, "RedundancyMode", &s.RedundancyMode)
			delete(rawMsg, key)
		case "repositorySiteName":
			err = unpopulate(val, "RepositorySiteName", &s.RepositorySiteName)
			delete(rawMsg, key)
		case "reserved":
			err = unpopulate(val, "Reserved", &s.Reserved)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &s.ResourceGroup)
			delete(rawMsg, key)
		case "scmSiteAlsoStopped":
			err = unpopulate(val, "ScmSiteAlsoStopped", &s.ScmSiteAlsoStopped)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &s.ServerFarmID)
			delete(rawMsg, key)
		case "siteConfig":
			err = unpopulate(val, "SiteConfig", &s.SiteConfig)
			delete(rawMsg, key)
		case "slotSwapStatus":
			err = unpopulate(val, "SlotSwapStatus", &s.SlotSwapStatus)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "suspendedTill":
			err = unpopulateTimeRFC3339(val, "SuspendedTill", &s.SuspendedTill)
			delete(rawMsg, key)
		case "targetSwapSlot":
			err = unpopulate(val, "TargetSwapSlot", &s.TargetSwapSlot)
			delete(rawMsg, key)
		case "trafficManagerHostNames":
			err = unpopulate(val, "TrafficManagerHostNames", &s.TrafficManagerHostNames)
			delete(rawMsg, key)
		case "usageState":
			err = unpopulate(val, "UsageState", &s.UsageState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteSourceControl.
func (s SiteSourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteSourceControl.
func (s *SiteSourceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SiteSourceControlProperties.
func (s SiteSourceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", s.Branch)
	populate(objectMap, "deploymentRollbackEnabled", s.DeploymentRollbackEnabled)
	populate(objectMap, "isManualIntegration", s.IsManualIntegration)
	populate(objectMap, "isMercurial", s.IsMercurial)
	populate(objectMap, "repoUrl", s.RepoURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SiteSourceControlProperties.
func (s *SiteSourceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &s.Branch)
			delete(rawMsg, key)
		case "deploymentRollbackEnabled":
			err = unpopulate(val, "DeploymentRollbackEnabled", &s.DeploymentRollbackEnabled)
			delete(rawMsg, key)
		case "isManualIntegration":
			err = unpopulate(val, "IsManualIntegration", &s.IsManualIntegration)
			delete(rawMsg, key)
		case "isMercurial":
			err = unpopulate(val, "IsMercurial", &s.IsMercurial)
			delete(rawMsg, key)
		case "repoUrl":
			err = unpopulate(val, "RepoURL", &s.RepoURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotConfigNames.
func (s SlotConfigNames) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appSettingNames", s.AppSettingNames)
	populate(objectMap, "azureStorageConfigNames", s.AzureStorageConfigNames)
	populate(objectMap, "connectionStringNames", s.ConnectionStringNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotConfigNames.
func (s *SlotConfigNames) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appSettingNames":
			err = unpopulate(val, "AppSettingNames", &s.AppSettingNames)
			delete(rawMsg, key)
		case "azureStorageConfigNames":
			err = unpopulate(val, "AzureStorageConfigNames", &s.AzureStorageConfigNames)
			delete(rawMsg, key)
		case "connectionStringNames":
			err = unpopulate(val, "ConnectionStringNames", &s.ConnectionStringNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotConfigNamesResource.
func (s SlotConfigNamesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotConfigNamesResource.
func (s *SlotConfigNamesResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotDifference.
func (s SlotDifference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotDifference.
func (s *SlotDifference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotDifferenceCollection.
func (s SlotDifferenceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotDifferenceCollection.
func (s *SlotDifferenceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotDifferenceProperties.
func (s SlotDifferenceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "diffRule", s.DiffRule)
	populate(objectMap, "level", s.Level)
	populate(objectMap, "settingName", s.SettingName)
	populate(objectMap, "settingType", s.SettingType)
	populate(objectMap, "valueInCurrentSlot", s.ValueInCurrentSlot)
	populate(objectMap, "valueInTargetSlot", s.ValueInTargetSlot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotDifferenceProperties.
func (s *SlotDifferenceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "diffRule":
			err = unpopulate(val, "DiffRule", &s.DiffRule)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &s.Level)
			delete(rawMsg, key)
		case "settingName":
			err = unpopulate(val, "SettingName", &s.SettingName)
			delete(rawMsg, key)
		case "settingType":
			err = unpopulate(val, "SettingType", &s.SettingType)
			delete(rawMsg, key)
		case "valueInCurrentSlot":
			err = unpopulate(val, "ValueInCurrentSlot", &s.ValueInCurrentSlot)
			delete(rawMsg, key)
		case "valueInTargetSlot":
			err = unpopulate(val, "ValueInTargetSlot", &s.ValueInTargetSlot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlotSwapStatus.
func (s SlotSwapStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationSlotName", s.DestinationSlotName)
	populate(objectMap, "sourceSlotName", s.SourceSlotName)
	populateTimeRFC3339(objectMap, "timestampUtc", s.TimestampUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlotSwapStatus.
func (s *SlotSwapStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationSlotName":
			err = unpopulate(val, "DestinationSlotName", &s.DestinationSlotName)
			delete(rawMsg, key)
		case "sourceSlotName":
			err = unpopulate(val, "SourceSlotName", &s.SourceSlotName)
			delete(rawMsg, key)
		case "timestampUtc":
			err = unpopulateTimeRFC3339(val, "TimestampUTC", &s.TimestampUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlowRequestsBasedTrigger.
func (s SlowRequestsBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "timeInterval", s.TimeInterval)
	populate(objectMap, "timeTaken", s.TimeTaken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlowRequestsBasedTrigger.
func (s *SlowRequestsBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &s.TimeInterval)
			delete(rawMsg, key)
		case "timeTaken":
			err = unpopulate(val, "TimeTaken", &s.TimeTaken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snapshot.
func (s *Snapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotCollection.
func (s SnapshotCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotCollection.
func (s *SnapshotCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "time", s.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "time":
			err = unpopulate(val, "Time", &s.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRecoverySource.
func (s SnapshotRecoverySource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRecoverySource.
func (s *SnapshotRecoverySource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRestoreRequest.
func (s SnapshotRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRestoreRequest.
func (s *SnapshotRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRestoreRequestProperties.
func (s SnapshotRestoreRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ignoreConflictingHostNames", s.IgnoreConflictingHostNames)
	populate(objectMap, "overwrite", s.Overwrite)
	populate(objectMap, "recoverConfiguration", s.RecoverConfiguration)
	populate(objectMap, "recoverySource", s.RecoverySource)
	populate(objectMap, "snapshotTime", s.SnapshotTime)
	populate(objectMap, "useDRSecondary", s.UseDRSecondary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRestoreRequestProperties.
func (s *SnapshotRestoreRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ignoreConflictingHostNames":
			err = unpopulate(val, "IgnoreConflictingHostNames", &s.IgnoreConflictingHostNames)
			delete(rawMsg, key)
		case "overwrite":
			err = unpopulate(val, "Overwrite", &s.Overwrite)
			delete(rawMsg, key)
		case "recoverConfiguration":
			err = unpopulate(val, "RecoverConfiguration", &s.RecoverConfiguration)
			delete(rawMsg, key)
		case "recoverySource":
			err = unpopulate(val, "RecoverySource", &s.RecoverySource)
			delete(rawMsg, key)
		case "snapshotTime":
			err = unpopulate(val, "SnapshotTime", &s.SnapshotTime)
			delete(rawMsg, key)
		case "useDRSecondary":
			err = unpopulate(val, "UseDRSecondary", &s.UseDRSecondary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControl.
func (s SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControl.
func (s *SourceControl) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlCollection.
func (s SourceControlCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlCollection.
func (s *SourceControlCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlProperties.
func (s SourceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateTimeRFC3339(objectMap, "expirationTime", s.ExpirationTime)
	populate(objectMap, "refreshToken", s.RefreshToken)
	populate(objectMap, "token", s.Token)
	populate(objectMap, "tokenSecret", s.TokenSecret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlProperties.
func (s *SourceControlProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationTime":
			err = unpopulateTimeRFC3339(val, "ExpirationTime", &s.ExpirationTime)
			delete(rawMsg, key)
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &s.RefreshToken)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &s.Token)
			delete(rawMsg, key)
		case "tokenSecret":
			err = unpopulate(val, "TokenSecret", &s.TokenSecret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StackMajorVersion.
func (s StackMajorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationInsights", s.ApplicationInsights)
	populate(objectMap, "displayVersion", s.DisplayVersion)
	populate(objectMap, "isDefault", s.IsDefault)
	populate(objectMap, "minorVersions", s.MinorVersions)
	populate(objectMap, "runtimeVersion", s.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StackMajorVersion.
func (s *StackMajorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationInsights":
			err = unpopulate(val, "ApplicationInsights", &s.ApplicationInsights)
			delete(rawMsg, key)
		case "displayVersion":
			err = unpopulate(val, "DisplayVersion", &s.DisplayVersion)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &s.IsDefault)
			delete(rawMsg, key)
		case "minorVersions":
			err = unpopulate(val, "MinorVersions", &s.MinorVersions)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &s.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StackMinorVersion.
func (s StackMinorVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayVersion", s.DisplayVersion)
	populate(objectMap, "isDefault", s.IsDefault)
	populate(objectMap, "isRemoteDebuggingEnabled", s.IsRemoteDebuggingEnabled)
	populate(objectMap, "runtimeVersion", s.RuntimeVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StackMinorVersion.
func (s *StackMinorVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayVersion":
			err = unpopulate(val, "DisplayVersion", &s.DisplayVersion)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &s.IsDefault)
			delete(rawMsg, key)
		case "isRemoteDebuggingEnabled":
			err = unpopulate(val, "IsRemoteDebuggingEnabled", &s.IsRemoteDebuggingEnabled)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &s.RuntimeVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StampCapacity.
func (s StampCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableCapacity", s.AvailableCapacity)
	populate(objectMap, "computeMode", s.ComputeMode)
	populate(objectMap, "excludeFromCapacityAllocation", s.ExcludeFromCapacityAllocation)
	populate(objectMap, "isApplicableForAllComputeModes", s.IsApplicableForAllComputeModes)
	populate(objectMap, "isLinux", s.IsLinux)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "siteMode", s.SiteMode)
	populate(objectMap, "totalCapacity", s.TotalCapacity)
	populate(objectMap, "unit", s.Unit)
	populate(objectMap, "workerSize", s.WorkerSize)
	populate(objectMap, "workerSizeId", s.WorkerSizeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StampCapacity.
func (s *StampCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableCapacity":
			err = unpopulate(val, "AvailableCapacity", &s.AvailableCapacity)
			delete(rawMsg, key)
		case "computeMode":
			err = unpopulate(val, "ComputeMode", &s.ComputeMode)
			delete(rawMsg, key)
		case "excludeFromCapacityAllocation":
			err = unpopulate(val, "ExcludeFromCapacityAllocation", &s.ExcludeFromCapacityAllocation)
			delete(rawMsg, key)
		case "isApplicableForAllComputeModes":
			err = unpopulate(val, "IsApplicableForAllComputeModes", &s.IsApplicableForAllComputeModes)
			delete(rawMsg, key)
		case "isLinux":
			err = unpopulate(val, "IsLinux", &s.IsLinux)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "siteMode":
			err = unpopulate(val, "SiteMode", &s.SiteMode)
			delete(rawMsg, key)
		case "totalCapacity":
			err = unpopulate(val, "TotalCapacity", &s.TotalCapacity)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		case "workerSize":
			err = unpopulate(val, "WorkerSize", &s.WorkerSize)
			delete(rawMsg, key)
		case "workerSizeId":
			err = unpopulate(val, "WorkerSizeID", &s.WorkerSizeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StatusCodesBasedTrigger.
func (s StatusCodesBasedTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "subStatus", s.SubStatus)
	populate(objectMap, "timeInterval", s.TimeInterval)
	populate(objectMap, "win32Status", s.Win32Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusCodesBasedTrigger.
func (s *StatusCodesBasedTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "subStatus":
			err = unpopulate(val, "SubStatus", &s.SubStatus)
			delete(rawMsg, key)
		case "timeInterval":
			err = unpopulate(val, "TimeInterval", &s.TimeInterval)
			delete(rawMsg, key)
		case "win32Status":
			err = unpopulate(val, "Win32Status", &s.Win32Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationOptions.
func (s StorageMigrationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationOptions.
func (s *StorageMigrationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationOptionsProperties.
func (s StorageMigrationOptionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azurefilesConnectionString", s.AzurefilesConnectionString)
	populate(objectMap, "azurefilesShare", s.AzurefilesShare)
	populate(objectMap, "blockWriteAccessToSite", s.BlockWriteAccessToSite)
	populate(objectMap, "switchSiteAfterMigration", s.SwitchSiteAfterMigration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationOptionsProperties.
func (s *StorageMigrationOptionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azurefilesConnectionString":
			err = unpopulate(val, "AzurefilesConnectionString", &s.AzurefilesConnectionString)
			delete(rawMsg, key)
		case "azurefilesShare":
			err = unpopulate(val, "AzurefilesShare", &s.AzurefilesShare)
			delete(rawMsg, key)
		case "blockWriteAccessToSite":
			err = unpopulate(val, "BlockWriteAccessToSite", &s.BlockWriteAccessToSite)
			delete(rawMsg, key)
		case "switchSiteAfterMigration":
			err = unpopulate(val, "SwitchSiteAfterMigration", &s.SwitchSiteAfterMigration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationResponse.
func (s StorageMigrationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationResponse.
func (s *StorageMigrationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageMigrationResponseProperties.
func (s StorageMigrationResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", s.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageMigrationResponseProperties.
func (s *StorageMigrationResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &s.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringDictionary.
func (s StringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringDictionary.
func (s *StringDictionary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwiftVirtualNetwork.
func (s SwiftVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwiftVirtualNetwork.
func (s *SwiftVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwiftVirtualNetworkProperties.
func (s SwiftVirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetResourceId", s.SubnetResourceID)
	populate(objectMap, "swiftSupported", s.SwiftSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwiftVirtualNetworkProperties.
func (s *SwiftVirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetResourceId":
			err = unpopulate(val, "SubnetResourceID", &s.SubnetResourceID)
			delete(rawMsg, key)
		case "swiftSupported":
			err = unpopulate(val, "SwiftSupported", &s.SwiftSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobHistory.
func (t TriggeredJobHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobHistory.
func (t *TriggeredJobHistory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobHistoryCollection.
func (t TriggeredJobHistoryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobHistoryCollection.
func (t *TriggeredJobHistoryCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobHistoryProperties.
func (t TriggeredJobHistoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "runs", t.Runs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobHistoryProperties.
func (t *TriggeredJobHistoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runs":
			err = unpopulate(val, "Runs", &t.Runs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobRun.
func (t TriggeredJobRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobRun.
func (t *TriggeredJobRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredJobRunProperties.
func (t TriggeredJobRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "duration", t.Duration)
	populateTimeRFC3339(objectMap, "end_time", t.EndTime)
	populate(objectMap, "error_url", t.ErrorURL)
	populate(objectMap, "job_name", t.JobName)
	populate(objectMap, "output_url", t.OutputURL)
	populateTimeRFC3339(objectMap, "start_time", t.StartTime)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "trigger", t.Trigger)
	populate(objectMap, "url", t.URL)
	populate(objectMap, "web_job_id", t.WebJobID)
	populate(objectMap, "web_job_name", t.WebJobName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredJobRunProperties.
func (t *TriggeredJobRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &t.Duration)
			delete(rawMsg, key)
		case "end_time":
			err = unpopulateTimeRFC3339(val, "EndTime", &t.EndTime)
			delete(rawMsg, key)
		case "error_url":
			err = unpopulate(val, "ErrorURL", &t.ErrorURL)
			delete(rawMsg, key)
		case "job_name":
			err = unpopulate(val, "JobName", &t.JobName)
			delete(rawMsg, key)
		case "output_url":
			err = unpopulate(val, "OutputURL", &t.OutputURL)
			delete(rawMsg, key)
		case "start_time":
			err = unpopulateTimeRFC3339(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "trigger":
			err = unpopulate(val, "Trigger", &t.Trigger)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		case "web_job_id":
			err = unpopulate(val, "WebJobID", &t.WebJobID)
			delete(rawMsg, key)
		case "web_job_name":
			err = unpopulate(val, "WebJobName", &t.WebJobName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredWebJob.
func (t TriggeredWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "kind", t.Kind)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredWebJob.
func (t *TriggeredWebJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredWebJobCollection.
func (t TriggeredWebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredWebJobCollection.
func (t *TriggeredWebJobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggeredWebJobProperties.
func (t TriggeredWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", t.Error)
	populate(objectMap, "extra_info_url", t.ExtraInfoURL)
	populate(objectMap, "history_url", t.HistoryURL)
	populate(objectMap, "latest_run", t.LatestRun)
	populate(objectMap, "run_command", t.RunCommand)
	populate(objectMap, "scheduler_logs_url", t.SchedulerLogsURL)
	populate(objectMap, "settings", t.Settings)
	populate(objectMap, "url", t.URL)
	populate(objectMap, "using_sdk", t.UsingSdk)
	populate(objectMap, "web_job_type", t.WebJobType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggeredWebJobProperties.
func (t *TriggeredWebJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &t.Error)
			delete(rawMsg, key)
		case "extra_info_url":
			err = unpopulate(val, "ExtraInfoURL", &t.ExtraInfoURL)
			delete(rawMsg, key)
		case "history_url":
			err = unpopulate(val, "HistoryURL", &t.HistoryURL)
			delete(rawMsg, key)
		case "latest_run":
			err = unpopulate(val, "LatestRun", &t.LatestRun)
			delete(rawMsg, key)
		case "run_command":
			err = unpopulate(val, "RunCommand", &t.RunCommand)
			delete(rawMsg, key)
		case "scheduler_logs_url":
			err = unpopulate(val, "SchedulerLogsURL", &t.SchedulerLogsURL)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &t.Settings)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		case "using_sdk":
			err = unpopulate(val, "UsingSdk", &t.UsingSdk)
			delete(rawMsg, key)
		case "web_job_type":
			err = unpopulate(val, "WebJobType", &t.WebJobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "kind", u.Kind)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type User.
func (u *User) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &u.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserProperties.
func (u UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publishingPassword", u.PublishingPassword)
	populate(objectMap, "publishingPasswordHash", u.PublishingPasswordHash)
	populate(objectMap, "publishingPasswordHashSalt", u.PublishingPasswordHashSalt)
	populate(objectMap, "publishingUserName", u.PublishingUserName)
	populate(objectMap, "scmUri", u.ScmURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserProperties.
func (u *UserProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publishingPassword":
			err = unpopulate(val, "PublishingPassword", &u.PublishingPassword)
			delete(rawMsg, key)
		case "publishingPasswordHash":
			err = unpopulate(val, "PublishingPasswordHash", &u.PublishingPasswordHash)
			delete(rawMsg, key)
		case "publishingPasswordHashSalt":
			err = unpopulate(val, "PublishingPasswordHashSalt", &u.PublishingPasswordHashSalt)
			delete(rawMsg, key)
		case "publishingUserName":
			err = unpopulate(val, "PublishingUserName", &u.PublishingUserName)
			delete(rawMsg, key)
		case "scmUri":
			err = unpopulate(val, "ScmURI", &u.ScmURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateContainerSettingsRequest.
func (v ValidateContainerSettingsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baseUrl", v.BaseURL)
	populate(objectMap, "password", v.Password)
	populate(objectMap, "platform", v.Platform)
	populate(objectMap, "repository", v.Repository)
	populate(objectMap, "tag", v.Tag)
	populate(objectMap, "username", v.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateContainerSettingsRequest.
func (v *ValidateContainerSettingsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseUrl":
			err = unpopulate(val, "BaseURL", &v.BaseURL)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &v.Password)
			delete(rawMsg, key)
		case "platform":
			err = unpopulate(val, "Platform", &v.Platform)
			delete(rawMsg, key)
		case "repository":
			err = unpopulate(val, "Repository", &v.Repository)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &v.Tag)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &v.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateProperties.
func (v ValidateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", v.Capacity)
	populate(objectMap, "hostingEnvironment", v.HostingEnvironment)
	populate(objectMap, "isSpot", v.IsSpot)
	populate(objectMap, "isXenon", v.IsXenon)
	populate(objectMap, "needLinuxWorkers", v.NeedLinuxWorkers)
	populate(objectMap, "skuName", v.SKUName)
	populate(objectMap, "serverFarmId", v.ServerFarmID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateProperties.
func (v *ValidateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &v.Capacity)
			delete(rawMsg, key)
		case "hostingEnvironment":
			err = unpopulate(val, "HostingEnvironment", &v.HostingEnvironment)
			delete(rawMsg, key)
		case "isSpot":
			err = unpopulate(val, "IsSpot", &v.IsSpot)
			delete(rawMsg, key)
		case "isXenon":
			err = unpopulate(val, "IsXenon", &v.IsXenon)
			delete(rawMsg, key)
		case "needLinuxWorkers":
			err = unpopulate(val, "NeedLinuxWorkers", &v.NeedLinuxWorkers)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &v.SKUName)
			delete(rawMsg, key)
		case "serverFarmId":
			err = unpopulate(val, "ServerFarmID", &v.ServerFarmID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateRequest.
func (v ValidateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateRequest.
func (v *ValidateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateResponse.
func (v ValidateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateResponse.
func (v *ValidateResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValidateResponseError.
func (v ValidateResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateResponseError.
func (v *ValidateResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualApplication.
func (v VirtualApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "physicalPath", v.PhysicalPath)
	populate(objectMap, "preloadEnabled", v.PreloadEnabled)
	populate(objectMap, "virtualDirectories", v.VirtualDirectories)
	populate(objectMap, "virtualPath", v.VirtualPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualApplication.
func (v *VirtualApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "physicalPath":
			err = unpopulate(val, "PhysicalPath", &v.PhysicalPath)
			delete(rawMsg, key)
		case "preloadEnabled":
			err = unpopulate(val, "PreloadEnabled", &v.PreloadEnabled)
			delete(rawMsg, key)
		case "virtualDirectories":
			err = unpopulate(val, "VirtualDirectories", &v.VirtualDirectories)
			delete(rawMsg, key)
		case "virtualPath":
			err = unpopulate(val, "VirtualPath", &v.VirtualPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualDirectory.
func (v VirtualDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "physicalPath", v.PhysicalPath)
	populate(objectMap, "virtualPath", v.VirtualPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualDirectory.
func (v *VirtualDirectory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "physicalPath":
			err = unpopulate(val, "PhysicalPath", &v.PhysicalPath)
			delete(rawMsg, key)
		case "virtualPath":
			err = unpopulate(val, "VirtualPath", &v.VirtualPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualIPMapping.
func (v VirtualIPMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inUse", v.InUse)
	populate(objectMap, "internalHttpPort", v.InternalHTTPPort)
	populate(objectMap, "internalHttpsPort", v.InternalHTTPSPort)
	populate(objectMap, "virtualIP", v.VirtualIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualIPMapping.
func (v *VirtualIPMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inUse":
			err = unpopulate(val, "InUse", &v.InUse)
			delete(rawMsg, key)
		case "internalHttpPort":
			err = unpopulate(val, "InternalHTTPPort", &v.InternalHTTPPort)
			delete(rawMsg, key)
		case "internalHttpsPort":
			err = unpopulate(val, "InternalHTTPSPort", &v.InternalHTTPSPort)
			delete(rawMsg, key)
		case "virtualIP":
			err = unpopulate(val, "VirtualIP", &v.VirtualIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProfile.
func (v VirtualNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "subnet", v.Subnet)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProfile.
func (v *VirtualNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetGateway.
func (v VnetGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetGateway.
func (v *VnetGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetGatewayProperties.
func (v VnetGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vpnPackageUri", v.VPNPackageURI)
	populate(objectMap, "vnetName", v.VnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetGatewayProperties.
func (v *VnetGatewayProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vpnPackageUri":
			err = unpopulate(val, "VPNPackageURI", &v.VPNPackageURI)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &v.VnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetInfo.
func (v VnetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetInfo.
func (v *VnetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetInfoProperties.
func (v VnetInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certBlob", v.CertBlob)
	populate(objectMap, "certThumbprint", v.CertThumbprint)
	populate(objectMap, "dnsServers", v.DNSServers)
	populate(objectMap, "isSwift", v.IsSwift)
	populate(objectMap, "resyncRequired", v.ResyncRequired)
	populate(objectMap, "routes", v.Routes)
	populate(objectMap, "vnetResourceId", v.VnetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetInfoProperties.
func (v *VnetInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certBlob":
			err = unpopulate(val, "CertBlob", &v.CertBlob)
			delete(rawMsg, key)
		case "certThumbprint":
			err = unpopulate(val, "CertThumbprint", &v.CertThumbprint)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		case "isSwift":
			err = unpopulate(val, "IsSwift", &v.IsSwift)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &v.ResyncRequired)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &v.Routes)
			delete(rawMsg, key)
		case "vnetResourceId":
			err = unpopulate(val, "VnetResourceID", &v.VnetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetParameters.
func (v VnetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetParameters.
func (v *VnetParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetParametersProperties.
func (v VnetParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vnetName", v.VnetName)
	populate(objectMap, "vnetResourceGroup", v.VnetResourceGroup)
	populate(objectMap, "vnetSubnetName", v.VnetSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetParametersProperties.
func (v *VnetParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vnetName":
			err = unpopulate(val, "VnetName", &v.VnetName)
			delete(rawMsg, key)
		case "vnetResourceGroup":
			err = unpopulate(val, "VnetResourceGroup", &v.VnetResourceGroup)
			delete(rawMsg, key)
		case "vnetSubnetName":
			err = unpopulate(val, "VnetSubnetName", &v.VnetSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetRoute.
func (v VnetRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetRoute.
func (v *VnetRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetRouteProperties.
func (v VnetRouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endAddress", v.EndAddress)
	populate(objectMap, "routeType", v.RouteType)
	populate(objectMap, "startAddress", v.StartAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetRouteProperties.
func (v *VnetRouteProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endAddress":
			err = unpopulate(val, "EndAddress", &v.EndAddress)
			delete(rawMsg, key)
		case "routeType":
			err = unpopulate(val, "RouteType", &v.RouteType)
			delete(rawMsg, key)
		case "startAddress":
			err = unpopulate(val, "StartAddress", &v.StartAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationFailureDetails.
func (v VnetValidationFailureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationFailureDetails.
func (v *VnetValidationFailureDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationFailureDetailsProperties.
func (v VnetValidationFailureDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failed", v.Failed)
	populate(objectMap, "failedTests", v.FailedTests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationFailureDetailsProperties.
func (v *VnetValidationFailureDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failed":
			err = unpopulate(val, "Failed", &v.Failed)
			delete(rawMsg, key)
		case "failedTests":
			err = unpopulate(val, "FailedTests", &v.FailedTests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationTestFailure.
func (v VnetValidationTestFailure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationTestFailure.
func (v *VnetValidationTestFailure) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VnetValidationTestFailureProperties.
func (v VnetValidationTestFailureProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", v.Details)
	populate(objectMap, "testName", v.TestName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VnetValidationTestFailureProperties.
func (v *VnetValidationTestFailureProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &v.Details)
			delete(rawMsg, key)
		case "testName":
			err = unpopulate(val, "TestName", &v.TestName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppCollection.
func (w WebAppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppCollection.
func (w *WebAppCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppInstanceCollection.
func (w WebAppInstanceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppInstanceCollection.
func (w *WebAppInstanceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebJob.
func (w WebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebJob.
func (w *WebJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebJobCollection.
func (w WebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebJobCollection.
func (w *WebJobCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebJobProperties.
func (w WebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", w.Error)
	populate(objectMap, "extra_info_url", w.ExtraInfoURL)
	populate(objectMap, "run_command", w.RunCommand)
	populate(objectMap, "settings", w.Settings)
	populate(objectMap, "url", w.URL)
	populate(objectMap, "using_sdk", w.UsingSdk)
	populate(objectMap, "web_job_type", w.WebJobType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebJobProperties.
func (w *WebJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &w.Error)
			delete(rawMsg, key)
		case "extra_info_url":
			err = unpopulate(val, "ExtraInfoURL", &w.ExtraInfoURL)
			delete(rawMsg, key)
		case "run_command":
			err = unpopulate(val, "RunCommand", &w.RunCommand)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &w.Settings)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &w.URL)
			delete(rawMsg, key)
		case "using_sdk":
			err = unpopulate(val, "UsingSdk", &w.UsingSdk)
			delete(rawMsg, key)
		case "web_job_type":
			err = unpopulate(val, "WebJobType", &w.WebJobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkerPool.
func (w WorkerPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeMode", w.ComputeMode)
	populate(objectMap, "instanceNames", w.InstanceNames)
	populate(objectMap, "workerCount", w.WorkerCount)
	populate(objectMap, "workerSize", w.WorkerSize)
	populate(objectMap, "workerSizeId", w.WorkerSizeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkerPool.
func (w *WorkerPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeMode":
			err = unpopulate(val, "ComputeMode", &w.ComputeMode)
			delete(rawMsg, key)
		case "instanceNames":
			err = unpopulate(val, "InstanceNames", &w.InstanceNames)
			delete(rawMsg, key)
		case "workerCount":
			err = unpopulate(val, "WorkerCount", &w.WorkerCount)
			delete(rawMsg, key)
		case "workerSize":
			err = unpopulate(val, "WorkerSize", &w.WorkerSize)
			delete(rawMsg, key)
		case "workerSizeId":
			err = unpopulate(val, "WorkerSizeID", &w.WorkerSizeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]any, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
