; COMMAND-LINE: --dt-stc-ind
; EXPECT: unsat
(set-logic UFDT)
(declare-datatype Nat ((succ (pred Nat)) (zero)))
(declare-datatype Lst ((cons (head Nat) (tail Lst)) (nil)))
(declare-datatype Tree ((node (data Nat) (left Tree) (right Tree)) (leaf)))
(declare-fun less (Nat Nat) Bool)
(declare-fun mem (Nat Lst) Bool)
(assert (forall ((x Nat)) (not (mem x nil))))
(assert (forall ((x Nat) (y Nat) (z Lst)) (= (mem x (cons y z)) (or (= x y) (mem x z)))))
(declare-fun tinsert (Tree Nat) Tree)
(assert (forall ((i Nat)) (= (tinsert leaf i) (node i leaf leaf))))
(assert (forall ((r Tree) (l Tree) (d Nat) (i Nat)) (= (tinsert (node d l r) i) (ite (less d i) (node d l (tinsert r i)) (node d (tinsert l i) r)))))
(declare-fun tinsert-all (Tree Lst) Tree)
(assert (forall ((x Tree)) (= (tinsert-all x nil) x)))
(assert (forall ((x Tree) (n Nat) (l Lst)) (= (tinsert-all x (cons n l)) (tinsert (tinsert-all x l) n))))
(declare-fun tcontains (Tree Nat) Bool)
(assert (forall ((i Nat)) (not (tcontains leaf i))))
(assert (forall ((d Nat) (l Tree) (r Tree) (i Nat)) (= (tcontains (node d l r) i) (or (= d i) (tcontains l i) (tcontains r i)))))
(assert (forall ((i Nat) (x Tree) (j Nat)) (= (or (= i j) (tcontains x j)) (tcontains (tinsert x i) j))))
(assert (not (forall ((x Lst) (i Nat)) (= (mem i x) (tcontains (tinsert-all leaf x) i)))))
(check-sat)
