
/**
 * Provide some extra responses for the page list so we can have automatic
 * on change.
 */

Drupal.behaviors.PageManagerList = function() {
  var timeoutID = 0;
  $('form#page-manager-list-pages-form select:not(.pm-processed)')
    .addClass('pm-processed')
    .change(function() {
      $('#edit-pages-apply').click();
    });
  $('form#page-manager-list-pages-form input[type=text]:not(.pm-processed)')
    .addClass('pm-processed')
    .keyup(function(e) {
      switch (e.keyCode) {
        case 16: // shift
        case 17: // ctrl
        case 18: // alt
        case 20: // caps lock
        case 33: // page up
        case 34: // page down
        case 35: // end
        case 36: // home
        case 37: // left arrow
        case 38: // up arrow
        case 39: // right arrow
        case 40: // down arrow
        case 9:  // tab
        case 13: // enter
        case 27: // esc
          return false;
        default:
          if (!$('#edit-pages-apply').hasClass('ctools-ajaxing')) {
            if ((timeoutID)) {
              clearTimeout(timeoutID);
            }

            timeoutID = setTimeout(function() { $('#edit-pages-apply').click(); }, 300);
        }
      }
    });
}
