//! `GET /_matrix/identity/*/validate/email/submitToken`
//!
//! Validate ownership of an email ID by the end-user, after creation of a session.

pub mod v2 {
    //! `/v2/` ([spec])
    //!
    //! [spec]: https://spec.matrix.org/latest/identity-service-api/#get_matrixidentityv2validateemailsubmittoken

    use ruma_common::{
        OwnedClientSecret, OwnedSessionId,
        api::{auth_scheme::AccessToken, request, response},
        metadata,
    };

    metadata! {
        method: GET,
        rate_limited: false,
        authentication: AccessToken,
        history: {
            1.0 => "/_matrix/identity/v2/validate/email/submitToken",
        }
    }

    /// Request type for the `validate_email_by_end_user` endpoint.
    #[request]
    pub struct Request {
        /// The session ID, generated by the `requestToken` call.
        #[ruma_api(query)]
        pub sid: OwnedSessionId,

        /// The client secret that was supplied to the `requestToken` call.
        #[ruma_api(query)]
        pub client_secret: OwnedClientSecret,

        /// The token generated by the `requestToken` call and emailed to the user.
        #[ruma_api(query)]
        pub token: String,
    }

    /// Response type for the `validate_email_by_end_user` endpoint.
    #[response]
    #[derive(Default)]
    pub struct Response {}

    impl Request {
        /// Create a new `Request` with the given session ID, client secret and token.
        pub fn new(sid: OwnedSessionId, client_secret: OwnedClientSecret, token: String) -> Self {
            Self { sid, client_secret, token }
        }
    }

    impl Response {
        /// Create a new empty `Response`.
        pub fn new() -> Self {
            Self {}
        }
    }
}
