# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationProtectionContainersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_list_by_replication_fabrics(self, resource_group):
        response = self.client.replication_protection_containers.list_by_replication_fabrics(
            fabric_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_get(self, resource_group):
        response = self.client.replication_protection_containers.get(
            fabric_name="str",
            protection_container_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_begin_create(self, resource_group):
        response = self.client.replication_protection_containers.begin_create(
            fabric_name="str",
            protection_container_name="str",
            creation_input={
                "properties": {"providerSpecificInput": ["replication_provider_specific_container_creation_input"]}
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_begin_discover_protectable_item(self, resource_group):
        response = self.client.replication_protection_containers.begin_discover_protectable_item(
            fabric_name="str",
            protection_container_name="str",
            discover_protectable_item_request={
                "properties": {"friendlyName": "str", "ipAddress": "str", "osType": "str"}
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_begin_delete(self, resource_group):
        response = self.client.replication_protection_containers.begin_delete(
            fabric_name="str",
            protection_container_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_begin_switch_cluster_protection(self, resource_group):
        response = self.client.replication_protection_containers.begin_switch_cluster_protection(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            switch_input={
                "properties": {
                    "providerSpecificDetails": "switch_cluster_protection_provider_specific_input",
                    "replicationProtectionClusterName": "str",
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_begin_switch_protection(self, resource_group):
        response = self.client.replication_protection_containers.begin_switch_protection(
            fabric_name="str",
            protection_container_name="str",
            switch_input={
                "properties": {
                    "providerSpecificDetails": "switch_protection_provider_specific_input",
                    "replicationProtectedItemName": "str",
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_containers_list(self, resource_group):
        response = self.client.replication_protection_containers.list(
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
