/**
 * Semi-major radius of the WGS84 ellipsoid.
 *
 * @const
 * @type {number}
 */
export const RADIUS: number;
/**
 * Extent of the EPSG:4326 projection which is the whole world.
 *
 * @const
 * @type {import("../extent.js").Extent}
 */
export const EXTENT: import("../extent.js").Extent;
/**
 * @const
 * @type {number}
 */
export const METERS_PER_UNIT: number;
/**
 * Projections equal to EPSG:4326.
 *
 * @const
 * @type {Array<import("./Projection.js").default>}
 */
export const PROJECTIONS: Array<import("./Projection.js").default>;
//# sourceMappingURL=epsg4326.d.ts.map