#pragma once
/*
 *  $Id: gwygraphmodel.h 28799 2025-11-05 11:47:53Z yeti-dn $
 *  Copyright (C) 2004-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_MODEL_H__
#define __GWYUI_GRAPH_MODEL_H__

#include <glib-object.h>
#include <gtk/gtk.h>

#include <libgwyui/gwygraphcurvemodel.h>
#include <libgwyddion/field.h>

G_BEGIN_DECLS

/* FIXME GTK3 we only have AUTO as an effective boolean. */
typedef enum {
    GWY_GRAPH_GRID_NONE,
    GWY_GRAPH_GRID_AUTO,
    GWY_GRAPH_GRID_USER
} GwyGraphGridType;

typedef enum {
    GWY_GRAPH_MODEL_EXPORT_ASCII_PLAIN   = 0,
    GWY_GRAPH_MODEL_EXPORT_ASCII_GNUPLOT = 1,
    GWY_GRAPH_MODEL_EXPORT_ASCII_CSV     = 2,
    /* FIXME GTK3 probably remove as it has never been a separate format. */
    GWY_GRAPH_MODEL_EXPORT_ASCII_ORIGIN  = 3,
    GWY_GRAPH_MODEL_EXPORT_ASCII_IGORPRO = 4,
    GWY_GRAPH_MODEL_EXPORT_ASCII_POSIX   = 1024,
    GWY_GRAPH_MODEL_EXPORT_ASCII_MERGED  = 2048,
} GwyGraphModelExportStyle;

#define GWY_TYPE_GRAPH_MODEL            (gwy_graph_model_get_type())
#define GWY_GRAPH_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_MODEL, GwyGraphModel))
#define GWY_GRAPH_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_MODEL, GwyGraphModelClass))
#define GWY_IS_GRAPH_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_MODEL))
#define GWY_IS_GRAPH_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_MODEL))
#define GWY_GRAPH_MODEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_MODEL, GwyGraphModelClass))


typedef struct _GwyGraphModel        GwyGraphModel;
typedef struct _GwyGraphModelClass   GwyGraphModelClass;
typedef struct _GwyGraphModelPrivate GwyGraphModelPrivate;

struct _GwyGraphModel {
    GObject parent_instance;
    GwyGraphModelPrivate *priv;
};

struct _GwyGraphModelClass {
    GObjectClass parent_class;

    void (*curve_data_changed)(GwyGraphModel *gmodel,
                               gint i);
    void (*curve_notify)(GwyGraphModel *gmodel,
                         gint i,
                         GParamSpec *pspec);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType               gwy_graph_model_get_type                   (void)                                  G_GNUC_CONST;
GwyGraphModel*      gwy_graph_model_new                        (void);
GwyGraphModel*      gwy_graph_model_new_alike                  (GwyGraphModel *gmodel);
GwyGraphModel*      gwy_graph_model_copy                       (GwyGraphModel *gmodel);
void                gwy_graph_model_assign                     (GwyGraphModel *destination,
                                                                GwyGraphModel *source);
gint                gwy_graph_model_get_n_curves               (GwyGraphModel *gmodel);
gint                gwy_graph_model_add_curve                  (GwyGraphModel *gmodel,
                                                                GwyGraphCurveModel *curve);
gint                gwy_graph_model_remove_curve_by_description(GwyGraphModel *gmodel,
                                                                const gchar *description);
void                gwy_graph_model_remove_curve               (GwyGraphModel *gmodel,
                                                                gint cindex);
GwyGraphCurveModel* gwy_graph_model_get_curve_by_description   (GwyGraphModel *gmodel,
                                                                const gchar *description);
GwyGraphCurveModel* gwy_graph_model_get_curve                  (GwyGraphModel *gmodel,
                                                                gint cindex);
gint                gwy_graph_model_get_curve_index            (GwyGraphModel *gmodel,
                                                                GwyGraphCurveModel *curve);
void                gwy_graph_model_replace_curve              (GwyGraphModel *gmodel,
                                                                gint cindex,
                                                                GwyGraphCurveModel *curve);
void                gwy_graph_model_remove_all_curves          (GwyGraphModel *gmodel);
void                gwy_graph_model_append_curves              (GwyGraphModel *gmodel,
                                                                GwyGraphModel *source,
                                                                gint colorstep);
GwyUnit*            gwy_graph_model_get_unit_x                 (GwyGraphModel *gmodel);
GwyUnit*            gwy_graph_model_get_unit_y                 (GwyGraphModel *gmodel);
void                gwy_graph_model_set_units_from_line        (GwyGraphModel *gmodel,
                                                                GwyLine *line);
void                gwy_graph_model_set_units_from_field       (GwyGraphModel *gmodel,
                                                                GwyField *field,
                                                                gint power_xy_in_x,
                                                                gint power_z_in_x,
                                                                gint power_xy_in_y,
                                                                gint power_z_in_y);
gboolean            gwy_graph_model_units_are_compatible       (GwyGraphModel *gmodel,
                                                                GwyGraphModel *othergmodel);
gboolean            gwy_graph_model_x_data_can_be_logarithmed  (GwyGraphModel *gmodel);
gboolean            gwy_graph_model_y_data_can_be_logarithmed  (GwyGraphModel *gmodel);
void                gwy_graph_model_set_axis_label             (GwyGraphModel *gmodel,
                                                                GtkPositionType pos,
                                                                const gchar *label);
const gchar*        gwy_graph_model_get_axis_label             (GwyGraphModel *gmodel,
                                                                GtkPositionType pos);
const gchar*        gwy_graph_model_get_title                  (GwyGraphModel *gmodel);
gboolean            gwy_graph_model_get_x_range                (GwyGraphModel *gmodel,
                                                                gdouble *x_min,
                                                                gdouble *x_max);
gboolean            gwy_graph_model_get_y_range                (GwyGraphModel *gmodel,
                                                                gdouble *y_min,
                                                                gdouble *y_max);
gboolean            gwy_graph_model_get_ranges                 (GwyGraphModel *gmodel,
                                                                gboolean x_logscale,
                                                                gboolean y_logscale,
                                                                gdouble *x_min,
                                                                gdouble *x_max,
                                                                gdouble *y_min,
                                                                gdouble *y_max);
GString*            gwy_graph_model_export_ascii               (GwyGraphModel *model,
                                                                gboolean export_units,
                                                                gboolean export_labels,
                                                                gboolean export_metadata,
                                                                GwyGraphModelExportStyle export_style,
                                                                GString *string);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
