//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlocks

import "time"

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ManagementLockListResult - The list of locks.
type ManagementLockListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string

	// The list of locks.
	Value []*ManagementLockObject
}

// ManagementLockObject - The lock information.
type ManagementLockObject struct {
	// REQUIRED; The properties of the lock.
	Properties *ManagementLockProperties

	// READ-ONLY; The resource ID of the lock.
	ID *string

	// READ-ONLY; The name of the lock.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The resource type of the lock - Microsoft.Authorization/locks.
	Type *string
}

// ManagementLockOwner - Lock owner properties.
type ManagementLockOwner struct {
	// The application ID of the lock owner.
	ApplicationID *string
}

// ManagementLockProperties - The lock properties.
type ManagementLockProperties struct {
	// REQUIRED; The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized
	// users are able to read and modify the resources, but not delete. ReadOnly means
	// authorized users can only read from a resource, but they can't modify or delete it.
	Level *LockLevel

	// Notes about the lock. Maximum of 512 characters.
	Notes *string

	// The owners of the lock.
	Owners []*ManagementLockOwner
}

// Operation - Microsoft.Authorization operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.Authorization
	Provider *string

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string
}

// OperationListResult - Result of the request to list Microsoft.Authorization operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Microsoft.Authorization operations.
	Value []*Operation
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
