/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Evangelos Ribeiro Tzaras <devrtz@fortysixandtwo.eu>
 */


#pragma once

#if !defined (__LIBCELLBROADCAST_H_INSIDE__) && !defined (LIBCELLBROADCAST_COMPILATION)
#error "Only <libcellbroadcast.h> can be included directly."
#endif

#include "lcb-enums.h"
#include <glib-object.h>


G_BEGIN_DECLS

#define LCB_TYPE_MESSAGE (lcb_message_get_type ())

G_DECLARE_DERIVABLE_TYPE (LcbMessage, lcb_message, LCB, MESSAGE, GObject);

struct _LcbMessageClass {
  GObjectClass parent_class;

  /* Padding for future expansion */
  void (*_cbd_reserved0) (void);
  void (*_cbd_reserved1) (void);
  void (*_cbd_reserved2) (void);
  void (*_cbd_reserved3) (void);
  void (*_cbd_reserved4) (void);
  void (*_cbd_reserved5) (void);
  void (*_cbd_reserved6) (void);
  void (*_cbd_reserved7) (void);
  void (*_cbd_reserved8) (void);
  void (*_cbd_reserved9) (void);

};

/* static */
const char      *lcb_message_get_text          (LcbMessage *self);
gint64           lcb_message_get_timestamp     (LcbMessage *self);
guint            lcb_message_get_channel       (LcbMessage *self);
guint            lcb_message_get_msg_code      (LcbMessage *self);
guint            lcb_message_get_update        (LcbMessage *self);
LcbSeverityLevel lcb_message_get_severity      (LcbMessage *self);
const char      *lcb_message_get_msg_id        (LcbMessage *self);
const char      *lcb_message_get_severity_subject (LcbMessage *self);
const char      *lcb_message_get_operator_code (LcbMessage *self);

G_END_DECLS
